package molecule.boilerplate.api

import molecule.boilerplate.ast.Model._


/** transaction apply data on molecule.
 * <br><br>
 * `Tx` takes a transaction apply data molecule with attributes having the transaction id as their entity id.
 * {{{
 * for {
 *   // Save molecule with transaction apply data
 *   _ <- Person.name("Ben").Tx.apply(MyMetaData.action("add member")).save
 *
 *   // Query for data with transaction apply data - "which persons became members"
 *   _ <- Person.name.Tx.apply(MyMetaData.action_("add member")).get.map(_ ==> List("Ben"))
 * } yield ()
 * }}}
 */
trait TxMetaData_

trait TxMetaData_0 extends TxMetaData_ { self: Elements =>
    final def apply                                                                   (tx: Elements_00                                                                  ): Molecule_00                                                                   = new Molecule_00                                                                   { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                                               ] (tx: Elements_01[a                                                               ]): Molecule_01[a                                                               ] = new Molecule_01[a                                                               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                                            ] (tx: Elements_02[a, b                                                            ]): Molecule_02[a, b                                                            ] = new Molecule_02[a, b                                                            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                                                         ] (tx: Elements_03[a, b, c                                                         ]): Molecule_03[a, b, c                                                         ] = new Molecule_03[a, b, c                                                         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                                                      ] (tx: Elements_04[a, b, c, d                                                      ]): Molecule_04[a, b, c, d                                                      ] = new Molecule_04[a, b, c, d                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                                                   ] (tx: Elements_05[a, b, c, d, e                                                   ]): Molecule_05[a, b, c, d, e                                                   ] = new Molecule_05[a, b, c, d, e                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                                                ] (tx: Elements_06[a, b, c, d, e, f                                                ]): Molecule_06[a, b, c, d, e, f                                                ] = new Molecule_06[a, b, c, d, e, f                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                                             ] (tx: Elements_07[a, b, c, d, e, f, g                                             ]): Molecule_07[a, b, c, d, e, f, g                                             ] = new Molecule_07[a, b, c, d, e, f, g                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h                                          ] (tx: Elements_08[a, b, c, d, e, f, g, h                                          ]): Molecule_08[a, b, c, d, e, f, g, h                                          ] = new Molecule_08[a, b, c, d, e, f, g, h                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i                                       ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                                       ]): Molecule_09[a, b, c, d, e, f, g, h, i                                       ] = new Molecule_09[a, b, c, d, e, f, g, h, i                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j                                    ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                                    ]): Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ] = new Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k                                 ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ] = new Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l                              ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ] = new Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] = new Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] = new Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] = new Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] = new Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] = new Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] = new Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (tx: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] = new Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (tx: Elements_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] = new Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (tx: Elements_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] = new Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (tx: Elements_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] = new Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    
    final def meta                                                                   (tx: Elements_00                                                                  ): Molecule_00                                                                   = new Molecule_00                                                                   { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                                               ] (tx: Elements_01[a                                                               ]): Molecule_01[a                                                               ] = new Molecule_01[a                                                               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                                            ] (tx: Elements_02[a, b                                                            ]): Molecule_02[a, b                                                            ] = new Molecule_02[a, b                                                            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                                                         ] (tx: Elements_03[a, b, c                                                         ]): Molecule_03[a, b, c                                                         ] = new Molecule_03[a, b, c                                                         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                                                      ] (tx: Elements_04[a, b, c, d                                                      ]): Molecule_04[a, b, c, d                                                      ] = new Molecule_04[a, b, c, d                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                                                   ] (tx: Elements_05[a, b, c, d, e                                                   ]): Molecule_05[a, b, c, d, e                                                   ] = new Molecule_05[a, b, c, d, e                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                                                ] (tx: Elements_06[a, b, c, d, e, f                                                ]): Molecule_06[a, b, c, d, e, f                                                ] = new Molecule_06[a, b, c, d, e, f                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                                             ] (tx: Elements_07[a, b, c, d, e, f, g                                             ]): Molecule_07[a, b, c, d, e, f, g                                             ] = new Molecule_07[a, b, c, d, e, f, g                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h                                          ] (tx: Elements_08[a, b, c, d, e, f, g, h                                          ]): Molecule_08[a, b, c, d, e, f, g, h                                          ] = new Molecule_08[a, b, c, d, e, f, g, h                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i                                       ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                                       ]): Molecule_09[a, b, c, d, e, f, g, h, i                                       ] = new Molecule_09[a, b, c, d, e, f, g, h, i                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j                                    ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                                    ]): Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ] = new Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k                                 ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ] = new Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l                              ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ] = new Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] = new Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] = new Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] = new Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] = new Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] = new Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] = new Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (tx: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] = new Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (tx: Elements_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] = new Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (tx: Elements_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] = new Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (tx: Elements_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] = new Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_1[A] extends TxMetaData_ { self: Elements =>
    final def apply                                                                (tx: Elements_00                                                               ): Molecule_01[A                                                               ] = new Molecule_01[A                                                               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                                            ] (tx: Elements_01[a                                                            ]): Molecule_02[A, a                                                            ] = new Molecule_02[A, a                                                            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                                         ] (tx: Elements_02[a, b                                                         ]): Molecule_03[A, a, b                                                         ] = new Molecule_03[A, a, b                                                         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                                                      ] (tx: Elements_03[a, b, c                                                      ]): Molecule_04[A, a, b, c                                                      ] = new Molecule_04[A, a, b, c                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                                                   ] (tx: Elements_04[a, b, c, d                                                   ]): Molecule_05[A, a, b, c, d                                                   ] = new Molecule_05[A, a, b, c, d                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                                                ] (tx: Elements_05[a, b, c, d, e                                                ]): Molecule_06[A, a, b, c, d, e                                                ] = new Molecule_06[A, a, b, c, d, e                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                                             ] (tx: Elements_06[a, b, c, d, e, f                                             ]): Molecule_07[A, a, b, c, d, e, f                                             ] = new Molecule_07[A, a, b, c, d, e, f                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                                          ] (tx: Elements_07[a, b, c, d, e, f, g                                          ]): Molecule_08[A, a, b, c, d, e, f, g                                          ] = new Molecule_08[A, a, b, c, d, e, f, g                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h                                       ] (tx: Elements_08[a, b, c, d, e, f, g, h                                       ]): Molecule_09[A, a, b, c, d, e, f, g, h                                       ] = new Molecule_09[A, a, b, c, d, e, f, g, h                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i                                    ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                                    ]): Molecule_10[A, a, b, c, d, e, f, g, h, i                                    ] = new Molecule_10[A, a, b, c, d, e, f, g, h, i                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j                                 ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                                 ]): Molecule_11[A, a, b, c, d, e, f, g, h, i, j                                 ] = new Molecule_11[A, a, b, c, d, e, f, g, h, i, j                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k                              ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                              ]): Molecule_12[A, a, b, c, d, e, f, g, h, i, j, k                              ] = new Molecule_12[A, a, b, c, d, e, f, g, h, i, j, k                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l                           ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                           ]): Molecule_13[A, a, b, c, d, e, f, g, h, i, j, k, l                           ] = new Molecule_13[A, a, b, c, d, e, f, g, h, i, j, k, l                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m                        ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                        ]): Molecule_14[A, a, b, c, d, e, f, g, h, i, j, k, l, m                        ] = new Molecule_14[A, a, b, c, d, e, f, g, h, i, j, k, l, m                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n                     ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                     ]): Molecule_15[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n                     ] = new Molecule_15[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                  ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                  ]): Molecule_16[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                  ] = new Molecule_16[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p               ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p               ]): Molecule_17[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p               ] = new Molecule_17[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q            ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q            ]): Molecule_18[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q            ] = new Molecule_18[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r         ] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r         ]): Molecule_19[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r         ] = new Molecule_19[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s      ] (tx: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s      ]): Molecule_20[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s      ] = new Molecule_20[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t   ] (tx: Elements_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t   ]): Molecule_21[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t   ] = new Molecule_21[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u] (tx: Elements_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u]): Molecule_22[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u] = new Molecule_22[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    
    final def meta                                                                (tx: Elements_00                                                               ): Molecule_01[A                                                               ] = new Molecule_01[A                                                               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                                            ] (tx: Elements_01[a                                                            ]): Molecule_02[A, a                                                            ] = new Molecule_02[A, a                                                            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                                         ] (tx: Elements_02[a, b                                                         ]): Molecule_03[A, a, b                                                         ] = new Molecule_03[A, a, b                                                         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                                                      ] (tx: Elements_03[a, b, c                                                      ]): Molecule_04[A, a, b, c                                                      ] = new Molecule_04[A, a, b, c                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                                                   ] (tx: Elements_04[a, b, c, d                                                   ]): Molecule_05[A, a, b, c, d                                                   ] = new Molecule_05[A, a, b, c, d                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                                                ] (tx: Elements_05[a, b, c, d, e                                                ]): Molecule_06[A, a, b, c, d, e                                                ] = new Molecule_06[A, a, b, c, d, e                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                                             ] (tx: Elements_06[a, b, c, d, e, f                                             ]): Molecule_07[A, a, b, c, d, e, f                                             ] = new Molecule_07[A, a, b, c, d, e, f                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                                          ] (tx: Elements_07[a, b, c, d, e, f, g                                          ]): Molecule_08[A, a, b, c, d, e, f, g                                          ] = new Molecule_08[A, a, b, c, d, e, f, g                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h                                       ] (tx: Elements_08[a, b, c, d, e, f, g, h                                       ]): Molecule_09[A, a, b, c, d, e, f, g, h                                       ] = new Molecule_09[A, a, b, c, d, e, f, g, h                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i                                    ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                                    ]): Molecule_10[A, a, b, c, d, e, f, g, h, i                                    ] = new Molecule_10[A, a, b, c, d, e, f, g, h, i                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j                                 ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                                 ]): Molecule_11[A, a, b, c, d, e, f, g, h, i, j                                 ] = new Molecule_11[A, a, b, c, d, e, f, g, h, i, j                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k                              ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                              ]): Molecule_12[A, a, b, c, d, e, f, g, h, i, j, k                              ] = new Molecule_12[A, a, b, c, d, e, f, g, h, i, j, k                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l                           ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                           ]): Molecule_13[A, a, b, c, d, e, f, g, h, i, j, k, l                           ] = new Molecule_13[A, a, b, c, d, e, f, g, h, i, j, k, l                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m                        ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                        ]): Molecule_14[A, a, b, c, d, e, f, g, h, i, j, k, l, m                        ] = new Molecule_14[A, a, b, c, d, e, f, g, h, i, j, k, l, m                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n                     ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                     ]): Molecule_15[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n                     ] = new Molecule_15[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                  ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                  ]): Molecule_16[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                  ] = new Molecule_16[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p               ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p               ]): Molecule_17[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p               ] = new Molecule_17[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q            ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q            ]): Molecule_18[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q            ] = new Molecule_18[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r         ] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r         ]): Molecule_19[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r         ] = new Molecule_19[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s      ] (tx: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s      ]): Molecule_20[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s      ] = new Molecule_20[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t   ] (tx: Elements_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t   ]): Molecule_21[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t   ] = new Molecule_21[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u] (tx: Elements_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u]): Molecule_22[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u] = new Molecule_22[A, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_2[A, B] extends TxMetaData_ { self: Elements =>
    final def apply                                                             (tx: Elements_00                                                            ): Molecule_02[A, B                                                            ] = new Molecule_02[A, B                                                            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                                         ] (tx: Elements_01[a                                                         ]): Molecule_03[A, B, a                                                         ] = new Molecule_03[A, B, a                                                         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                                      ] (tx: Elements_02[a, b                                                      ]): Molecule_04[A, B, a, b                                                      ] = new Molecule_04[A, B, a, b                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                                                   ] (tx: Elements_03[a, b, c                                                   ]): Molecule_05[A, B, a, b, c                                                   ] = new Molecule_05[A, B, a, b, c                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                                                ] (tx: Elements_04[a, b, c, d                                                ]): Molecule_06[A, B, a, b, c, d                                                ] = new Molecule_06[A, B, a, b, c, d                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                                             ] (tx: Elements_05[a, b, c, d, e                                             ]): Molecule_07[A, B, a, b, c, d, e                                             ] = new Molecule_07[A, B, a, b, c, d, e                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                                          ] (tx: Elements_06[a, b, c, d, e, f                                          ]): Molecule_08[A, B, a, b, c, d, e, f                                          ] = new Molecule_08[A, B, a, b, c, d, e, f                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                                       ] (tx: Elements_07[a, b, c, d, e, f, g                                       ]): Molecule_09[A, B, a, b, c, d, e, f, g                                       ] = new Molecule_09[A, B, a, b, c, d, e, f, g                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h                                    ] (tx: Elements_08[a, b, c, d, e, f, g, h                                    ]): Molecule_10[A, B, a, b, c, d, e, f, g, h                                    ] = new Molecule_10[A, B, a, b, c, d, e, f, g, h                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i                                 ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                                 ]): Molecule_11[A, B, a, b, c, d, e, f, g, h, i                                 ] = new Molecule_11[A, B, a, b, c, d, e, f, g, h, i                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j                              ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                              ]): Molecule_12[A, B, a, b, c, d, e, f, g, h, i, j                              ] = new Molecule_12[A, B, a, b, c, d, e, f, g, h, i, j                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k                           ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                           ]): Molecule_13[A, B, a, b, c, d, e, f, g, h, i, j, k                           ] = new Molecule_13[A, B, a, b, c, d, e, f, g, h, i, j, k                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l                        ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                        ]): Molecule_14[A, B, a, b, c, d, e, f, g, h, i, j, k, l                        ] = new Molecule_14[A, B, a, b, c, d, e, f, g, h, i, j, k, l                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m                     ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                     ]): Molecule_15[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m                     ] = new Molecule_15[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n                  ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                  ]): Molecule_16[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n                  ] = new Molecule_16[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o               ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o               ]): Molecule_17[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o               ] = new Molecule_17[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p            ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p            ]): Molecule_18[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p            ] = new Molecule_18[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q         ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q         ]): Molecule_19[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q         ] = new Molecule_19[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r      ] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r      ]): Molecule_20[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r      ] = new Molecule_20[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s   ] (tx: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s   ]): Molecule_21[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s   ] = new Molecule_21[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t] (tx: Elements_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t]): Molecule_22[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t] = new Molecule_22[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                                             (tx: Elements_00                                                            ): Molecule_02[A, B                                                            ] = new Molecule_02[A, B                                                            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                                         ] (tx: Elements_01[a                                                         ]): Molecule_03[A, B, a                                                         ] = new Molecule_03[A, B, a                                                         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                                      ] (tx: Elements_02[a, b                                                      ]): Molecule_04[A, B, a, b                                                      ] = new Molecule_04[A, B, a, b                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                                                   ] (tx: Elements_03[a, b, c                                                   ]): Molecule_05[A, B, a, b, c                                                   ] = new Molecule_05[A, B, a, b, c                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                                                ] (tx: Elements_04[a, b, c, d                                                ]): Molecule_06[A, B, a, b, c, d                                                ] = new Molecule_06[A, B, a, b, c, d                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                                             ] (tx: Elements_05[a, b, c, d, e                                             ]): Molecule_07[A, B, a, b, c, d, e                                             ] = new Molecule_07[A, B, a, b, c, d, e                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                                          ] (tx: Elements_06[a, b, c, d, e, f                                          ]): Molecule_08[A, B, a, b, c, d, e, f                                          ] = new Molecule_08[A, B, a, b, c, d, e, f                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                                       ] (tx: Elements_07[a, b, c, d, e, f, g                                       ]): Molecule_09[A, B, a, b, c, d, e, f, g                                       ] = new Molecule_09[A, B, a, b, c, d, e, f, g                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h                                    ] (tx: Elements_08[a, b, c, d, e, f, g, h                                    ]): Molecule_10[A, B, a, b, c, d, e, f, g, h                                    ] = new Molecule_10[A, B, a, b, c, d, e, f, g, h                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i                                 ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                                 ]): Molecule_11[A, B, a, b, c, d, e, f, g, h, i                                 ] = new Molecule_11[A, B, a, b, c, d, e, f, g, h, i                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j                              ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                              ]): Molecule_12[A, B, a, b, c, d, e, f, g, h, i, j                              ] = new Molecule_12[A, B, a, b, c, d, e, f, g, h, i, j                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k                           ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                           ]): Molecule_13[A, B, a, b, c, d, e, f, g, h, i, j, k                           ] = new Molecule_13[A, B, a, b, c, d, e, f, g, h, i, j, k                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l                        ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                        ]): Molecule_14[A, B, a, b, c, d, e, f, g, h, i, j, k, l                        ] = new Molecule_14[A, B, a, b, c, d, e, f, g, h, i, j, k, l                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m                     ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                     ]): Molecule_15[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m                     ] = new Molecule_15[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n                  ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                  ]): Molecule_16[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n                  ] = new Molecule_16[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o               ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o               ]): Molecule_17[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o               ] = new Molecule_17[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p            ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p            ]): Molecule_18[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p            ] = new Molecule_18[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q         ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q         ]): Molecule_19[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q         ] = new Molecule_19[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r      ] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r      ]): Molecule_20[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r      ] = new Molecule_20[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s   ] (tx: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s   ]): Molecule_21[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s   ] = new Molecule_21[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t] (tx: Elements_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t]): Molecule_22[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t] = new Molecule_22[A, B, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_3[A, B, C] extends TxMetaData_ { self: Elements =>
    final def apply                                                          (tx: Elements_00                                                         ): Molecule_03[A, B, C                                                         ] = new Molecule_03[A, B, C                                                         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                                      ] (tx: Elements_01[a                                                      ]): Molecule_04[A, B, C, a                                                      ] = new Molecule_04[A, B, C, a                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                                   ] (tx: Elements_02[a, b                                                   ]): Molecule_05[A, B, C, a, b                                                   ] = new Molecule_05[A, B, C, a, b                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                                                ] (tx: Elements_03[a, b, c                                                ]): Molecule_06[A, B, C, a, b, c                                                ] = new Molecule_06[A, B, C, a, b, c                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                                             ] (tx: Elements_04[a, b, c, d                                             ]): Molecule_07[A, B, C, a, b, c, d                                             ] = new Molecule_07[A, B, C, a, b, c, d                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                                          ] (tx: Elements_05[a, b, c, d, e                                          ]): Molecule_08[A, B, C, a, b, c, d, e                                          ] = new Molecule_08[A, B, C, a, b, c, d, e                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                                       ] (tx: Elements_06[a, b, c, d, e, f                                       ]): Molecule_09[A, B, C, a, b, c, d, e, f                                       ] = new Molecule_09[A, B, C, a, b, c, d, e, f                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                                    ] (tx: Elements_07[a, b, c, d, e, f, g                                    ]): Molecule_10[A, B, C, a, b, c, d, e, f, g                                    ] = new Molecule_10[A, B, C, a, b, c, d, e, f, g                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h                                 ] (tx: Elements_08[a, b, c, d, e, f, g, h                                 ]): Molecule_11[A, B, C, a, b, c, d, e, f, g, h                                 ] = new Molecule_11[A, B, C, a, b, c, d, e, f, g, h                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i                              ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                              ]): Molecule_12[A, B, C, a, b, c, d, e, f, g, h, i                              ] = new Molecule_12[A, B, C, a, b, c, d, e, f, g, h, i                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j                           ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                           ]): Molecule_13[A, B, C, a, b, c, d, e, f, g, h, i, j                           ] = new Molecule_13[A, B, C, a, b, c, d, e, f, g, h, i, j                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k                        ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                        ]): Molecule_14[A, B, C, a, b, c, d, e, f, g, h, i, j, k                        ] = new Molecule_14[A, B, C, a, b, c, d, e, f, g, h, i, j, k                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l                     ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                     ]): Molecule_15[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l                     ] = new Molecule_15[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m                  ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                  ]): Molecule_16[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m                  ] = new Molecule_16[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n               ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n               ]): Molecule_17[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n               ] = new Molecule_17[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o            ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o            ]): Molecule_18[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o            ] = new Molecule_18[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p         ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p         ]): Molecule_19[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p         ] = new Molecule_19[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q      ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q      ]): Molecule_20[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q      ] = new Molecule_20[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r   ] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r   ]): Molecule_21[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r   ] = new Molecule_21[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s] (tx: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s]): Molecule_22[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s] = new Molecule_22[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                                          (tx: Elements_00                                                         ): Molecule_03[A, B, C                                                         ] = new Molecule_03[A, B, C                                                         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                                      ] (tx: Elements_01[a                                                      ]): Molecule_04[A, B, C, a                                                      ] = new Molecule_04[A, B, C, a                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                                   ] (tx: Elements_02[a, b                                                   ]): Molecule_05[A, B, C, a, b                                                   ] = new Molecule_05[A, B, C, a, b                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                                                ] (tx: Elements_03[a, b, c                                                ]): Molecule_06[A, B, C, a, b, c                                                ] = new Molecule_06[A, B, C, a, b, c                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                                             ] (tx: Elements_04[a, b, c, d                                             ]): Molecule_07[A, B, C, a, b, c, d                                             ] = new Molecule_07[A, B, C, a, b, c, d                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                                          ] (tx: Elements_05[a, b, c, d, e                                          ]): Molecule_08[A, B, C, a, b, c, d, e                                          ] = new Molecule_08[A, B, C, a, b, c, d, e                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                                       ] (tx: Elements_06[a, b, c, d, e, f                                       ]): Molecule_09[A, B, C, a, b, c, d, e, f                                       ] = new Molecule_09[A, B, C, a, b, c, d, e, f                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                                    ] (tx: Elements_07[a, b, c, d, e, f, g                                    ]): Molecule_10[A, B, C, a, b, c, d, e, f, g                                    ] = new Molecule_10[A, B, C, a, b, c, d, e, f, g                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h                                 ] (tx: Elements_08[a, b, c, d, e, f, g, h                                 ]): Molecule_11[A, B, C, a, b, c, d, e, f, g, h                                 ] = new Molecule_11[A, B, C, a, b, c, d, e, f, g, h                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i                              ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                              ]): Molecule_12[A, B, C, a, b, c, d, e, f, g, h, i                              ] = new Molecule_12[A, B, C, a, b, c, d, e, f, g, h, i                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j                           ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                           ]): Molecule_13[A, B, C, a, b, c, d, e, f, g, h, i, j                           ] = new Molecule_13[A, B, C, a, b, c, d, e, f, g, h, i, j                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k                        ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                        ]): Molecule_14[A, B, C, a, b, c, d, e, f, g, h, i, j, k                        ] = new Molecule_14[A, B, C, a, b, c, d, e, f, g, h, i, j, k                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l                     ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                     ]): Molecule_15[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l                     ] = new Molecule_15[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m                  ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                  ]): Molecule_16[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m                  ] = new Molecule_16[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n               ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n               ]): Molecule_17[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n               ] = new Molecule_17[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o            ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o            ]): Molecule_18[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o            ] = new Molecule_18[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p         ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p         ]): Molecule_19[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p         ] = new Molecule_19[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q      ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q      ]): Molecule_20[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q      ] = new Molecule_20[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r   ] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r   ]): Molecule_21[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r   ] = new Molecule_21[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s] (tx: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s]): Molecule_22[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s] = new Molecule_22[A, B, C, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_4[A, B, C, D] extends TxMetaData_ { self: Elements =>
    final def apply                                                       (tx: Elements_00                                                      ): Molecule_04[A, B, C, D                                                      ] = new Molecule_04[A, B, C, D                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                                   ] (tx: Elements_01[a                                                   ]): Molecule_05[A, B, C, D, a                                                   ] = new Molecule_05[A, B, C, D, a                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                                ] (tx: Elements_02[a, b                                                ]): Molecule_06[A, B, C, D, a, b                                                ] = new Molecule_06[A, B, C, D, a, b                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                                             ] (tx: Elements_03[a, b, c                                             ]): Molecule_07[A, B, C, D, a, b, c                                             ] = new Molecule_07[A, B, C, D, a, b, c                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                                          ] (tx: Elements_04[a, b, c, d                                          ]): Molecule_08[A, B, C, D, a, b, c, d                                          ] = new Molecule_08[A, B, C, D, a, b, c, d                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                                       ] (tx: Elements_05[a, b, c, d, e                                       ]): Molecule_09[A, B, C, D, a, b, c, d, e                                       ] = new Molecule_09[A, B, C, D, a, b, c, d, e                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                                    ] (tx: Elements_06[a, b, c, d, e, f                                    ]): Molecule_10[A, B, C, D, a, b, c, d, e, f                                    ] = new Molecule_10[A, B, C, D, a, b, c, d, e, f                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                                 ] (tx: Elements_07[a, b, c, d, e, f, g                                 ]): Molecule_11[A, B, C, D, a, b, c, d, e, f, g                                 ] = new Molecule_11[A, B, C, D, a, b, c, d, e, f, g                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h                              ] (tx: Elements_08[a, b, c, d, e, f, g, h                              ]): Molecule_12[A, B, C, D, a, b, c, d, e, f, g, h                              ] = new Molecule_12[A, B, C, D, a, b, c, d, e, f, g, h                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i                           ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                           ]): Molecule_13[A, B, C, D, a, b, c, d, e, f, g, h, i                           ] = new Molecule_13[A, B, C, D, a, b, c, d, e, f, g, h, i                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j                        ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                        ]): Molecule_14[A, B, C, D, a, b, c, d, e, f, g, h, i, j                        ] = new Molecule_14[A, B, C, D, a, b, c, d, e, f, g, h, i, j                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k                     ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                     ]): Molecule_15[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k                     ] = new Molecule_15[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l                  ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                  ]): Molecule_16[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l                  ] = new Molecule_16[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m               ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m               ]): Molecule_17[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m               ] = new Molecule_17[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n            ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n            ]): Molecule_18[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n            ] = new Molecule_18[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o         ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o         ]): Molecule_19[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o         ] = new Molecule_19[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p      ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p      ]): Molecule_20[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p      ] = new Molecule_20[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q   ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q   ]): Molecule_21[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q   ] = new Molecule_21[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r]): Molecule_22[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r] = new Molecule_22[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                                       (tx: Elements_00                                                      ): Molecule_04[A, B, C, D                                                      ] = new Molecule_04[A, B, C, D                                                      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                                   ] (tx: Elements_01[a                                                   ]): Molecule_05[A, B, C, D, a                                                   ] = new Molecule_05[A, B, C, D, a                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                                ] (tx: Elements_02[a, b                                                ]): Molecule_06[A, B, C, D, a, b                                                ] = new Molecule_06[A, B, C, D, a, b                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                                             ] (tx: Elements_03[a, b, c                                             ]): Molecule_07[A, B, C, D, a, b, c                                             ] = new Molecule_07[A, B, C, D, a, b, c                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                                          ] (tx: Elements_04[a, b, c, d                                          ]): Molecule_08[A, B, C, D, a, b, c, d                                          ] = new Molecule_08[A, B, C, D, a, b, c, d                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                                       ] (tx: Elements_05[a, b, c, d, e                                       ]): Molecule_09[A, B, C, D, a, b, c, d, e                                       ] = new Molecule_09[A, B, C, D, a, b, c, d, e                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                                    ] (tx: Elements_06[a, b, c, d, e, f                                    ]): Molecule_10[A, B, C, D, a, b, c, d, e, f                                    ] = new Molecule_10[A, B, C, D, a, b, c, d, e, f                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                                 ] (tx: Elements_07[a, b, c, d, e, f, g                                 ]): Molecule_11[A, B, C, D, a, b, c, d, e, f, g                                 ] = new Molecule_11[A, B, C, D, a, b, c, d, e, f, g                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h                              ] (tx: Elements_08[a, b, c, d, e, f, g, h                              ]): Molecule_12[A, B, C, D, a, b, c, d, e, f, g, h                              ] = new Molecule_12[A, B, C, D, a, b, c, d, e, f, g, h                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i                           ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                           ]): Molecule_13[A, B, C, D, a, b, c, d, e, f, g, h, i                           ] = new Molecule_13[A, B, C, D, a, b, c, d, e, f, g, h, i                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j                        ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                        ]): Molecule_14[A, B, C, D, a, b, c, d, e, f, g, h, i, j                        ] = new Molecule_14[A, B, C, D, a, b, c, d, e, f, g, h, i, j                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k                     ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                     ]): Molecule_15[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k                     ] = new Molecule_15[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l                  ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                  ]): Molecule_16[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l                  ] = new Molecule_16[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m               ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m               ]): Molecule_17[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m               ] = new Molecule_17[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n            ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n            ]): Molecule_18[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n            ] = new Molecule_18[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o         ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o         ]): Molecule_19[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o         ] = new Molecule_19[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p      ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p      ]): Molecule_20[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p      ] = new Molecule_20[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q   ] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q   ]): Molecule_21[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q   ] = new Molecule_21[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r] (tx: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r]): Molecule_22[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r] = new Molecule_22[A, B, C, D, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_5[A, B, C, D, E] extends TxMetaData_ { self: Elements =>
    final def apply                                                    (tx: Elements_00                                                   ): Molecule_05[A, B, C, D, E                                                   ] = new Molecule_05[A, B, C, D, E                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                                ] (tx: Elements_01[a                                                ]): Molecule_06[A, B, C, D, E, a                                                ] = new Molecule_06[A, B, C, D, E, a                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                             ] (tx: Elements_02[a, b                                             ]): Molecule_07[A, B, C, D, E, a, b                                             ] = new Molecule_07[A, B, C, D, E, a, b                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                                          ] (tx: Elements_03[a, b, c                                          ]): Molecule_08[A, B, C, D, E, a, b, c                                          ] = new Molecule_08[A, B, C, D, E, a, b, c                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                                       ] (tx: Elements_04[a, b, c, d                                       ]): Molecule_09[A, B, C, D, E, a, b, c, d                                       ] = new Molecule_09[A, B, C, D, E, a, b, c, d                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                                    ] (tx: Elements_05[a, b, c, d, e                                    ]): Molecule_10[A, B, C, D, E, a, b, c, d, e                                    ] = new Molecule_10[A, B, C, D, E, a, b, c, d, e                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                                 ] (tx: Elements_06[a, b, c, d, e, f                                 ]): Molecule_11[A, B, C, D, E, a, b, c, d, e, f                                 ] = new Molecule_11[A, B, C, D, E, a, b, c, d, e, f                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                              ] (tx: Elements_07[a, b, c, d, e, f, g                              ]): Molecule_12[A, B, C, D, E, a, b, c, d, e, f, g                              ] = new Molecule_12[A, B, C, D, E, a, b, c, d, e, f, g                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h                           ] (tx: Elements_08[a, b, c, d, e, f, g, h                           ]): Molecule_13[A, B, C, D, E, a, b, c, d, e, f, g, h                           ] = new Molecule_13[A, B, C, D, E, a, b, c, d, e, f, g, h                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i                        ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                        ]): Molecule_14[A, B, C, D, E, a, b, c, d, e, f, g, h, i                        ] = new Molecule_14[A, B, C, D, E, a, b, c, d, e, f, g, h, i                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j                     ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                     ]): Molecule_15[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j                     ] = new Molecule_15[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k                  ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                  ]): Molecule_16[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k                  ] = new Molecule_16[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l               ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l               ]): Molecule_17[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l               ] = new Molecule_17[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m            ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m            ]): Molecule_18[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m            ] = new Molecule_18[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n         ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n         ]): Molecule_19[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n         ] = new Molecule_19[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o      ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o      ]): Molecule_20[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o      ] = new Molecule_20[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p   ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p   ]): Molecule_21[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p   ] = new Molecule_21[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q]): Molecule_22[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q] = new Molecule_22[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                                    (tx: Elements_00                                                   ): Molecule_05[A, B, C, D, E                                                   ] = new Molecule_05[A, B, C, D, E                                                   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                                ] (tx: Elements_01[a                                                ]): Molecule_06[A, B, C, D, E, a                                                ] = new Molecule_06[A, B, C, D, E, a                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                             ] (tx: Elements_02[a, b                                             ]): Molecule_07[A, B, C, D, E, a, b                                             ] = new Molecule_07[A, B, C, D, E, a, b                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                                          ] (tx: Elements_03[a, b, c                                          ]): Molecule_08[A, B, C, D, E, a, b, c                                          ] = new Molecule_08[A, B, C, D, E, a, b, c                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                                       ] (tx: Elements_04[a, b, c, d                                       ]): Molecule_09[A, B, C, D, E, a, b, c, d                                       ] = new Molecule_09[A, B, C, D, E, a, b, c, d                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                                    ] (tx: Elements_05[a, b, c, d, e                                    ]): Molecule_10[A, B, C, D, E, a, b, c, d, e                                    ] = new Molecule_10[A, B, C, D, E, a, b, c, d, e                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                                 ] (tx: Elements_06[a, b, c, d, e, f                                 ]): Molecule_11[A, B, C, D, E, a, b, c, d, e, f                                 ] = new Molecule_11[A, B, C, D, E, a, b, c, d, e, f                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                              ] (tx: Elements_07[a, b, c, d, e, f, g                              ]): Molecule_12[A, B, C, D, E, a, b, c, d, e, f, g                              ] = new Molecule_12[A, B, C, D, E, a, b, c, d, e, f, g                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h                           ] (tx: Elements_08[a, b, c, d, e, f, g, h                           ]): Molecule_13[A, B, C, D, E, a, b, c, d, e, f, g, h                           ] = new Molecule_13[A, B, C, D, E, a, b, c, d, e, f, g, h                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i                        ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                        ]): Molecule_14[A, B, C, D, E, a, b, c, d, e, f, g, h, i                        ] = new Molecule_14[A, B, C, D, E, a, b, c, d, e, f, g, h, i                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j                     ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                     ]): Molecule_15[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j                     ] = new Molecule_15[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k                  ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k                  ]): Molecule_16[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k                  ] = new Molecule_16[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l               ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l               ]): Molecule_17[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l               ] = new Molecule_17[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m            ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m            ]): Molecule_18[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m            ] = new Molecule_18[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n         ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n         ]): Molecule_19[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n         ] = new Molecule_19[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o      ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o      ]): Molecule_20[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o      ] = new Molecule_20[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p   ] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p   ]): Molecule_21[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p   ] = new Molecule_21[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q] (tx: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q]): Molecule_22[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q] = new Molecule_22[A, B, C, D, E, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_6[A, B, C, D, E, F] extends TxMetaData_ { self: Elements =>
    final def apply                                                 (tx: Elements_00                                                ): Molecule_06[A, B, C, D, E, F                                                ] = new Molecule_06[A, B, C, D, E, F                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                             ] (tx: Elements_01[a                                             ]): Molecule_07[A, B, C, D, E, F, a                                             ] = new Molecule_07[A, B, C, D, E, F, a                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                          ] (tx: Elements_02[a, b                                          ]): Molecule_08[A, B, C, D, E, F, a, b                                          ] = new Molecule_08[A, B, C, D, E, F, a, b                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                                       ] (tx: Elements_03[a, b, c                                       ]): Molecule_09[A, B, C, D, E, F, a, b, c                                       ] = new Molecule_09[A, B, C, D, E, F, a, b, c                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                                    ] (tx: Elements_04[a, b, c, d                                    ]): Molecule_10[A, B, C, D, E, F, a, b, c, d                                    ] = new Molecule_10[A, B, C, D, E, F, a, b, c, d                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                                 ] (tx: Elements_05[a, b, c, d, e                                 ]): Molecule_11[A, B, C, D, E, F, a, b, c, d, e                                 ] = new Molecule_11[A, B, C, D, E, F, a, b, c, d, e                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                              ] (tx: Elements_06[a, b, c, d, e, f                              ]): Molecule_12[A, B, C, D, E, F, a, b, c, d, e, f                              ] = new Molecule_12[A, B, C, D, E, F, a, b, c, d, e, f                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                           ] (tx: Elements_07[a, b, c, d, e, f, g                           ]): Molecule_13[A, B, C, D, E, F, a, b, c, d, e, f, g                           ] = new Molecule_13[A, B, C, D, E, F, a, b, c, d, e, f, g                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h                        ] (tx: Elements_08[a, b, c, d, e, f, g, h                        ]): Molecule_14[A, B, C, D, E, F, a, b, c, d, e, f, g, h                        ] = new Molecule_14[A, B, C, D, E, F, a, b, c, d, e, f, g, h                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i                     ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                     ]): Molecule_15[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i                     ] = new Molecule_15[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j                  ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                  ]): Molecule_16[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j                  ] = new Molecule_16[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k               ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k               ]): Molecule_17[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k               ] = new Molecule_17[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l            ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l            ]): Molecule_18[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l            ] = new Molecule_18[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m         ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m         ]): Molecule_19[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m         ] = new Molecule_19[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n      ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n      ]): Molecule_20[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n      ] = new Molecule_20[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o   ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o   ]): Molecule_21[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o   ] = new Molecule_21[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p]): Molecule_22[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p] = new Molecule_22[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                                 (tx: Elements_00                                                ): Molecule_06[A, B, C, D, E, F                                                ] = new Molecule_06[A, B, C, D, E, F                                                ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                             ] (tx: Elements_01[a                                             ]): Molecule_07[A, B, C, D, E, F, a                                             ] = new Molecule_07[A, B, C, D, E, F, a                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                          ] (tx: Elements_02[a, b                                          ]): Molecule_08[A, B, C, D, E, F, a, b                                          ] = new Molecule_08[A, B, C, D, E, F, a, b                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                                       ] (tx: Elements_03[a, b, c                                       ]): Molecule_09[A, B, C, D, E, F, a, b, c                                       ] = new Molecule_09[A, B, C, D, E, F, a, b, c                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                                    ] (tx: Elements_04[a, b, c, d                                    ]): Molecule_10[A, B, C, D, E, F, a, b, c, d                                    ] = new Molecule_10[A, B, C, D, E, F, a, b, c, d                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                                 ] (tx: Elements_05[a, b, c, d, e                                 ]): Molecule_11[A, B, C, D, E, F, a, b, c, d, e                                 ] = new Molecule_11[A, B, C, D, E, F, a, b, c, d, e                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                              ] (tx: Elements_06[a, b, c, d, e, f                              ]): Molecule_12[A, B, C, D, E, F, a, b, c, d, e, f                              ] = new Molecule_12[A, B, C, D, E, F, a, b, c, d, e, f                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                           ] (tx: Elements_07[a, b, c, d, e, f, g                           ]): Molecule_13[A, B, C, D, E, F, a, b, c, d, e, f, g                           ] = new Molecule_13[A, B, C, D, E, F, a, b, c, d, e, f, g                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h                        ] (tx: Elements_08[a, b, c, d, e, f, g, h                        ]): Molecule_14[A, B, C, D, E, F, a, b, c, d, e, f, g, h                        ] = new Molecule_14[A, B, C, D, E, F, a, b, c, d, e, f, g, h                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i                     ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                     ]): Molecule_15[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i                     ] = new Molecule_15[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j                  ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j                  ]): Molecule_16[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j                  ] = new Molecule_16[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k               ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k               ]): Molecule_17[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k               ] = new Molecule_17[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l            ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l            ]): Molecule_18[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l            ] = new Molecule_18[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m         ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m         ]): Molecule_19[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m         ] = new Molecule_19[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n      ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n      ]): Molecule_20[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n      ] = new Molecule_20[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o   ] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o   ]): Molecule_21[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o   ] = new Molecule_21[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p] (tx: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p]): Molecule_22[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p] = new Molecule_22[A, B, C, D, E, F, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_7[A, B, C, D, E, F, G] extends TxMetaData_ { self: Elements =>
    final def apply                                              (tx: Elements_00                                             ): Molecule_07[A, B, C, D, E, F, G                                             ] = new Molecule_07[A, B, C, D, E, F, G                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                          ] (tx: Elements_01[a                                          ]): Molecule_08[A, B, C, D, E, F, G, a                                          ] = new Molecule_08[A, B, C, D, E, F, G, a                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                       ] (tx: Elements_02[a, b                                       ]): Molecule_09[A, B, C, D, E, F, G, a, b                                       ] = new Molecule_09[A, B, C, D, E, F, G, a, b                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                                    ] (tx: Elements_03[a, b, c                                    ]): Molecule_10[A, B, C, D, E, F, G, a, b, c                                    ] = new Molecule_10[A, B, C, D, E, F, G, a, b, c                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                                 ] (tx: Elements_04[a, b, c, d                                 ]): Molecule_11[A, B, C, D, E, F, G, a, b, c, d                                 ] = new Molecule_11[A, B, C, D, E, F, G, a, b, c, d                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                              ] (tx: Elements_05[a, b, c, d, e                              ]): Molecule_12[A, B, C, D, E, F, G, a, b, c, d, e                              ] = new Molecule_12[A, B, C, D, E, F, G, a, b, c, d, e                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                           ] (tx: Elements_06[a, b, c, d, e, f                           ]): Molecule_13[A, B, C, D, E, F, G, a, b, c, d, e, f                           ] = new Molecule_13[A, B, C, D, E, F, G, a, b, c, d, e, f                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                        ] (tx: Elements_07[a, b, c, d, e, f, g                        ]): Molecule_14[A, B, C, D, E, F, G, a, b, c, d, e, f, g                        ] = new Molecule_14[A, B, C, D, E, F, G, a, b, c, d, e, f, g                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h                     ] (tx: Elements_08[a, b, c, d, e, f, g, h                     ]): Molecule_15[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h                     ] = new Molecule_15[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i                  ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                  ]): Molecule_16[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i                  ] = new Molecule_16[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j               ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j               ]): Molecule_17[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j               ] = new Molecule_17[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k            ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k            ]): Molecule_18[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k            ] = new Molecule_18[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l         ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l         ]): Molecule_19[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l         ] = new Molecule_19[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m      ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m      ]): Molecule_20[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m      ] = new Molecule_20[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n   ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n   ]): Molecule_21[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m, n   ] = new Molecule_21[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m, n   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o]): Molecule_22[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o] = new Molecule_22[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                              (tx: Elements_00                                             ): Molecule_07[A, B, C, D, E, F, G                                             ] = new Molecule_07[A, B, C, D, E, F, G                                             ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                          ] (tx: Elements_01[a                                          ]): Molecule_08[A, B, C, D, E, F, G, a                                          ] = new Molecule_08[A, B, C, D, E, F, G, a                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                       ] (tx: Elements_02[a, b                                       ]): Molecule_09[A, B, C, D, E, F, G, a, b                                       ] = new Molecule_09[A, B, C, D, E, F, G, a, b                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                                    ] (tx: Elements_03[a, b, c                                    ]): Molecule_10[A, B, C, D, E, F, G, a, b, c                                    ] = new Molecule_10[A, B, C, D, E, F, G, a, b, c                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                                 ] (tx: Elements_04[a, b, c, d                                 ]): Molecule_11[A, B, C, D, E, F, G, a, b, c, d                                 ] = new Molecule_11[A, B, C, D, E, F, G, a, b, c, d                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                              ] (tx: Elements_05[a, b, c, d, e                              ]): Molecule_12[A, B, C, D, E, F, G, a, b, c, d, e                              ] = new Molecule_12[A, B, C, D, E, F, G, a, b, c, d, e                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                           ] (tx: Elements_06[a, b, c, d, e, f                           ]): Molecule_13[A, B, C, D, E, F, G, a, b, c, d, e, f                           ] = new Molecule_13[A, B, C, D, E, F, G, a, b, c, d, e, f                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                        ] (tx: Elements_07[a, b, c, d, e, f, g                        ]): Molecule_14[A, B, C, D, E, F, G, a, b, c, d, e, f, g                        ] = new Molecule_14[A, B, C, D, E, F, G, a, b, c, d, e, f, g                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h                     ] (tx: Elements_08[a, b, c, d, e, f, g, h                     ]): Molecule_15[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h                     ] = new Molecule_15[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i                  ] (tx: Elements_09[a, b, c, d, e, f, g, h, i                  ]): Molecule_16[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i                  ] = new Molecule_16[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j               ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j               ]): Molecule_17[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j               ] = new Molecule_17[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k            ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k            ]): Molecule_18[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k            ] = new Molecule_18[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l         ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l         ]): Molecule_19[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l         ] = new Molecule_19[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m      ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m      ]): Molecule_20[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m      ] = new Molecule_20[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n   ] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n   ]): Molecule_21[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m, n   ] = new Molecule_21[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m, n   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o] (tx: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o]): Molecule_22[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o] = new Molecule_22[A, B, C, D, E, F, G, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_8[A, B, C, D, E, F, G, H] extends TxMetaData_ { self: Elements =>
    final def apply                                           (tx: Elements_00                                          ): Molecule_08[A, B, C, D, E, F, G, H                                          ] = new Molecule_08[A, B, C, D, E, F, G, H                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                       ] (tx: Elements_01[a                                       ]): Molecule_09[A, B, C, D, E, F, G, H, a                                       ] = new Molecule_09[A, B, C, D, E, F, G, H, a                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                    ] (tx: Elements_02[a, b                                    ]): Molecule_10[A, B, C, D, E, F, G, H, a, b                                    ] = new Molecule_10[A, B, C, D, E, F, G, H, a, b                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                                 ] (tx: Elements_03[a, b, c                                 ]): Molecule_11[A, B, C, D, E, F, G, H, a, b, c                                 ] = new Molecule_11[A, B, C, D, E, F, G, H, a, b, c                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                              ] (tx: Elements_04[a, b, c, d                              ]): Molecule_12[A, B, C, D, E, F, G, H, a, b, c, d                              ] = new Molecule_12[A, B, C, D, E, F, G, H, a, b, c, d                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                           ] (tx: Elements_05[a, b, c, d, e                           ]): Molecule_13[A, B, C, D, E, F, G, H, a, b, c, d, e                           ] = new Molecule_13[A, B, C, D, E, F, G, H, a, b, c, d, e                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                        ] (tx: Elements_06[a, b, c, d, e, f                        ]): Molecule_14[A, B, C, D, E, F, G, H, a, b, c, d, e, f                        ] = new Molecule_14[A, B, C, D, E, F, G, H, a, b, c, d, e, f                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                     ] (tx: Elements_07[a, b, c, d, e, f, g                     ]): Molecule_15[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g                     ] = new Molecule_15[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h                  ] (tx: Elements_08[a, b, c, d, e, f, g, h                  ]): Molecule_16[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h                  ] = new Molecule_16[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i               ] (tx: Elements_09[a, b, c, d, e, f, g, h, i               ]): Molecule_17[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i               ] = new Molecule_17[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j            ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j            ]): Molecule_18[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j            ] = new Molecule_18[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k         ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k         ]): Molecule_19[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k         ] = new Molecule_19[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l      ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l      ]): Molecule_20[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l      ] = new Molecule_20[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m   ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m   ]): Molecule_21[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l, m   ] = new Molecule_21[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l, m   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m, n] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n]): Molecule_22[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l, m, n] = new Molecule_22[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l, m, n] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                           (tx: Elements_00                                          ): Molecule_08[A, B, C, D, E, F, G, H                                          ] = new Molecule_08[A, B, C, D, E, F, G, H                                          ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                       ] (tx: Elements_01[a                                       ]): Molecule_09[A, B, C, D, E, F, G, H, a                                       ] = new Molecule_09[A, B, C, D, E, F, G, H, a                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                    ] (tx: Elements_02[a, b                                    ]): Molecule_10[A, B, C, D, E, F, G, H, a, b                                    ] = new Molecule_10[A, B, C, D, E, F, G, H, a, b                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                                 ] (tx: Elements_03[a, b, c                                 ]): Molecule_11[A, B, C, D, E, F, G, H, a, b, c                                 ] = new Molecule_11[A, B, C, D, E, F, G, H, a, b, c                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                              ] (tx: Elements_04[a, b, c, d                              ]): Molecule_12[A, B, C, D, E, F, G, H, a, b, c, d                              ] = new Molecule_12[A, B, C, D, E, F, G, H, a, b, c, d                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                           ] (tx: Elements_05[a, b, c, d, e                           ]): Molecule_13[A, B, C, D, E, F, G, H, a, b, c, d, e                           ] = new Molecule_13[A, B, C, D, E, F, G, H, a, b, c, d, e                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                        ] (tx: Elements_06[a, b, c, d, e, f                        ]): Molecule_14[A, B, C, D, E, F, G, H, a, b, c, d, e, f                        ] = new Molecule_14[A, B, C, D, E, F, G, H, a, b, c, d, e, f                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                     ] (tx: Elements_07[a, b, c, d, e, f, g                     ]): Molecule_15[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g                     ] = new Molecule_15[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h                  ] (tx: Elements_08[a, b, c, d, e, f, g, h                  ]): Molecule_16[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h                  ] = new Molecule_16[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i               ] (tx: Elements_09[a, b, c, d, e, f, g, h, i               ]): Molecule_17[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i               ] = new Molecule_17[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j            ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j            ]): Molecule_18[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j            ] = new Molecule_18[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k         ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k         ]): Molecule_19[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k         ] = new Molecule_19[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l      ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l      ]): Molecule_20[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l      ] = new Molecule_20[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m   ] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m   ]): Molecule_21[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l, m   ] = new Molecule_21[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l, m   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m, n] (tx: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n]): Molecule_22[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l, m, n] = new Molecule_22[A, B, C, D, E, F, G, H, a, b, c, d, e, f, g, h, i, j, k, l, m, n] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_9[A, B, C, D, E, F, G, H, I] extends TxMetaData_ { self: Elements =>
    final def apply                                        (tx: Elements_00                                       ): Molecule_09[A, B, C, D, E, F, G, H, I                                       ] = new Molecule_09[A, B, C, D, E, F, G, H, I                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                    ] (tx: Elements_01[a                                    ]): Molecule_10[A, B, C, D, E, F, G, H, I, a                                    ] = new Molecule_10[A, B, C, D, E, F, G, H, I, a                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                                 ] (tx: Elements_02[a, b                                 ]): Molecule_11[A, B, C, D, E, F, G, H, I, a, b                                 ] = new Molecule_11[A, B, C, D, E, F, G, H, I, a, b                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                              ] (tx: Elements_03[a, b, c                              ]): Molecule_12[A, B, C, D, E, F, G, H, I, a, b, c                              ] = new Molecule_12[A, B, C, D, E, F, G, H, I, a, b, c                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                           ] (tx: Elements_04[a, b, c, d                           ]): Molecule_13[A, B, C, D, E, F, G, H, I, a, b, c, d                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, a, b, c, d                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                        ] (tx: Elements_05[a, b, c, d, e                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, a, b, c, d, e                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, a, b, c, d, e                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                     ] (tx: Elements_06[a, b, c, d, e, f                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g                  ] (tx: Elements_07[a, b, c, d, e, f, g                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h               ] (tx: Elements_08[a, b, c, d, e, f, g, h               ]): Molecule_17[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i            ] (tx: Elements_09[a, b, c, d, e, f, g, h, i            ]): Molecule_18[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j         ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j         ]): Molecule_19[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k      ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k      ]): Molecule_20[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l   ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l   ]): Molecule_21[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k, l   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k, l   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l, m] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m]): Molecule_22[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k, l, m] = new Molecule_22[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k, l, m] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                        (tx: Elements_00                                       ): Molecule_09[A, B, C, D, E, F, G, H, I                                       ] = new Molecule_09[A, B, C, D, E, F, G, H, I                                       ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                    ] (tx: Elements_01[a                                    ]): Molecule_10[A, B, C, D, E, F, G, H, I, a                                    ] = new Molecule_10[A, B, C, D, E, F, G, H, I, a                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                                 ] (tx: Elements_02[a, b                                 ]): Molecule_11[A, B, C, D, E, F, G, H, I, a, b                                 ] = new Molecule_11[A, B, C, D, E, F, G, H, I, a, b                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                              ] (tx: Elements_03[a, b, c                              ]): Molecule_12[A, B, C, D, E, F, G, H, I, a, b, c                              ] = new Molecule_12[A, B, C, D, E, F, G, H, I, a, b, c                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                           ] (tx: Elements_04[a, b, c, d                           ]): Molecule_13[A, B, C, D, E, F, G, H, I, a, b, c, d                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, a, b, c, d                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                        ] (tx: Elements_05[a, b, c, d, e                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, a, b, c, d, e                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, a, b, c, d, e                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                     ] (tx: Elements_06[a, b, c, d, e, f                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g                  ] (tx: Elements_07[a, b, c, d, e, f, g                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h               ] (tx: Elements_08[a, b, c, d, e, f, g, h               ]): Molecule_17[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i            ] (tx: Elements_09[a, b, c, d, e, f, g, h, i            ]): Molecule_18[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j         ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j         ]): Molecule_19[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k      ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k      ]): Molecule_20[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l   ] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l   ]): Molecule_21[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k, l   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k, l   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l, m] (tx: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m]): Molecule_22[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k, l, m] = new Molecule_22[A, B, C, D, E, F, G, H, I, a, b, c, d, e, f, g, h, i, j, k, l, m] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_10[A, B, C, D, E, F, G, H, I, J] extends TxMetaData_ { self: Elements =>
    final def apply                                     (tx: Elements_00                                    ): Molecule_10[A, B, C, D, E, F, G, H, I, J                                    ] = new Molecule_10[A, B, C, D, E, F, G, H, I, J                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                                 ] (tx: Elements_01[a                                 ]): Molecule_11[A, B, C, D, E, F, G, H, I, J, a                                 ] = new Molecule_11[A, B, C, D, E, F, G, H, I, J, a                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                              ] (tx: Elements_02[a, b                              ]): Molecule_12[A, B, C, D, E, F, G, H, I, J, a, b                              ] = new Molecule_12[A, B, C, D, E, F, G, H, I, J, a, b                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                           ] (tx: Elements_03[a, b, c                           ]): Molecule_13[A, B, C, D, E, F, G, H, I, J, a, b, c                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, J, a, b, c                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                        ] (tx: Elements_04[a, b, c, d                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, J, a, b, c, d                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, a, b, c, d                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                     ] (tx: Elements_05[a, b, c, d, e                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f                  ] (tx: Elements_06[a, b, c, d, e, f                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g               ] (tx: Elements_07[a, b, c, d, e, f, g               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h            ] (tx: Elements_08[a, b, c, d, e, f, g, h            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i         ] (tx: Elements_09[a, b, c, d, e, f, g, h, i         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j      ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k   ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j, k   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j, k   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k, l] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l]): Molecule_22[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j, k, l] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j, k, l] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                     (tx: Elements_00                                    ): Molecule_10[A, B, C, D, E, F, G, H, I, J                                    ] = new Molecule_10[A, B, C, D, E, F, G, H, I, J                                    ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                                 ] (tx: Elements_01[a                                 ]): Molecule_11[A, B, C, D, E, F, G, H, I, J, a                                 ] = new Molecule_11[A, B, C, D, E, F, G, H, I, J, a                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                              ] (tx: Elements_02[a, b                              ]): Molecule_12[A, B, C, D, E, F, G, H, I, J, a, b                              ] = new Molecule_12[A, B, C, D, E, F, G, H, I, J, a, b                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                           ] (tx: Elements_03[a, b, c                           ]): Molecule_13[A, B, C, D, E, F, G, H, I, J, a, b, c                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, J, a, b, c                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                        ] (tx: Elements_04[a, b, c, d                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, J, a, b, c, d                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, a, b, c, d                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                     ] (tx: Elements_05[a, b, c, d, e                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f                  ] (tx: Elements_06[a, b, c, d, e, f                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g               ] (tx: Elements_07[a, b, c, d, e, f, g               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h            ] (tx: Elements_08[a, b, c, d, e, f, g, h            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i         ] (tx: Elements_09[a, b, c, d, e, f, g, h, i         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j      ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k   ] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j, k   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j, k   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k, l] (tx: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l]): Molecule_22[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j, k, l] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, a, b, c, d, e, f, g, h, i, j, k, l] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_11[A, B, C, D, E, F, G, H, I, J, K] extends TxMetaData_ { self: Elements =>
    final def apply                                  (tx: Elements_00                                 ): Molecule_11[A, B, C, D, E, F, G, H, I, J, K                                 ] = new Molecule_11[A, B, C, D, E, F, G, H, I, J, K                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                              ] (tx: Elements_01[a                              ]): Molecule_12[A, B, C, D, E, F, G, H, I, J, K, a                              ] = new Molecule_12[A, B, C, D, E, F, G, H, I, J, K, a                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                           ] (tx: Elements_02[a, b                           ]): Molecule_13[A, B, C, D, E, F, G, H, I, J, K, a, b                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, J, K, a, b                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                        ] (tx: Elements_03[a, b, c                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, J, K, a, b, c                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, K, a, b, c                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                     ] (tx: Elements_04[a, b, c, d                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e                  ] (tx: Elements_05[a, b, c, d, e                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f               ] (tx: Elements_06[a, b, c, d, e, f               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g            ] (tx: Elements_07[a, b, c, d, e, f, g            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h         ] (tx: Elements_08[a, b, c, d, e, f, g, h         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i      ] (tx: Elements_09[a, b, c, d, e, f, g, h, i      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j   ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i, j   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i, j   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j, k] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i, j, k] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i, j, k] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                                  (tx: Elements_00                                 ): Molecule_11[A, B, C, D, E, F, G, H, I, J, K                                 ] = new Molecule_11[A, B, C, D, E, F, G, H, I, J, K                                 ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                              ] (tx: Elements_01[a                              ]): Molecule_12[A, B, C, D, E, F, G, H, I, J, K, a                              ] = new Molecule_12[A, B, C, D, E, F, G, H, I, J, K, a                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                           ] (tx: Elements_02[a, b                           ]): Molecule_13[A, B, C, D, E, F, G, H, I, J, K, a, b                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, J, K, a, b                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                        ] (tx: Elements_03[a, b, c                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, J, K, a, b, c                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, K, a, b, c                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                     ] (tx: Elements_04[a, b, c, d                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e                  ] (tx: Elements_05[a, b, c, d, e                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f               ] (tx: Elements_06[a, b, c, d, e, f               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g            ] (tx: Elements_07[a, b, c, d, e, f, g            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h         ] (tx: Elements_08[a, b, c, d, e, f, g, h         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i      ] (tx: Elements_09[a, b, c, d, e, f, g, h, i      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j   ] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i, j   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i, j   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j, k] (tx: Elements_11[a, b, c, d, e, f, g, h, i, j, k]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i, j, k] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, a, b, c, d, e, f, g, h, i, j, k] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_12[A, B, C, D, E, F, G, H, I, J, K, L] extends TxMetaData_ { self: Elements =>
    final def apply                               (tx: Elements_00                              ): Molecule_12[A, B, C, D, E, F, G, H, I, J, K, L                              ] = new Molecule_12[A, B, C, D, E, F, G, H, I, J, K, L                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                           ] (tx: Elements_01[a                           ]): Molecule_13[A, B, C, D, E, F, G, H, I, J, K, L, a                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, J, K, L, a                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                        ] (tx: Elements_02[a, b                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, a, b                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, a, b                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                     ] (tx: Elements_03[a, b, c                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d                  ] (tx: Elements_04[a, b, c, d                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e               ] (tx: Elements_05[a, b, c, d, e               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f            ] (tx: Elements_06[a, b, c, d, e, f            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g         ] (tx: Elements_07[a, b, c, d, e, f, g         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h      ] (tx: Elements_08[a, b, c, d, e, f, g, h      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i   ] (tx: Elements_09[a, b, c, d, e, f, g, h, i   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h, i   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h, i   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i, j] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h, i, j] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h, i, j] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                               (tx: Elements_00                              ): Molecule_12[A, B, C, D, E, F, G, H, I, J, K, L                              ] = new Molecule_12[A, B, C, D, E, F, G, H, I, J, K, L                              ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                           ] (tx: Elements_01[a                           ]): Molecule_13[A, B, C, D, E, F, G, H, I, J, K, L, a                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, J, K, L, a                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                        ] (tx: Elements_02[a, b                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, a, b                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, a, b                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                     ] (tx: Elements_03[a, b, c                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d                  ] (tx: Elements_04[a, b, c, d                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e               ] (tx: Elements_05[a, b, c, d, e               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f            ] (tx: Elements_06[a, b, c, d, e, f            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g         ] (tx: Elements_07[a, b, c, d, e, f, g         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h      ] (tx: Elements_08[a, b, c, d, e, f, g, h      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i   ] (tx: Elements_09[a, b, c, d, e, f, g, h, i   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h, i   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h, i   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i, j] (tx: Elements_10[a, b, c, d, e, f, g, h, i, j]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h, i, j] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, a, b, c, d, e, f, g, h, i, j] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_13[A, B, C, D, E, F, G, H, I, J, K, L, M] extends TxMetaData_ { self: Elements =>
    final def apply                            (tx: Elements_00                           ): Molecule_13[A, B, C, D, E, F, G, H, I, J, K, L, M                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, J, K, L, M                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                        ] (tx: Elements_01[a                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, M, a                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, M, a                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                     ] (tx: Elements_02[a, b                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c                  ] (tx: Elements_03[a, b, c                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d               ] (tx: Elements_04[a, b, c, d               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e            ] (tx: Elements_05[a, b, c, d, e            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f         ] (tx: Elements_06[a, b, c, d, e, f         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g      ] (tx: Elements_07[a, b, c, d, e, f, g      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h   ] (tx: Elements_08[a, b, c, d, e, f, g, h   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g, h   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g, h   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h, i] (tx: Elements_09[a, b, c, d, e, f, g, h, i]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g, h, i] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g, h, i] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                            (tx: Elements_00                           ): Molecule_13[A, B, C, D, E, F, G, H, I, J, K, L, M                           ] = new Molecule_13[A, B, C, D, E, F, G, H, I, J, K, L, M                           ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                        ] (tx: Elements_01[a                        ]): Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, M, a                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, M, a                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                     ] (tx: Elements_02[a, b                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c                  ] (tx: Elements_03[a, b, c                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d               ] (tx: Elements_04[a, b, c, d               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e            ] (tx: Elements_05[a, b, c, d, e            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f         ] (tx: Elements_06[a, b, c, d, e, f         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g      ] (tx: Elements_07[a, b, c, d, e, f, g      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h   ] (tx: Elements_08[a, b, c, d, e, f, g, h   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g, h   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g, h   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h, i] (tx: Elements_09[a, b, c, d, e, f, g, h, i]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g, h, i] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, a, b, c, d, e, f, g, h, i] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_14[A, B, C, D, E, F, G, H, I, J, K, L, M, N] extends TxMetaData_ { self: Elements =>
    final def apply                         (tx: Elements_00                        ): Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, M, N                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, M, N                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                     ] (tx: Elements_01[a                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b                  ] (tx: Elements_02[a, b                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c               ] (tx: Elements_03[a, b, c               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d            ] (tx: Elements_04[a, b, c, d            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e         ] (tx: Elements_05[a, b, c, d, e         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f      ] (tx: Elements_06[a, b, c, d, e, f      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g   ] (tx: Elements_07[a, b, c, d, e, f, g   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f, g   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f, g   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g, h] (tx: Elements_08[a, b, c, d, e, f, g, h]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f, g, h] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f, g, h] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                         (tx: Elements_00                        ): Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, M, N                        ] = new Molecule_14[A, B, C, D, E, F, G, H, I, J, K, L, M, N                        ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                     ] (tx: Elements_01[a                     ]): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b                  ] (tx: Elements_02[a, b                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c               ] (tx: Elements_03[a, b, c               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d            ] (tx: Elements_04[a, b, c, d            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e         ] (tx: Elements_05[a, b, c, d, e         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f      ] (tx: Elements_06[a, b, c, d, e, f      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g   ] (tx: Elements_07[a, b, c, d, e, f, g   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f, g   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f, g   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g, h] (tx: Elements_08[a, b, c, d, e, f, g, h]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f, g, h] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, a, b, c, d, e, f, g, h] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O] extends TxMetaData_ { self: Elements =>
    final def apply                      (tx: Elements_00                     ): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a                  ] (tx: Elements_01[a                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b               ] (tx: Elements_02[a, b               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c            ] (tx: Elements_03[a, b, c            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d         ] (tx: Elements_04[a, b, c, d         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e      ] (tx: Elements_05[a, b, c, d, e      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f   ] (tx: Elements_06[a, b, c, d, e, f   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e, f   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e, f   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f, g] (tx: Elements_07[a, b, c, d, e, f, g]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e, f, g] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e, f, g] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                      (tx: Elements_00                     ): Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O                     ] = new Molecule_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O                     ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a                  ] (tx: Elements_01[a                  ]): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b               ] (tx: Elements_02[a, b               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c            ] (tx: Elements_03[a, b, c            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d         ] (tx: Elements_04[a, b, c, d         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e      ] (tx: Elements_05[a, b, c, d, e      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f   ] (tx: Elements_06[a, b, c, d, e, f   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e, f   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e, f   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f, g] (tx: Elements_07[a, b, c, d, e, f, g]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e, f, g] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, a, b, c, d, e, f, g] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P] extends TxMetaData_ { self: Elements =>
    final def apply                   (tx: Elements_00                  ): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a               ] (tx: Elements_01[a               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b            ] (tx: Elements_02[a, b            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c         ] (tx: Elements_03[a, b, c         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d      ] (tx: Elements_04[a, b, c, d      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e   ] (tx: Elements_05[a, b, c, d, e   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d, e   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d, e   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e, f] (tx: Elements_06[a, b, c, d, e, f]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d, e, f] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d, e, f] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                   (tx: Elements_00                  ): Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P                  ] = new Molecule_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P                  ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a               ] (tx: Elements_01[a               ]): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b            ] (tx: Elements_02[a, b            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c         ] (tx: Elements_03[a, b, c         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d      ] (tx: Elements_04[a, b, c, d      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e   ] (tx: Elements_05[a, b, c, d, e   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d, e   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d, e   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e, f] (tx: Elements_06[a, b, c, d, e, f]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d, e, f] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, a, b, c, d, e, f] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q] extends TxMetaData_ { self: Elements =>
    final def apply                (tx: Elements_00               ): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a            ] (tx: Elements_01[a            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b         ] (tx: Elements_02[a, b         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c      ] (tx: Elements_03[a, b, c      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d   ] (tx: Elements_04[a, b, c, d   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c, d   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c, d   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d, e] (tx: Elements_05[a, b, c, d, e]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c, d, e] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c, d, e] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta                (tx: Elements_00               ): Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q               ] = new Molecule_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q               ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a            ] (tx: Elements_01[a            ]): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b         ] (tx: Elements_02[a, b         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c      ] (tx: Elements_03[a, b, c      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d   ] (tx: Elements_04[a, b, c, d   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c, d   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c, d   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d, e] (tx: Elements_05[a, b, c, d, e]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c, d, e] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, a, b, c, d, e] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R] extends TxMetaData_ { self: Elements =>
    final def apply             (tx: Elements_00            ): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a         ] (tx: Elements_01[a         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b      ] (tx: Elements_02[a, b      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c   ] (tx: Elements_03[a, b, c   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b, c   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b, c   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c, d] (tx: Elements_04[a, b, c, d]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b, c, d] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b, c, d] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta             (tx: Elements_00            ): Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R            ] = new Molecule_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R            ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a         ] (tx: Elements_01[a         ]): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b      ] (tx: Elements_02[a, b      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c   ] (tx: Elements_03[a, b, c   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b, c   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b, c   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c, d] (tx: Elements_04[a, b, c, d]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b, c, d] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, a, b, c, d] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S] extends TxMetaData_ { self: Elements =>
    final def apply         (tx: Elements_00         ): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a      ](tx: Elements_01[a      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b   ](tx: Elements_02[a, b   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a, b   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a, b   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b, c](tx: Elements_03[a, b, c]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a, b, c] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a, b, c] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta         (tx: Elements_00         ): Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S         ] = new Molecule_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S         ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a      ](tx: Elements_01[a      ]): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b   ](tx: Elements_02[a, b   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a, b   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a, b   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b, c](tx: Elements_03[a, b, c]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a, b, c] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, a, b, c] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T] extends TxMetaData_ { self: Elements =>
    final def apply       (tx: Elements_00      ): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a   ] (tx: Elements_01[a   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, a   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, a   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a, b] (tx: Elements_02[a, b]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, a, b] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, a, b] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta       (tx: Elements_00      ): Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T      ] = new Molecule_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T      ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a   ] (tx: Elements_01[a   ]): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, a   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, a   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a, b] (tx: Elements_02[a, b]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, a, b] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, a, b] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U] extends TxMetaData_ { self: Elements =>
    final def apply    (tx: Elements_00   ): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def apply[a] (tx: Elements_01[a]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, a] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, a] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta    (tx: Elements_00   ): Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U   ] = new Molecule_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U   ] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
    final def meta[a] (tx: Elements_01[a]): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, a] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, a] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}

trait TxMetaData_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V] extends TxMetaData_ { self: Elements =>
    final def apply(tx: Elements_00): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }

    final def meta(tx: Elements_00): Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V] = new Molecule_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V] { override val elements: List[Element] = self.elements :+ TxMetaData(tx.elements) }
}
