package codegen.boilerplate.api

import codegen.BoilerplateGenBase

object _Nested extends BoilerplateGenBase("Nested", "/api") {
  val content = {
    val traits = (0 to 21).map(arity => Trait(arity).body).mkString("\n")
    s"""// GENERATED CODE ********************************
       |package molecule.boilerplate.api
       |
       |import molecule.boilerplate.ast.DataModel._
       |
       |$traits
       |""".stripMargin
  }

  case class Trait(arity: Int) extends TemplateVals(arity) {
    val body =
      s"""
         |class NestedInit_$n0[${`A..V, `}NestedTpl](override val elements: List[Element]) extends Molecule_$n1[${`A..V, `}Seq[NestedTpl]]
         |
         |trait ${fileName}Op${_0}${`[A..V]`} {
         |  protected def _nestedMan[NestedTpl](nestedElements: List[Element]): NestedInit_$n0[${`A..V, `}NestedTpl] = ???
         |  protected def _nestedOpt[NestedTpl](nestedElements: List[Element]): NestedInit_$n0[${`A..V, `}NestedTpl] = ???
         |}
         |trait $fileName_$arity${`[A..V]`} { self: ${fileName}Op${_0}${`[A..V]`} =>
         |  final def * [a                                                               ] (nested: Molecule_01[a                                                               ]): NestedInit_$n0[${`A..V, `}a                                                                 ] = _nestedMan[a                                                                 ](nested.elements)
         |  final def * [a, b                                                            ] (nested: Molecule_02[a, b                                                            ]): NestedInit_$n0[${`A..V, `}(a, b                                                            )] = _nestedMan[(a, b                                                            )](nested.elements)
         |  final def * [a, b, c                                                         ] (nested: Molecule_03[a, b, c                                                         ]): NestedInit_$n0[${`A..V, `}(a, b, c                                                         )] = _nestedMan[(a, b, c                                                         )](nested.elements)
         |  final def * [a, b, c, d                                                      ] (nested: Molecule_04[a, b, c, d                                                      ]): NestedInit_$n0[${`A..V, `}(a, b, c, d                                                      )] = _nestedMan[(a, b, c, d                                                      )](nested.elements)
         |  final def * [a, b, c, d, e                                                   ] (nested: Molecule_05[a, b, c, d, e                                                   ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e                                                   )] = _nestedMan[(a, b, c, d, e                                                   )](nested.elements)
         |  final def * [a, b, c, d, e, f                                                ] (nested: Molecule_06[a, b, c, d, e, f                                                ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f                                                )] = _nestedMan[(a, b, c, d, e, f                                                )](nested.elements)
         |  final def * [a, b, c, d, e, f, g                                             ] (nested: Molecule_07[a, b, c, d, e, f, g                                             ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g                                             )] = _nestedMan[(a, b, c, d, e, f, g                                             )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h                                          ] (nested: Molecule_08[a, b, c, d, e, f, g, h                                          ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h                                          )] = _nestedMan[(a, b, c, d, e, f, g, h                                          )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i                                       ] (nested: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i                                       )] = _nestedMan[(a, b, c, d, e, f, g, h, i                                       )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j                                    ] (nested: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j                                    )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j                                    )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k                                 )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k                                 )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l                              )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = _nestedMan[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nested.elements)
         |
         |  final def *?[a                                                               ] (nested: Molecule_01[a                                                               ]): NestedInit_$n0[${`A..V, `}a                                                                 ] = _nestedOpt[a                                                                 ](nested.elements)
         |  final def *?[a, b                                                            ] (nested: Molecule_02[a, b                                                            ]): NestedInit_$n0[${`A..V, `}(a, b                                                            )] = _nestedOpt[(a, b                                                            )](nested.elements)
         |  final def *?[a, b, c                                                         ] (nested: Molecule_03[a, b, c                                                         ]): NestedInit_$n0[${`A..V, `}(a, b, c                                                         )] = _nestedOpt[(a, b, c                                                         )](nested.elements)
         |  final def *?[a, b, c, d                                                      ] (nested: Molecule_04[a, b, c, d                                                      ]): NestedInit_$n0[${`A..V, `}(a, b, c, d                                                      )] = _nestedOpt[(a, b, c, d                                                      )](nested.elements)
         |  final def *?[a, b, c, d, e                                                   ] (nested: Molecule_05[a, b, c, d, e                                                   ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e                                                   )] = _nestedOpt[(a, b, c, d, e                                                   )](nested.elements)
         |  final def *?[a, b, c, d, e, f                                                ] (nested: Molecule_06[a, b, c, d, e, f                                                ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f                                                )] = _nestedOpt[(a, b, c, d, e, f                                                )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g                                             ] (nested: Molecule_07[a, b, c, d, e, f, g                                             ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g                                             )] = _nestedOpt[(a, b, c, d, e, f, g                                             )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h                                          ] (nested: Molecule_08[a, b, c, d, e, f, g, h                                          ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h                                          )] = _nestedOpt[(a, b, c, d, e, f, g, h                                          )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i                                       ] (nested: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i                                       )] = _nestedOpt[(a, b, c, d, e, f, g, h, i                                       )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j                                    ] (nested: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j                                    )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j                                    )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k                                 )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k                                 )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l                              )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): NestedInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = _nestedOpt[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nested.elements)
         |}
         |""".stripMargin
  }
}
