/*
 * Decompiled with CFR 0.152.
 */
package molecule.base.util;

import java.io.Serializable;
import java.net.URI;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.UUID;
import molecule.base.error.ModelError$;
import molecule.base.util.DateHandling;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.BigDecimal;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public interface BaseHelpers
extends DateHandling {
    public static void $init$(BaseHelpers $this) {
        $this.molecule$base$util$BaseHelpers$$time0_$eq(System.currentTimeMillis());
        $this.molecule$base$util$BaseHelpers$$prevTime_$eq($this.molecule$base$util$BaseHelpers$$time0());
    }

    public static String firstLow$(BaseHelpers $this, Object str) {
        return $this.firstLow(str);
    }

    default public String firstLow(Object str) {
        return new StringBuilder(0).append(BoxesRunTime.boxToCharacter((char)RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(str.toString()))))).toString()).append(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(str.toString()))).toString();
    }

    public static String getKwName$(BaseHelpers $this, String kw) {
        return $this.getKwName(kw);
    }

    default public String getKwName(String kw) {
        return kw.substring(kw.indexOf(47) + 1);
    }

    public static String thousands$(BaseHelpers $this, long i) {
        return $this.thousands(i);
    }

    default public String thousands(long i) {
        return StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(BoxesRunTime.boxToLong((long)i).toString()))), 3).mkString(" ")));
    }

    public static String indent$(BaseHelpers $this, int tabs) {
        return $this.indent(tabs);
    }

    default public String indent(int tabs) {
        return StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("  "), tabs);
    }

    public static String escStr$(BaseHelpers $this, String s) {
        return $this.escStr(s);
    }

    default public String escStr(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String unescStr$(BaseHelpers $this, String s) {
        return $this.unescStr(s);
    }

    default public String unescStr(String s) {
        return s.replace("\\\"", "\"").replace("\\\\", "\\");
    }

    public static String withDecimal$(BaseHelpers $this, Object v) {
        return $this.withDecimal(v);
    }

    default public String withDecimal(Object v) {
        String s = v.toString();
        if (s.contains(".")) {
            return s;
        }
        return new StringBuilder(2).append(s).append(".0").toString();
    }

    public static String ss$(BaseHelpers $this, String a, String b) {
        return $this.ss(a, b);
    }

    default public String ss(String a, String b) {
        return new StringBuilder(1).append(a).append("_").append(b).toString().replace("__", "_");
    }

    public static String ss$(BaseHelpers $this, String a, String b, String c) {
        return $this.ss(a, b, c);
    }

    default public String ss(String a, String b, String c) {
        return new StringBuilder(2).append(a).append("_").append(b).append("_").append(c).toString().replace("__", "_");
    }

    public static String double$(BaseHelpers $this, Object arg) {
        return $this.double(arg);
    }

    default public String double(Object arg) {
        return new StringBuilder(5).append("__n__").append(arg).append(arg.toString().contains(".") ? "" : ".0").toString();
    }

    public static BigDecimal bigDec$(BaseHelpers $this, Object arg) {
        return $this.bigDec(arg);
    }

    default public BigDecimal bigDec(Object arg) {
        return package$.MODULE$.BigDecimal().apply(this.withDecimal(arg));
    }

    public static String padS$(BaseHelpers $this, int longest, String str) {
        return $this.padS(longest, str);
    }

    default public String padS(int longest, String str) {
        return this.pad(longest, str.length());
    }

    public static String pad$(BaseHelpers $this, int longest, int shorter) {
        return $this.pad(longest, shorter);
    }

    default public String pad(int longest, int shorter) {
        if (longest > shorter) {
            return StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), longest - shorter);
        }
        return "";
    }

    public static String o$(BaseHelpers $this, Option opt) {
        return $this.o((Option<Object>)opt);
    }

    default public String o(Option<Object> opt) {
        return (String)opt.fold(BaseHelpers::o$$anonfun$1, (Function1 & Serializable)v -> new StringBuilder(6).append("Some(").append(this.render(v)).append(")").toString());
    }

    public static String opt$(BaseHelpers $this, Option opt) {
        return $this.opt((Option<Object>)opt);
    }

    default public String opt(Option<Object> opt) {
        return (String)opt.fold(BaseHelpers::opt$$anonfun$1, (Function1 & Serializable)v -> new StringBuilder(6).append("Some(").append(v).append(")").toString());
    }

    public static String optFilterAttr$(BaseHelpers $this, Option opt) {
        return $this.optFilterAttr((Option<Tuple3<Object, List<String>, Object>>)opt);
    }

    default public String optFilterAttr(Option<Tuple3<Object, List<String>, Object>> opt) {
        return (String)opt.fold(BaseHelpers::optFilterAttr$$anonfun$1, (Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                int dir = BoxesRunTime.unboxToInt((Object)tuple3._1());
                List filterPath = (List)tuple3._2();
                Object filterAttr = tuple3._3();
                String path = filterPath.mkString("List(\"", "\", \"", "\")");
                return new StringBuilder(18).append("Some(").append(dir).append(", ").append(path).append(", \n    ").append(filterAttr).append("\n  )").toString();
            }
            throw new MatchError((Object)tuple3);
        });
    }

    public static String oStr$(BaseHelpers $this, Option opt) {
        return $this.oStr((Option<String>)opt);
    }

    default public String oStr(Option<String> opt) {
        if (opt.isEmpty()) {
            return "None";
        }
        return new StringBuilder(8).append("Some(\"").append(opt.get()).append("\")").toString();
    }

    public static String oStr2$(BaseHelpers $this, Option opt) {
        return $this.oStr2((Option<String>)opt);
    }

    default public String oStr2(Option<String> opt) {
        if (opt.isEmpty()) {
            return "None";
        }
        String s = this.escStr((String)opt.get());
        if (s.contains("\n")) {
            return new StringBuilder(13).append("Some(\n").append("\"\"\"").append(s).append("\"\"\")").toString();
        }
        return new StringBuilder(8).append("Some(\"").append(s).append("\")").toString();
    }

    public static String render$(BaseHelpers $this, Object value) {
        return $this.render(value);
    }

    default public String render(Object value) {
        Object object = value;
        if (object instanceof Tuple2) {
            Tuple2 tuple2 = (Tuple2)object;
            Object a = tuple2._1();
            Object b = tuple2._2();
            return new StringBuilder(4).append("(").append(this.render(a)).append(", ").append(this.render(b)).append(")").toString();
        }
        if (object instanceof Long) {
            long v = BoxesRunTime.unboxToLong((Object)object);
            return new StringBuilder(1).append(BoxesRunTime.boxToLong((long)v).toString()).append("L").toString();
        }
        if (object instanceof Float) {
            float v = BoxesRunTime.unboxToFloat((Object)object);
            return new StringBuilder(1).append(BoxesRunTime.boxToFloat((float)v).toString()).append("f").toString();
        }
        if (object instanceof String) {
            String v = (String)object;
            return new StringBuilder(2).append("\"").append(this.escStr(v)).append("\"").toString();
        }
        if (object instanceof Date) {
            Date d = (Date)object;
            return d.toString();
        }
        if (object instanceof UUID) {
            UUID v = (UUID)object;
            return new StringBuilder(2).append("\"").append(v).append("\"").toString();
        }
        if (object instanceof URI) {
            URI v = (URI)object;
            return new StringBuilder(2).append("\"").append(v).append("\"").toString();
        }
        Object v = object;
        return v.toString();
    }

    public static String renderValidations$(BaseHelpers $this, Seq validations) {
        return $this.renderValidations((Seq<Tuple2<String, String>>)validations);
    }

    default public String renderValidations(Seq<Tuple2<String, String>> validations) {
        if (validations.isEmpty()) {
            return "Nil";
        }
        return ((IterableOnceOps)validations.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String test = (String)tuple2._1();
                String error = (String)tuple2._2();
                String errorStr = error.isEmpty() ? "\"\"" : new StringBuilder(6).append("\"\"\"").append(error).append("\"\"\"").toString();
                return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(106).append("            (\n             |              \"\"\"").append(test).append("\"\"\",\n             |              ").append(errorStr).append("\n             |            )").toString()));
            }
            throw new MatchError((Object)tuple2);
        })).mkString("Seq(\n", ",\n", ")");
    }

    public static String sq$(BaseHelpers $this, Iterable values) {
        return $this.sq(values);
    }

    default public <T> String sq(Iterable<T> values) {
        if (values.isEmpty()) {
            return "Nil";
        }
        return ((IterableOnceOps)values.map((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (object instanceof Set) {
                Set set = (Set)object;
                if (((IterableOnceOps)set).isEmpty()) {
                    return "Nil";
                }
                return ((IterableOnceOps)((IterableOps)set).map((Function1 & Serializable)value -> this.render(value))).mkString("Set(", ", ", ")");
            }
            if (object instanceof Seq) {
                Seq seq = (Seq)object;
                if (((SeqOps)seq).isEmpty()) {
                    return "Nil";
                }
                return ((IterableOnceOps)((IterableOps)seq).map((Function1 & Serializable)value -> this.render(value))).mkString("Seq(", ", ", ")");
            }
            if (object instanceof Tuple2) {
                Tuple2 tuple2 = (Tuple2)object;
                Object a = tuple2._1();
                Object b = tuple2._2();
                return new StringBuilder(4).append(this.render(a)).append(" -> ").append(this.render(b)).toString();
            }
            Object v = object;
            return this.render(v);
        })).mkString("Seq(", ", ", ")");
    }

    public long molecule$base$util$BaseHelpers$$time0();

    public void molecule$base$util$BaseHelpers$$time0_$eq(long var1);

    public long molecule$base$util$BaseHelpers$$prevTime();

    public void molecule$base$util$BaseHelpers$$prevTime_$eq(long var1);

    public static Map molecule$base$util$BaseHelpers$$times$(BaseHelpers $this) {
        return $this.molecule$base$util$BaseHelpers$$times();
    }

    default public Map<Object, Object> molecule$base$util$BaseHelpers$$times() {
        return (Map)Map$.MODULE$.empty();
    }

    public static DateTimeFormatter molecule$base$util$BaseHelpers$$formatter$(BaseHelpers $this) {
        return $this.molecule$base$util$BaseHelpers$$formatter();
    }

    default public DateTimeFormatter molecule$base$util$BaseHelpers$$formatter() {
        return DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    }

    public static void resetTimer$(BaseHelpers $this) {
        $this.resetTimer();
    }

    default public void resetTimer() {
        this.molecule$base$util$BaseHelpers$$time0_$eq(System.currentTimeMillis());
        this.molecule$base$util$BaseHelpers$$prevTime_$eq(this.molecule$base$util$BaseHelpers$$time0());
        this.molecule$base$util$BaseHelpers$$times().clear();
    }

    public static void time$(BaseHelpers $this, int n, int prev) {
        $this.time(n, prev);
    }

    default public void time(int n, int prev) {
        if (n < 1 || prev < 0) {
            throw new IllegalArgumentException("Identifiers have to be positive numbers");
        }
        if (this.molecule$base$util$BaseHelpers$$times().nonEmpty() && n <= BoxesRunTime.unboxToInt((Object)this.molecule$base$util$BaseHelpers$$times().keys().max((Ordering)Ordering.Int$.MODULE$))) {
            throw new IllegalArgumentException(new StringBuilder(77).append("Identifier have to be incremental. `").append(n).append("` is smaller than or equal to previous `").append(this.molecule$base$util$BaseHelpers$$times().keys().max((Ordering)Ordering.Int$.MODULE$)).append("`").toString());
        }
        if (this.molecule$base$util$BaseHelpers$$times().keys().toSeq().contains((Object)BoxesRunTime.boxToInteger((int)n))) {
            throw new IllegalArgumentException(new StringBuilder(48).append("Can't use same time identifier `").append(n).append("` multiple times").toString());
        }
        long time1 = prev > 0 ? this.molecule$base$util$BaseHelpers$$times().apply$mcJI$sp(prev) : this.molecule$base$util$BaseHelpers$$prevTime();
        long time2 = System.currentTimeMillis();
        long elapsed = time2 - time1;
        Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)n));
        this.molecule$base$util$BaseHelpers$$times().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n2, (Object)BoxesRunTime.boxToLong((long)time2)));
        this.molecule$base$util$BaseHelpers$$prevTime_$eq(time2);
        LocalDateTime d = LocalDateTime.ofInstant(Instant.ofEpochMilli(elapsed), ZoneOffset.UTC);
        Predef$.MODULE$.println((Object)new StringBuilder(7).append("TIME ").append(n).append(": ").append(this.molecule$base$util$BaseHelpers$$formatter().format(d)).toString());
    }

    public static int time$default$2$(BaseHelpers $this) {
        return $this.time$default$2();
    }

    default public int time$default$2() {
        return 0;
    }

    public static void diff$(BaseHelpers $this, String s1, String s2) {
        $this.diff(s1, s2);
    }

    default public void diff(String s1, String s2) {
        Object[] objectArray;
        Object[] lines1 = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(s1), '\n');
        Object[] lines2 = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(s2), '\n');
        Object object = Predef$.MODULE$.refArrayOps(lines1);
        int max1 = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.length(), ClassTag$.MODULE$.apply(Integer.TYPE))).max((Ordering)Ordering.Int$.MODULE$)) + 3;
        if (lines1.length >= lines2.length) {
            Object object2 = Predef$.MODULE$.refArrayOps(lines2);
            Iterator it2 = ArrayOps$.MODULE$.iterator$extension(object2);
            Object object3 = Predef$.MODULE$.refArrayOps(lines1);
            objectArray = (String[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)l1 -> new StringBuilder(5).append((String)l1).append(this.padS(max1, (String)l1)).append("  |  ").append(it2.hasNext() ? it2.next() : "").toString(), ClassTag$.MODULE$.apply(String.class));
        } else {
            Object object4 = Predef$.MODULE$.refArrayOps(lines1);
            Iterator it1 = ArrayOps$.MODULE$.iterator$extension(object4);
            Object object5 = Predef$.MODULE$.refArrayOps(lines2);
            objectArray = (String[])ArrayOps$.MODULE$.map$extension(object5, (Function1 & Serializable)l2 -> {
                String s1 = it1.hasNext() ? (String)it1.next() : "";
                return new StringBuilder(5).append(s1).append(this.padS(max1, s1)).append("  |  ").append((String)l2).toString();
            }, ClassTag$.MODULE$.apply(String.class));
        }
        Object[] lines = objectArray;
        Predef$.MODULE$.println((Object)Predef$.MODULE$.wrapRefArray(lines).mkString("\n"));
    }

    public static String okIdent$(BaseHelpers $this, String name) {
        return $this.okIdent(name);
    }

    default public String okIdent(String name) {
        List list;
        Option option;
        String string = name;
        if (string != null && !(option = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{":-?[a-zA-Z][a-zA-Z0-9_]+/[a-z][a-zA-Z0-9]+"}))).r().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(0) == 0) {
            return name;
        }
        throw ModelError$.MODULE$.apply(new StringBuilder(103).append("Invalid attribute name `").append(name).append("`. ").append("Expecting attribute name in the format `:<Ns>/<attr>` or `:<part_Ns>/<attr>`").toString());
    }

    public static String okEnumIdent$(BaseHelpers $this, String enumIdent) {
        return $this.okEnumIdent(enumIdent);
    }

    default public String okEnumIdent(String enumIdent) {
        List list;
        Option option;
        String string = enumIdent;
        if (string != null && !(option = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{":[a-zA-Z][a-zA-Z0-9_]+\\.[a-zA-Z0-9_]+/[a-zA-Z0-9]+"}))).r().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(0) == 0) {
            return enumIdent;
        }
        throw ModelError$.MODULE$.apply(new StringBuilder(127).append("Invalid enum attribute name `").append(enumIdent).append("`. ").append("Expecting enum attribute name in the format `:<Ns>.<attr>/<enum>` or `:<part_Ns>.<attr>/<enum>`").toString());
    }

    public static String okNamespaceName$(BaseHelpers $this, String name) {
        return $this.okNamespaceName(name);
    }

    default public String okNamespaceName(String name) {
        List list;
        Option option;
        String string = name;
        if (string != null && !(option = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[a-zA-Z][a-zA-Z0-9_]+"}))).r().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(0) == 0) {
            return name;
        }
        throw ModelError$.MODULE$.apply(new StringBuilder(89).append("Invalid namespace name `").append(name).append("`. Expecting namespace name in the format `[a-zA-Z][a-zA-Z0-9_]+`").toString());
    }

    public static String okPartitionName$(BaseHelpers $this, String name) {
        return $this.okPartitionName(name);
    }

    default public String okPartitionName(String name) {
        List list;
        Option option;
        String string = name;
        if (string != null && !(option = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[a-z][a-zA-Z0-9]+"}))).r().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(0) == 0) {
            return name;
        }
        throw ModelError$.MODULE$.apply(new StringBuilder(85).append("Invalid partition name `").append(name).append("`. Expecting partition name in the format `[a-z][a-zA-Z0-9]+`").toString());
    }

    private static String o$$anonfun$1() {
        return "None";
    }

    private static String opt$$anonfun$1() {
        return "None";
    }

    private static String optFilterAttr$$anonfun$1() {
        return "None";
    }
}

