/*
 * Decompiled with CFR 0.152.
 */
package molecule.base.util;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.TimeZone;
import molecule.base.util.RegexMatching;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext$;
import scala.Tuple9;
import scala.Tuple9$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public interface DateHandling
extends RegexMatching {
    public static ZoneOffset localZoneOffset$(DateHandling $this) {
        return $this.localZoneOffset();
    }

    default public ZoneOffset localZoneOffset() {
        return OffsetDateTime.now().getOffset();
    }

    public static String localOffset$(DateHandling $this) {
        return $this.localOffset();
    }

    default public String localOffset() {
        return this.localZoneOffset().toString();
    }

    public static ZoneId zone$(DateHandling $this) {
        return $this.zone();
    }

    default public ZoneId zone() {
        return ZoneId.of(TimeZone.getDefault().getID());
    }

    private Nothing$ error(String err) {
        String err1 = new StringBuilder(16).append("[DateHandling]  ").append(err).toString();
        throw new IllegalArgumentException(err1);
    }

    private int mkMs(String s) {
        String string = s;
        if (string != null) {
            List list;
            List list2;
            List list3;
            Option option = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(00\\d|0\\d\\d|\\d\\d\\d)", ""}))).r().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && (list3 = (List)option.get()).lengthCompare(1) == 0) {
                String string2;
                String n = string2 = (String)list3.apply(0);
                return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(n));
            }
            Option option2 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(0\\d|\\d\\d)", ""}))).r().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && (list2 = (List)option2.get()).lengthCompare(1) == 0) {
                String string3;
                String n = string3 = (String)list2.apply(0);
                return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(n)) * 10;
            }
            Option option3 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(\\d)", ""}))).r().unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && (list = (List)option3.get()).lengthCompare(1) == 0) {
                String string4;
                String n = string4 = (String)list.apply(0);
                return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(n)) * 100;
            }
        }
        throw new MatchError((Object)string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean local(String sign, String zh, String zm) {
        String string = new StringBuilder(1).append(sign).append(zh).append(":").append(zm).toString();
        String string2 = this.localOffset();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = zh;
        String string4 = "Z";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private String p(String s, int i) {
        int n = i;
        switch (n) {
            case 2: {
                return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)))}));
            }
            case 3: {
                return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%03d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)))}));
            }
            case 4: {
                return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%04d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)))}));
            }
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    private int p$default$2() {
        return 2;
    }

    public static int daylight$(DateHandling $this, long ms) {
        return $this.daylight(ms);
    }

    default public int daylight(long ms) {
        if (this.zone().getRules().isDaylightSavings(Instant.ofEpochMilli(ms))) {
            return 0;
        }
        return 3600000;
    }

    private String getDateStr(Date date, ZoneOffset zoneOffset, String pattern) {
        LocalDateTime ldt = LocalDateTime.ofInstant(Instant.ofEpochMilli(date.getTime()), zoneOffset);
        ZonedDateTime zdt = ZonedDateTime.of(ldt, zoneOffset);
        return zdt.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String date2datomic$(DateHandling $this, Date date) {
        return $this.date2datomic(date);
    }

    default public String date2datomic(Date date) {
        return this.getDateStr(date, ZoneOffset.ofTotalSeconds(0), "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    }

    public static String date2str$(DateHandling $this, Date date, ZoneOffset zoneOffset) {
        return $this.date2str(date, zoneOffset);
    }

    default public String date2str(Date date, ZoneOffset zoneOffset) {
        long epochMs0 = date.getTime();
        long epochMs = epochMs0 - (long)this.daylight(epochMs0);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMs), zoneOffset);
        boolean ms = zdt.getNano() / 1000000 > 0;
        ZoneOffset zoneOffset2 = zoneOffset;
        ZoneOffset zoneOffset3 = this.localZoneOffset();
        if (!(zoneOffset2 != null ? !((Object)zoneOffset2).equals(zoneOffset3) : zoneOffset3 != null)) {
            if (ms) {
                return zdt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
            }
            if (zdt.getSecond() != 0) {
                return zdt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            if (zdt.getHour() != 0 || zdt.getMinute() != 0) {
                return zdt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
            }
            return zdt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        if (ms) {
            return zdt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS XXX"));
        }
        if (zdt.getSecond() != 0) {
            return zdt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss XXX"));
        }
        return zdt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm XXX"));
    }

    public static ZoneOffset date2str$default$2$(DateHandling $this) {
        return $this.date2str$default$2();
    }

    default public ZoneOffset date2str$default$2() {
        return this.localZoneOffset();
    }

    public static Date str2date$(DateHandling $this, String s, ZoneOffset zoneOffset) {
        return $this.str2date(s, zoneOffset);
    }

    default public Date str2date(String s, ZoneOffset zoneOffset) {
        Instant inst = this.str2zdt(s, zoneOffset).toInstant();
        long ms = inst.getEpochSecond() * 1000L + (long)(inst.getNano() / 1000000);
        return new Date(ms + (long)this.daylight(ms));
    }

    public static ZoneOffset str2date$default$2$(DateHandling $this) {
        return $this.str2date$default$2();
    }

    default public ZoneOffset str2date$default$2() {
        return this.localZoneOffset();
    }

    public static ZonedDateTime str2zdt$(DateHandling $this, String s, ZoneOffset zoneOffset) {
        return $this.str2zdt(s, zoneOffset);
    }

    default public ZonedDateTime str2zdt(String s, ZoneOffset zoneOffset) {
        String string = s.trim();
        if (string != null) {
            List list;
            List list2;
            List list3;
            List list4;
            List list5;
            List list6;
            List list7;
            List list8;
            List list9;
            List list10;
            List list11;
            List list12;
            Option option = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && (list12 = (List)option.get()).lengthCompare(1) == 0) {
                String string2;
                String y = string2 = (String)list12.apply(0);
                return this.da$1(zoneOffset, y, DateHandling.da$default$2$1(), DateHandling.da$default$3$1(), DateHandling.da$default$4$1(), DateHandling.da$default$5$1(), DateHandling.da$default$6$1(), DateHandling.da$default$7$1(), DateHandling.da$default$8$1(), DateHandling.da$default$9$1());
            }
            Option option2 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && (list11 = (List)option2.get()).lengthCompare(2) == 0) {
                String string3 = (String)list11.apply(0);
                String string4 = (String)list11.apply(1);
                String y = string3;
                String m = string4;
                return this.da$1(zoneOffset, y, m, DateHandling.da$default$3$1(), DateHandling.da$default$4$1(), DateHandling.da$default$5$1(), DateHandling.da$default$6$1(), DateHandling.da$default$7$1(), DateHandling.da$default$8$1(), DateHandling.da$default$9$1());
            }
            Option option3 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && (list10 = (List)option3.get()).lengthCompare(3) == 0) {
                String string5 = (String)list10.apply(0);
                String string6 = (String)list10.apply(1);
                String string7 = (String)list10.apply(2);
                String y = string5;
                String m = string6;
                String d = string7;
                return this.da$1(zoneOffset, y, m, d, DateHandling.da$default$4$1(), DateHandling.da$default$5$1(), DateHandling.da$default$6$1(), DateHandling.da$default$7$1(), DateHandling.da$default$8$1(), DateHandling.da$default$9$1());
            }
            Option option4 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option4.isEmpty() && (list9 = (List)option4.get()).lengthCompare(5) == 0) {
                String string8 = (String)list9.apply(0);
                String string9 = (String)list9.apply(1);
                String string10 = (String)list9.apply(2);
                String string11 = (String)list9.apply(3);
                String string12 = (String)list9.apply(4);
                String y = string8;
                String m = string9;
                String d = string10;
                String hh = string11;
                String mm = string12;
                return this.da$1(zoneOffset, y, m, d, hh, mm, DateHandling.da$default$6$1(), DateHandling.da$default$7$1(), DateHandling.da$default$8$1(), DateHandling.da$default$9$1());
            }
            Option option5 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option5.isEmpty() && (list8 = (List)option5.get()).lengthCompare(6) == 0) {
                String string13 = (String)list8.apply(0);
                String string14 = (String)list8.apply(1);
                String string15 = (String)list8.apply(2);
                String string16 = (String)list8.apply(3);
                String string17 = (String)list8.apply(4);
                String string18 = (String)list8.apply(5);
                String y = string13;
                String m = string14;
                String d = string15;
                String hh = string16;
                String mm = string17;
                String ss = string18;
                return this.da$1(zoneOffset, y, m, d, hh, mm, ss, DateHandling.da$default$7$1(), DateHandling.da$default$8$1(), DateHandling.da$default$9$1());
            }
            Option option6 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "\\.(\\d{1,3})", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option6.isEmpty() && (list7 = (List)option6.get()).lengthCompare(7) == 0) {
                String string19 = (String)list7.apply(0);
                String string20 = (String)list7.apply(1);
                String string21 = (String)list7.apply(2);
                String string22 = (String)list7.apply(3);
                String string23 = (String)list7.apply(4);
                String string24 = (String)list7.apply(5);
                String string25 = (String)list7.apply(6);
                String y = string19;
                String m = string20;
                String d = string21;
                String hh = string22;
                String mm = string23;
                String ss = string24;
                String ms = string25;
                return this.da$1(zoneOffset, y, m, d, hh, mm, ss, ms, DateHandling.da$default$8$1(), DateHandling.da$default$9$1());
            }
            Option option7 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "\\.(\\d{1,3})", " *([\\+\\-]?)", "(1[0-2]|0?[0-9]|Z)", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option7.isEmpty() && (list6 = (List)option7.get()).lengthCompare(9) == 0) {
                String string26 = (String)list6.apply(0);
                String string27 = (String)list6.apply(1);
                String string28 = (String)list6.apply(2);
                String string29 = (String)list6.apply(3);
                String string30 = (String)list6.apply(4);
                String string31 = (String)list6.apply(5);
                String string32 = (String)list6.apply(6);
                String string33 = (String)list6.apply(7);
                String string34 = (String)list6.apply(8);
                String y = string26;
                String m = string27;
                String d = string28;
                String hh = string29;
                String mm = string30;
                String ss = string31;
                String ms = string32;
                String sign = string33;
                String zh = string34;
                return this.da$1(zoneOffset, y, m, d, hh, mm, ss, ms, new StringBuilder(0).append(sign).append(zh).toString(), DateHandling.da$default$9$1());
            }
            Option option8 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "\\.(\\d{1,3})", " *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option8.isEmpty() && (list5 = (List)option8.get()).lengthCompare(10) == 0) {
                String string35 = (String)list5.apply(0);
                String string36 = (String)list5.apply(1);
                String string37 = (String)list5.apply(2);
                String string38 = (String)list5.apply(3);
                String string39 = (String)list5.apply(4);
                String string40 = (String)list5.apply(5);
                String string41 = (String)list5.apply(6);
                String string42 = (String)list5.apply(7);
                String string43 = (String)list5.apply(8);
                String string44 = (String)list5.apply(9);
                String y = string35;
                String m = string36;
                String d = string37;
                String hh = string38;
                String mm = string39;
                String ss = string40;
                String ms = string41;
                String sign = string42;
                String zh = string43;
                String zm = string44;
                return this.da$1(zoneOffset, y, m, d, hh, mm, ss, ms, new StringBuilder(0).append(sign).append(zh).toString(), new StringBuilder(0).append(sign).append(zm).toString());
            }
            Option option9 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", " *([\\+\\-]?)", "(1[0-2]|0?[0-9]|Z)", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option9.isEmpty() && (list4 = (List)option9.get()).lengthCompare(8) == 0) {
                String string45 = (String)list4.apply(0);
                String string46 = (String)list4.apply(1);
                String string47 = (String)list4.apply(2);
                String string48 = (String)list4.apply(3);
                String string49 = (String)list4.apply(4);
                String string50 = (String)list4.apply(5);
                String string51 = (String)list4.apply(6);
                String string52 = (String)list4.apply(7);
                String y = string45;
                String m = string46;
                String d = string47;
                String hh = string48;
                String mm = string49;
                String ss = string50;
                String sign = string51;
                String zh = string52;
                return this.da$1(zoneOffset, y, m, d, hh, mm, ss, "0", new StringBuilder(0).append(sign).append(zh).toString(), DateHandling.da$default$9$1());
            }
            Option option10 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", " *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option10.isEmpty() && (list3 = (List)option10.get()).lengthCompare(9) == 0) {
                String string53 = (String)list3.apply(0);
                String string54 = (String)list3.apply(1);
                String string55 = (String)list3.apply(2);
                String string56 = (String)list3.apply(3);
                String string57 = (String)list3.apply(4);
                String string58 = (String)list3.apply(5);
                String string59 = (String)list3.apply(6);
                String string60 = (String)list3.apply(7);
                String string61 = (String)list3.apply(8);
                String y = string53;
                String m = string54;
                String d = string55;
                String hh = string56;
                String mm = string57;
                String ss = string58;
                String sign = string59;
                String zh = string60;
                String zm = string61;
                return this.da$1(zoneOffset, y, m, d, hh, mm, ss, "0", new StringBuilder(0).append(sign).append(zh).toString(), new StringBuilder(0).append(sign).append(zm).toString());
            }
            Option option11 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", " *([\\+\\-]?)", "(1[0-2]|0?[0-9]|Z)", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option11.isEmpty() && (list2 = (List)option11.get()).lengthCompare(7) == 0) {
                String string62 = (String)list2.apply(0);
                String string63 = (String)list2.apply(1);
                String string64 = (String)list2.apply(2);
                String string65 = (String)list2.apply(3);
                String string66 = (String)list2.apply(4);
                String string67 = (String)list2.apply(5);
                String string68 = (String)list2.apply(6);
                String y = string62;
                String m = string63;
                String d = string64;
                String hh = string65;
                String mm = string66;
                String sign = string67;
                String zh = string68;
                return this.da$1(zoneOffset, y, m, d, hh, mm, "0", "0", new StringBuilder(0).append(sign).append(zh).toString(), DateHandling.da$default$9$1());
            }
            Option option12 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", " *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option12.isEmpty() && (list = (List)option12.get()).lengthCompare(8) == 0) {
                String string69 = (String)list.apply(0);
                String string70 = (String)list.apply(1);
                String string71 = (String)list.apply(2);
                String string72 = (String)list.apply(3);
                String string73 = (String)list.apply(4);
                String string74 = (String)list.apply(5);
                String string75 = (String)list.apply(6);
                String string76 = (String)list.apply(7);
                String y = string69;
                String m = string70;
                String d = string71;
                String hh = string72;
                String mm = string73;
                String sign = string74;
                String zh = string75;
                String zm = string76;
                return this.da$1(zoneOffset, y, m, d, hh, mm, "0", "0", new StringBuilder(0).append(sign).append(zh).toString(), new StringBuilder(0).append(sign).append(zm).toString());
            }
        }
        String other = string;
        throw this.error(new StringBuilder(29).append("Unrecognized date pattern: `").append(other).append("`").toString());
    }

    public static ZoneOffset str2zdt$default$2$(DateHandling $this) {
        return $this.str2zdt$default$2();
    }

    default public ZoneOffset str2zdt$default$2() {
        return this.localZoneOffset();
    }

    public static String truncateDateStr$(DateHandling $this, String dateStr) {
        return $this.truncateDateStr(dateStr);
    }

    /*
     * WARNING - void declaration
     */
    default public String truncateDateStr(String dateStr) {
        void other;
        String string = dateStr.trim();
        if (string != null) {
            List list;
            List list2;
            List list3;
            List list4;
            List list5;
            List list6;
            List list7;
            List list8;
            List list9;
            List list10;
            List list11;
            List list12;
            List list13;
            List list14;
            List list15;
            List list16;
            List list17;
            List list18;
            List list19;
            List list20;
            List list21;
            Option option = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && (list21 = (List)option.get()).lengthCompare(1) == 0) {
                String string2;
                String y = string2 = (String)list21.apply(0);
                return new StringBuilder(6).append(this.p(y, 4)).append("-01-01").toString();
            }
            Option option2 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && (list20 = (List)option2.get()).lengthCompare(2) == 0) {
                String string3 = (String)list20.apply(0);
                String string4 = (String)list20.apply(1);
                String y = string3;
                String m = string4;
                return new StringBuilder(4).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-01").toString();
            }
            Option option3 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && (list19 = (List)option3.get()).lengthCompare(3) == 0) {
                String string5 = (String)list19.apply(0);
                String string6 = (String)list19.apply(1);
                String string7 = (String)list19.apply(2);
                String y = string5;
                String m = string6;
                String d = string7;
                return new StringBuilder(2).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).toString();
            }
            Option option4 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+00:00$"}))).r().unapplySeq((CharSequence)string);
            if (!option4.isEmpty() && (list18 = (List)option4.get()).lengthCompare(3) == 0) {
                String string8 = (String)list18.apply(0);
                String string9 = (String)list18.apply(1);
                String string10 = (String)list18.apply(2);
                String y = string8;
                String m = string9;
                String d = string10;
                return new StringBuilder(2).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).toString();
            }
            Option option5 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+00:00:00$"}))).r().unapplySeq((CharSequence)string);
            if (!option5.isEmpty() && (list17 = (List)option5.get()).lengthCompare(3) == 0) {
                String string11 = (String)list17.apply(0);
                String string12 = (String)list17.apply(1);
                String string13 = (String)list17.apply(2);
                String y = string11;
                String m = string12;
                String d = string13;
                return new StringBuilder(2).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).toString();
            }
            Option option6 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+00:00:00\\.0{1,3}$"}))).r().unapplySeq((CharSequence)string);
            if (!option6.isEmpty() && (list16 = (List)option6.get()).lengthCompare(3) == 0) {
                String string14 = (String)list16.apply(0);
                String string15 = (String)list16.apply(1);
                String string16 = (String)list16.apply(2);
                String y = string14;
                String m = string15;
                String d = string16;
                return new StringBuilder(2).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).toString();
            }
            Option option7 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option7.isEmpty() && (list15 = (List)option7.get()).lengthCompare(5) == 0) {
                String string17 = (String)list15.apply(0);
                String string18 = (String)list15.apply(1);
                String string19 = (String)list15.apply(2);
                String string20 = (String)list15.apply(3);
                String string21 = (String)list15.apply(4);
                String y = string17;
                String m = string18;
                String d = string19;
                String hh = string20;
                String mm = string21;
                return new StringBuilder(4).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).toString();
            }
            Option option8 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":00$"}))).r().unapplySeq((CharSequence)string);
            if (!option8.isEmpty() && (list14 = (List)option8.get()).lengthCompare(5) == 0) {
                String string22 = (String)list14.apply(0);
                String string23 = (String)list14.apply(1);
                String string24 = (String)list14.apply(2);
                String string25 = (String)list14.apply(3);
                String string26 = (String)list14.apply(4);
                String y = string22;
                String m = string23;
                String d = string24;
                String hh = string25;
                String mm = string26;
                return new StringBuilder(4).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).toString();
            }
            Option option9 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":00\\.0{1,3}$"}))).r().unapplySeq((CharSequence)string);
            if (!option9.isEmpty() && (list13 = (List)option9.get()).lengthCompare(5) == 0) {
                String string27 = (String)list13.apply(0);
                String string28 = (String)list13.apply(1);
                String string29 = (String)list13.apply(2);
                String string30 = (String)list13.apply(3);
                String string31 = (String)list13.apply(4);
                String y = string27;
                String m = string28;
                String d = string29;
                String hh = string30;
                String mm = string31;
                return new StringBuilder(4).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).toString();
            }
            Option option10 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option10.isEmpty() && (list12 = (List)option10.get()).lengthCompare(6) == 0) {
                String string32 = (String)list12.apply(0);
                String string33 = (String)list12.apply(1);
                String string34 = (String)list12.apply(2);
                String string35 = (String)list12.apply(3);
                String string36 = (String)list12.apply(4);
                String string37 = (String)list12.apply(5);
                String y = string32;
                String m = string33;
                String d = string34;
                String hh = string35;
                String mm = string36;
                String ss = string37;
                return new StringBuilder(5).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":").append(this.p(ss, this.p$default$2())).toString();
            }
            Option option11 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "\\.0{1,3}$"}))).r().unapplySeq((CharSequence)string);
            if (!option11.isEmpty() && (list11 = (List)option11.get()).lengthCompare(6) == 0) {
                String string38 = (String)list11.apply(0);
                String string39 = (String)list11.apply(1);
                String string40 = (String)list11.apply(2);
                String string41 = (String)list11.apply(3);
                String string42 = (String)list11.apply(4);
                String string43 = (String)list11.apply(5);
                String y = string38;
                String m = string39;
                String d = string40;
                String hh = string41;
                String mm = string42;
                String ss = string43;
                return new StringBuilder(5).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":").append(this.p(ss, this.p$default$2())).toString();
            }
            Option option12 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "\\.(\\d{1,3})", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option12.isEmpty() && (list10 = (List)option12.get()).lengthCompare(7) == 0) {
                String string44 = (String)list10.apply(0);
                String string45 = (String)list10.apply(1);
                String string46 = (String)list10.apply(2);
                String string47 = (String)list10.apply(3);
                String string48 = (String)list10.apply(4);
                String string49 = (String)list10.apply(5);
                String string50 = (String)list10.apply(6);
                String y = string44;
                String m = string45;
                String d = string46;
                String hh = string47;
                String mm = string48;
                String ss = string49;
                String ms = string50;
                return new StringBuilder(6).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":").append(this.p(ss, this.p$default$2())).append(".").append(ms).toString();
            }
            Option option13 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+00:00 *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option13.isEmpty() && (list9 = (List)option13.get()).lengthCompare(6) == 0) {
                String string51 = (String)list9.apply(0);
                String string52 = (String)list9.apply(1);
                String string53 = (String)list9.apply(2);
                String string54 = (String)list9.apply(3);
                String string55 = (String)list9.apply(4);
                String string56 = (String)list9.apply(5);
                String y = string51;
                String m = string52;
                String d = string53;
                String sign = string54;
                String zh = string55;
                String zm = string56;
                return new StringBuilder(2).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(this.local(sign, zh, zm) ? "" : new StringBuilder(8).append(" 00:00 ").append(sign).append(zh).append(":").append(zm).toString()).toString();
            }
            Option option14 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+00:00:00 *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option14.isEmpty() && (list8 = (List)option14.get()).lengthCompare(6) == 0) {
                String string57 = (String)list8.apply(0);
                String string58 = (String)list8.apply(1);
                String string59 = (String)list8.apply(2);
                String string60 = (String)list8.apply(3);
                String string61 = (String)list8.apply(4);
                String string62 = (String)list8.apply(5);
                String y = string57;
                String m = string58;
                String d = string59;
                String sign = string60;
                String zh = string61;
                String zm = string62;
                return new StringBuilder(2).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(this.local(sign, zh, zm) ? "" : new StringBuilder(8).append(" 00:00 ").append(sign).append(zh).append(":").append(zm).toString()).toString();
            }
            Option option15 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+00:00:00\\.0{1,3} *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option15.isEmpty() && (list7 = (List)option15.get()).lengthCompare(6) == 0) {
                String string63 = (String)list7.apply(0);
                String string64 = (String)list7.apply(1);
                String string65 = (String)list7.apply(2);
                String string66 = (String)list7.apply(3);
                String string67 = (String)list7.apply(4);
                String string68 = (String)list7.apply(5);
                String y = string63;
                String m = string64;
                String d = string65;
                String sign = string66;
                String zh = string67;
                String zm = string68;
                return new StringBuilder(2).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(this.local(sign, zh, zm) ? "" : new StringBuilder(8).append(" 00:00 ").append(sign).append(zh).append(":").append(zm).toString()).toString();
            }
            Option option16 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", " *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option16.isEmpty() && (list6 = (List)option16.get()).lengthCompare(8) == 0) {
                String string69 = (String)list6.apply(0);
                String string70 = (String)list6.apply(1);
                String string71 = (String)list6.apply(2);
                String string72 = (String)list6.apply(3);
                String string73 = (String)list6.apply(4);
                String string74 = (String)list6.apply(5);
                String string75 = (String)list6.apply(6);
                String string76 = (String)list6.apply(7);
                String y = string69;
                String m = string70;
                String d = string71;
                String hh = string72;
                String mm = string73;
                String sign = string74;
                String zh = string75;
                String zm = string76;
                return new StringBuilder(4).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(this.local(sign, zh, zm) ? "" : new StringBuilder(2).append(" ").append(sign).append(zh).append(":").append(zm).toString()).toString();
            }
            Option option17 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":00 *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option17.isEmpty() && (list5 = (List)option17.get()).lengthCompare(8) == 0) {
                String string77 = (String)list5.apply(0);
                String string78 = (String)list5.apply(1);
                String string79 = (String)list5.apply(2);
                String string80 = (String)list5.apply(3);
                String string81 = (String)list5.apply(4);
                String string82 = (String)list5.apply(5);
                String string83 = (String)list5.apply(6);
                String string84 = (String)list5.apply(7);
                String y = string77;
                String m = string78;
                String d = string79;
                String hh = string80;
                String mm = string81;
                String sign = string82;
                String zh = string83;
                String zm = string84;
                return new StringBuilder(4).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(this.local(sign, zh, zm) ? "" : new StringBuilder(2).append(" ").append(sign).append(zh).append(":").append(zm).toString()).toString();
            }
            Option option18 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":00\\.0{1,3} *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option18.isEmpty() && (list4 = (List)option18.get()).lengthCompare(8) == 0) {
                String string85 = (String)list4.apply(0);
                String string86 = (String)list4.apply(1);
                String string87 = (String)list4.apply(2);
                String string88 = (String)list4.apply(3);
                String string89 = (String)list4.apply(4);
                String string90 = (String)list4.apply(5);
                String string91 = (String)list4.apply(6);
                String string92 = (String)list4.apply(7);
                String y = string85;
                String m = string86;
                String d = string87;
                String hh = string88;
                String mm = string89;
                String sign = string90;
                String zh = string91;
                String zm = string92;
                return new StringBuilder(4).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(this.local(sign, zh, zm) ? "" : new StringBuilder(2).append(" ").append(sign).append(zh).append(":").append(zm).toString()).toString();
            }
            Option option19 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", " *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option19.isEmpty() && (list3 = (List)option19.get()).lengthCompare(9) == 0) {
                String string93 = (String)list3.apply(0);
                String string94 = (String)list3.apply(1);
                String string95 = (String)list3.apply(2);
                String string96 = (String)list3.apply(3);
                String string97 = (String)list3.apply(4);
                String string98 = (String)list3.apply(5);
                String string99 = (String)list3.apply(6);
                String string100 = (String)list3.apply(7);
                String string101 = (String)list3.apply(8);
                String y = string93;
                String m = string94;
                String d = string95;
                String hh = string96;
                String mm = string97;
                String ss = string98;
                String sign = string99;
                String zh = string100;
                String zm = string101;
                return new StringBuilder(5).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":").append(this.p(ss, this.p$default$2())).append(this.local(sign, zh, zm) ? "" : new StringBuilder(2).append(" ").append(sign).append(zh).append(":").append(zm).toString()).toString();
            }
            Option option20 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "\\.0{1,3} *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option20.isEmpty() && (list2 = (List)option20.get()).lengthCompare(9) == 0) {
                void zm;
                void zh;
                void sign;
                void ss;
                void mm;
                String string102 = (String)list2.apply(0);
                String string103 = (String)list2.apply(1);
                String string104 = (String)list2.apply(2);
                String string105 = (String)list2.apply(3);
                String string106 = (String)list2.apply(4);
                String string107 = (String)list2.apply(5);
                String string108 = (String)list2.apply(6);
                String string109 = (String)list2.apply(7);
                String string110 = (String)list2.apply(8);
                String y = string102;
                String m = string103;
                String d = string104;
                String hh = string105;
                String string111 = string106;
                String string112 = string107;
                String string113 = string108;
                String string114 = string109;
                String string115 = string110;
                return new StringBuilder(5).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p((String)mm, this.p$default$2())).append(":").append(this.p((String)ss, this.p$default$2())).append(this.local((String)sign, (String)zh, (String)zm) ? "" : new StringBuilder(2).append(" ").append((String)sign).append((String)zh).append(":").append((String)zm).toString()).toString();
            }
            Option option21 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "\\.(\\d{1,3})", " *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option21.isEmpty() && (list = (List)option21.get()).lengthCompare(10) == 0) {
                void zm;
                void zh;
                void sign;
                void ms;
                void ss;
                void mm;
                void hh;
                void d;
                void m;
                void y;
                String string116 = (String)list.apply(0);
                String string117 = (String)list.apply(1);
                String string118 = (String)list.apply(2);
                String string119 = (String)list.apply(3);
                String string120 = (String)list.apply(4);
                String string121 = (String)list.apply(5);
                String string122 = (String)list.apply(6);
                String string123 = (String)list.apply(7);
                String string124 = (String)list.apply(8);
                String string125 = (String)list.apply(9);
                String string126 = string116;
                String string127 = string117;
                String string128 = string118;
                String string129 = string119;
                String string130 = string120;
                String string131 = string121;
                String string132 = string122;
                String string133 = string123;
                String string134 = string124;
                String string135 = string125;
                return new StringBuilder(6).append(this.p((String)y, 4)).append("-").append(this.p((String)m, this.p$default$2())).append("-").append(this.p((String)d, this.p$default$2())).append(" ").append(this.p((String)hh, this.p$default$2())).append(":").append(this.p((String)mm, this.p$default$2())).append(":").append(this.p((String)ss, this.p$default$2())).append(".").append((String)ms).append(this.local((String)sign, (String)zh, (String)zm) ? "" : new StringBuilder(2).append(" ").append((String)sign).append((String)zh).append(":").append((String)zm).toString()).toString();
            }
        }
        String string136 = string;
        throw this.error(new StringBuilder(50).append("Can't truncate unrecognized zoned date pattern: `").append((String)other).append("`").toString());
    }

    public static String expandDateStr$(DateHandling $this, String dateStr) {
        return $this.expandDateStr(dateStr);
    }

    default public String expandDateStr(String dateStr) {
        String string = dateStr.trim();
        if (string != null) {
            List list;
            List list2;
            List list3;
            List list4;
            List list5;
            List list6;
            List list7;
            List list8;
            List list9;
            List list10;
            Option option = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && (list10 = (List)option.get()).lengthCompare(1) == 0) {
                String string2;
                String y = string2 = (String)list10.apply(0);
                return new StringBuilder(20).append(this.p(y, 4)).append("-01-01 00:00:00.000 ").append(this.localOffset()).toString();
            }
            Option option2 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option2.isEmpty() && (list9 = (List)option2.get()).lengthCompare(2) == 0) {
                String string3 = (String)list9.apply(0);
                String string4 = (String)list9.apply(1);
                String y = string3;
                String m = string4;
                return new StringBuilder(18).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-01 00:00:00.000 ").append(this.localOffset()).toString();
            }
            Option option3 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option3.isEmpty() && (list8 = (List)option3.get()).lengthCompare(3) == 0) {
                String string5 = (String)list8.apply(0);
                String string6 = (String)list8.apply(1);
                String string7 = (String)list8.apply(2);
                String y = string5;
                String m = string6;
                String d = string7;
                return new StringBuilder(16).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" 00:00:00.000 ").append(this.localOffset()).toString();
            }
            Option option4 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option4.isEmpty() && (list7 = (List)option4.get()).lengthCompare(4) == 0) {
                String string8 = (String)list7.apply(0);
                String string9 = (String)list7.apply(1);
                String string10 = (String)list7.apply(2);
                String string11 = (String)list7.apply(3);
                String y = string8;
                String m = string9;
                String d = string10;
                String hh = string11;
                return new StringBuilder(14).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":00:00.000 ").append(this.localOffset()).toString();
            }
            Option option5 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option5.isEmpty() && (list6 = (List)option5.get()).lengthCompare(5) == 0) {
                String string12 = (String)list6.apply(0);
                String string13 = (String)list6.apply(1);
                String string14 = (String)list6.apply(2);
                String string15 = (String)list6.apply(3);
                String string16 = (String)list6.apply(4);
                String y = string12;
                String m = string13;
                String d = string14;
                String hh = string15;
                String mm = string16;
                return new StringBuilder(12).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":00.000 ").append(this.localOffset()).toString();
            }
            Option option6 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option6.isEmpty() && (list5 = (List)option6.get()).lengthCompare(6) == 0) {
                String string17 = (String)list5.apply(0);
                String string18 = (String)list5.apply(1);
                String string19 = (String)list5.apply(2);
                String string20 = (String)list5.apply(3);
                String string21 = (String)list5.apply(4);
                String string22 = (String)list5.apply(5);
                String y = string17;
                String m = string18;
                String d = string19;
                String hh = string20;
                String mm = string21;
                String ss = string22;
                return new StringBuilder(10).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":").append(this.p(ss, this.p$default$2())).append(".000 ").append(this.localOffset()).toString();
            }
            Option option7 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "\\.(\\d{1,3})", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option7.isEmpty() && (list4 = (List)option7.get()).lengthCompare(7) == 0) {
                String string23 = (String)list4.apply(0);
                String string24 = (String)list4.apply(1);
                String string25 = (String)list4.apply(2);
                String string26 = (String)list4.apply(3);
                String string27 = (String)list4.apply(4);
                String string28 = (String)list4.apply(5);
                String string29 = (String)list4.apply(6);
                String y = string23;
                String m = string24;
                String d = string25;
                String hh = string26;
                String mm = string27;
                String ss = string28;
                String ms = string29;
                return new StringBuilder(7).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":").append(this.p(ss, this.p$default$2())).append(".").append(this.p(ms, 3)).append(" ").append(this.localOffset()).toString();
            }
            Option option8 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "\\.(\\d{1,3})", " *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option8.isEmpty() && (list3 = (List)option8.get()).lengthCompare(10) == 0) {
                String string30 = (String)list3.apply(0);
                String string31 = (String)list3.apply(1);
                String string32 = (String)list3.apply(2);
                String string33 = (String)list3.apply(3);
                String string34 = (String)list3.apply(4);
                String string35 = (String)list3.apply(5);
                String string36 = (String)list3.apply(6);
                String string37 = (String)list3.apply(7);
                String string38 = (String)list3.apply(8);
                String string39 = (String)list3.apply(9);
                String y = string30;
                String m = string31;
                String d = string32;
                String hh = string33;
                String mm = string34;
                String ss = string35;
                String ms = string36;
                String sign = string37;
                String zh = string38;
                String zm = string39;
                return new StringBuilder(8).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":").append(this.p(ss, this.p$default$2())).append(".").append(this.p(ms, 3)).append(" ").append(sign).append(zh).append(":").append(zm).toString();
            }
            Option option9 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", " *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option9.isEmpty() && (list2 = (List)option9.get()).lengthCompare(9) == 0) {
                String string40 = (String)list2.apply(0);
                String string41 = (String)list2.apply(1);
                String string42 = (String)list2.apply(2);
                String string43 = (String)list2.apply(3);
                String string44 = (String)list2.apply(4);
                String string45 = (String)list2.apply(5);
                String string46 = (String)list2.apply(6);
                String string47 = (String)list2.apply(7);
                String string48 = (String)list2.apply(8);
                String y = string40;
                String m = string41;
                String d = string42;
                String hh = string43;
                String mm = string44;
                String ss = string45;
                String sign = string46;
                String zh = string47;
                String zm = string48;
                return new StringBuilder(11).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":").append(this.p(ss, this.p$default$2())).append(".000 ").append(sign).append(zh).append(":").append(zm).toString();
            }
            Option option10 = this.Regex(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"^(\\d{1,4})", "-(1[0-2]|0?[0-9])", "-(3[01]|[12][0-9]|0?[0-9])", "['T ]+(2[0-3]|1[0-9]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", " *([\\+\\-]?)", "(1[0-2]|0?[0-9])", ":([1-5][0-9]|0?[0-9])", "$"}))).r().unapplySeq((CharSequence)string);
            if (!option10.isEmpty() && (list = (List)option10.get()).lengthCompare(8) == 0) {
                String string49 = (String)list.apply(0);
                String string50 = (String)list.apply(1);
                String string51 = (String)list.apply(2);
                String string52 = (String)list.apply(3);
                String string53 = (String)list.apply(4);
                String string54 = (String)list.apply(5);
                String string55 = (String)list.apply(6);
                String string56 = (String)list.apply(7);
                String y = string49;
                String m = string50;
                String d = string51;
                String hh = string52;
                String mm = string53;
                String sign = string54;
                String zh = string55;
                String zm = string56;
                return new StringBuilder(13).append(this.p(y, 4)).append("-").append(this.p(m, this.p$default$2())).append("-").append(this.p(d, this.p$default$2())).append(" ").append(this.p(hh, this.p$default$2())).append(":").append(this.p(mm, this.p$default$2())).append(":00.000 ").append(sign).append(zh).append(":").append(zm).toString();
            }
        }
        String other = string;
        throw this.error(new StringBuilder(42).append("Can't expand unrecognized date pattern: `").append(other).append("`").toString());
    }

    private static int mkZh$1(String zh0) {
        if (zh0.contains("Z")) {
            return 0;
        }
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(zh0));
    }

    private static int mkZm$1(String zh0, String zm0) {
        if (zh0.contains("Z")) {
            return 0;
        }
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(zm0));
    }

    private ZonedDateTime da$1(ZoneOffset zoneOffset$1, String y0, String m0, String d0, String hh0, String mm0, String ss0, String ms0, String zh0, String zm0) {
        Tuple9 tuple9 = Tuple9$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(y0))), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m0))), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(d0))), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(hh0))), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(mm0))), (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(ss0))), (Object)BoxesRunTime.boxToInteger((int)(this.mkMs(ms0) * 1000000)), (Object)BoxesRunTime.boxToInteger((int)DateHandling.mkZh$1(zh0)), (Object)BoxesRunTime.boxToInteger((int)DateHandling.mkZm$1(zh0, zm0)));
        int y = BoxesRunTime.unboxToInt((Object)tuple9._1());
        int m = BoxesRunTime.unboxToInt((Object)tuple9._2());
        int d = BoxesRunTime.unboxToInt((Object)tuple9._3());
        int hh = BoxesRunTime.unboxToInt((Object)tuple9._4());
        int mm = BoxesRunTime.unboxToInt((Object)tuple9._5());
        int ss = BoxesRunTime.unboxToInt((Object)tuple9._6());
        int nanoS = BoxesRunTime.unboxToInt((Object)tuple9._7());
        int zh = BoxesRunTime.unboxToInt((Object)tuple9._8());
        int zm = BoxesRunTime.unboxToInt((Object)tuple9._9());
        if (zh0.contains("Z")) {
            return ZonedDateTime.of(y, m, d, hh, mm, ss, nanoS, this.localZoneOffset());
        }
        if (zm != 99) {
            return ZonedDateTime.of(y, m, d, hh, mm, ss, nanoS, ZoneOffset.ofHoursMinutes(zh, zm));
        }
        if (zh != 99) {
            return ZonedDateTime.of(y, m, d, hh, mm, ss, nanoS, ZoneOffset.ofHours(zh));
        }
        return ZonedDateTime.of(y, m, d, hh, mm, ss, nanoS, zoneOffset$1);
    }

    private static String da$default$2$1() {
        return "1";
    }

    private static String da$default$3$1() {
        return "1";
    }

    private static String da$default$4$1() {
        return "0";
    }

    private static String da$default$5$1() {
        return "0";
    }

    private static String da$default$6$1() {
        return "0";
    }

    private static String da$default$7$1() {
        return "0";
    }

    private static String da$default$8$1() {
        return "99";
    }

    private static String da$default$9$1() {
        return "99";
    }
}

