package molecule.composition

import molecule.boilerplate.base._
import molecule.composition.Composite_In_1._
import molecule.composition.Composite_In_2._
import molecule.composition.Composite_In_3._
import scala.language.higherKinds

/** Add sub-molecule to composite molecule.
  * <br><br>
  * Composite molecules model entities with attributes from different namespaces that are
  * not necessarily related. Each group of attributes is modelled by a molecule and these
  * "sub-molecules" are tied together with `~` methods to form a composite molecule.
  * <br><br>
  * `~` methods of this interface adds a new sub-molecule to the composite.
  * {{{
  *   //                                          | add sub-molecule
  *   m(Article.name.author ~ Tag.category.weight ~ Publisher.name).get === List(
  *     (("Battle of Waterloo", "Ben Bridge"), ("History", 5), "Bestseller Publications Inc.")
  *   )
  * }}}
  * To insert composite data, see [[molecule.action.CompositeInserts CompositeInserts]].
  * @see [[http://www.scalamolecule.org/manual/relationships/composites/ Manual]]
  *     | Tests: [[https://github.com/scalamolecule/molecule/blob/master/coretests/src/test/scala/molecule/coretests/ref/Composite.scala composite]],
  *     [[https://github.com/scalamolecule/molecule/blob/master/coretests/src/test/scala/molecule/coretests/json/Composite.scala#L1 composite json]]
  *
  */
trait Composite extends NS


/** `~` methods on composite molecule to add sub-molecule. */
object Composite {

  trait Composite00 extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite00                                                                     = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite01[a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite01[(a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite01[(a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite01[(a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite01[(a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite01[(a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite01[(a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite01[(a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite01[(a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite01[(a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_00[I1                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_01[I1, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_01[I1, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_01[I1, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_01[I1, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_01[I1, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_01[I1, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_00[I1, I2                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_01[I1, I2, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_01[I1, I2, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_01[I1, I2, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_01[I1, I2, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_01[I1, I2, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_00[I1, I2, I3                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_01[I1, I2, I3, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_01[I1, I2, I3, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_01[I1, I2, I3, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite01[T1] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite01[T1                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite02[T1, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite02[T1, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite02[T1, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite02[T1, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite02[T1, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite02[T1, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite02[T1, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite02[T1, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite02[T1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_01[I1, T1                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_02[I1, T1, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_02[I1, T1, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_02[I1, T1, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_02[I1, T1, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_02[I1, T1, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_01[I1, I2, T1                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_02[I1, I2, T1, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_02[I1, I2, T1, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, T1, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, T1                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, T1, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, T1, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite02[T1, T2] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite02[T1, T2                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite03[T1, T2, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite03[T1, T2, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite03[T1, T2, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite03[T1, T2, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite03[T1, T2, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite03[T1, T2, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite03[T1, T2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_02[I1, T1, T2                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_03[I1, T1, T2, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_03[I1, T1, T2, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_03[I1, T1, T2, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_02[I1, I2, T1, T2                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_03[I1, I2, T1, T2, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_03[I1, I2, T1, T2, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_02[I1, I2, I3, T1, T2                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_03[I1, I2, I3, T1, T2, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite03[T1, T2, T3] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite03[T1, T2, T3                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite04[T1, T2, T3, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite04[T1, T2, T3, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite04[T1, T2, T3, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite04[T1, T2, T3, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite04[T1, T2, T3, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite04[T1, T2, T3, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_03[I1, T1, T2, T3                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_04[I1, T1, T2, T3, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_04[I1, T1, T2, T3, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_03[I1, I2, T1, T2, T3                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_04[I1, I2, T1, T2, T3, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_03[I1, I2, I3, T1, T2, T3                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite04[T1, T2, T3, T4] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite04[T1, T2, T3, T4                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite05[T1, T2, T3, T4, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite05[T1, T2, T3, T4, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite05[T1, T2, T3, T4, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite05[T1, T2, T3, T4, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_04[I1, T1, T2, T3, T4                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_05[I1, T1, T2, T3, T4, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_04[I1, I2, T1, T2, T3, T4                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, T4                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite05[T1, T2, T3, T4, T5] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite05[T1, T2, T3, T4, T5                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite06[T1, T2, T3, T4, T5, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite06[T1, T2, T3, T4, T5, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite06[T1, T2, T3, T4, T5, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_05[I1, T1, T2, T3, T4, T5                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, T5                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, T5                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite06[T1, T2, T3, T4, T5, T6] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite06[T1, T2, T3, T4, T5, T6                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite07[T1, T2, T3, T4, T5, T6, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, T6                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, T6                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, T6                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite07[T1, T2, T3, T4, T5, T6, T7] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite07[T1, T2, T3, T4, T5, T6, T7                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite08[T1, T2, T3, T4, T5, T6, T7, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, T7                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, T7                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite08[T1, T2, T3, T4, T5, T6, T7, T8] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite08[T1, T2, T3, T4, T5, T6, T7, T8                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, T8                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite09[T1, T2, T3, T4, T5, T6, T7, T8, T9] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite09[T1, T2, T3, T4, T5, T6, T7, T8, T9                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1                                                                  ] (nextMolecule: IN1_00[I1                                                                  ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21                                                                    ] = ???
    def ~[I1, a                                                               ] (nextMolecule: IN1_01[I1, a                                                               ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 ] = ???
    def ~[I1, a, b                                                            ] (nextMolecule: IN1_02[I1, a, b                                                            ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            )] = ???
    def ~[I1, a, b, c                                                         ] (nextMolecule: IN1_03[I1, a, b, c                                                         ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         )] = ???
    def ~[I1, a, b, c, d                                                      ] (nextMolecule: IN1_04[I1, a, b, c, d                                                      ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      )] = ???
    def ~[I1, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I1, a, b, c, d, e                                                   ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   )] = ???
    def ~[I1, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I1, a, b, c, d, e, f                                                ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I1, a, b, c, d, e, f, g                                             ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2                                                                  ] (nextMolecule: IN2_00[I1, I2                                                                  ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21                                                                    ] = ???
    def ~[I1, I2, a                                                               ] (nextMolecule: IN2_01[I1, I2, a                                                               ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 ] = ???
    def ~[I1, I2, a, b                                                            ] (nextMolecule: IN2_02[I1, I2, a, b                                                            ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            )] = ???
    def ~[I1, I2, a, b, c                                                         ] (nextMolecule: IN2_03[I1, I2, a, b, c                                                         ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         )] = ???
    def ~[I1, I2, a, b, c, d                                                      ] (nextMolecule: IN2_04[I1, I2, a, b, c, d                                                      ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I1, I2, a, b, c, d, e                                                   ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I1, I2, I3                                                                  ] (nextMolecule: IN3_00[I1, I2, I3                                                                  ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21                                                                    ] = ???
    def ~[I1, I2, I3, a                                                               ] (nextMolecule: IN3_01[I1, I2, I3, a                                                               ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 ] = ???
    def ~[I1, I2, I3, a, b                                                            ] (nextMolecule: IN3_02[I1, I2, I3, a, b                                                            ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            )] = ???
    def ~[I1, I2, I3, a, b, c                                                         ] (nextMolecule: IN3_03[I1, I2, I3, a, b, c                                                         ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         )] = ???
    def ~[I1, I2, I3, a, b, c, d                                                      ] (nextMolecule: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
  
  trait Composite22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22] extends Composite
  
}