package molecule.composition

import molecule.boilerplate.base._
import molecule.composition.Composite._
import molecule.composition.Composite_In_2._
import molecule.composition.Composite_In_3._
import scala.language.higherKinds


/** Build composite molecule from input molecule awaiting 2 inputs.
  * <br><br>
  * Composite molecules model entities with attributes from different namespaces that are
  * not necessarily related. Each group of attributes is modelled by a molecule and the
  * "sub-molecules" are tied together with `~` methods to form a composite molecule.
  * <br><br>
  * The attributes of the first input sub-molecule awaiting 2 inputs are tied
  * together in a tuple of its own before being merged with the tuple of attribute values
  * of the second sub-molecule. If any of the sub-molecules are of arity-1, then no tuple is created:
  * {{{
  *   m(Article.name(?).author(?).editor ~ Tag.category.weight)
  *     .apply("Battle of Waterloo", "Ben Bridge").get === List(
  *       (("Battle of Waterloo", "Ben Bridge", "Joe Moe"), ("History", 5))
  *     )
  * }}}
  * To insert composite data, see [[molecule.action.CompositeInserts CompositeInserts]].
  * @see [[http://www.scalamolecule.org/manual/relationships/composites/ Manual]]
  *     | [[https://github.com/scalamolecule/molecule/blob/master/coretests/src/test/scala/molecule/coretests/ref/Composite.scala Tests]]
  */
trait CompositeInit_In_2 extends NS


/** Initial `~` methods on first sub-molecule awaiting 2 inputs to merge with second sub-molecule into composite molecule. */
object CompositeInit_In_2 {

  trait CompositeInit_In_2_00[I1, I2] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_00[I1, I2                                                                    ]= ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_01[I1, I2, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_01[I1, I2, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_01[I1, I2, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_01[I1, I2, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_01[I1, I2, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_00[I1, I2, I3                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_01[I1, I2, I3, a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_01[I1, I2, I3, (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_01[I1, I2, I3, (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_01[I1, I2, A] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, A                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, A, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, A, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, A, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, A, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, A                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, A, a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, A, (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_02[I1, I2, A, B] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_03[I1, I2, A, B, C] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_04[I1, I2, A, B, C, D] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_05[I1, I2, A, B, C, D, E] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_06[I1, I2, A, B, C, D, E, F] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_07[I1, I2, A, B, C, D, E, F, G] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_08[I1, I2, A, B, C, D, E, F, G, H] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_09[I1, I2, A, B, C, D, E, F, G, H, I] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_10[I1, I2, A, B, C, D, E, F, G, H, I, J] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, K] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_In_2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V] extends CompositeInit_In_2 {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_2_01[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I3                                                                  ] (nextMolecule: IN1_00[I3                                                                  ]): Composite_In_3_01[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)                                                                    ] = ???
    def ~[I3, a                                                               ] (nextMolecule: IN1_01[I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), a                                                                 ] = ???
    def ~[I3, a, b                                                            ] (nextMolecule: IN1_02[I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b                                                            )] = ???
    def ~[I3, a, b, c                                                         ] (nextMolecule: IN1_03[I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c                                                         )] = ???
    def ~[I3, a, b, c, d                                                      ] (nextMolecule: IN1_04[I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d                                                      )] = ???
    def ~[I3, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e                                                   )] = ???
    def ~[I3, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f                                                )] = ???
    def ~[I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g                                             )] = ???
    def ~[I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
}