package molecule.composition

import molecule.boilerplate.base._
import molecule.composition.Composite_In_2._
import molecule.composition.Composite_In_3._
import scala.language.higherKinds

/** Add sub-molecule to composite input molecule awaiting 1 input.
  * <br><br>
  * Composite molecules model entities with attributes from different namespaces that are
  * not necessarily related. Each group of attributes is modelled by a molecule and the
  * "sub-molecules" are tied together with `~` methods to form a composite molecule.
  * <br><br>
  * `~` methods of this interface adds a new sub-molecule to the composite.
  * {{{
  *   //             | input composite               | add sub-molecule
  *   m(Article.name(?).author ~ Tag.category.weight ~ Publisher.name)
  *     .apply("Battle of Waterloo").get === List(
  *       (("Battle of Waterloo", "Ben Bridge"), ("History", 5), "Bestseller Publications Inc.")
  *     )
  * }}}
  * To insert composite data, see [[molecule.action.CompositeInserts CompositeInserts]].
  * @see [[http://www.scalamolecule.org/manual/relationships/composites/ Manual]]
  *     | [[https://github.com/scalamolecule/molecule/blob/master/coretests/src/test/scala/molecule/coretests/ref/Composite.scala Tests]]
  */
trait Composite_In_1 extends NS


/** `~` methods on composite molecule awaiting 1 input to add sub-molecule. */
object Composite_In_1 {

  trait Composite_In_1_00[I1] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_00[I1                                                                    ]= ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_01[I1, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_01[I1, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_01[I1, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_01[I1, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_01[I1, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_01[I1, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_01[I1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_00[I1, I2                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_01[I1, I2, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_01[I1, I2, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_01[I1, I2, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_01[I1, I2, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_01[I1, I2, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_01[I1, I2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_00[I1, I2, I3                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_01[I1, I2, I3, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_01[I1, I2, I3, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_01[I1, I2, I3, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_01[I1, T1] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_01[I1, T1                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_02[I1, T1, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_02[I1, T1, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_02[I1, T1, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_02[I1, T1, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_02[I1, T1, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_02[I1, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_01[I1, I2, T1                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_02[I1, I2, T1, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_02[I1, I2, T1, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_02[I1, I2, T1, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_02[I1, I2, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_01[I1, I2, I3, T1                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_02[I1, I2, I3, T1, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_02[I1, I2, I3, T1, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_02[I1, T1, T2] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_02[I1, T1, T2                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_03[I1, T1, T2, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_03[I1, T1, T2, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_03[I1, T1, T2, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_03[I1, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_02[I1, I2, T1, T2                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_03[I1, I2, T1, T2, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_03[I1, I2, T1, T2, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_03[I1, I2, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_02[I1, I2, I3, T1, T2                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_03[I1, I2, I3, T1, T2, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_03[I1, T1, T2, T3] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_03[I1, T1, T2, T3                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_04[I1, T1, T2, T3, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_04[I1, T1, T2, T3, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_04[I1, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_03[I1, I2, T1, T2, T3                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_04[I1, I2, T1, T2, T3, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_04[I1, I2, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_03[I1, I2, I3, T1, T2, T3                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_04[I1, T1, T2, T3, T4] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_04[I1, T1, T2, T3, T4                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_05[I1, T1, T2, T3, T4, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_05[I1, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_04[I1, I2, T1, T2, T3, T4                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, T4                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_05[I1, T1, T2, T3, T4, T5] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_05[I1, T1, T2, T3, T4, T5                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_05[I1, I2, T1, T2, T3, T4, T5                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, T5                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_06[I1, T1, T2, T3, T4, T5, T6] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_06[I1, T1, T2, T3, T4, T5, T6                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_06[I1, I2, T1, T2, T3, T4, T5, T6                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, T6                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, T7] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_07[I1, T1, T2, T3, T4, T5, T6, T7                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_07[I1, I2, T1, T2, T3, T4, T5, T6, T7                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, T8] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_08[I1, T1, T2, T3, T4, T5, T6, T7, T8                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_08[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_09[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_09[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_10[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_10[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_11[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_11[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_12[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_12[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_13[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_13[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_14[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_14[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_15[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_15[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_16[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_16[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_17[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_17[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_18[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_18[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_19[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_19[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_20[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_20[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21] extends Composite {
    def ~[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_1_21[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21                                                                    ] = ???
    def ~[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 ] = ???
    def ~[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            )] = ???
    def ~[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         )] = ???
    def ~[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      )] = ???
    def ~[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   )] = ???
    def ~[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                )] = ???
    def ~[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             )] = ???
    def ~[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2                                                                  ] (nextMolecule: IN1_00[I2                                                                  ]): Composite_In_2_21[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21                                                                    ] = ???
    def ~[I2, a                                                               ] (nextMolecule: IN1_01[I2, a                                                               ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 ] = ???
    def ~[I2, a, b                                                            ] (nextMolecule: IN1_02[I2, a, b                                                            ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            )] = ???
    def ~[I2, a, b, c                                                         ] (nextMolecule: IN1_03[I2, a, b, c                                                         ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         )] = ???
    def ~[I2, a, b, c, d                                                      ] (nextMolecule: IN1_04[I2, a, b, c, d                                                      ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      )] = ???
    def ~[I2, a, b, c, d, e                                                   ] (nextMolecule: IN1_05[I2, a, b, c, d, e                                                   ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   )] = ???
    def ~[I2, a, b, c, d, e, f                                                ] (nextMolecule: IN1_06[I2, a, b, c, d, e, f                                                ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, a, b, c, d, e, f, g                                             ] (nextMolecule: IN1_07[I2, a, b, c, d, e, f, g                                             ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN1_08[I2, a, b, c, d, e, f, g, h                                          ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN1_09[I2, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN1_10[I2, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN1_11[I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN1_12[I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN1_13[I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN1_14[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN1_15[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN1_16[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN1_17[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN1_18[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN1_19[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN1_20[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN1_21[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN1_22[I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_2_22[I1, I2, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    def ~[I2, I3                                                                  ] (nextMolecule: IN2_00[I2, I3                                                                  ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21                                                                    ] = ???
    def ~[I2, I3, a                                                               ] (nextMolecule: IN2_01[I2, I3, a                                                               ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 ] = ???
    def ~[I2, I3, a, b                                                            ] (nextMolecule: IN2_02[I2, I3, a, b                                                            ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            )] = ???
    def ~[I2, I3, a, b, c                                                         ] (nextMolecule: IN2_03[I2, I3, a, b, c                                                         ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         )] = ???
    def ~[I2, I3, a, b, c, d                                                      ] (nextMolecule: IN2_04[I2, I3, a, b, c, d                                                      ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      )] = ???
    def ~[I2, I3, a, b, c, d, e                                                   ] (nextMolecule: IN2_05[I2, I3, a, b, c, d, e                                                   ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   )] = ???
    def ~[I2, I3, a, b, c, d, e, f                                                ] (nextMolecule: IN2_06[I2, I3, a, b, c, d, e, f                                                ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g                                             ] (nextMolecule: IN2_07[I2, I3, a, b, c, d, e, f, g                                             ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h                                          ] (nextMolecule: IN2_08[I2, I3, a, b, c, d, e, f, g, h                                          ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: IN2_09[I2, I3, a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: IN2_10[I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: IN2_11[I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: IN2_12[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: IN2_13[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: IN2_14[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: IN2_15[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: IN2_16[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: IN2_17[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: IN2_18[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: IN2_19[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: IN2_20[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: IN2_21[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    def ~[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: IN2_22[I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_1_22[I1, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22] extends Composite

}