package molecule.macros
import molecule.transform.Model2Query
import scala.language.experimental.macros
import scala.language.higherKinds
import scala.reflect.macros.blackbox


/** Macro to make input molecules. */
class MakeMolecule_In(val c: blackbox.Context) extends Base {
  import c.universe._

  private[this] final def generateInputMolecule(dsl: Tree, InTypes: Type*)(OutTypes: Type*): Tree = {
    val InputMoleculeTpe = inputMolecule_i_o(InTypes.size, OutTypes.size)
    val OutMoleculeTpe = molecule_o(OutTypes.size)
    val inputMolecule = TypeName(c.freshName("inputMolecule$"))
    val outMolecule = TypeName(c.freshName("outMolecule$"))
    val (model0, types, casts, jsons, nestedRefAttrs, hasVariables, postTypes, postCasts, postJsons) = getModel(dsl)
    val flat = casts.size == 1

    // Methods for applying separate lists of input
    val applySeqs = InTypes match {
      case Seq(it1) => q"" // no extra

      case Seq(it1, it2) =>
        val (i1, i2) = (TermName(s"in1"), TermName(s"in2"))
        val (t1, t2) = (tq"Seq[$it1]", tq"Seq[$it2]")
        val (inParams, inTerm1, inTerm2) = (Seq(q"$i1: $t1", q"$i2: $t2"), i1, i2)
        if (flat) {
          q"""
            def apply(..$inParams)(implicit conn: Conn): $OutMoleculeTpe[..$OutTypes] = {
              final class $outMolecule extends $OutMoleculeTpe[..$OutTypes](_model, (bindSeqs(_query, $inTerm1, $inTerm2), None)) {
                final override def castRow(row: java.util.List[AnyRef]): (..$OutTypes) = (..${topLevel(casts)})
              }
              new $outMolecule
            }
          """
        } else {
          q"""
            def apply(..$inParams)(implicit conn: Conn): $OutMoleculeTpe[..$OutTypes] = {
              final class $outMolecule extends $OutMoleculeTpe[..$OutTypes](
                _model,
                (bindSeqs(_query, $inTerm1, $inTerm2), Some(bindSeqs(_nestedQuery.get, $inTerm1, $inTerm2)))
              ) with ${nestedJsonClassX(casts.size)}[(..$OutTypes)] {
                ..${resolveNestedTupleMethods(casts, types, OutTypes, postTypes, postCasts).get}
                ..${resolveNestedJsonMethods(jsons, nestedRefAttrs, postJsons).get}
              }
              new $outMolecule
            }
          """
        }

      case Seq(it1, it2, it3) =>
        val (i1, i2, i3) = (TermName(s"in1"), TermName(s"in2"), TermName(s"in3"))
        val (t1, t2, t3) = (tq"Seq[$it1]", tq"Seq[$it2]", tq"Seq[$it3]")
        val (inParams, inTerm1, inTerm2, inTerm3) = (Seq(q"$i1: $t1", q"$i2: $t2", q"$i3: $t3"), i1, i2, i3)
        if (flat) {
          q"""
            def apply(..$inParams)(implicit conn: Conn): $OutMoleculeTpe[..$OutTypes] = {
              final class $outMolecule extends $OutMoleculeTpe[..$OutTypes](_model, (bindSeqs(_query, $inTerm1, $inTerm2, $inTerm3), None)) {
                final override def castRow(row: java.util.List[AnyRef]): (..$OutTypes) = (..${topLevel(casts)})
              }
              new $outMolecule
            }
          """
        } else {
          q"""
            def apply(..$inParams)(implicit conn: Conn): $OutMoleculeTpe[..$OutTypes] = {
              final class $outMolecule extends $OutMoleculeTpe[..$OutTypes](
                _model,
                (bindSeqs(_query, $inTerm1, $inTerm2, $inTerm3), Some(bindSeqs(_nestedQuery.get, $inTerm1, $inTerm2, $inTerm3)))
              ) with ${nestedJsonClassX(casts.size)}[(..$OutTypes)] {
                ..${resolveNestedTupleMethods(casts, types, OutTypes, postTypes, postCasts).get}
                ..${resolveNestedJsonMethods(jsons, nestedRefAttrs, postJsons).get}
              }
              new $outMolecule
            }
          """
        }
    }


    if (flat) {
      if (hasVariables) {
        q"""
          import molecule.ast.model._
          import molecule.facade.Conn
          import molecule.ops.ModelOps._
          private val _resolvedModel: Model = resolveIdentifiers($model0, ${mapIdentifiers(model0.elements).toMap})
          final class $inputMolecule extends $InputMoleculeTpe[..$InTypes, ..$OutTypes](_resolvedModel, _root_.molecule.transform.Model2Query(_resolvedModel)) {
            def apply(args: Seq[(..$InTypes)])(implicit conn: Conn): $OutMoleculeTpe[..$OutTypes] = {
              final class $outMolecule extends $OutMoleculeTpe[..$OutTypes](_model, (bindValues(_query, args), None)) {
                final override def castRow(row: java.util.List[AnyRef]): (..$OutTypes) = (..${topLevel(casts)})
                final override def row2json(sb: StringBuilder, row: java.util.List[AnyRef]): StringBuilder = {..${topLevelJson(jsons)}}
              }
              new $outMolecule
            }
            $applySeqs
          }
          new $inputMolecule
        """
      } else {
        q"""
          import molecule.ast.model._
          import molecule.facade.Conn

          final class $inputMolecule extends $InputMoleculeTpe[..$InTypes, ..$OutTypes]($model0, ${Model2Query(model0)}) {
            def apply(args: Seq[(..$InTypes)])(implicit conn: Conn): $OutMoleculeTpe[..$OutTypes] = {
              final class $outMolecule extends $OutMoleculeTpe[..$OutTypes](_model, (bindValues(_query, args), None)) {
                final override def castRow(row: java.util.List[AnyRef]): (..$OutTypes) = (..${topLevel(casts)})
                final override def row2json(sb: StringBuilder, row: java.util.List[AnyRef]): StringBuilder = {..${topLevelJson(jsons)}}
              }
              new $outMolecule
            }
            $applySeqs
          }
          new $inputMolecule
        """
      }

    } else {

      if (hasVariables) {
        q"""
          import molecule.ast.model._
          import molecule.facade.Conn
          import molecule.ops.ModelOps._
          private val _resolvedModel: Model = resolveIdentifiers($model0, ${mapIdentifiers(model0.elements).toMap})
          final class $inputMolecule extends $InputMoleculeTpe[..$InTypes, ..$OutTypes](_resolvedModel, _root_.molecule.transform.Model2Query(_resolvedModel)) {
            def apply(args: Seq[(..$InTypes)])(implicit conn: Conn): $OutMoleculeTpe[..$OutTypes] = {
              final class $outMolecule extends $OutMoleculeTpe[..$OutTypes](
                _model,
                (bindValues(_query, args), Some(bindValues(_nestedQuery.get, args)))
              ) with ${nestedJsonClassX(casts.size)}[(..$OutTypes)] {
                ..${resolveNestedTupleMethods(casts, types, OutTypes, postTypes, postCasts).get}
                ..${resolveNestedJsonMethods(jsons, nestedRefAttrs, postJsons).get}
              }
              new $outMolecule
            }
            $applySeqs
          }
          new $inputMolecule
        """
      } else {
        q"""
          import molecule.ast.model._
          import molecule.facade.Conn
          final class $inputMolecule extends $InputMoleculeTpe[..$InTypes, ..$OutTypes]($model0, ${Model2Query(model0)}) {
            def apply(args: Seq[(..$InTypes)])(implicit conn: Conn): $OutMoleculeTpe[..$OutTypes] = {
              final class $outMolecule extends $OutMoleculeTpe[..$OutTypes](
                _model,
                (bindValues(_query, args), Some(bindValues(_nestedQuery.get, args)))
              ) with ${nestedJsonClassX(casts.size)}[(..$OutTypes)] {
                ..${resolveNestedTupleMethods(casts, types, OutTypes, postTypes, postCasts).get}
                ..${resolveNestedJsonMethods(jsons, nestedRefAttrs, postJsons).get}
              }
              new $outMolecule
            }
            $applySeqs
          }
          new $inputMolecule
        """
      }
    }
  }


  // Input molecules with 1 input and 1-22 outputs

  final def await_1_1[In1_1[_, _], In1_2[_, _, _], In2_1[_, _, _], In2_2[_, _, _, _], I1: WeakTypeTag, A: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A])
  final def await_1_2[In1_2[_, _, _], In1_3[_, _, _, _], In2_2[_, _, _, _], In2_3[_, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B])
  final def await_1_3[In1_3[_, _, _, _], In1_4[_, _, _, _, _], In2_3[_, _, _, _, _], In2_4[_, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C])
  final def await_1_4[In1_4[_, _, _, _, _], In1_5[_, _, _, _, _, _], In2_4[_, _, _, _, _, _], In2_5[_, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D])
  final def await_1_5[In1_5[_, _, _, _, _, _], In1_6[_, _, _, _, _, _, _], In2_5[_, _, _, _, _, _, _], In2_6[_, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E])
  final def await_1_6[In1_6[_, _, _, _, _, _, _], In1_7[_, _, _, _, _, _, _, _], In2_6[_, _, _, _, _, _, _, _], In2_7[_, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F])
  final def await_1_7[In1_7[_, _, _, _, _, _, _, _], In1_8[_, _, _, _, _, _, _, _, _], In2_7[_, _, _, _, _, _, _, _, _], In2_8[_, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G])
  final def await_1_8[In1_8[_, _, _, _, _, _, _, _, _], In1_9[_, _, _, _, _, _, _, _, _, _], In2_8[_, _, _, _, _, _, _, _, _, _], In2_9[_, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H])
  final def await_1_9[In1_9[_, _, _, _, _, _, _, _, _, _], In1_10[_, _, _, _, _, _, _, _, _, _, _], In2_9[_, _, _, _, _, _, _, _, _, _, _], In2_10[_, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I])
  final def await_1_10[In1_10[_, _, _, _, _, _, _, _, _, _, _], In1_11[_, _, _, _, _, _, _, _, _, _, _, _], In2_10[_, _, _, _, _, _, _, _, _, _, _, _], In2_11[_, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J])
  final def await_1_11[In1_11[_, _, _, _, _, _, _, _, _, _, _, _], In1_12[_, _, _, _, _, _, _, _, _, _, _, _, _], In2_11[_, _, _, _, _, _, _, _, _, _, _, _, _], In2_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K])
  final def await_1_12[In1_12[_, _, _, _, _, _, _, _, _, _, _, _, _], In1_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L])
  final def await_1_13[In1_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M])
  final def await_1_14[In1_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N])
  final def await_1_15[In1_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O])
  final def await_1_16[In1_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P])
  final def await_1_17[In1_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q])
  final def await_1_18[In1_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R])
  final def await_1_19[In1_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S])
  final def await_1_20[In1_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag, T: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S], weakTypeOf[T])
  final def await_1_21[In1_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag, T: WeakTypeTag, U: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S], weakTypeOf[T], weakTypeOf[U])
  final def await_1_22[In1_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In1_23[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_23[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag, T: WeakTypeTag, U: WeakTypeTag, V: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S], weakTypeOf[T], weakTypeOf[U], weakTypeOf[V])


  // Input molecules with 2 inputs and 1-22 outputs

  final def await_2_1[In2_1[_, _, _], In2_2[_, _, _, _], In3_1[_, _, _, _], In3_2[_, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A])
  final def await_2_2[In2_2[_, _, _, _], In2_3[_, _, _, _, _], In3_2[_, _, _, _, _], In3_3[_, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B])
  final def await_2_3[In2_3[_, _, _, _, _], In2_4[_, _, _, _, _, _], In3_3[_, _, _, _, _, _], In3_4[_, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C])
  final def await_2_4[In2_4[_, _, _, _, _, _], In2_5[_, _, _, _, _, _, _], In3_4[_, _, _, _, _, _, _], In3_5[_, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D])
  final def await_2_5[In2_5[_, _, _, _, _, _, _], In2_6[_, _, _, _, _, _, _, _], In3_5[_, _, _, _, _, _, _, _], In3_6[_, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E])
  final def await_2_6[In2_6[_, _, _, _, _, _, _, _], In2_7[_, _, _, _, _, _, _, _, _], In3_6[_, _, _, _, _, _, _, _, _], In3_7[_, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F])
  final def await_2_7[In2_7[_, _, _, _, _, _, _, _, _], In2_8[_, _, _, _, _, _, _, _, _, _], In3_7[_, _, _, _, _, _, _, _, _, _], In3_8[_, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G])
  final def await_2_8[In2_8[_, _, _, _, _, _, _, _, _, _], In2_9[_, _, _, _, _, _, _, _, _, _, _], In3_8[_, _, _, _, _, _, _, _, _, _, _], In3_9[_, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H])
  final def await_2_9[In2_9[_, _, _, _, _, _, _, _, _, _, _], In2_10[_, _, _, _, _, _, _, _, _, _, _, _], In3_9[_, _, _, _, _, _, _, _, _, _, _, _], In3_10[_, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I])
  final def await_2_10[In2_10[_, _, _, _, _, _, _, _, _, _, _, _], In2_11[_, _, _, _, _, _, _, _, _, _, _, _, _], In3_10[_, _, _, _, _, _, _, _, _, _, _, _, _], In3_11[_, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J])
  final def await_2_11[In2_11[_, _, _, _, _, _, _, _, _, _, _, _, _], In2_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_11[_, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K])
  final def await_2_12[In2_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L])
  final def await_2_13[In2_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M])
  final def await_2_14[In2_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N])
  final def await_2_15[In2_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O])
  final def await_2_16[In2_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P])
  final def await_2_17[In2_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q])
  final def await_2_18[In2_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R])
  final def await_2_19[In2_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S])
  final def await_2_20[In2_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag, T: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S], weakTypeOf[T])
  final def await_2_21[In2_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag, T: WeakTypeTag, U: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S], weakTypeOf[T], weakTypeOf[U])
  final def await_2_22[In2_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In2_23[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_23[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag, T: WeakTypeTag, U: WeakTypeTag, V: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S], weakTypeOf[T], weakTypeOf[U], weakTypeOf[V])


  // Input molecules with 3 inputs and 1-22 outputs

  final def await_3_1[In3_1[_, _, _, _], In3_2[_, _, _, _, _], In4_1[_, _, _, _, _], In4_2[_, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A])
  final def await_3_2[In3_2[_, _, _, _, _], In3_3[_, _, _, _, _, _], In4_2[_, _, _, _, _, _], In4_3[_, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B])
  final def await_3_3[In3_3[_, _, _, _, _, _], In3_4[_, _, _, _, _, _, _], In4_3[_, _, _, _, _, _, _], In4_4[_, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C])
  final def await_3_4[In3_4[_, _, _, _, _, _, _], In3_5[_, _, _, _, _, _, _, _], In4_4[_, _, _, _, _, _, _, _], In4_5[_, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D])
  final def await_3_5[In3_5[_, _, _, _, _, _, _, _], In3_6[_, _, _, _, _, _, _, _, _], In4_5[_, _, _, _, _, _, _, _, _], In4_6[_, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E])
  final def await_3_6[In3_6[_, _, _, _, _, _, _, _, _], In3_7[_, _, _, _, _, _, _, _, _, _], In4_6[_, _, _, _, _, _, _, _, _, _], In4_7[_, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F])
  final def await_3_7[In3_7[_, _, _, _, _, _, _, _, _, _], In3_8[_, _, _, _, _, _, _, _, _, _, _], In4_7[_, _, _, _, _, _, _, _, _, _, _], In4_8[_, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G])
  final def await_3_8[In3_8[_, _, _, _, _, _, _, _, _, _, _], In3_9[_, _, _, _, _, _, _, _, _, _, _, _], In4_8[_, _, _, _, _, _, _, _, _, _, _, _], In4_9[_, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H])
  final def await_3_9[In3_9[_, _, _, _, _, _, _, _, _, _, _, _], In3_10[_, _, _, _, _, _, _, _, _, _, _, _, _], In4_9[_, _, _, _, _, _, _, _, _, _, _, _, _], In4_10[_, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I])
  final def await_3_10[In3_10[_, _, _, _, _, _, _, _, _, _, _, _, _], In3_11[_, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_10[_, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_11[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J])
  final def await_3_11[In3_11[_, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_11[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K])
  final def await_3_12[In3_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_12[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L])
  final def await_3_13[In3_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_13[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M])
  final def await_3_14[In3_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_14[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N])
  final def await_3_15[In3_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_15[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O])
  final def await_3_16[In3_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_16[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P])
  final def await_3_17[In3_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_17[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q])
  final def await_3_18[In3_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_18[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R])
  final def await_3_19[In3_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_19[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S])
  final def await_3_20[In3_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_20[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag, T: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S], weakTypeOf[T])
  final def await_3_21[In3_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_21[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag, T: WeakTypeTag, U: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S], weakTypeOf[T], weakTypeOf[U])
  final def await_3_22[In3_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In3_23[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_22[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], In4_23[_, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _, _], I1: WeakTypeTag, I2: WeakTypeTag, I3: WeakTypeTag, A: WeakTypeTag, B: WeakTypeTag, C: WeakTypeTag, D: WeakTypeTag, E: WeakTypeTag, F: WeakTypeTag, G: WeakTypeTag, H: WeakTypeTag, I: WeakTypeTag, J: WeakTypeTag, K: WeakTypeTag, L: WeakTypeTag, M: WeakTypeTag, N: WeakTypeTag, O: WeakTypeTag, P: WeakTypeTag, Q: WeakTypeTag, R: WeakTypeTag, S: WeakTypeTag, T: WeakTypeTag, U: WeakTypeTag, V: WeakTypeTag](dsl: Tree): Tree = generateInputMolecule(dsl, weakTypeOf[I1], weakTypeOf[I2], weakTypeOf[I3])(weakTypeOf[A], weakTypeOf[B], weakTypeOf[C], weakTypeOf[D], weakTypeOf[E], weakTypeOf[F], weakTypeOf[G], weakTypeOf[H], weakTypeOf[I], weakTypeOf[J], weakTypeOf[K], weakTypeOf[L], weakTypeOf[M], weakTypeOf[N], weakTypeOf[O], weakTypeOf[P], weakTypeOf[Q], weakTypeOf[R], weakTypeOf[S], weakTypeOf[T], weakTypeOf[U], weakTypeOf[V])
}