package molecule.composition

import molecule.boilerplate.base._
import scala.language.higherKinds

/** Add sub-molecule to composite input molecule awaiting 3 inputs.
  * <br><br>
  * Composite molecules model entities with attributes from different namespaces that are
  * not necessarily related. Each group of attributes is modelled by a molecule and the
  * "sub-molecules" are tied together with `+` methods to form a composite molecule.
  * <br><br>
  * `+` methods of this interface adds a new sub-molecule to the composite.
  * {{{
  *   //             | input composite                     | add sub-molecule
  *   m(Article.name(?).author(?) + Tag.category.weight(?) + Publisher.name)
  *     .apply("Battle of Waterloo", "Ben Bridge", 5).get === List(
  *       (("Battle of Waterloo", "Ben Bridge"), ("History", 5), "Bestseller Publications Inc.")
  *     )
  * }}}
  * @see [[http://www.scalamolecule.org/manual/relationships/composites/ Manual]]
  *     | [[https://github.com/scalamolecule/molecule/blob/master/coretests/src/test/scala/molecule/coretests/ref/Composite.scala Tests]]
  */
trait Composite_In_3 extends NS


/** `+` methods on composite molecule awaiting 3 inputs to add sub-molecule. */
object Composite_In_3 {

  trait Composite_In_3_00[I1, I2, I3] extends Composite {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_3_00[I1, I2, I3                                                                    ]= ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_01[I1, I2, I3, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_01[I1, I2, I3, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_01[I1, I2, I3, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_01[I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_01[I1, I2, I3, T1] extends Composite {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_3_01[I1, I2, I3, T1                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_02[I1, I2, I3, T1, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_02[I1, I2, I3, T1, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_02[I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_02[I1, I2, I3, T1, T2] extends Composite {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_3_02[I1, I2, I3, T1, T2                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_03[I1, I2, I3, T1, T2, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_03[I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_03[I1, I2, I3, T1, T2, T3] extends Composite {
    final def +[x                                                               ] (nextMolecule: NS00[x                                                               ]): Composite_In_3_03[I1, I2, I3, T1, T2, T3                                                                    ] = ???
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_04[I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_04[I1, I2, I3, T1, T2, T3, T4] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_05[I1, I2, I3, T1, T2, T3, T4, T5] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_06[I1, I2, I3, T1, T2, T3, T4, T5, T6] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_07[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_08[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_09[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_10[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_11[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_12[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_13[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_14[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_15[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_16[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_17[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_18[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_19[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_20[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_21[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21] extends Composite {
    final def +[a                                                               ] (nextMolecule: NS01[a                                                               ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 ] = ???
    final def +[a, b                                                            ] (nextMolecule: NS02[a, b                                                            ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            )] = ???
    final def +[a, b, c                                                         ] (nextMolecule: NS03[a, b, c                                                         ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         )] = ???
    final def +[a, b, c, d                                                      ] (nextMolecule: NS04[a, b, c, d                                                      ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      )] = ???
    final def +[a, b, c, d, e                                                   ] (nextMolecule: NS05[a, b, c, d, e                                                   ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   )] = ???
    final def +[a, b, c, d, e, f                                                ] (nextMolecule: NS06[a, b, c, d, e, f                                                ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                )] = ???
    final def +[a, b, c, d, e, f, g                                             ] (nextMolecule: NS07[a, b, c, d, e, f, g                                             ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             )] = ???
    final def +[a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS08[a, b, c, d, e, f, g, h                                          ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS09[a, b, c, d, e, f, g, h, i                                       ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_In_3_22[I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22] extends Composite

}