package molecule.composition

import molecule.boilerplate.base._
import scala.language.higherKinds


/** Add nested molecule.
  * <br><br>
  * Related data of cardinality-many referenced entities can be queried in a "flat" way:
  * {{{
  *   m(Order.no.LineItem.product.price.quantity).get === List(
  *     (23, "Chocolate", 48.00, 1),
  *     (23, "Whisky", 38.00, 2)
  *   )
  * }}}
  * For convenience, Molecule offers to automatically nest the same data so that
  * redundancy is avoided and we can work straight on the hierarchical data:
  * {{{
  *   m(Order.no * LineItem.product.price.quantity).get === List(
  *     (23, List(("Chocolate", 48.00, 1), ("Whisky", 38.00, 2)))
  *   )
  * }}}
  * Nested molecules can nest up to 7 levels deep.
  * <br><br>
  * Internally, Molecule adds entity ids to each level in the query to be able to group data on each level by a unique entity id.
  * @see [[http://www.scalamolecule.org/manual/relationships/card-many/ Manual]]
  *     | Tests: [[https://github.com/scalamolecule/molecule/blob/master/coretests/src/test/scala/molecule/coretests/ref/NestedRef.scala#L1 nested]],
  *     [[https://github.com/scalamolecule/molecule/blob/master/coretests/src/test/scala/molecule/coretests/json/NestedJson.scala#L1 nested json]],
  *     [[https://github.com/scalamolecule/molecule/blob/master/coretests/src/test/scala/molecule/coretests/json/NestedTypes.scala#L1 nested json types]]
  */
trait Nested


/** `*` methods to add nested molecule. */
object Nested {

  trait Nested00[Ns1[_], In1_1[_,_], In2_1[_,_,_], In3_1[_,_,_,_]] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns1[Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns1[Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns1[Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns1[Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns1[Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns1[Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns1[Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns1[Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns1[Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_1[I1, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_1[I1, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_1[I1, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_1[I1, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_1[I1, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_1[I1, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_1[I1, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_1[I1, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_1[I1, I2, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_1[I1, I2, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_1[I1, I2, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_1[I1, I2, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_1[I1, I2, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_1[I1, I2, I3, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_1[I1, I2, I3, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_1[I1, I2, I3, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_1[I1, I2, I3, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested01[Ns2[_,_], In1_2[_,_,_], In2_2[_,_,_,_], In3_2[_,_,_,_,_], A] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns2[A, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns2[A, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns2[A, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns2[A, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns2[A, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns2[A, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns2[A, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns2[A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_2[I1, A, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_2[I1, A, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_2[I1, A, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_2[I1, A, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_2[I1, A, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_2[I1, A, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_2[I1, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_2[I1, I2, A, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_2[I1, I2, A, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_2[I1, I2, A, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_2[I1, I2, A, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_2[I1, I2, I3, A, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_2[I1, I2, I3, A, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_2[I1, I2, I3, A, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested02[Ns3[_,_,_], In1_3[_,_,_,_], In2_3[_,_,_,_,_], In3_3[_,_,_,_,_,_], A, B] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns3[A, B, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns3[A, B, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns3[A, B, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns3[A, B, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns3[A, B, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns3[A, B, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns3[A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
    
    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_3[I1, A, B, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_3[I1, A, B, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_3[I1, A, B, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_3[I1, A, B, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_3[I1, A, B, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_3[I1, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
    
    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_3[I1, I2, A, B, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_3[I1, I2, A, B, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_3[I1, I2, A, B, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
    
    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_3[I1, I2, I3, A, B, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_3[I1, I2, I3, A, B, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested03[Ns4[_,_,_,_], In1_4[_,_,_,_,_], In2_4[_,_,_,_,_,_], In3_4[_,_,_,_,_,_,_], A, B, C] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns4[A, B, C, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns4[A, B, C, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns4[A, B, C, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns4[A, B, C, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns4[A, B, C, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns4[A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_4[I1, A, B, C, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_4[I1, A, B, C, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_4[I1, A, B, C, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_4[I1, A, B, C, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_4[I1, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_4[I1, I2, A, B, C, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_4[I1, I2, A, B, C, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_4[I1, I2, I3, A, B, C, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested04[Ns5[_,_,_,_,_], In1_5[_,_,_,_,_,_], In2_5[_,_,_,_,_,_,_], In3_5[_,_,_,_,_,_,_,_], A, B, C, D] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns5[A, B, C, D, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns5[A, B, C, D, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns5[A, B, C, D, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns5[A, B, C, D, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns5[A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_5[I1, A, B, C, D, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_5[I1, A, B, C, D, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_5[I1, A, B, C, D, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_5[I1, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_5[I1, I2, A, B, C, D, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_5[I1, I2, I3, A, B, C, D, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested05[Ns6[_,_,_,_,_,_], In1_6[_,_,_,_,_,_,_], In2_6[_,_,_,_,_,_,_,_], In3_6[_,_,_,_,_,_,_,_,_], A, B, C, D, E] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns6[A, B, C, D, E, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns6[A, B, C, D, E, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns6[A, B, C, D, E, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns6[A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_6[I1, A, B, C, D, E, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_6[I1, A, B, C, D, E, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_6[I1, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_6[I1, I2, A, B, C, D, E, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested06[Ns7[_,_,_,_,_,_,_], In1_7[_,_,_,_,_,_,_,_], In2_7[_,_,_,_,_,_,_,_,_], In3_7[_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns7[A, B, C, D, E, F, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns7[A, B, C, D, E, F, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns7[A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_7[I1, A, B, C, D, E, F, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_7[I1, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested07[Ns8[_,_,_,_,_,_,_,_], In1_8[_,_,_,_,_,_,_,_,_], In2_8[_,_,_,_,_,_,_,_,_,_], In3_8[_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns8[A, B, C, D, E, F, G, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns8[A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_8[I1, A, B, C, D, E, F, G, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_8[I1, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested08[Ns9[_,_,_,_,_,_,_,_,_], In1_9[_,_,_,_,_,_,_,_,_,_], In2_9[_,_,_,_,_,_,_,_,_,_,_], In3_9[_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns9[A, B, C, D, E, F, G, H, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns9[A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_9[I1, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested09[Ns10[_,_,_,_,_,_,_,_,_,_], In1_10[_,_,_,_,_,_,_,_,_,_,_], In2_10[_,_,_,_,_,_,_,_,_,_,_,_], In3_10[_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns10[A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_10[I1, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested10[Ns11[_,_,_,_,_,_,_,_,_,_,_], In1_11[_,_,_,_,_,_,_,_,_,_,_,_], In2_11[_,_,_,_,_,_,_,_,_,_,_,_,_], In3_11[_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns11[A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_11[I1, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested11[Ns12[_,_,_,_,_,_,_,_,_,_,_,_], In1_12[_,_,_,_,_,_,_,_,_,_,_,_,_], In2_12[_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_12[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns12[A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_12[I1, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested12[Ns13[_,_,_,_,_,_,_,_,_,_,_,_,_], In1_13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_13[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_13[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns13[A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_13[I1, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested13[Ns14[_,_,_,_,_,_,_,_,_,_,_,_,_,_], In1_14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L, M] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns14[A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_14[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }



  trait Nested14[Ns15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In1_15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L, M, N] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_15[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested15[Ns16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In1_16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L, M, N, O] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_16[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested16[Ns17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In1_17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_17[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested17[Ns18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In1_18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_18[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested18[Ns19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In1_19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_19[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested19[Ns20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In1_20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_20[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested20[Ns21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In1_21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_21[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested21[Ns22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In1_22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In2_22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U] extends Nested {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Ns22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, a                                                               ] (nested: IN1_01[I1, a                                                               ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[a                                                                 ]] = ???
    final def *[I1, a, b                                                            ] (nested: IN1_02[I1, a, b                                                            ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b                                                            )]] = ???
    final def *[I1, a, b, c                                                         ] (nested: IN1_03[I1, a, b, c                                                         ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, a, b, c, d                                                      ] (nested: IN1_04[I1, a, b, c, d                                                      ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, a, b, c, d, e                                                   ] (nested: IN1_05[I1, a, b, c, d, e                                                   ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, a, b, c, d, e, f                                                ] (nested: IN1_06[I1, a, b, c, d, e, f                                                ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I1, a, b, c, d, e, f, g                                             ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I1, a, b, c, d, e, f, g, h                                          ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I1, a, b, c, d, e, f, g, h, i                                       ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I1, a, b, c, d, e, f, g, h, i, j                                    ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I1, a, b, c, d, e, f, g, h, i, j, k                                 ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I1, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I1, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I1, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In1_22[I1, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, a                                                               ] (nested: IN2_01[I1, I2, a                                                               ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[a                                                                 ]] = ???
    final def *[I1, I2, a, b                                                            ] (nested: IN2_02[I1, I2, a, b                                                            ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, a, b, c                                                         ] (nested: IN2_03[I1, I2, a, b, c                                                         ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, a, b, c, d                                                      ] (nested: IN2_04[I1, I2, a, b, c, d                                                      ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, a, b, c, d, e                                                   ] (nested: IN2_05[I1, I2, a, b, c, d, e                                                   ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f                                                ] (nested: IN2_06[I1, I2, a, b, c, d, e, f                                                ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g                                             ] (nested: IN2_07[I1, I2, a, b, c, d, e, f, g                                             ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h                                          ] (nested: IN2_08[I1, I2, a, b, c, d, e, f, g, h                                          ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i                                       ] (nested: IN2_09[I1, I2, a, b, c, d, e, f, g, h, i                                       ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN2_10[I1, I2, a, b, c, d, e, f, g, h, i, j                                    ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN2_11[I1, I2, a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN2_12[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN2_13[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN2_14[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN2_15[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN2_16[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN2_17[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN2_18[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN2_19[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN2_20[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN2_21[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN2_22[I1, I2, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I1, I2, I3, a                                                               ] (nested: IN3_01[I1, I2, I3, a                                                               ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[a                                                                 ]] = ???
    final def *[I1, I2, I3, a, b                                                            ] (nested: IN3_02[I1, I2, I3, a, b                                                            ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b                                                            )]] = ???
    final def *[I1, I2, I3, a, b, c                                                         ] (nested: IN3_03[I1, I2, I3, a, b, c                                                         ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c                                                         )]] = ???
    final def *[I1, I2, I3, a, b, c, d                                                      ] (nested: IN3_04[I1, I2, I3, a, b, c, d                                                      ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e                                                   ] (nested: IN3_05[I1, I2, I3, a, b, c, d, e                                                   ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f                                                ] (nested: IN3_06[I1, I2, I3, a, b, c, d, e, f                                                ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g                                             ] (nested: IN3_07[I1, I2, I3, a, b, c, d, e, f, g                                             ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h                                          ] (nested: IN3_08[I1, I2, I3, a, b, c, d, e, f, g, h                                          ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN3_09[I1, I2, I3, a, b, c, d, e, f, g, h, i                                       ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN3_10[I1, I2, I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN3_11[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN3_12[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN3_13[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN3_14[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN3_15[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN3_16[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN3_17[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN3_18[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN3_19[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN3_20[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN3_21[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN3_22[I1, I2, I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }
}