/*
 * Decompiled with CFR 0.152.
 */
package molecule.api;

import datomic.ListenableFuture;
import datomic.Peer;
import datomic.Util;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import molecule.ast.MoleculeBase;
import molecule.ast.model;
import molecule.ast.transactionModel;
import molecule.facade.Conn;
import molecule.facade.TxReport;
import molecule.facade.TxReport$;
import molecule.macros.exception.TxFnException;
import molecule.transform.Model2Transaction;
import molecule.util.BridgeDatomicFuture;
import molecule.util.DateHandling;
import molecule.util.Helpers;
import molecule.util.Helpers$mkDate$;
import molecule.util.RegexMatching;
import moleculeBuildInfo.BuildInfo$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class TxMethods$
implements Helpers,
BridgeDatomicFuture {
    public static TxMethods$ MODULE$;
    private volatile Helpers$mkDate$ mkDate$module;
    private long molecule$util$Helpers$$time0;
    private final scala.collection.mutable.Map<Object, Object> molecule$util$Helpers$$times;
    private ZoneOffset localZoneOffset;
    private String localOffset;
    private ZoneId zone;
    private volatile byte bitmap$0;

    static {
        new TxMethods$();
    }

    @Override
    public <T> Future<T> bridgeDatomicFuture(ListenableFuture<T> listenF, ExecutionContext ec) {
        return BridgeDatomicFuture.bridgeDatomicFuture$(this, listenF, ec);
    }

    @Override
    public String clean(String attr2) {
        return Helpers.clean$(this, attr2);
    }

    @Override
    public final Object f(Object a2) {
        return Helpers.f$(this, a2);
    }

    @Override
    public String escStr(String s) {
        return Helpers.escStr$(this, s);
    }

    @Override
    public String unescStr(String s) {
        return Helpers.unescStr$(this, s);
    }

    @Override
    public String cast(Object value) {
        return Helpers.cast$(this, value);
    }

    @Override
    public final String os(Option<Set<?>> opt) {
        return Helpers.os$(this, opt);
    }

    @Override
    public final String o(Option<Object> opt) {
        return Helpers.o$(this, opt);
    }

    @Override
    public final <T> String seq(Seq<T> values) {
        return Helpers.seq$(this, values);
    }

    @Override
    public final Seq<Object> tupleToSeq(Object arg) {
        return Helpers.tupleToSeq$(this, arg);
    }

    @Override
    public final void time(int n, int prev) {
        Helpers.time$(this, n, prev);
    }

    @Override
    public final int time$default$2() {
        return Helpers.time$default$2$(this);
    }

    @Override
    public int daylight(long ms) {
        return DateHandling.daylight$(this, ms);
    }

    @Override
    public String date2datomicStr(Date date, ZoneOffset zoneOffset) {
        return DateHandling.date2datomicStr$(this, date, zoneOffset);
    }

    @Override
    public ZoneOffset date2datomicStr$default$2() {
        return DateHandling.date2datomicStr$default$2$(this);
    }

    @Override
    public String date2str(Date date, ZoneOffset zoneOffset) {
        return DateHandling.date2str$(this, date, zoneOffset);
    }

    @Override
    public ZoneOffset date2str$default$2() {
        return DateHandling.date2str$default$2$(this);
    }

    @Override
    public Date str2date(String s, ZoneOffset zoneOffset) {
        return DateHandling.str2date$(this, s, zoneOffset);
    }

    @Override
    public ZoneOffset str2date$default$2() {
        return DateHandling.str2date$default$2$(this);
    }

    @Override
    public ZonedDateTime str2zdt(String s, ZoneOffset zoneOffset) {
        return DateHandling.str2zdt$(this, s, zoneOffset);
    }

    @Override
    public ZoneOffset str2zdt$default$2() {
        return DateHandling.str2zdt$default$2$(this);
    }

    @Override
    public String truncateDateStr(String dateStr) {
        return DateHandling.truncateDateStr$(this, dateStr);
    }

    @Override
    public String expandDateStr(String dateStr) {
        return DateHandling.expandDateStr$(this, dateStr);
    }

    @Override
    public RegexMatching.Regex Regex(StringContext sc) {
        return RegexMatching.Regex$(this, sc);
    }

    @Override
    public Helpers$mkDate$ mkDate() {
        if (this.mkDate$module == null) {
            this.mkDate$lzycompute$1();
        }
        return this.mkDate$module;
    }

    @Override
    public long molecule$util$Helpers$$time0() {
        return this.molecule$util$Helpers$$time0;
    }

    @Override
    public void molecule$util$Helpers$$time0_$eq(long x$1) {
        this.molecule$util$Helpers$$time0 = x$1;
    }

    @Override
    public scala.collection.mutable.Map<Object, Object> molecule$util$Helpers$$times() {
        return this.molecule$util$Helpers$$times;
    }

    @Override
    public final void molecule$util$Helpers$_setter_$molecule$util$Helpers$$times_$eq(scala.collection.mutable.Map<Object, Object> x$1) {
        this.molecule$util$Helpers$$times = x$1;
    }

    private ZoneOffset localZoneOffset$lzycompute() {
        TxMethods$ txMethods$ = this;
        synchronized (txMethods$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.localZoneOffset = DateHandling.localZoneOffset$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.localZoneOffset;
    }

    @Override
    public ZoneOffset localZoneOffset() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.localZoneOffset$lzycompute() : this.localZoneOffset;
    }

    private String localOffset$lzycompute() {
        TxMethods$ txMethods$ = this;
        synchronized (txMethods$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.localOffset = DateHandling.localOffset$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.localOffset;
    }

    @Override
    public String localOffset() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.localOffset$lzycompute() : this.localOffset;
    }

    private ZoneId zone$lzycompute() {
        TxMethods$ txMethods$ = this;
        synchronized (txMethods$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.zone = DateHandling.zone$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.zone;
    }

    @Override
    public ZoneId zone() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.zone$lzycompute() : this.zone;
    }

    public String excMissingScalaJar(Throwable e2) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(616).append("The Datomic transactor needs any dependencies in transactor\n       |functions to be available on its classpath. Please copy the scala-library jar to the Datomic transactor lib.\n       |Supposing $DATOMIC_HOME points to your Datomic distribution folder you can likely run this command (on a mac):\n       |cp ~/.ivy2/cache/org.scala-lang/scala-library/jars/scala-library-").append(BuildInfo$.MODULE$.scalaVersion()).append(".jar $DATOMIC_HOME/lib/\n       |You might also want to copy the molecule library:\n       |cp ~/.ivy2/cache/org.scalamolecule/molecule_2.13/").append(BuildInfo$.MODULE$.version()).append("/jars/molecule_2.13.jar $DATOMIC_HOME/lib/\n       |You need to then restart the Datomic transactor.\n       |").append(e2.getMessage()).toString())).stripMargin();
    }

    public String excMissingMoleculeClass(Throwable e2) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(464).append("The Datomic transactor needs any dependencies in transactor\n       |functions to be available on its classpath. Please copy the Molecule library jar to the Datomic transactor lib.\n       |Supposing $DATOMIC_HOME points to your Datomic distribution folder you can likely run this command (on a mac):\n       |cp ~/.ivy2/cache/org.scalamolecule/molecule_2.13/").append(BuildInfo$.MODULE$.version()).append("/jars/molecule_2.13.jar $DATOMIC_HOME/lib/\n       |You need to then restart the Datomic transactor.\n       |").append(e2.getMessage()).toString())).stripMargin();
    }

    public String excMissingMoleculeMethod(Throwable e2) {
        String err = e2.getMessage();
        String method = err.substring(29, err.indexOf("("));
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(313).append("The Datomic transactor needs all used Scala transaction methods to be in its scope.\n       |The Scala transaction method `").append(method).append("` is not found by the transactor. So you may need to restart\n       |the transactor (if using classpath) or make an updated jar with all transaction functions for the transactor lib.\n       |").append(e2.getMessage()).toString())).stripMargin();
    }

    public String txFnException(Throwable e2) {
        return new StringBuilder(53).append("Unexpected error when invoking transaction function:\n").append(e2.getCause()).toString();
    }

    public TxReport tryTransactTxFn(Function0<TxReport> body) {
        TxReport txReport;
        try {
            txReport = (TxReport)package$.MODULE$.blocking(body);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof ExecutionException) {
                ExecutionException executionException = (ExecutionException)throwable2;
                String string = executionException.getMessage();
                if (string.startsWith("java.lang.NoClassDefFoundError: scala")) {
                    throw new TxFnException(this.excMissingScalaJar(executionException));
                }
                if (string.startsWith("java.lang.NoClassDefFoundError: molecule")) {
                    throw new TxFnException(this.excMissingMoleculeClass(executionException));
                }
                if (string.startsWith("java.lang.NoSuchMethodError: molecule")) {
                    throw new TxFnException(this.excMissingMoleculeMethod(executionException));
                }
                throw new TxFnException(this.txFnException(executionException));
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e2 = (Throwable)option.get();
                throw new TxFnException(this.txFnException(e2));
            }
            throw throwable;
        }
        return txReport;
    }

    public Map<?, ?> buildTxFnInstall(String txFn, Seq<Object> args) {
        IndexedSeq params = (IndexedSeq)args.indices().map((Function1 & Serializable & scala.Serializable)i -> TxMethods$.$anonfun$buildTxFnInstall$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        Object[] objectArray = new Object[4];
        objectArray[0] = Util.read((String)":db/ident");
        objectArray[1] = Util.read((String)new StringBuilder(1).append(":").append(txFn).toString());
        objectArray[2] = Util.read((String)":db/fn");
        Object[] objectArray2 = new Object[6];
        objectArray2[0] = Util.read((String)":lang");
        objectArray2[1] = "java";
        objectArray2[2] = Util.read((String)":params");
        Object object = Util.read((String)"txDb");
        Object object2 = Util.read((String)"txMetaData");
        objectArray2[3] = Util.list((Object[])((Object[])((TraversableOnce)((SeqLike)((SeqLike)params.map((Function1 & Serializable & scala.Serializable)x$1 -> Util.read((String)x$1), IndexedSeq$.MODULE$.canBuildFrom())).$plus$colon(object2, IndexedSeq$.MODULE$.canBuildFrom())).$plus$colon(object, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object())));
        objectArray2[4] = Util.read((String)":code");
        objectArray2[5] = new StringBuilder(28).append("return ").append(txFn).append("(txDb, txMetaData, ").append(params.mkString(", ")).append(");").toString();
        objectArray[3] = Peer.function((Map)Util.map((Object[])objectArray2));
        return Util.map((Object[])objectArray);
    }

    private Seq<transactionModel.Statement> txStmts(Seq<MoleculeBase> txMolecules, Conn conn) {
        Seq<transactionModel.Statement> seq;
        if (txMolecules.nonEmpty()) {
            Seq txElements = (Seq)txMolecules.flatMap((Function1 & Serializable & scala.Serializable)mol -> (Seq)mol._model().elements().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Seq seq;
                model.Element element = x0$1;
                if (element instanceof model.Composite) {
                    Seq elements;
                    model.Composite composite = (model.Composite)element;
                    seq = elements = composite.elements();
                } else {
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new model.Element[]{element}));
                }
                return seq;
            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
            model.Model txModel = new model.Model((Seq<model.Element>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new model.TxMetaData[]{new model.TxMetaData((Seq<model.Element>)txElements)}))));
            Model2Transaction txTransformer = new Model2Transaction(conn, txModel);
            seq = txTransformer.saveStmts();
        } else {
            seq = Nil$.MODULE$;
        }
        return seq;
    }

    public TxReport txFnCall(String txFn, Seq<MoleculeBase> txMolecules, Seq<Object> args, Conn conn) {
        return this.tryTransactTxFn((Function0<TxReport>)(Function0 & Serializable & scala.Serializable)() -> {
            Object object = conn.datomicConn().db().entity((Object)new StringBuilder(1).append(":").append(txFn).toString()) == null ? conn.datomicConn().transact(Util.list((Object[])new Object[]{MODULE$.buildTxFnInstall(txFn, args)})).get() : BoxedUnit.UNIT;
            Object[] objectArray = new Object[1];
            Object object2 = Util.read((String)txFn);
            Seq<transactionModel.Statement> seq = MODULE$.txStmts(txMolecules, conn);
            objectArray[0] = Util.list((Object[])((Object[])((TraversableOnce)((SeqLike)((SeqLike)args.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3, Seq$.MODULE$.canBuildFrom())).$plus$colon(seq, Seq$.MODULE$.canBuildFrom())).$plus$colon(object2, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef())));
            List txFnInvocationClause = Util.list((Object[])objectArray);
            return new TxReport((Map)conn.datomicConn().transact(txFnInvocationClause).get(), TxReport$.MODULE$.apply$default$2());
        });
    }

    public void debugTxFnCall(String txFn, Seq<MoleculeBase> txMolecules, Seq<Object> args, Conn conn) {
        conn.testDbWith((Seq<Seq<Seq<transactionModel.Statement>>>)Nil$.MODULE$);
        this.txFnCall(txFn, txMolecules, args, conn).debug();
        conn.useLiveDb();
    }

    public Future<TxReport> asyncTxFnCall(String txFn, Seq<MoleculeBase> txMolecules, Seq<Object> args, Conn conn, ExecutionContext ec) {
        Future future;
        try {
            Future txFnInstallFuture = conn.datomicConn().db().entity((Object)new StringBuilder(1).append(":").append(txFn).toString()) == null ? this.bridgeDatomicFuture(conn.datomicConn().transactAsync(Util.list((Object[])new Object[]{this.buildTxFnInstall(txFn, args)})), ec) : Future$.MODULE$.unit();
            future = txFnInstallFuture.flatMap((Function1 & Serializable & scala.Serializable)txFnInstall -> {
                Promise p = Promise$.MODULE$.apply();
                Object[] objectArray = new Object[1];
                Object object = Util.read((String)txFn);
                Seq<transactionModel.Statement> seq = MODULE$.txStmts(txMolecules, conn);
                objectArray[0] = Util.list((Object[])((Object[])((TraversableOnce)((SeqLike)((SeqLike)args.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6, Seq$.MODULE$.canBuildFrom())).$plus$colon(seq, Seq$.MODULE$.canBuildFrom())).$plus$colon(object, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef())));
                List txFnInvocationClause = Util.list((Object[])objectArray);
                ListenableFuture txFnInvocationListenable = conn.datomicConn().transactAsync(txFnInvocationClause);
                txFnInvocationListenable.addListener(new Runnable(p, txFnInvocationListenable){
                    private final Promise p$1;
                    private final ListenableFuture txFnInvocationListenable$1;

                    public void run() {
                        try {
                            this.p$1.success(this.txFnInvocationListenable$1.get());
                        }
                        catch (Throwable throwable) {
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof ExecutionException) {
                                ExecutionException executionException = (ExecutionException)throwable2;
                                String string = executionException.getMessage();
                                if (string.startsWith("java.lang.NoClassDefFoundError: scala")) {
                                    Promise promise = this.p$1;
                                    throw new TxFnException(TxMethods$.MODULE$.excMissingScalaJar(executionException));
                                }
                                if (string.startsWith("java.lang.NoClassDefFoundError: molecule")) {
                                    Promise promise = this.p$1;
                                    throw new TxFnException(TxMethods$.MODULE$.excMissingMoleculeClass(executionException));
                                }
                                if (string.startsWith("java.lang.NoSuchMethodError: molecule")) {
                                    Promise promise = this.p$1;
                                    throw new TxFnException(TxMethods$.MODULE$.excMissingMoleculeMethod(executionException));
                                }
                                Promise promise = this.p$1;
                                throw new TxFnException(TxMethods$.MODULE$.txFnException(executionException));
                            }
                            Option option = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option.isEmpty()) {
                                Throwable e2 = (Throwable)option.get();
                                Promise promise = this.p$1;
                                throw new TxFnException(TxMethods$.MODULE$.txFnException(e2));
                            }
                            throw throwable;
                        }
                    }
                    {
                        this.p$1 = p$1;
                        this.txFnInvocationListenable$1 = txFnInvocationListenable$1;
                    }
                }, arg0 -> ec.execute(arg0));
                return p.future();
            }, ec);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e2 = (Throwable)option.get();
            Future future2 = Future$.MODULE$.failed(e2);
            future = future2;
        }
        Future txFnInvocationfuture = future;
        return txFnInvocationfuture.map((Function1 & Serializable & scala.Serializable)txFnInvocationResult -> new TxReport((Map<?, ?>)txFnInvocationResult, TxReport$.MODULE$.apply$default$2()), ec);
    }

    private final void mkDate$lzycompute$1() {
        TxMethods$ txMethods$ = this;
        synchronized (txMethods$) {
            if (this.mkDate$module == null) {
                this.mkDate$module = new Helpers$mkDate$(this);
            }
        }
    }

    public static final /* synthetic */ String $anonfun$buildTxFnInstall$1(int i) {
        return ((Object)BoxesRunTime.boxToCharacter((char)((char)(97 + i)))).toString();
    }

    private TxMethods$() {
        MODULE$ = this;
        RegexMatching.$init$(this);
        DateHandling.$init$(this);
        Helpers.$init$(this);
        BridgeDatomicFuture.$init$(this);
    }
}

