package molecule.core.composition

import molecule.core.boilerplate.base._
import scala.language.higherKinds


/** Add nested molecule to input molecule awaiting 3 inputs.
  * {{{
  *   m(Order.no(?).total.>(?).att(?) * LineItem.product.price.quantity)
  *     .apply(23, 120, "Ben Smith").get === List(
  *       (23, 124, "Ben Smith", List(("Chocolate", 48.00, 1), ("Whisky", 38.00, 2)))
  *     )
  * }}}
  */
trait Nested_In_3


/** `*` methods to add nested molecule to molecule awaiting 3 inputs. */
object Nested_In_3 {

  trait Nested_In_3_00[In3_1[_,_,_,_], I1, I2, I3] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_1[I1, I2, I3, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_1[I1, I2, I3, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_1[I1, I2, I3, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_1[I1, I2, I3, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_01[In3_2[_,_,_,_,_], I1, I2, I3, A] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_2[I1, I2, I3, A, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_2[I1, I2, I3, A, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_2[I1, I2, I3, A, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_02[In3_3[_,_,_,_,_,_], I1, I2, I3, A, B] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_3[I1, I2, I3, A, B, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_3[I1, I2, I3, A, B, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_03[In3_4[_,_,_,_,_,_,_], I1, I2, I3, A, B, C] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_4[I1, I2, I3, A, B, C, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_04[In3_5[_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a                                                               )]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_05[In3_6[_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_06[In3_7[_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_07[In3_8[_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_08[In3_9[_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_09[In3_10[_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_10[In3_11[_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_11[In3_12[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_12[In3_13[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_13[In3_14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_14[In3_15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_15[In3_16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_16[In3_17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_17[In3_18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_18[In3_19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_19[In3_20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_20[In3_21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_3_21[In3_22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U] extends Nested_In_3 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }
}