package molecule.core.composition

import molecule.core.boilerplate.base._
import scala.language.higherKinds


/** Add nested molecule to input molecule awaiting 2 inputs.
  * {{{
  *   m(Order.no(?).total.>(?) * LineItem.product.price.quantity)
  *     .apply(23, 120).get === List(
  *       (23, 124, List(("Chocolate", 48.00, 1), ("Whisky", 38.00, 2)))
  *     )
  * }}}
  */
trait Nested_In_2


/** `*` methods to add nested molecule to molecule awaiting 2 inputs. */
object Nested_In_2 {

  trait Nested_In_2_00[In2_1[_,_,_], In3_1[_,_,_,_], I1, I2] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_1[I1, I2, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_1[I1, I2, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_1[I1, I2, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_1[I1, I2, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_1[I1, I2, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_1[I1, I2, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_1[I1, I2, I3, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_1[I1, I2, I3, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_1[I1, I2, I3, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_1[I1, I2, I3, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_1[I1, I2, I3, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }                                                                                                                                                                       

  trait Nested_In_2_01[In2_2[_,_,_,_], In3_2[_,_,_,_,_], I1, I2, A] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_2[I1, I2, A, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_2[I1, I2, A, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_2[I1, I2, A, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_2[I1, I2, A, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_2[I1, I2, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_2[I1, I2, I3, A, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_2[I1, I2, I3, A, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_2[I1, I2, I3, A, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_2[I1, I2, I3, A, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_02[In2_3[_,_,_,_,_], In3_3[_,_,_,_,_,_], I1, I2, A, B] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_3[I1, I2, A, B, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_3[I1, I2, A, B, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_3[I1, I2, A, B, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_3[I1, I2, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_3[I1, I2, I3, A, B, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_3[I1, I2, I3, A, B, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_3[I1, I2, I3, A, B, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_03[In2_4[_,_,_,_,_,_], In3_4[_,_,_,_,_,_,_], I1, I2, A, B, C] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_4[I1, I2, A, B, C, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_4[I1, I2, A, B, C, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_4[I1, I2, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_4[I1, I2, I3, A, B, C, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_4[I1, I2, I3, A, B, C, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_04[In2_5[_,_,_,_,_,_,_], In3_5[_,_,_,_,_,_,_,_], I1, I2, A, B, C, D] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_5[I1, I2, A, B, C, D, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_5[I1, I2, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_5[I1, I2, I3, A, B, C, D, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_5[I1, I2, I3, A, B, C, D, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_05[In2_6[_,_,_,_,_,_,_,_], In3_6[_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_6[I1, I2, A, B, C, D, E, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_6[I1, I2, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_6[I1, I2, I3, A, B, C, D, E, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_06[In2_7[_,_,_,_,_,_,_,_,_], In3_7[_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_7[I1, I2, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_7[I1, I2, I3, A, B, C, D, E, F, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_07[In2_8[_,_,_,_,_,_,_,_,_,_], In3_8[_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_8[I1, I2, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_8[I1, I2, I3, A, B, C, D, E, F, G, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_08[In2_9[_,_,_,_,_,_,_,_,_,_,_], In3_9[_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_9[I1, I2, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_9[I1, I2, I3, A, B, C, D, E, F, G, H, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_09[In2_10[_,_,_,_,_,_,_,_,_,_,_,_], In3_10[_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_10[I1, I2, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_10[I1, I2, I3, A, B, C, D, E, F, G, H, I, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_10[In2_11[_,_,_,_,_,_,_,_,_,_,_,_,_], In3_11[_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_11[I1, I2, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_11[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_11[In2_12[_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_12[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_12[I1, I2, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_12[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_12[In2_13[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_13[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_13[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_13[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_13[In2_14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_14[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_14[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_14[In2_15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_15[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_15[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_15[In2_16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_16[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_16[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_16[In2_17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_17[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_17[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_17[In2_18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_18[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_18[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_18[In2_19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_19[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_19[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_19[In2_20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_20[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_20[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_20[In2_21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_21[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_21[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }

  trait Nested_In_2_21[In2_22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], In3_22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U] extends Nested_In_2 {
    final def *[a                                                               ] (nested: NS01[a                                                               ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[a                                                                 ]] = ???
    final def *[a, b                                                            ] (nested: NS02[a, b                                                            ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b                                                            )]] = ???
    final def *[a, b, c                                                         ] (nested: NS03[a, b, c                                                         ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c                                                         )]] = ???
    final def *[a, b, c, d                                                      ] (nested: NS04[a, b, c, d                                                      ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d                                                      )]] = ???
    final def *[a, b, c, d, e                                                   ] (nested: NS05[a, b, c, d, e                                                   ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[a, b, c, d, e, f                                                ] (nested: NS06[a, b, c, d, e, f                                                ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[a, b, c, d, e, f, g                                             ] (nested: NS07[a, b, c, d, e, f, g                                             ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[a, b, c, d, e, f, g, h                                          ] (nested: NS08[a, b, c, d, e, f, g, h                                          ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[a, b, c, d, e, f, g, h, i                                       ] (nested: NS09[a, b, c, d, e, f, g, h, i                                       ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j                                    ] (nested: NS10[a, b, c, d, e, f, g, h, i, j                                    ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: NS11[a, b, c, d, e, f, g, h, i, j, k                                 ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: NS12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: NS13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: NS14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: NS15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: NS16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: NS17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: NS18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: NS19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: NS20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: NS21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: NS22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In2_22[I1, I2, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???

    final def *[I3, a                                                               ] (nested: IN1_01[I3, a                                                               ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[a                                                                 ]] = ???
    final def *[I3, a, b                                                            ] (nested: IN1_02[I3, a, b                                                            ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b                                                            )]] = ???
    final def *[I3, a, b, c                                                         ] (nested: IN1_03[I3, a, b, c                                                         ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c                                                         )]] = ???
    final def *[I3, a, b, c, d                                                      ] (nested: IN1_04[I3, a, b, c, d                                                      ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d                                                      )]] = ???
    final def *[I3, a, b, c, d, e                                                   ] (nested: IN1_05[I3, a, b, c, d, e                                                   ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e                                                   )]] = ???
    final def *[I3, a, b, c, d, e, f                                                ] (nested: IN1_06[I3, a, b, c, d, e, f                                                ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f                                                )]] = ???
    final def *[I3, a, b, c, d, e, f, g                                             ] (nested: IN1_07[I3, a, b, c, d, e, f, g                                             ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g                                             )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h                                          ] (nested: IN1_08[I3, a, b, c, d, e, f, g, h                                          ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h                                          )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i                                       ] (nested: IN1_09[I3, a, b, c, d, e, f, g, h, i                                       ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i                                       )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j                                    ] (nested: IN1_10[I3, a, b, c, d, e, f, g, h, i, j                                    ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j                                    )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: IN1_11[I3, a, b, c, d, e, f, g, h, i, j, k                                 ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k                                 )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: IN1_12[I3, a, b, c, d, e, f, g, h, i, j, k, l                              ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l                              )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: IN1_13[I3, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: IN1_14[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: IN1_15[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: IN1_16[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: IN1_17[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: IN1_18[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: IN1_19[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: IN1_20[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: IN1_21[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )]] = ???
    final def *[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: IN1_22[I3, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): In3_22[I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Seq[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)]] = ???
  }
}