package molecule.core.composition

import molecule.core.dsl.base._
import molecule.core.composition.Composite_3._
import scala.language.higherKinds


/** Build composite molecule from input molecule awaiting 3 inputs.
  * <br><br>
  * Composite molecules model entities with attributes from different namespaces that are
  * not necessarily related. Each group of attributes is modelled by a molecule and the
  * "sub-molecules" are tied together with `+` methods to form a composite molecule.
  * <br><br>
  * The attributes of the first input sub-molecule awaiting 3 inputs are tied
  * together in a tuple of its own before being merged with the tuple of attribute values
  * of the second sub-molecule. If any of the sub-molecules are of arity-1, then no tuple is created:
  * {{{
  *   m(Article.name(?).author(?).editor(?) + Tag.category.weight)
  *     .apply("Battle of Waterloo", "Ben Bridge", "Joe Moe").get === List(
  *       (("Battle of Waterloo", "Ben Bridge", "Joe Moe"), ("History", 5))
  *     )
  * }}}
  */
object CompositeInit_3 {

  trait CompositeInit_3_00[obj[_], props, I1, I2, I3] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_00[obj, obj[props] with nextObj[nextProps], I1, I2, I3                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_00[obj, obj[props with nextProps], I1, I2, I3                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_01[obj[_], props, I1, I2, I3, A] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, A                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_02[obj[_], props, I1, I2, I3, A, B] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_03[obj[_], props, I1, I2, I3, A, B, C] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_04[obj[_], props, I1, I2, I3, A, B, C, D] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_05[obj[_], props, I1, I2, I3, A, B, C, D, E] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_06[obj[_], props, I1, I2, I3, A, B, C, D, E, F] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_07[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_08[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_09[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_10[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_11[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_12[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_13[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_14[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_15[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_16[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_17[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_18[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_19[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_20[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_21[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait CompositeInit_3_22[obj[_], props, I1, I2, I3, A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V] {
    final def +[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props] with nextObj[nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???

    final def ++[nextObj[_], nextProps                                                                  ] (nextMolecule: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)                                                                    ] = ???
    final def ++[nextObj[_], nextProps, a                                                               ] (nextMolecule: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), a                                                                 ] = ???
    final def ++[nextObj[_], nextProps, a, b                                                            ] (nextMolecule: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b                                                            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c                                                         ] (nextMolecule: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c                                                         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d                                                      ] (nextMolecule: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d                                                      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e                                                   ] (nextMolecule: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e                                                   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (nextMolecule: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f                                                )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (nextMolecule: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g                                             )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (nextMolecule: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h                                          )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (nextMolecule: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (nextMolecule: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (nextMolecule: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (nextMolecule: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nextMolecule: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nextMolecule: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nextMolecule: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nextMolecule: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nextMolecule: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nextMolecule: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nextMolecule: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nextMolecule: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nextMolecule: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def ++[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nextMolecule: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, obj[props with nextProps], I1, I2, I3, (A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }
}