package molecule.core.composition

import molecule.core.dsl.base._
import scala.language.higherKinds

/** Add sub-molecule to composite input molecule awaiting 3 inputs.
  * <br><br>
  * Composite molecules model entities with attributes from different namespaces that are
  * not necessarily related. Each group of attributes is modelled by a molecule and the
  * "sub-molecules" are tied together with `+` methods to form a composite molecule.
  * <br><br>
  * `+` methods of this interface adds a new sub-molecule to the composite.
  * {{{
  *   //             | input composite                     | add sub-molecule
  *   m(Article.name(?).author(?) + Tag.category.weight(?) + Publisher.name)
  *     .apply("Battle of Waterloo", "Ben Bridge", 5).get === List(
  *       (("Battle of Waterloo", "Ben Bridge"), ("History", 5), "Bestseller Publications Inc.")
  *     )
  * }}}
  */
object Composite_3 {

  trait Composite_3_00[obj[_], props, I1, I2, I3] {
    final def +[nextObj[_], nextProps                                                                  ] (next: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_00[obj, props with nextObj[nextProps], I1, I2, I3                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_01[obj[_], props, I1, I2, I3, T1] {
    final def +[nextObj[_], nextProps                                                                  ] (next: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_01[obj, props with nextObj[nextProps], I1, I2, I3, T1                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_02[obj[_], props, I1, I2, I3, T1, T2] {
    final def +[nextObj[_], nextProps                                                                  ] (next: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_02[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_03[obj[_], props, I1, I2, I3, T1, T2, T3] {
    final def +[nextObj[_], nextProps                                                                  ] (next: NS_0_00[nextObj, nextProps                                                                  ]): Composite_3_03[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3                                                                    ] = ???
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_04[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_04[obj[_], props, I1, I2, I3, T1, T2, T3, T4] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_05[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_05[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_06[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_06[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_07[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_07[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_08[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_08[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_09[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_09[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_10[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_10[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_11[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_11[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_12[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_12[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_13[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_13[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_14[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_14[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_15[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_15[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_16[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_16[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_17[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_17[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_18[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_18[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_19[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_19[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_20[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_20[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_21[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_21[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21] {
    final def +[nextObj[_], nextProps, a                                                               ] (next: NS_0_01[nextObj, nextProps, a                                                               ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 ] = ???
    final def +[nextObj[_], nextProps, a, b                                                            ] (next: NS_0_02[nextObj, nextProps, a, b                                                            ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            )] = ???
    final def +[nextObj[_], nextProps, a, b, c                                                         ] (next: NS_0_03[nextObj, nextProps, a, b, c                                                         ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d                                                      ] (next: NS_0_04[nextObj, nextProps, a, b, c, d                                                      ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e                                                   ] (next: NS_0_05[nextObj, nextProps, a, b, c, d, e                                                   ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f                                                ] (next: NS_0_06[nextObj, nextProps, a, b, c, d, e, f                                                ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g                                             ] (next: NS_0_07[nextObj, nextProps, a, b, c, d, e, f, g                                             ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h                                          ] (next: NS_0_08[nextObj, nextProps, a, b, c, d, e, f, g, h                                          ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i                                       ] (next: NS_0_09[nextObj, nextProps, a, b, c, d, e, f, g, h, i                                       ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j                                    ] (next: NS_0_10[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j                                    ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ] (next: NS_0_11[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ] (next: NS_0_12[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (next: NS_0_13[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (next: NS_0_14[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (next: NS_0_15[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (next: NS_0_16[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (next: NS_0_17[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (next: NS_0_18[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (next: NS_0_19[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (next: NS_0_20[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (next: NS_0_21[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )] = ???
    final def +[nextObj[_], nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (next: NS_0_22[nextObj, nextProps, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_3_22[obj, props with nextObj[nextProps], I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)] = ???
  }

  trait Composite_3_22[obj[_], props, I1, I2, I3, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22]

}