package molecule.datomic.base.marshalling

import java.util.{Collection => jCollection, List => jList}
import molecule.core.marshalling.nodes._
import molecule.datomic.base.marshalling.packers.ResolverFlat

private[molecule] case class Flat2packed(
  obj: Obj,
  rows: jCollection[jList[AnyRef]],
  maxRows: Int = -1
) extends ResolverFlat {

  val sb = new StringBuffer()

  def getPacked: String = {
    if (!rows.isEmpty) {
      val nodesWithNonTacitProps: List[Node] = {
        def resolve(node: Node, acc: List[Node]): List[Node] = node match {
          case Obj(_, _, _, Nil)     => acc
          case prop: Prop            => acc :+ prop
          case o@Obj(_, _, _, props) =>
            val nonEmptyProps = props.flatMap(prop => resolve(prop, Nil))
            nonEmptyProps match {
              case Nil => acc
              case _   => acc :+ o.copy(props = nonEmptyProps)
            }
        }
        resolve(obj, Nil)
      }

      val packRow = packRef(nodesWithNonTacitProps, 0)
      if (maxRows == -1) {
        rows.forEach(row => packRow(row))
      } else {
        val rowIterator = rows.iterator()
        var i           = 0
        while (rowIterator.hasNext && i != maxRows) {
          packRow(rowIterator.next)
          i += 1
        }
      }
    }
    sb.toString
  }

  private var colIndex = -1

  def packAttr(node: Node, level: Int): jList[_] => StringBuffer = {
    node match {
      case Prop(_, _, baseTpe, _, group, optAggrTpe) =>
        colIndex += 1
        packFlatAttr(sb, group, baseTpe, colIndex, optAggrTpe)

      case Obj(_, _, _, props) =>
        packRef(props, level)
    }
  }

  def packRef(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    attrs.size match {
      case 1   => packRef1(attrs, level)
      case 2   => packRef2(attrs, level)
      case 3   => packRef3(attrs, level)
      case 4   => packRef4(attrs, level)
      case 5   => packRef5(attrs, level)
      case 6   => packRef6(attrs, level)
      case 7   => packRef7(attrs, level)
      case 8   => packRef8(attrs, level)
      case 9   => packRef9(attrs, level)
      case 10  => packRef10(attrs, level)
      case 11  => packRef11(attrs, level)
      case 12  => packRef12(attrs, level)
      case 13  => packRef13(attrs, level)
      case 14  => packRef14(attrs, level)
      case 15  => packRef15(attrs, level)
      case 16  => packRef16(attrs, level)
      case 17  => packRef17(attrs, level)
      case 18  => packRef18(attrs, level)
      case 19  => packRef19(attrs, level)
      case 20  => packRef20(attrs, level)
      case 21  => packRef21(attrs, level)
      case 22  => packRef22(attrs, level)
      case 23  => packRef23(attrs, level)
      case 24  => packRef24(attrs, level)
      case 25  => packRef25(attrs, level)
      case 26  => packRef26(attrs, level)
      case 27  => packRef27(attrs, level)
      case 28  => packRef28(attrs, level)
      case 29  => packRef29(attrs, level)
      case 30  => packRef30(attrs, level)
      case 31  => packRef31(attrs, level)
      case 32  => packRef32(attrs, level)
      case 33  => packRef33(attrs, level)
      case 34  => packRef34(attrs, level)
      case 35  => packRef35(attrs, level)
      case 36  => packRef36(attrs, level)
      case 37  => packRef37(attrs, level)
      case 38  => packRef38(attrs, level)
      case 39  => packRef39(attrs, level)
      case 40  => packRef40(attrs, level)
      case 41  => packRef41(attrs, level)
      case 42  => packRef42(attrs, level)
      case 43  => packRef43(attrs, level)
      case 44  => packRef44(attrs, level)
      case 45  => packRef45(attrs, level)
      case 46  => packRef46(attrs, level)
      case 47  => packRef47(attrs, level)
      case 48  => packRef48(attrs, level)
      case 49  => packRef49(attrs, level)
      case 50  => packRef50(attrs, level)
      case 51  => packRef51(attrs, level)
      case 52  => packRef52(attrs, level)
      case 53  => packRef53(attrs, level)
      case 54  => packRef54(attrs, level)
      case 55  => packRef55(attrs, level)
      case 56  => packRef56(attrs, level)
      case 57  => packRef57(attrs, level)
      case 58  => packRef58(attrs, level)
      case 59  => packRef59(attrs, level)
      case 60  => packRef60(attrs, level)
      case 61  => packRef61(attrs, level)
      case 62  => packRef62(attrs, level)
      case 63  => packRef63(attrs, level)
      case 64  => packRef64(attrs, level)
      case 65  => packRef65(attrs, level)
      case 66  => packRef66(attrs, level)
      case 67  => packRef67(attrs, level)
      case 68  => packRef68(attrs, level)
      case 69  => packRef69(attrs, level)
      case 70  => packRef70(attrs, level)
      case 71  => packRef71(attrs, level)
      case 72  => packRef72(attrs, level)
      case 73  => packRef73(attrs, level)
      case 74  => packRef74(attrs, level)
      case 75  => packRef75(attrs, level)
      case 76  => packRef76(attrs, level)
      case 77  => packRef77(attrs, level)
      case 78  => packRef78(attrs, level)
      case 79  => packRef79(attrs, level)
      case 80  => packRef80(attrs, level)
      case 81  => packRef81(attrs, level)
      case 82  => packRef82(attrs, level)
      case 83  => packRef83(attrs, level)
      case 84  => packRef84(attrs, level)
      case 85  => packRef85(attrs, level)
      case 86  => packRef86(attrs, level)
      case 87  => packRef87(attrs, level)
      case 88  => packRef88(attrs, level)
      case 89  => packRef89(attrs, level)
      case 90  => packRef90(attrs, level)
      case 91  => packRef91(attrs, level)
      case 92  => packRef92(attrs, level)
      case 93  => packRef93(attrs, level)
      case 94  => packRef94(attrs, level)
      case 95  => packRef95(attrs, level)
      case 96  => packRef96(attrs, level)
      case 97  => packRef97(attrs, level)
      case 98  => packRef98(attrs, level)
      case 99  => packRef99(attrs, level)
      case 100 => packRef100(attrs, level)
      case n   => throw new RuntimeException(
        s"[Flat2packed] Can handle maximum 100 attributes from JS side. Found $n."
      )
    }
  }

  def packRef1(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    (row: jList[_]) =>
      pack0(row)
  }

  def packRef2(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    val pack1 = packAttr(attrs(1), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
  }

  def packRef3(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    val pack1 = packAttr(attrs(1), level)
    val pack2 = packAttr(attrs(2), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
  }

  def packRef4(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    val pack1 = packAttr(attrs(1), level)
    val pack2 = packAttr(attrs(2), level)
    val pack3 = packAttr(attrs(3), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
  }

  def packRef5(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    val pack1 = packAttr(attrs(1), level)
    val pack2 = packAttr(attrs(2), level)
    val pack3 = packAttr(attrs(3), level)
    val pack4 = packAttr(attrs(4), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
  }

  def packRef6(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    val pack1 = packAttr(attrs(1), level)
    val pack2 = packAttr(attrs(2), level)
    val pack3 = packAttr(attrs(3), level)
    val pack4 = packAttr(attrs(4), level)
    val pack5 = packAttr(attrs(5), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
  }

  def packRef7(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    val pack1 = packAttr(attrs(1), level)
    val pack2 = packAttr(attrs(2), level)
    val pack3 = packAttr(attrs(3), level)
    val pack4 = packAttr(attrs(4), level)
    val pack5 = packAttr(attrs(5), level)
    val pack6 = packAttr(attrs(6), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
  }

  def packRef8(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    val pack1 = packAttr(attrs(1), level)
    val pack2 = packAttr(attrs(2), level)
    val pack3 = packAttr(attrs(3), level)
    val pack4 = packAttr(attrs(4), level)
    val pack5 = packAttr(attrs(5), level)
    val pack6 = packAttr(attrs(6), level)
    val pack7 = packAttr(attrs(7), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
  }

  def packRef9(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    val pack1 = packAttr(attrs(1), level)
    val pack2 = packAttr(attrs(2), level)
    val pack3 = packAttr(attrs(3), level)
    val pack4 = packAttr(attrs(4), level)
    val pack5 = packAttr(attrs(5), level)
    val pack6 = packAttr(attrs(6), level)
    val pack7 = packAttr(attrs(7), level)
    val pack8 = packAttr(attrs(8), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
  }

  def packRef10(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0 = packAttr(attrs.head, level)
    val pack1 = packAttr(attrs(1), level)
    val pack2 = packAttr(attrs(2), level)
    val pack3 = packAttr(attrs(3), level)
    val pack4 = packAttr(attrs(4), level)
    val pack5 = packAttr(attrs(5), level)
    val pack6 = packAttr(attrs(6), level)
    val pack7 = packAttr(attrs(7), level)
    val pack8 = packAttr(attrs(8), level)
    val pack9 = packAttr(attrs(9), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
  }

  def packRef11(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
  }

  def packRef12(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
  }

  def packRef13(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
  }

  def packRef14(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
  }

  def packRef15(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
  }

  def packRef16(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
  }

  def packRef17(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
  }

  def packRef18(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
  }

  def packRef19(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
  }

  def packRef20(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
  }

  def packRef21(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
  }

  def packRef22(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
  }

  def packRef23(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
  }

  def packRef24(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
  }

  def packRef25(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
  }

  def packRef26(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
  }

  def packRef27(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
  }

  def packRef28(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
  }

  def packRef29(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
  }

  def packRef30(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
  }

  def packRef31(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
  }

  def packRef32(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
  }

  def packRef33(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
  }

  def packRef34(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
  }

  def packRef35(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
  }

  def packRef36(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
  }

  def packRef37(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
  }

  def packRef38(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
  }

  def packRef39(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
  }

  def packRef40(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
  }

  def packRef41(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
  }

  def packRef42(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
  }

  def packRef43(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
  }

  def packRef44(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
  }

  def packRef45(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
  }

  def packRef46(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
  }

  def packRef47(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
  }

  def packRef48(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
  }

  def packRef49(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
  }

  def packRef50(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
  }

  def packRef51(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
  }

  def packRef52(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
  }

  def packRef53(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
  }

  def packRef54(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
  }

  def packRef55(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
  }

  def packRef56(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
  }

  def packRef57(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
  }

  def packRef58(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
  }

  def packRef59(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
  }

  def packRef60(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
  }

  def packRef61(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
  }

  def packRef62(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
  }

  def packRef63(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
  }

  def packRef64(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
  }

  def packRef65(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
  }

  def packRef66(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
  }

  def packRef67(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
  }

  def packRef68(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
  }

  def packRef69(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
  }

  def packRef70(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
  }

  def packRef71(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
  }

  def packRef72(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
  }

  def packRef73(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
  }

  def packRef74(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
  }

  def packRef75(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
  }

  def packRef76(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
  }

  def packRef77(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
  }

  def packRef78(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
  }

  def packRef79(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
  }

  def packRef80(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
  }

  def packRef81(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
  }

  def packRef82(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
  }

  def packRef83(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
  }

  def packRef84(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
  }

  def packRef85(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
  }

  def packRef86(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
  }

  def packRef87(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
  }

  def packRef88(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
  }

  def packRef89(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
  }

  def packRef90(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
  }

  def packRef91(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
  }

  def packRef92(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    val pack91 = packAttr(attrs(91), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
      pack91(row)
  }

  def packRef93(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    val pack91 = packAttr(attrs(91), level)
    val pack92 = packAttr(attrs(92), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
      pack91(row)
      pack92(row)
  }

  def packRef94(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    val pack91 = packAttr(attrs(91), level)
    val pack92 = packAttr(attrs(92), level)
    val pack93 = packAttr(attrs(93), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
      pack91(row)
      pack92(row)
      pack93(row)
  }

  def packRef95(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    val pack91 = packAttr(attrs(91), level)
    val pack92 = packAttr(attrs(92), level)
    val pack93 = packAttr(attrs(93), level)
    val pack94 = packAttr(attrs(94), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
      pack91(row)
      pack92(row)
      pack93(row)
      pack94(row)
  }

  def packRef96(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    val pack91 = packAttr(attrs(91), level)
    val pack92 = packAttr(attrs(92), level)
    val pack93 = packAttr(attrs(93), level)
    val pack94 = packAttr(attrs(94), level)
    val pack95 = packAttr(attrs(95), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
      pack91(row)
      pack92(row)
      pack93(row)
      pack94(row)
      pack95(row)
  }

  def packRef97(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    val pack91 = packAttr(attrs(91), level)
    val pack92 = packAttr(attrs(92), level)
    val pack93 = packAttr(attrs(93), level)
    val pack94 = packAttr(attrs(94), level)
    val pack95 = packAttr(attrs(95), level)
    val pack96 = packAttr(attrs(96), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
      pack91(row)
      pack92(row)
      pack93(row)
      pack94(row)
      pack95(row)
      pack96(row)
  }

  def packRef98(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    val pack91 = packAttr(attrs(91), level)
    val pack92 = packAttr(attrs(92), level)
    val pack93 = packAttr(attrs(93), level)
    val pack94 = packAttr(attrs(94), level)
    val pack95 = packAttr(attrs(95), level)
    val pack96 = packAttr(attrs(96), level)
    val pack97 = packAttr(attrs(97), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
      pack91(row)
      pack92(row)
      pack93(row)
      pack94(row)
      pack95(row)
      pack96(row)
      pack97(row)
  }

  def packRef99(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    val pack91 = packAttr(attrs(91), level)
    val pack92 = packAttr(attrs(92), level)
    val pack93 = packAttr(attrs(93), level)
    val pack94 = packAttr(attrs(94), level)
    val pack95 = packAttr(attrs(95), level)
    val pack96 = packAttr(attrs(96), level)
    val pack97 = packAttr(attrs(97), level)
    val pack98 = packAttr(attrs(98), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
      pack91(row)
      pack92(row)
      pack93(row)
      pack94(row)
      pack95(row)
      pack96(row)
      pack97(row)
      pack98(row)
  }

  def packRef100(attrs: List[Node], level: Int): jList[_] => StringBuffer = {
    val pack0  = packAttr(attrs.head, level)
    val pack1  = packAttr(attrs(1), level)
    val pack2  = packAttr(attrs(2), level)
    val pack3  = packAttr(attrs(3), level)
    val pack4  = packAttr(attrs(4), level)
    val pack5  = packAttr(attrs(5), level)
    val pack6  = packAttr(attrs(6), level)
    val pack7  = packAttr(attrs(7), level)
    val pack8  = packAttr(attrs(8), level)
    val pack9  = packAttr(attrs(9), level)
    val pack10 = packAttr(attrs(10), level)
    val pack11 = packAttr(attrs(11), level)
    val pack12 = packAttr(attrs(12), level)
    val pack13 = packAttr(attrs(13), level)
    val pack14 = packAttr(attrs(14), level)
    val pack15 = packAttr(attrs(15), level)
    val pack16 = packAttr(attrs(16), level)
    val pack17 = packAttr(attrs(17), level)
    val pack18 = packAttr(attrs(18), level)
    val pack19 = packAttr(attrs(19), level)
    val pack20 = packAttr(attrs(20), level)
    val pack21 = packAttr(attrs(21), level)
    val pack22 = packAttr(attrs(22), level)
    val pack23 = packAttr(attrs(23), level)
    val pack24 = packAttr(attrs(24), level)
    val pack25 = packAttr(attrs(25), level)
    val pack26 = packAttr(attrs(26), level)
    val pack27 = packAttr(attrs(27), level)
    val pack28 = packAttr(attrs(28), level)
    val pack29 = packAttr(attrs(29), level)
    val pack30 = packAttr(attrs(30), level)
    val pack31 = packAttr(attrs(31), level)
    val pack32 = packAttr(attrs(32), level)
    val pack33 = packAttr(attrs(33), level)
    val pack34 = packAttr(attrs(34), level)
    val pack35 = packAttr(attrs(35), level)
    val pack36 = packAttr(attrs(36), level)
    val pack37 = packAttr(attrs(37), level)
    val pack38 = packAttr(attrs(38), level)
    val pack39 = packAttr(attrs(39), level)
    val pack40 = packAttr(attrs(40), level)
    val pack41 = packAttr(attrs(41), level)
    val pack42 = packAttr(attrs(42), level)
    val pack43 = packAttr(attrs(43), level)
    val pack44 = packAttr(attrs(44), level)
    val pack45 = packAttr(attrs(45), level)
    val pack46 = packAttr(attrs(46), level)
    val pack47 = packAttr(attrs(47), level)
    val pack48 = packAttr(attrs(48), level)
    val pack49 = packAttr(attrs(49), level)
    val pack50 = packAttr(attrs(50), level)
    val pack51 = packAttr(attrs(51), level)
    val pack52 = packAttr(attrs(52), level)
    val pack53 = packAttr(attrs(53), level)
    val pack54 = packAttr(attrs(54), level)
    val pack55 = packAttr(attrs(55), level)
    val pack56 = packAttr(attrs(56), level)
    val pack57 = packAttr(attrs(57), level)
    val pack58 = packAttr(attrs(58), level)
    val pack59 = packAttr(attrs(59), level)
    val pack60 = packAttr(attrs(60), level)
    val pack61 = packAttr(attrs(61), level)
    val pack62 = packAttr(attrs(62), level)
    val pack63 = packAttr(attrs(63), level)
    val pack64 = packAttr(attrs(64), level)
    val pack65 = packAttr(attrs(65), level)
    val pack66 = packAttr(attrs(66), level)
    val pack67 = packAttr(attrs(67), level)
    val pack68 = packAttr(attrs(68), level)
    val pack69 = packAttr(attrs(69), level)
    val pack70 = packAttr(attrs(70), level)
    val pack71 = packAttr(attrs(71), level)
    val pack72 = packAttr(attrs(72), level)
    val pack73 = packAttr(attrs(73), level)
    val pack74 = packAttr(attrs(74), level)
    val pack75 = packAttr(attrs(75), level)
    val pack76 = packAttr(attrs(76), level)
    val pack77 = packAttr(attrs(77), level)
    val pack78 = packAttr(attrs(78), level)
    val pack79 = packAttr(attrs(79), level)
    val pack80 = packAttr(attrs(80), level)
    val pack81 = packAttr(attrs(81), level)
    val pack82 = packAttr(attrs(82), level)
    val pack83 = packAttr(attrs(83), level)
    val pack84 = packAttr(attrs(84), level)
    val pack85 = packAttr(attrs(85), level)
    val pack86 = packAttr(attrs(86), level)
    val pack87 = packAttr(attrs(87), level)
    val pack88 = packAttr(attrs(88), level)
    val pack89 = packAttr(attrs(89), level)
    val pack90 = packAttr(attrs(90), level)
    val pack91 = packAttr(attrs(91), level)
    val pack92 = packAttr(attrs(92), level)
    val pack93 = packAttr(attrs(93), level)
    val pack94 = packAttr(attrs(94), level)
    val pack95 = packAttr(attrs(95), level)
    val pack96 = packAttr(attrs(96), level)
    val pack97 = packAttr(attrs(97), level)
    val pack98 = packAttr(attrs(98), level)
    val pack99 = packAttr(attrs(99), level)
    (row: jList[_]) =>
      pack0(row)
      pack1(row)
      pack2(row)
      pack3(row)
      pack4(row)
      pack5(row)
      pack6(row)
      pack7(row)
      pack8(row)
      pack9(row)
      pack10(row)
      pack11(row)
      pack12(row)
      pack13(row)
      pack14(row)
      pack15(row)
      pack16(row)
      pack17(row)
      pack18(row)
      pack19(row)
      pack20(row)
      pack21(row)
      pack22(row)
      pack23(row)
      pack24(row)
      pack25(row)
      pack26(row)
      pack27(row)
      pack28(row)
      pack29(row)
      pack30(row)
      pack31(row)
      pack32(row)
      pack33(row)
      pack34(row)
      pack35(row)
      pack36(row)
      pack37(row)
      pack38(row)
      pack39(row)
      pack40(row)
      pack41(row)
      pack42(row)
      pack43(row)
      pack44(row)
      pack45(row)
      pack46(row)
      pack47(row)
      pack48(row)
      pack49(row)
      pack50(row)
      pack51(row)
      pack52(row)
      pack53(row)
      pack54(row)
      pack55(row)
      pack56(row)
      pack57(row)
      pack58(row)
      pack59(row)
      pack60(row)
      pack61(row)
      pack62(row)
      pack63(row)
      pack64(row)
      pack65(row)
      pack66(row)
      pack67(row)
      pack68(row)
      pack69(row)
      pack70(row)
      pack71(row)
      pack72(row)
      pack73(row)
      pack74(row)
      pack75(row)
      pack76(row)
      pack77(row)
      pack78(row)
      pack79(row)
      pack80(row)
      pack81(row)
      pack82(row)
      pack83(row)
      pack84(row)
      pack85(row)
      pack86(row)
      pack87(row)
      pack88(row)
      pack89(row)
      pack90(row)
      pack91(row)
      pack92(row)
      pack93(row)
      pack94(row)
      pack95(row)
      pack96(row)
      pack97(row)
      pack98(row)
      pack99(row)
  }
}
