/*
 * Decompiled with CFR 0.152.
 */
package breeze.plot;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class ExportGraphics$ {
    public static final ExportGraphics$ MODULE$;

    static {
        new ExportGraphics$();
    }

    public void writeFile(File file, Function1<Graphics2D, BoxedUnit> draw, int width, int height, int dpi) {
        ObjectRef fos$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        if (file.getName().toLowerCase().endsWith(".png")) {
            this.writePNG(this.fos$1(file, fos$lzy, bitmap$0), draw, width, height, dpi);
        }
        if (file.getName().toLowerCase().endsWith(".eps")) {
            this.writeEPS(this.fos$1(file, fos$lzy, bitmap$0), draw, width, height);
        }
        if (file.getName().toLowerCase().endsWith(".pdf")) {
            this.writePDF(this.fos$1(file, fos$lzy, bitmap$0), draw, width, height);
            return;
        }
        throw new IOException("Unrecognized file extension: should be png, svg, eps, or pdf");
        finally {
            this.fos$1(file, fos$lzy, bitmap$0).close();
        }
        finally {
            this.fos$1(file, fos$lzy, bitmap$0).close();
        }
        finally {
            this.fos$1(file, fos$lzy, bitmap$0).close();
        }
    }

    public int writeFile$default$5() {
        return 72;
    }

    public void writePNG(OutputStream out, Function1<Graphics2D, BoxedUnit> draw, int width, int height, int dpi) {
        double scale = (double)dpi / 72.0;
        int swidth = (int)((double)width * scale);
        int sheight = (int)((double)height * scale);
        BufferedImage image = new BufferedImage(swidth, sheight, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.scale(scale, scale);
        draw.apply((Object)g2d);
        g2d.dispose();
        ImageIO.write((RenderedImage)image, "png", out);
    }

    public int writePNG$default$5() {
        return 72;
    }

    public void writeEPS(OutputStream out, Function1<Graphics2D, BoxedUnit> draw, int width, int height) {
        EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
        g2d.setGraphicContext(new GraphicContext());
        g2d.setupDocument(out, width, height);
        draw.apply((Object)g2d);
        g2d.finish();
    }

    public void writePDF(OutputStream out, Function1<Graphics2D, BoxedUnit> draw, int width, int height) {
        Document document = new Document();
        try {
            document.setPageSize(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2d = tp.createGraphics((float)width, (float)height);
            draw.apply((Object)g2d);
            g2d.dispose();
            cb.addTemplate(tp, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            return;
        }
        finally {
            document.close();
        }
    }

    private final FileOutputStream fos$lzycompute$1(File file$1, ObjectRef fos$lzy$1, VolatileByteRef bitmap$0$1) {
        ExportGraphics$ exportGraphics$ = this;
        synchronized (exportGraphics$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                fos$lzy$1.elem = new FileOutputStream(file$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return (FileOutputStream)fos$lzy$1.elem;
        }
    }

    private final FileOutputStream fos$1(File file$1, ObjectRef fos$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.fos$lzycompute$1(file$1, fos$lzy$1, bitmap$0$1) : (FileOutputStream)fos$lzy$1.elem;
    }

    private ExportGraphics$() {
        MODULE$ = this;
    }
}

