/*
 * Decompiled with CFR 0.152.
 */
package breeze.plot;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.ps.EPSDocumentGraphics2D;
import scala.Function1;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;

public final class ExportGraphics$ {
    public static ExportGraphics$ MODULE$;

    static {
        new ExportGraphics$();
    }

    public void writeFile(File file, Function1<Graphics2D, BoxedUnit> draw, int width, int height, int dpi) {
        LazyRef fos$lzy = new LazyRef();
        if (file.getName().toLowerCase().endsWith(".png")) {
            try {
                FileOutputStream writePNG_out = ExportGraphics$.fos$1(fos$lzy, file);
                double writePNG_scale = (double)dpi / 72.0;
                int writePNG_swidth = (int)((double)width * writePNG_scale);
                int writePNG_sheight = (int)((double)height * writePNG_scale);
                BufferedImage writePNG_image = new BufferedImage(writePNG_swidth, writePNG_sheight, 2);
                Graphics2D writePNG_g2d = writePNG_image.createGraphics();
                writePNG_g2d.scale(writePNG_scale, writePNG_scale);
                draw.apply((Object)writePNG_g2d);
                writePNG_g2d.dispose();
                ImageIO.write((RenderedImage)writePNG_image, "png", writePNG_out);
            }
            finally {
                ExportGraphics$.fos$1(fos$lzy, file).close();
            }
            return;
        }
        if (file.getName().toLowerCase().endsWith(".eps")) {
            try {
                FileOutputStream writeEPS_out = ExportGraphics$.fos$1(fos$lzy, file);
                EPSDocumentGraphics2D writeEPS_g2d = new EPSDocumentGraphics2D(false);
                writeEPS_g2d.setGraphicContext(new GraphicContext());
                writeEPS_g2d.setupDocument((OutputStream)writeEPS_out, width, height);
                draw.apply((Object)writeEPS_g2d);
                writeEPS_g2d.finish();
            }
            finally {
                ExportGraphics$.fos$1(fos$lzy, file).close();
            }
            return;
        }
        if (file.getName().toLowerCase().endsWith(".pdf")) {
            try {
                FileOutputStream writePDF_out = ExportGraphics$.fos$1(fos$lzy, file);
                try (Document writePDF_document = new Document();){
                    writePDF_document.setPageSize(new Rectangle((float)width, (float)height));
                    PdfWriter writePDF_writer = PdfWriter.getInstance((Document)writePDF_document, (OutputStream)writePDF_out);
                    writePDF_document.open();
                    PdfContentByte writePDF_cb = writePDF_writer.getDirectContent();
                    PdfTemplate writePDF_tp = writePDF_cb.createTemplate((float)width, (float)height);
                    Graphics2D writePDF_g2d = writePDF_tp.createGraphics((float)width, (float)height);
                    draw.apply((Object)writePDF_g2d);
                    writePDF_g2d.dispose();
                    writePDF_cb.addTemplate(writePDF_tp, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                }
            }
            finally {
                ExportGraphics$.fos$1(fos$lzy, file).close();
            }
            return;
        }
        throw new IOException("Unrecognized file extension: should be png, svg, eps, or pdf");
    }

    public int writeFile$default$5() {
        return 72;
    }

    public void writePNG(OutputStream out, Function1<Graphics2D, BoxedUnit> draw, int width, int height, int dpi) {
        double scale = (double)dpi / 72.0;
        int swidth = (int)((double)width * scale);
        int sheight = (int)((double)height * scale);
        BufferedImage image = new BufferedImage(swidth, sheight, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.scale(scale, scale);
        draw.apply((Object)g2d);
        g2d.dispose();
        ImageIO.write((RenderedImage)image, "png", out);
    }

    public int writePNG$default$5() {
        return 72;
    }

    public void writeEPS(OutputStream out, Function1<Graphics2D, BoxedUnit> draw, int width, int height) {
        EPSDocumentGraphics2D g2d = new EPSDocumentGraphics2D(false);
        g2d.setGraphicContext(new GraphicContext());
        g2d.setupDocument(out, width, height);
        draw.apply((Object)g2d);
        g2d.finish();
    }

    public void writePDF(OutputStream out, Function1<Graphics2D, BoxedUnit> draw, int width, int height) {
        try (Document document = new Document();){
            document.setPageSize(new Rectangle((float)width, (float)height));
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)out);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            Graphics2D g2d = tp.createGraphics((float)width, (float)height);
            draw.apply((Object)g2d);
            g2d.dispose();
            cb.addTemplate(tp, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    private static final /* synthetic */ FileOutputStream fos$lzycompute$1(LazyRef fos$lzy$1, File file$1) {
        synchronized (fos$lzy$1) {
            FileOutputStream fileOutputStream = fos$lzy$1.initialized() ? (FileOutputStream)fos$lzy$1.value() : (FileOutputStream)fos$lzy$1.initialize((Object)new FileOutputStream(file$1));
            return fileOutputStream;
        }
    }

    private static final FileOutputStream fos$1(LazyRef fos$lzy$1, File file$1) {
        if (fos$lzy$1.initialized()) {
            return (FileOutputStream)fos$lzy$1.value();
        }
        return ExportGraphics$.fos$lzycompute$1(fos$lzy$1, file$1);
    }

    private ExportGraphics$() {
        MODULE$ = this;
    }
}

