/*
 * Decompiled with CFR 0.152.
 */
package breeze.interpolation;

import breeze.interpolation.package;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.math.Field$fieldDouble$;
import breeze.storage.Zero;
import breeze.storage.Zero$DoubleZero$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u000f\t\t2)\u001e2jG&sG/\u001a:q_2\fGo\u001c:\u000b\u0005\r!\u0011!D5oi\u0016\u0014\bo\u001c7bi&|gNC\u0001\u0006\u0003\u0019\u0011'/Z3{K\u000e\u00011C\u0001\u0001\t!\rIQ\u0002\u0005\b\u0003\u0015-i\u0011AA\u0005\u0003\u0019\t\tq\u0001]1dW\u0006<W-\u0003\u0002\u000f\u001f\tY\u0002*\u00198esVs\u0017N^1sS\u0006$X-\u00138uKJ\u0004x\u000e\\1u_JT!\u0001\u0004\u0002\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0011{WO\u00197f\u0011!9\u0002A!A!\u0002\u0013A\u0012\u0001\u0003=`G>|'\u000fZ:\u0011\u0007ea\u0002#D\u0001\u001b\u0015\tYB!\u0001\u0004mS:\fGnZ\u0005\u0003;i\u0011aAV3di>\u0014\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011\u0002\r\u0002\u0011e|6m\\8sINDQ!\t\u0001\u0005\u0002\t\na\u0001P5oSRtDcA\u0012%KA\u0011!\u0002\u0001\u0005\u0006/\u0001\u0002\r\u0001\u0007\u0005\u0006?\u0001\u0002\r\u0001\u0007\u0005\u0006O\u0001!I\u0001K\u0001\u0002QR\u0011\u0001#\u000b\u0005\u0006U\u0019\u0002\raK\u0001\u0002WB\u0011\u0011\u0003L\u0005\u0003[I\u00111!\u00138u\u0011\u0015y\u0003\u0001\"\u00031\u0003\u0005!GC\u0001\t2\u0011\u0015Qc\u00061\u0001,\u0011\u0015\u0019\u0004\u0001\"\u00035\u0003\u0019a\u0017-\u001c2eCR\u0011\u0001#\u000e\u0005\u0006UI\u0002\ra\u000b\u0005\u0006o\u0001!I\u0001O\u0001\u0003e>$\"\u0001E\u001d\t\u000b)2\u0004\u0019A\u0016\t\u000fm\u0002!\u0019!C\u0005y\u0005\tQ*F\u0001>!\rIb\bE\u0005\u0003\u007fi\u00111\u0002R3og\u0016l\u0015\r\u001e:jq\"1\u0011\t\u0001Q\u0001\nu\n!!\u0014\u0011\t\u000f\r\u0003!\u0019!C\u0005\t\u0006\t!-F\u0001F!\rIb\tE\u0005\u0003\u000fj\u00111\u0002R3og\u00164Vm\u0019;pe\"1\u0011\n\u0001Q\u0001\n\u0015\u000b!A\u0019\u0011\t\u000f-\u0003!\u0019!C\u0005\t\u0006\u0011Q\u000e\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B#\u0002\u00075\u0004\b\u0005C\u0003P\u0001\u0011%\u0001+A\u0001n)\t\u0001\u0012\u000bC\u0003S\u001d\u0002\u00071&A\u0001j\u0011\u001d!\u0006A1A\u0005\nq\n\u0011!\u0011\u0005\u0007-\u0002\u0001\u000b\u0011B\u001f\u0002\u0005\u0005\u0003\u0003\"\u0002-\u0001\t#J\u0016aC5oi\u0016\u0014\bo\u001c7bi\u0016$\"\u0001\u0005.\t\u000bm;\u0006\u0019\u0001\t\u0002\u0003a<Q!\u0018\u0002\t\u0002y\u000b\u0011cQ;cS\u000eLe\u000e^3sa>d\u0017\r^8s!\tQqLB\u0003\u0002\u0005!\u0005\u0001m\u0005\u0002`CB\u0011\u0011CY\u0005\u0003GJ\u0011a!\u00118z%\u00164\u0007\"B\u0011`\t\u0003)G#\u00010\t\u000b\u001d|F\u0011\u00015\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\rJ'\u000eC\u0003\u0018M\u0002\u0007\u0001\u0004C\u0003 M\u0002\u0007\u0001\u0004")
public class CubicInterpolator
extends package.HandyUnivariateInterpolator<Object> {
    private final DenseMatrix<Object> M;
    private final DenseVector<Object> b;
    private final DenseVector<Object> mp;
    private final DenseMatrix<Object> A;

    private double h(int k) {
        return ((double[])this.X())[k + 1] - ((double[])this.X())[k];
    }

    private double d(int k) {
        return (((double[])this.Y())[k + 1] - ((double[])this.Y())[k]) / this.h(k);
    }

    private double lambda(int k) {
        return this.h(k) / (this.h(k - 1) + this.h(k));
    }

    private double ro(int k) {
        return 1.0 - this.lambda(k);
    }

    private DenseMatrix<Object> M() {
        return this.M;
    }

    private DenseVector<Object> b() {
        return this.b;
    }

    private DenseVector<Object> mp() {
        return this.mp;
    }

    private double m(int i) {
        double d;
        int n = i;
        switch (n) {
            case 0: {
                d = 0.0;
                break;
            }
            default: {
                if (n == ((double[])this.X()).length - 1) {
                    d = 0.0;
                    break;
                }
                d = this.mp().apply$mcD$sp(n - 1);
                break;
            }
        }
        return d;
    }

    private DenseMatrix<Object> A() {
        return this.A;
    }

    @Override
    public double interpolate(double x) {
        double d;
        int index = this.bisearch(BoxesRunTime.boxToDouble((double)x)) - 1;
        if (index == -1) {
            d = ((double[])this.Y())[0];
        } else {
            double dx = x - ((double[])this.X())[index];
            d = this.A().apply$mcD$sp(index, 0) + this.A().apply$mcD$sp(index, 1) * dx + this.A().apply$mcD$sp(index, 2) * dx * dx + this.A().apply$mcD$sp(index, 3) * dx * dx * dx;
        }
        return d;
    }

    public CubicInterpolator(Vector<Object> x_coords, Vector<Object> y_coords) {
        super(x_coords, y_coords, ClassTag$.MODULE$.Double(), Field$fieldDouble$.MODULE$, Ordering.Double$.MODULE$);
        if (((double[])this.X()).length < 3) {
            throw new Exception("You must provide at least 3 points for CubicInterpolator.");
        }
        this.M = (DenseMatrix)DenseMatrix$.MODULE$.tabulate$mDc$sp(((double[])this.X()).length - 2, ((double[])this.X()).length - 2, (Function2)(JFunction2.mcDII.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$1, x1$1);
            if (sp2 != null) {
                int i = sp2._1$mcI$sp();
                int j = sp2._2$mcI$sp();
                if (j - i == -1) {
                    return this.ro(i + 1);
                }
            }
            if (sp2 != null) {
                int i = sp2._1$mcI$sp();
                int j = sp2._2$mcI$sp();
                if (j == i) {
                    return 2.0;
                }
            }
            if (sp2 == null) return 0.0;
            int i = sp2._1$mcI$sp();
            int j = sp2._2$mcI$sp();
            if (j - i != 1) return 0.0;
            return this.lambda(i + 1);
        }, ClassTag$.MODULE$.Double(), (Zero)Zero$DoubleZero$.MODULE$);
        this.b = DenseVector$.MODULE$.tabulate$mDc$sp(((double[])this.X()).length - 2, (Function1<Object, Object>)(JFunction1.mcDI.sp & Serializable & scala.Serializable)x0$2 -> {
            int n = x0$2;
            double d = (double)6 * (this.d(n + 1) - this.d(n)) / (this.h(n) + this.h(n + 1));
            return d;
        }, (ClassTag<Object>)ClassTag$.MODULE$.Double());
        this.mp = this.M().$bslash(this.b(), DenseMatrix$.MODULE$.implOpSolveMatrixBy_DMD_DVD_eq_DVD());
        this.A = (DenseMatrix)DenseMatrix$.MODULE$.tabulate$mDc$sp(((double[])this.X()).length - 1, 4, (Function2)(JFunction2.mcDII.sp & Serializable & scala.Serializable)(x0$3, x1$2) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$3, x1$2);
            if (sp2 != null) {
                int k = sp2._1$mcI$sp();
                int n = sp2._2$mcI$sp();
                if (0 == n) {
                    return ((double[])this.Y())[k];
                }
            }
            if (sp2 != null) {
                int k = sp2._1$mcI$sp();
                int n = sp2._2$mcI$sp();
                if (1 == n) {
                    return this.d(k) - this.h(k) / (double)6 * ((double)2 * this.m(k) + this.m(k + 1));
                }
            }
            if (sp2 != null) {
                int k = sp2._1$mcI$sp();
                int n = sp2._2$mcI$sp();
                if (2 == n) {
                    return this.m(k) / (double)2;
                }
            }
            if (sp2 != null) {
                int k = sp2._1$mcI$sp();
                int n = sp2._2$mcI$sp();
                if (3 == n) {
                    return (this.m(k + 1) - this.m(k)) / (double)6 / this.h(k);
                }
            }
            Predef$.MODULE$.assert(false, (Function0 & Serializable & scala.Serializable)() -> "unreachable");
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }, ClassTag$.MODULE$.Double(), (Zero)Zero$DoubleZero$.MODULE$);
    }
}

