/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.NumericOps;
import breeze.linalg.QuasiTensor;
import breeze.linalg.Tensor;
import breeze.linalg.TensorLike;
import breeze.linalg.norm$;
import breeze.linalg.operators.OpSub$;
import breeze.linalg.support.CanCopy;
import breeze.optimize.DiffFunction;
import breeze.stats.distributions.Rand$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import java.io.Serializable;
import scala.;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class GradientTester$
implements SerializableLogging,
Serializable {
    private static volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;
    public static final GradientTester$ MODULE$;

    private GradientTester$() {
    }

    static {
        MODULE$ = new GradientTester$();
        SerializableLogging.$init$(MODULE$);
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GradientTester$.class);
    }

    public <K, T> T test(DiffFunction<T> f, T x, double randFraction, boolean skipZeros, double epsilon, double tolerance, Function1<K, String> toString, .less.colon.less<T, NumericOps<T>> view2, .less.colon.less<T, Tensor<K, Object>> view, CanCopy<T> copy, UFunc.UImpl<norm$, T, Object> canNorm, UFunc.UImpl2<OpSub$, T, T, T> opSub) {
        IndexedSeq indices = Rand$.MODULE$.subsetsOfSize(((QuasiTensor)view.apply(x)).keysIterator().toIndexedSeq(), (int)((double)((TensorLike)view.apply(x)).size() * randFraction + 1.0)).draw();
        return this.testIndices(f, x, (Iterable<K>)indices, skipZeros, toString, epsilon, tolerance, view2, view, copy, canNorm, opSub);
    }

    public double test$default$3() {
        return 0.01;
    }

    public boolean test$default$4() {
        return false;
    }

    public double test$default$5() {
        return 1.0E-8;
    }

    public double test$default$6() {
        return 0.001;
    }

    public <K, T> Function1<K, String> test$default$7() {
        return (Function1 & Serializable)_$1 -> _$1.toString();
    }

    public <T, K> T testIndices(DiffFunction<T> f, T x, Iterable<K> indices, boolean skipZeros, Function1<K, String> toString, double epsilon, double tolerance, .less.colon.less<T, NumericOps<T>> view2, .less.colon.less<T, Tensor<K, Object>> view, CanCopy<T> copy, UFunc.UImpl<norm$, T, Object> canNorm, UFunc.UImpl2<OpSub$, T, T, T> opSub) {
        Tuple2<Object, T> tuple2 = f.calculate(x);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double fx = BoxesRunTime.unboxToDouble((Object)tuple2._1());
        Object trueGrad = tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)fx), trueGrad);
        double fx2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
        Object trueGrad2 = tuple22._2();
        Object xx = copy.apply(x);
        Object differences = opSub.apply(x, x);
        IntRef ok = IntRef.create((int)0);
        IntRef tried = IntRef.create((int)0);
        int sz = indices.size();
        indices.foreach((Function1)(JProcedure1 & Serializable)k -> {
            if (skipZeros && BoxesRunTime.unboxToDouble(((TensorLike)view.apply(trueGrad2)).apply(k)) == 0.0) {
                this.logger().debug(() -> this.testIndices$$anonfun$2$$anonfun$1(toString, k));
                Predef$.MODULE$.print((Object)((String)toString.apply(k) + " "));
            } else {
                int n;
                Tensor tensor = (Tensor)view.apply(xx);
                tensor.update(k, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(tensor.apply(k)) + epsilon)));
                double grad = (f.apply(xx) - fx2) / epsilon;
                Tensor tensor2 = (Tensor)view.apply(xx);
                tensor2.update(k, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(tensor2.apply(k)) - epsilon)));
                double relDif = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(grad - BoxesRunTime.unboxToDouble(((TensorLike)view.apply(trueGrad2)).apply(k)))) / RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(package$.MODULE$.max(RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(BoxesRunTime.unboxToDouble(((TensorLike)view.apply(trueGrad2)).apply(k)))), RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(grad)))), 1.0E-4);
                if (relDif < tolerance) {
                    int n2;
                    ok$1.elem = n2 = ok$1.elem + 1;
                    this.logger().debug(() -> this.testIndices$$anonfun$3$$anonfun$2(toString, k, relDif));
                } else {
                    this.logger().warn(() -> this.testIndices$$anonfun$4$$anonfun$3(toString, epsilon, view, trueGrad2, k, grad, relDif));
                }
                ((TensorLike)view.apply(differences)).update(k, BoxesRunTime.boxToDouble((double)relDif));
                tried$1.elem = n = tried$1.elem + 1;
            }
            if (tried$1.elem % 100 == 0 || tried$1.elem == sz) {
                this.logger().info(() -> this.testIndices$$anonfun$5$$anonfun$4(x, view, ok, tried, sz));
            }
        });
        return differences;
    }

    public boolean testIndices$default$4() {
        return false;
    }

    public <T, K> Function1<K, String> testIndices$default$5() {
        return (Function1 & Serializable)_$2 -> _$2.toString();
    }

    public double testIndices$default$6() {
        return 1.0E-8;
    }

    public double testIndices$default$7() {
        return 0.001;
    }

    private final String testIndices$$anonfun$2$$anonfun$1(Function1 toString$2, Object k$1) {
        return "Zero Grad: " + toString$2.apply(k$1);
    }

    private final String testIndices$$anonfun$3$$anonfun$2(Function1 toString$3, Object k$2, double relDif$1) {
        return "OK: " + toString$3.apply(k$2) + " " + relDif$1;
    }

    private final String testIndices$$anonfun$4$$anonfun$3(Function1 toString$4, double epsilon$2, .less.colon.less view$2, Object trueGrad$2, Object k$3, double grad$1, double relDif$2) {
        return (String)toString$4.apply(k$3) + StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(" relDif: %.3e [eps : %e, calculated: %4.3e empirical: %4.3e]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)relDif$2), BoxesRunTime.boxToDouble((double)epsilon$2), ((TensorLike)view$2.apply(trueGrad$2)).apply(k$3), BoxesRunTime.boxToDouble((double)grad$1)}));
    }

    private final String testIndices$$anonfun$5$$anonfun$4(Object x$2, .less.colon.less view$3, IntRef ok$2, IntRef tried$2, int sz$2) {
        return StringOps$.MODULE$.format$extension("Checked %s of %s (out of dimension %s). %.4g%% ok.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)tried$2.elem), BoxesRunTime.boxToInteger((int)sz$2), BoxesRunTime.boxToInteger((int)((TensorLike)view$3.apply(x$2)).size()), BoxesRunTime.boxToDouble((double)((double)ok$2.elem * 100.0 / (double)tried$2.elem))}));
    }
}

