/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.linear;

import breeze.linalg.DenseVector;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import breeze.optimize.linear.LinearProgram$;
import breeze.optimize.linear.LinearProgram$Binary$;
import breeze.optimize.linear.LinearProgram$EQ$;
import breeze.optimize.linear.LinearProgram$GTE$;
import breeze.optimize.linear.LinearProgram$Integer$;
import breeze.optimize.linear.LinearProgram$LTE$;
import breeze.optimize.linear.LinearProgram$Real$;
import breeze.optimize.linear.LinearProgram$Result$;
import breeze.storage.Zero$;
import java.io.Serializable;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinearProgram {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(LinearProgram.class, "0bitmap$1");
    public long 0bitmap$1;
    private int _nextId = 0;
    private final ArrayBuffer variables;
    public LinearProgram$LTE$ LTE$lzy1;
    public LinearProgram$GTE$ GTE$lzy1;
    public LinearProgram$EQ$ EQ$lzy1;
    public final LinearProgram$Real$ Real$lzy1 = new LinearProgram$Real$(this);
    public final LinearProgram$Integer$ Integer$lzy1 = new LinearProgram$Integer$(this);
    public final LinearProgram$Binary$ Binary$lzy1 = new LinearProgram$Binary$(this);
    public final LinearProgram$Result$ Result$lzy1 = new LinearProgram$Result$(this);

    public static Solver mySolver() {
        return LinearProgram$.MODULE$.mySolver();
    }

    public LinearProgram() {
        this.variables = new ArrayBuffer();
    }

    public int breeze$optimize$linear$LinearProgram$$nextId() {
        ++this._nextId;
        return this._nextId - 1;
    }

    public ArrayBuffer<Variable> breeze$optimize$linear$LinearProgram$$variables() {
        return this.variables;
    }

    public Problem minimize(Expression expression) {
        return new Problem(expression, this){
            private final Expression expression$1;
            private final LinearProgram $outer;
            {
                this.expression$1 = expression$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Option goal() {
                return Option$.MODULE$.apply((Object)GoalType.MINIMIZE);
            }

            public Expression objective() {
                return this.expression$1.objective();
            }

            public IndexedSeq constraints() {
                return this.expression$1.constraints();
            }

            public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                return this.$outer;
            }
        };
    }

    public Problem maximize(Expression expression) {
        return new Problem(expression, this){
            private final Expression expression$1;
            private final LinearProgram $outer;
            {
                this.expression$1 = expression$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Option goal() {
                return Option$.MODULE$.apply((Object)GoalType.MAXIMIZE);
            }

            public Expression objective() {
                return this.expression$1.objective();
            }

            public IndexedSeq constraints() {
                return this.expression$1.constraints();
            }

            public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                return this.$outer;
            }
        };
    }

    public final LinearProgram$LTE$ LTE() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    LinearProgram$LTE$ linearProgram$LTE$;
                    this.LTE$lzy1 = linearProgram$LTE$ = new LinearProgram$LTE$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return linearProgram$LTE$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.LTE$lzy1;
    }

    public final LinearProgram$GTE$ GTE() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    LinearProgram$GTE$ linearProgram$GTE$;
                    this.GTE$lzy1 = linearProgram$GTE$ = new LinearProgram$GTE$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return linearProgram$GTE$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.GTE$lzy1;
    }

    public final LinearProgram$EQ$ EQ() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 2)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 2)) continue;
                try {
                    LinearProgram$EQ$ linearProgram$EQ$;
                    this.EQ$lzy1 = linearProgram$EQ$ = new LinearProgram$EQ$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 2);
                    return linearProgram$EQ$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 2);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 2);
        }
        return this.EQ$lzy1;
    }

    public final LinearProgram$Real$ Real() {
        return this.Real$lzy1;
    }

    public final LinearProgram$Integer$ Integer() {
        return this.Integer$lzy1;
    }

    public final LinearProgram$Binary$ Binary() {
        return this.Binary$lzy1;
    }

    public final LinearProgram$Result$ Result() {
        return this.Result$lzy1;
    }

    public Result maximize(Problem objective, Solver solver) {
        Predef$.MODULE$.assume(!objective.goal().contains((Object)GoalType.MINIMIZE), LinearProgram::maximize$$anonfun$1);
        return solver.maximize(this, objective);
    }

    public Result minimize(Problem objective, Solver solver) {
        Predef$.MODULE$.assume(!objective.goal().contains((Object)GoalType.MAXIMIZE), LinearProgram::minimize$$anonfun$1);
        return solver.minimize(this, objective);
    }

    public static final GoalType breeze$optimize$linear$LinearProgram$Problem$$_$_$$anonfun$1() {
        throw new IllegalArgumentException("Goal is not defined.");
    }

    private static final String maximize$$anonfun$1() {
        return "Cannot call maximize on a minimization problem";
    }

    private static final String minimize$$anonfun$1() {
        return "Cannot call minimize on a maximization problem";
    }

    public class Binary
    implements Problem,
    Expression,
    Variable,
    Product,
    Serializable {
        private final String name;
        private final int id;
        private final LinearProgram $outer;

        public Binary(LinearProgram $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.id = $outer.breeze$optimize$linear$LinearProgram$$variables().length();
            $outer.breeze$optimize$linear$LinearProgram$$variables().$plus$eq((Object)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Binary)) return false;
            if (((Binary)object).breeze$optimize$linear$LinearProgram$Binary$$$outer() != this.$outer) return false;
            Binary binary = (Binary)object;
            String string = this.name();
            String string2 = binary.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!binary.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Binary;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Binary";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "name";
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int id() {
            return this.id;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Vector<Object> coefficients() {
            void var1_1;
            SparseVector<Object> v = SparseVector$.MODULE$.zeros(this.$outer.breeze$optimize$linear$LinearProgram$$variables().length(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> v.update(this.id() + i, (Object)BoxesRunTime.boxToDouble((double)1.0)));
            return var1_1;
        }

        public Binary copy(String name) {
            return new Binary(this.$outer, name);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String _1() {
            return this.name();
        }

        public final LinearProgram breeze$optimize$linear$LinearProgram$Binary$$$outer() {
            return this.$outer;
        }

        @Override
        public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
            return this.$outer;
        }

        @Override
        public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
            return this.$outer;
        }

        @Override
        public final LinearProgram breeze$optimize$linear$LinearProgram$Variable$$$outer() {
            return this.$outer;
        }
    }

    public interface Constraint {
        public Expression lhs();

        public Expression rhs();

        public Relation relation();

        public static String toString$(Constraint $this) {
            return $this.toString();
        }

        default public String toString() {
            return "" + this.lhs() + " " + this.relation().operator() + " " + this.rhs();
        }

        public static Constraint standardize$(Constraint $this) {
            return $this.standardize();
        }

        default public Constraint standardize() {
            return new Constraint(this){
                private final Constraint $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Relation relation() {
                    return this.$outer.relation();
                }

                public Expression lhs() {
                    return new Problem(this){
                        private final $anon$17 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public Vector coefficients() {
                            return (Vector)this.$outer.breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer().lhs().coefficients().$minus(this.$outer.breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer().rhs().coefficients(), HasOps$.MODULE$.impl_Op_V_V_eq_V_idempotent_Double_OpSub());
                        }

                        public double scalarComponent() {
                            return 0.0;
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Constraint$$$outer();
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Constraint$$$outer();
                        }
                    };
                }

                public Expression rhs() {
                    return new Problem(this){
                        private final $anon$17 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public Vector coefficients() {
                            return SparseVector$.MODULE$.zeros(this.$outer.breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Constraint$$$outer().breeze$optimize$linear$LinearProgram$$variables().length(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
                        }

                        public double scalarComponent() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer().rhs().scalarComponent() - this.$outer.breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer().lhs().scalarComponent();
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Constraint$$$outer();
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Constraint$$$outer();
                        }
                    };
                }

                public final Constraint breeze$optimize$linear$LinearProgram$Constraint$_$$anon$$$outer() {
                    return this.$outer;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Constraint$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Constraint$$$outer();
                }
            };
        }

        public LinearProgram breeze$optimize$linear$LinearProgram$Constraint$$$outer();
    }

    public interface Expression
    extends Problem {
        public Vector<Object> coefficients();

        public static double scalarComponent$(Expression $this) {
            return $this.scalarComponent();
        }

        default public double scalarComponent() {
            return 0.0;
        }

        public static Expression objective$(Expression $this) {
            return $this.objective();
        }

        @Override
        default public Expression objective() {
            return this;
        }

        public static IndexedSeq constraints$(Expression $this) {
            return $this.constraints();
        }

        @Override
        default public IndexedSeq<Constraint> constraints() {
            return (IndexedSeq)package$.MODULE$.IndexedSeq().empty();
        }

        public static Expression $plus$(Expression $this, Expression other) {
            return $this.$plus(other);
        }

        default public Expression $plus(Expression other) {
            return new Problem(other, this){
                private final Expression other$1;
                private final Expression $outer;
                {
                    this.other$1 = other$5;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Vector coefficients() {
                    return (Vector)this.$outer.coefficients().$plus(this.other$1.coefficients(), HasOps$.MODULE$.impl_Op_V_V_eq_V_idempotent_Double_OpAdd());
                }

                public double scalarComponent() {
                    return this.$outer.scalarComponent() + this.other$1.scalarComponent();
                }

                public String toString() {
                    return this.$outer.toString() + " + " + this.other$1;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Expression $plus$(Expression $this, double other) {
            return $this.$plus(other);
        }

        default public Expression $plus(double other) {
            return new Problem(other, this){
                private final double other$1;
                private final Expression $outer;
                {
                    this.other$1 = other$6;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Vector coefficients() {
                    return this.$outer.coefficients();
                }

                public double scalarComponent() {
                    return this.$outer.scalarComponent() + this.other$1;
                }

                public String toString() {
                    return this.$outer.toString() + " + " + this.other$1;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Expression $minus$(Expression $this, Expression other) {
            return $this.$minus(other);
        }

        default public Expression $minus(Expression other) {
            return new Problem(other, this){
                private final Expression other$1;
                private final Expression $outer;
                {
                    this.other$1 = other$7;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Vector coefficients() {
                    return (Vector)this.$outer.coefficients().$minus(this.other$1.coefficients(), HasOps$.MODULE$.impl_Op_V_V_eq_V_idempotent_Double_OpSub());
                }

                public double scalarComponent() {
                    return this.$outer.scalarComponent() - this.other$1.scalarComponent();
                }

                public String toString() {
                    return this.$outer.toString() + " - " + this.other$1;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Expression $minus$(Expression $this, double other) {
            return $this.$minus(other);
        }

        default public Expression $minus(double other) {
            return new Problem(other, this){
                private final double other$1;
                private final Expression $outer;
                {
                    this.other$1 = other$8;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Vector coefficients() {
                    return this.$outer.coefficients();
                }

                public double scalarComponent() {
                    return this.$outer.scalarComponent() - this.other$1;
                }

                public String toString() {
                    return this.$outer.toString() + " - " + this.other$1;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Expression unary_$minus$(Expression $this) {
            return $this.unary_$minus();
        }

        default public Expression unary_$minus() {
            return new Problem(this){
                private final Expression $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Vector coefficients() {
                    return (Vector)this.$outer.coefficients().$times(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix());
                }

                public double scalarComponent() {
                    return -this.$outer.scalarComponent();
                }

                public String toString() {
                    return "-(" + this.$outer + ")";
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Constraint $less$eq$(Expression $this, Expression rhs_) {
            return $this.$less$eq(rhs_);
        }

        default public Constraint $less$eq(Expression rhs_) {
            return new Constraint(rhs_, this){
                private final Expression rhs_$1;
                private final Expression $outer;
                {
                    this.rhs_$1 = rhs_$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Relation relation() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer().LTE();
                }

                public Expression lhs() {
                    return this.$outer;
                }

                public Expression rhs() {
                    return this.rhs_$1;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Constraint$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Constraint $less$eq$(Expression $this, double c) {
            return $this.$less$eq(c);
        }

        default public Constraint $less$eq(double c) {
            return new Constraint(c, this){
                public final double breeze$optimize$linear$LinearProgram$$anon$10$$c$1;
                private final Expression $outer;
                {
                    this.breeze$optimize$linear$LinearProgram$$anon$10$$c$1 = c$6;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Relation relation() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer().LTE();
                }

                public Expression lhs() {
                    return this.$outer;
                }

                public Expression rhs() {
                    return new Problem(this){
                        private final $anon$10 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public Vector coefficients() {
                            return SparseVector$.MODULE$.zeros(this.$outer.breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Expression$$$outer().breeze$optimize$linear$LinearProgram$$variables().length(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
                        }

                        public double scalarComponent() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$$anon$10$$c$1;
                        }

                        public String toString() {
                            return BoxesRunTime.boxToDouble((double)this.$outer.breeze$optimize$linear$LinearProgram$$anon$10$$c$1).toString();
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Expression$$$outer();
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Expression$$$outer();
                        }
                    };
                }

                public final Expression breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer() {
                    return this.$outer;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Constraint$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Constraint $greater$eq$(Expression $this, Expression rhs_) {
            return $this.$greater$eq(rhs_);
        }

        default public Constraint $greater$eq(Expression rhs_) {
            return new Constraint(rhs_, this){
                private final Expression rhs_$1;
                private final Expression $outer;
                {
                    this.rhs_$1 = rhs_$5;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Relation relation() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer().GTE();
                }

                public Expression lhs() {
                    return this.$outer;
                }

                public Expression rhs() {
                    return this.rhs_$1;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Constraint$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Constraint $greater$eq$(Expression $this, double c) {
            return $this.$greater$eq(c);
        }

        default public Constraint $greater$eq(double c) {
            return new Constraint(c, this){
                public final double breeze$optimize$linear$LinearProgram$$anon$12$$c$1;
                private final Expression $outer;
                {
                    this.breeze$optimize$linear$LinearProgram$$anon$12$$c$1 = c$7;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Relation relation() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer().GTE();
                }

                public Expression lhs() {
                    return this.$outer;
                }

                public Expression rhs() {
                    return new Problem(this){
                        private final $anon$12 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public Vector coefficients() {
                            return SparseVector$.MODULE$.zeros(this.$outer.breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Expression$$$outer().breeze$optimize$linear$LinearProgram$$variables().length(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
                        }

                        public double scalarComponent() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$$anon$12$$c$1;
                        }

                        public String toString() {
                            return BoxesRunTime.boxToDouble((double)this.$outer.breeze$optimize$linear$LinearProgram$$anon$12$$c$1).toString();
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Expression$$$outer();
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Expression$$$outer();
                        }
                    };
                }

                public final Expression breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer() {
                    return this.$outer;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Constraint$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Constraint $eq$colon$eq$(Expression $this, Expression rhs_) {
            return $this.$eq$colon$eq(rhs_);
        }

        default public Constraint $eq$colon$eq(Expression rhs_) {
            return new Constraint(rhs_, this){
                private final Expression rhs_$1;
                private final Expression $outer;
                {
                    this.rhs_$1 = rhs_$6;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Relation relation() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer().EQ();
                }

                public Expression lhs() {
                    return this.$outer;
                }

                public Expression rhs() {
                    return this.rhs_$1;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Constraint$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Constraint $eq$colon$eq$(Expression $this, double c) {
            return $this.$eq$colon$eq(c);
        }

        default public Constraint $eq$colon$eq(double c) {
            return new Constraint(c, this){
                public final double breeze$optimize$linear$LinearProgram$$anon$14$$c$1;
                private final Expression $outer;
                {
                    this.breeze$optimize$linear$LinearProgram$$anon$14$$c$1 = c$8;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Relation relation() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer().EQ();
                }

                public Expression lhs() {
                    return this.$outer;
                }

                public Expression rhs() {
                    return new Problem(this){
                        private final $anon$14 $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public Vector coefficients() {
                            return SparseVector$.MODULE$.zeros(this.$outer.breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Expression$$$outer().breeze$optimize$linear$LinearProgram$$variables().length(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
                        }

                        public double scalarComponent() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$$anon$14$$c$1;
                        }

                        public String toString() {
                            return BoxesRunTime.boxToDouble((double)this.$outer.breeze$optimize$linear$LinearProgram$$anon$14$$c$1).toString();
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Expression$$$outer();
                        }

                        public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                            return this.$outer.breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer().breeze$optimize$linear$LinearProgram$Expression$$$outer();
                        }
                    };
                }

                public final Expression breeze$optimize$linear$LinearProgram$Expression$_$$anon$$$outer() {
                    return this.$outer;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Constraint$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Expression $times$(Expression $this, double c) {
            return $this.$times(c);
        }

        default public Expression $times(double c) {
            return new Problem(c, this){
                private final double c$1;
                private final Expression $outer;
                {
                    this.c$1 = c$9;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Vector coefficients() {
                    return (Vector)this.$outer.coefficients().$times(BoxesRunTime.boxToDouble((double)this.c$1), HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix());
                }

                public double scalarComponent() {
                    return this.$outer.scalarComponent() * this.c$1;
                }

                public String toString() {
                    return "(" + this.$outer + ") * " + this.c$1;
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public static Expression $times$colon$(Expression $this, double c) {
            return $this.$times$colon(c);
        }

        default public Expression $times$colon(double c) {
            return new Problem(c, this){
                private final double c$1;
                private final Expression $outer;
                {
                    this.c$1 = c$10;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Vector coefficients() {
                    return (Vector)this.$outer.coefficients().$times(BoxesRunTime.boxToDouble((double)this.c$1), HasOps$.MODULE$.impl_Op_V_S_eq_V_Double_OpMulMatrix());
                }

                public double scalarComponent() {
                    return this.$outer.scalarComponent() * this.c$1;
                }

                public String toString() {
                    return "" + this.c$1 + " * (" + this.$outer + ")";
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Expression$$$outer();
                }
            };
        }

        public LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer();
    }

    public class Integer
    implements Problem,
    Expression,
    Variable,
    Product,
    Serializable {
        private final String name;
        private final int id;
        private final LinearProgram $outer;

        public Integer(LinearProgram $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.id = $outer.breeze$optimize$linear$LinearProgram$$variables().length();
            $outer.breeze$optimize$linear$LinearProgram$$variables().$plus$eq((Object)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Integer)) return false;
            if (((Integer)object).breeze$optimize$linear$LinearProgram$Integer$$$outer() != this.$outer) return false;
            Integer integer = (Integer)object;
            String string = this.name();
            String string2 = integer.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!integer.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Integer;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Integer";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "name";
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int id() {
            return this.id;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Vector<Object> coefficients() {
            void var1_1;
            SparseVector<Object> v = SparseVector$.MODULE$.zeros(this.$outer.breeze$optimize$linear$LinearProgram$$variables().length(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> v.update(this.id() + i, (Object)BoxesRunTime.boxToDouble((double)1.0)));
            return var1_1;
        }

        public Integer copy(String name) {
            return new Integer(this.$outer, name);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String _1() {
            return this.name();
        }

        public final LinearProgram breeze$optimize$linear$LinearProgram$Integer$$$outer() {
            return this.$outer;
        }

        @Override
        public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
            return this.$outer;
        }

        @Override
        public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
            return this.$outer;
        }

        @Override
        public final LinearProgram breeze$optimize$linear$LinearProgram$Variable$$$outer() {
            return this.$outer;
        }
    }

    public interface Problem {
        public static Option goal$(Problem $this) {
            return $this.goal();
        }

        default public Option<GoalType> goal() {
            return None$.MODULE$;
        }

        public Expression objective();

        public IndexedSeq<Constraint> constraints();

        public static Problem subjectTo$(Problem $this, Seq constraints) {
            return $this.subjectTo((Seq<Constraint>)constraints);
        }

        default public Problem subjectTo(Seq<Constraint> constraints) {
            Seq<Constraint> cons = constraints;
            return new Problem(cons, this){
                private final Seq cons$1;
                private final Problem $outer;
                {
                    this.cons$1 = cons$2;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public Option goal() {
                    return this.$outer.goal();
                }

                public Expression objective() {
                    return this.$outer.objective();
                }

                public IndexedSeq constraints() {
                    return (IndexedSeq)this.$outer.constraints().$plus$plus((IterableOnce)this.cons$1);
                }

                public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
                    return this.$outer.breeze$optimize$linear$LinearProgram$Problem$$$outer();
                }
            };
        }

        public static Result solve$(Problem $this, Solver solver) {
            return $this.solve(solver);
        }

        default public Result solve(Solver solver) {
            Result result;
            GoalType _goal;
            GoalType goalType = _goal = (GoalType)this.goal().getOrElse(LinearProgram::breeze$optimize$linear$LinearProgram$Problem$$_$_$$anonfun$1);
            GoalType goalType2 = GoalType.MAXIMIZE;
            if (!(goalType != null ? !goalType.equals(goalType2) : goalType2 != null)) {
                result = solver.maximize(this.breeze$optimize$linear$LinearProgram$Problem$$$outer(), this);
            } else {
                GoalType goalType3 = _goal;
                GoalType goalType4 = GoalType.MINIMIZE;
                if (!(goalType3 != null ? !goalType3.equals(goalType4) : goalType4 != null)) {
                    result = solver.minimize(this.breeze$optimize$linear$LinearProgram$Problem$$$outer(), this);
                } else {
                    throw new IllegalArgumentException("Unknown goal " + _goal.name());
                }
            }
            return result;
        }

        public static String toString$(Problem $this) {
            return $this.toString();
        }

        default public String toString() {
            String string;
            Option<GoalType> option = this.goal();
            if (option instanceof Some) {
                GoalType g = (GoalType)((Some)option).value();
                string = g.name().toLowerCase();
            } else {
                string = "problem ";
            }
            String _goal = string;
            String beg = "\nsubject to";
            String sep = "\n          ";
            return "" + _goal + "    " + this.objective() + (this.constraints().nonEmpty() ? this.constraints().mkString(beg, sep, "") : "");
        }

        public LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer();
    }

    public class Real
    implements Problem,
    Expression,
    Variable,
    Product,
    Serializable {
        private final String name;
        private final int id;
        private final LinearProgram $outer;

        public Real(LinearProgram $outer, String name) {
            this.name = name;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.id = $outer.breeze$optimize$linear$LinearProgram$$variables().length();
            $outer.breeze$optimize$linear$LinearProgram$$variables().$plus$eq((Object)this);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Real)) return false;
            if (((Real)object).breeze$optimize$linear$LinearProgram$Real$$$outer() != this.$outer) return false;
            Real real = (Real)object;
            String string = this.name();
            String string2 = real.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!real.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Real;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Real";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "name";
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int id() {
            return this.id;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Vector<Object> coefficients() {
            void var1_1;
            SparseVector<Object> v = SparseVector$.MODULE$.zeros(this.$outer.breeze$optimize$linear$LinearProgram$$variables().length(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> v.update(this.id() + i, (Object)BoxesRunTime.boxToDouble((double)1.0)));
            return var1_1;
        }

        public Real copy(String name) {
            return new Real(this.$outer, name);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String _1() {
            return this.name();
        }

        public final LinearProgram breeze$optimize$linear$LinearProgram$Real$$$outer() {
            return this.$outer;
        }

        @Override
        public final LinearProgram breeze$optimize$linear$LinearProgram$Problem$$$outer() {
            return this.$outer;
        }

        @Override
        public final LinearProgram breeze$optimize$linear$LinearProgram$Expression$$$outer() {
            return this.$outer;
        }

        @Override
        public final LinearProgram breeze$optimize$linear$LinearProgram$Variable$$$outer() {
            return this.$outer;
        }
    }

    public abstract class Relation {
        private final String operator;
        private final LinearProgram $outer;

        public Relation(LinearProgram $outer, String operator) {
            this.operator = operator;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String operator() {
            return this.operator;
        }

        public final LinearProgram breeze$optimize$linear$LinearProgram$Relation$$$outer() {
            return this.$outer;
        }
    }

    public class Result
    implements Product,
    Serializable {
        private final DenseVector result;
        private final Problem problem;
        private final LinearProgram $outer;

        public Result(LinearProgram $outer, DenseVector<Object> result, Problem problem) {
            this.result = result;
            this.problem = problem;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            if (((Result)object).breeze$optimize$linear$LinearProgram$Result$$$outer() != this.$outer) return false;
            Result result = (Result)object;
            DenseVector<Object> denseVector = this.result();
            DenseVector<Object> denseVector2 = result.result();
            if (denseVector == null) {
                if (denseVector2 != null) {
                    return false;
                }
            } else if (!((Object)denseVector).equals(denseVector2)) return false;
            Problem problem = this.problem();
            Problem problem2 = result.problem();
            if (problem == null) {
                if (problem2 != null) {
                    return false;
                }
            } else if (!problem.equals(problem2)) return false;
            if (!result.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "result";
            } else if (1 == n2) {
                string = "problem";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public DenseVector<Object> result() {
            return this.result;
        }

        public Problem problem() {
            return this.problem;
        }

        public double valueOf(Expression x) {
            return BoxesRunTime.unboxToDouble((Object)this.result().dot(x.coefficients(), HasOps$.MODULE$.impl_OpMulInner_DV_V_eq_S_Double())) + x.scalarComponent();
        }

        public double value() {
            return this.valueOf(this.problem().objective());
        }

        public Result copy(DenseVector<Object> result, Problem problem) {
            return new Result(this.$outer, result, problem);
        }

        public DenseVector<Object> copy$default$1() {
            return this.result();
        }

        public Problem copy$default$2() {
            return this.problem();
        }

        public DenseVector<Object> _1() {
            return this.result();
        }

        public Problem _2() {
            return this.problem();
        }

        public final LinearProgram breeze$optimize$linear$LinearProgram$Result$$$outer() {
            return this.$outer;
        }
    }

    public static interface Solver {
        public Result maximize(LinearProgram var1, Problem var2);

        public Result minimize(LinearProgram var1, Problem var2);
    }

    public interface Variable
    extends Expression {
        public String name();

        public int id();

        public static int size$(Variable $this) {
            return $this.size();
        }

        default public int size() {
            return 1;
        }

        public static String toString$(Variable $this) {
            return $this.toString();
        }

        @Override
        default public String toString() {
            return this.name();
        }

        public LinearProgram breeze$optimize$linear$LinearProgram$Variable$$$outer();
    }
}

