/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.linear;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.package$;
import breeze.optimize.linear.NNLS$;
import breeze.optimize.linear.NNLS$State$;
import breeze.optimize.proximal.QuadraticMinimizer$;
import breeze.storage.Zero$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class NNLS
implements SerializableLogging {
    private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;
    private final int maxIters;
    public final NNLS$State$ State$lzy1;

    public static NNLS apply(int n) {
        return NNLS$.MODULE$.apply(n);
    }

    public static double computeObjectiveValue(DenseMatrix<Object> denseMatrix, DenseVector<Object> denseVector, DenseVector<Object> denseVector2) {
        return NNLS$.MODULE$.computeObjectiveValue(denseMatrix, denseVector, denseVector2);
    }

    public static void main(String[] stringArray) {
        NNLS$.MODULE$.main(stringArray);
    }

    public static int $lessinit$greater$default$1() {
        return NNLS$.MODULE$.$lessinit$greater$default$1();
    }

    public NNLS(int maxIters) {
        this.maxIters = maxIters;
        this.State$lzy1 = new NNLS$State$(this);
        SerializableLogging.$init$(this);
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return this.breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        this.breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    public int maxIters() {
        return this.maxIters;
    }

    public final NNLS$State$ State() {
        return this.State$lzy1;
    }

    private double steplen(DenseMatrix ata, DenseVector dir, DenseVector res, DenseVector tmp) {
        double top = BoxesRunTime.unboxToDouble((Object)dir.dot(res, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
        QuadraticMinimizer$.MODULE$.gemv(1.0, ata, dir, 0.0, tmp);
        return top / (BoxesRunTime.unboxToDouble((Object)tmp.dot(dir, (UFunc.UImpl2)HasOps$.MODULE$.canDotD())) + 1.0E-20);
    }

    private boolean stop(double step, double ndir, double nx) {
        return Predef$.MODULE$.double2Double(step).isNaN() || step < 1.0E-7 || step > 1.0E40 || ndir < 1.0E-12 * nx || ndir < 1.0E-32;
    }

    public State initialize(int n) {
        Vector grad = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Vector x = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Vector dir = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Vector lastDir = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Vector res = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Vector tmp = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        double lastNorm = 0.0;
        int lastWall = 0;
        return this.State().apply((DenseVector)x, (DenseVector)grad, (DenseVector)dir, (DenseVector)lastDir, (DenseVector)res, (DenseVector)tmp, lastNorm, lastWall, 0, false);
    }

    public State reset(DenseMatrix<Object> ata, DenseVector<Object> atb, State state) {
        Predef$.MODULE$.require(ata.cols() == ata.rows(), NNLS::reset$$anonfun$1);
        Predef$.MODULE$.require(ata.rows() == state.x().length(), NNLS::reset$$anonfun$2);
        state.x().$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        state.grad().$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        state.dir().$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        state.lastDir().$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        state.res().$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        state.tmp().$colon$eq(BoxesRunTime.boxToDouble((double)0.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpSet());
        return this.State().apply(state.x(), state.grad(), state.dir(), state.lastDir(), state.res(), state.tmp(), 0.0, 0, 0, false);
    }

    public State minimizeAndReturnState(DenseMatrix<Object> ata, DenseVector<Object> atb, State initialState, boolean resetState) {
        int nextIter;
        State startState = resetState ? this.reset(ata, atb, initialState) : initialState;
        int n = atb.length();
        int iterMax = this.maxIters() < 0 ? Math.max(400, 20 * n) : this.maxIters();
        double nextNorm = startState.lastNorm();
        int nextWall = startState.lastWall();
        for (nextIter = 0; nextIter <= iterMax; ++nextIter) {
            QuadraticMinimizer$.MODULE$.gemv(1.0, ata, startState.x(), 0.0, startState.res());
            package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)-1.0), atb, startState.res(), HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
            startState.grad().$colon$eq(startState.res(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            int yy = n;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                if (!(BoxesRunTime.unboxToDouble(startState.grad().apply(n2)) > 0.0) || BoxesRunTime.unboxToDouble(startState.x().apply(n2)) != 0.0) continue;
                startState.grad().update(n2, BoxesRunTime.boxToDouble((double)0.0));
            }
            double ngrad = BoxesRunTime.unboxToDouble((Object)startState.grad().dot(startState.grad(), (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
            startState.dir().$colon$eq(startState.grad(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            double step = this.steplen(ata, startState.grad(), startState.res(), startState.tmp());
            double ndir = 0.0;
            double nx = BoxesRunTime.unboxToDouble((Object)startState.x().dot(startState.x(), (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
            if (nextIter > nextWall + 1) {
                double alpha = ngrad / nextNorm;
                package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)alpha), startState.lastDir(), startState.dir(), HasOps$.MODULE$.impl_scaleAdd_InPlace_DV_T_DV_Double());
                double dstep = this.steplen(ata, startState.dir(), startState.res(), startState.tmp());
                ndir = BoxesRunTime.unboxToDouble((Object)startState.dir().dot(startState.dir(), (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
                if (this.stop(dstep, ndir, nx)) {
                    startState.dir().$colon$eq(startState.grad(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
                    ndir = BoxesRunTime.unboxToDouble((Object)startState.dir().dot(startState.dir(), (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
                } else {
                    step = dstep;
                }
            } else {
                ndir = BoxesRunTime.unboxToDouble((Object)startState.dir().dot(startState.dir(), (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
            }
            if (this.stop(step, ndir, nx)) {
                return this.State().apply(startState.x(), startState.grad(), startState.dir(), startState.lastDir(), startState.res(), startState.tmp(), nextNorm, nextWall, nextIter, true);
            }
            int yy2 = n;
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                if (!(step * BoxesRunTime.unboxToDouble(startState.dir().apply(n3)) > BoxesRunTime.unboxToDouble(startState.x().apply(n3)))) continue;
                step = BoxesRunTime.unboxToDouble(startState.x().apply(n3)) / BoxesRunTime.unboxToDouble(startState.dir().apply(n3));
            }
            int yy3 = n;
            for (int i = 0; i < n; ++i) {
                int n4 = i;
                if (step * BoxesRunTime.unboxToDouble(startState.dir().apply(n4)) > BoxesRunTime.unboxToDouble(startState.x().apply(n4)) * 0.99999999999999) {
                    startState.x().update(n4, BoxesRunTime.boxToDouble((double)0.0));
                    nextWall = nextIter;
                    continue;
                }
                startState.x().update(n4, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(startState.x().apply(n4)) - step * BoxesRunTime.unboxToDouble(startState.dir().apply(n4)))));
            }
            startState.lastDir().$colon$eq(startState.dir(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            nextNorm = ngrad;
        }
        return this.State().apply(startState.x(), startState.grad(), startState.dir(), startState.lastDir(), startState.res(), startState.tmp(), nextNorm, nextWall, nextIter, false);
    }

    public boolean minimizeAndReturnState$default$4() {
        return true;
    }

    public State minimizeAndReturnState(DenseMatrix<Object> ata, DenseVector<Object> atb) {
        State initialState = this.initialize(atb.length());
        return this.minimizeAndReturnState(ata, atb, initialState, this.minimizeAndReturnState$default$4());
    }

    public DenseVector<Object> minimize(DenseMatrix<Object> ata, DenseVector<Object> atb) {
        return this.minimizeAndReturnState(ata, atb).x();
    }

    public DenseVector<Object> minimize(DenseMatrix<Object> ata, DenseVector<Object> atb, State init) {
        return this.minimizeAndReturnState(ata, atb, init, this.minimizeAndReturnState$default$4()).x();
    }

    private static final String reset$$anonfun$1() {
        return "NNLS:iterations gram matrix must be symmetric";
    }

    private static final String reset$$anonfun$2() {
        return "NNLS:iterations gram and linear dimension mismatch";
    }

    public class State
    implements Product,
    Serializable {
        private final DenseVector x;
        private final DenseVector grad;
        private final DenseVector dir;
        private final DenseVector lastDir;
        private final DenseVector res;
        private final DenseVector tmp;
        private final double lastNorm;
        private final int lastWall;
        private final int iter;
        private final boolean converged;
        private final NNLS $outer;

        public State(NNLS $outer, DenseVector x, DenseVector grad, DenseVector dir, DenseVector lastDir, DenseVector res, DenseVector tmp, double lastNorm, int lastWall, int iter, boolean converged) {
            this.x = x;
            this.grad = grad;
            this.dir = dir;
            this.lastDir = lastDir;
            this.res = res;
            this.tmp = tmp;
            this.lastNorm = lastNorm;
            this.lastWall = lastWall;
            this.iter = iter;
            this.converged = converged;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.x()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.grad()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.dir()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.lastDir()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.res()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tmp()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.lastNorm()));
            n = Statics.mix((int)n, (int)this.lastWall());
            n = Statics.mix((int)n, (int)this.iter());
            n = Statics.mix((int)n, (int)(this.converged() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)10);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            if (((State)object).breeze$optimize$linear$NNLS$State$$$outer() != this.$outer) return false;
            State state = (State)object;
            if (this.lastNorm() != state.lastNorm()) return false;
            if (this.lastWall() != state.lastWall()) return false;
            if (this.iter() != state.iter()) return false;
            if (this.converged() != state.converged()) return false;
            DenseVector denseVector = this.x();
            DenseVector denseVector2 = state.x();
            if (denseVector == null) {
                if (denseVector2 != null) {
                    return false;
                }
            } else if (!((Object)denseVector).equals(denseVector2)) return false;
            DenseVector denseVector3 = this.grad();
            DenseVector denseVector4 = state.grad();
            if (denseVector3 == null) {
                if (denseVector4 != null) {
                    return false;
                }
            } else if (!((Object)denseVector3).equals(denseVector4)) return false;
            DenseVector denseVector5 = this.dir();
            DenseVector denseVector6 = state.dir();
            if (denseVector5 == null) {
                if (denseVector6 != null) {
                    return false;
                }
            } else if (!((Object)denseVector5).equals(denseVector6)) return false;
            DenseVector denseVector7 = this.lastDir();
            DenseVector denseVector8 = state.lastDir();
            if (denseVector7 == null) {
                if (denseVector8 != null) {
                    return false;
                }
            } else if (!((Object)denseVector7).equals(denseVector8)) return false;
            DenseVector denseVector9 = this.res();
            DenseVector denseVector10 = state.res();
            if (denseVector9 == null) {
                if (denseVector10 != null) {
                    return false;
                }
            } else if (!((Object)denseVector9).equals(denseVector10)) return false;
            DenseVector denseVector11 = this.tmp();
            DenseVector denseVector12 = state.tmp();
            if (denseVector11 == null) {
                if (denseVector12 != null) {
                    return false;
                }
            } else if (!((Object)denseVector11).equals(denseVector12)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 10;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = this._1();
                    break;
                }
                case 1: {
                    serializable = this._2();
                    break;
                }
                case 2: {
                    serializable = this._3();
                    break;
                }
                case 3: {
                    serializable = this._4();
                    break;
                }
                case 4: {
                    serializable = this._5();
                    break;
                }
                case 5: {
                    serializable = this._6();
                    break;
                }
                case 6: {
                    serializable = BoxesRunTime.boxToDouble((double)this._7());
                    break;
                }
                case 7: {
                    serializable = BoxesRunTime.boxToInteger((int)this._8());
                    break;
                }
                case 8: {
                    serializable = BoxesRunTime.boxToInteger((int)this._9());
                    break;
                }
                case 9: {
                    serializable = BoxesRunTime.boxToBoolean((boolean)this._10());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "x";
                    break;
                }
                case 1: {
                    string = "grad";
                    break;
                }
                case 2: {
                    string = "dir";
                    break;
                }
                case 3: {
                    string = "lastDir";
                    break;
                }
                case 4: {
                    string = "res";
                    break;
                }
                case 5: {
                    string = "tmp";
                    break;
                }
                case 6: {
                    string = "lastNorm";
                    break;
                }
                case 7: {
                    string = "lastWall";
                    break;
                }
                case 8: {
                    string = "iter";
                    break;
                }
                case 9: {
                    string = "converged";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public DenseVector x() {
            return this.x;
        }

        public DenseVector grad() {
            return this.grad;
        }

        public DenseVector dir() {
            return this.dir;
        }

        public DenseVector lastDir() {
            return this.lastDir;
        }

        public DenseVector res() {
            return this.res;
        }

        public DenseVector tmp() {
            return this.tmp;
        }

        public double lastNorm() {
            return this.lastNorm;
        }

        public int lastWall() {
            return this.lastWall;
        }

        public int iter() {
            return this.iter;
        }

        public boolean converged() {
            return this.converged;
        }

        public State copy(DenseVector x, DenseVector grad, DenseVector dir, DenseVector lastDir, DenseVector res, DenseVector tmp, double lastNorm, int lastWall, int iter, boolean converged) {
            return new State(this.$outer, x, grad, dir, lastDir, res, tmp, lastNorm, lastWall, iter, converged);
        }

        public DenseVector copy$default$1() {
            return this.x();
        }

        public DenseVector copy$default$2() {
            return this.grad();
        }

        public DenseVector copy$default$3() {
            return this.dir();
        }

        public DenseVector copy$default$4() {
            return this.lastDir();
        }

        public DenseVector copy$default$5() {
            return this.res();
        }

        public DenseVector copy$default$6() {
            return this.tmp();
        }

        public double copy$default$7() {
            return this.lastNorm();
        }

        public int copy$default$8() {
            return this.lastWall();
        }

        public int copy$default$9() {
            return this.iter();
        }

        public boolean copy$default$10() {
            return this.converged();
        }

        public DenseVector _1() {
            return this.x();
        }

        public DenseVector _2() {
            return this.grad();
        }

        public DenseVector _3() {
            return this.dir();
        }

        public DenseVector _4() {
            return this.lastDir();
        }

        public DenseVector _5() {
            return this.res();
        }

        public DenseVector _6() {
            return this.tmp();
        }

        public double _7() {
            return this.lastNorm();
        }

        public int _8() {
            return this.lastWall();
        }

        public int _9() {
            return this.iter();
        }

        public boolean _10() {
            return this.converged();
        }

        public final NNLS breeze$optimize$linear$NNLS$State$$$outer() {
            return this.$outer;
        }
    }
}

