/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats;

import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.math.Fractional;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Tuple2Zipped;
import scala.runtime.ZippedIterable2;
import scala.runtime.ZippedIterable2$;
import scala.util.Sorting$;

public final class DescriptiveStats$
implements Serializable {
    public static final DescriptiveStats$ MODULE$ = new DescriptiveStats$();

    private DescriptiveStats$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DescriptiveStats$.class);
    }

    public double percentile(IterableOnce<Object> it, double p) {
        if (p > 1.0 || p < 0.0) {
            throw new IllegalArgumentException("p must be in [0,1]");
        }
        IterableOnce iterableOnce = IterableOnce$.MODULE$.iterableOnceExtensionMethods(it);
        double[] arr = (double[])IterableOnceExtensionMethods$.MODULE$.toArray$extension(iterableOnce, ClassTag$.MODULE$.apply(Double.TYPE));
        Sorting$.MODULE$.quickSort(arr);
        return this.percentileInPlace(arr, p);
    }

    public double percentileInPlace(double[] arr, double p) {
        double d;
        if (p > 1.0 || p < 0.0) {
            throw new IllegalArgumentException("p must be in [0,1]");
        }
        double f = (double)(arr.length + 1) * p;
        int i = (int)f;
        if (i == 0) {
            Object object = Predef$.MODULE$.doubleArrayOps(arr);
            d = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.head$extension(object));
        } else if (i >= arr.length) {
            Object object = Predef$.MODULE$.doubleArrayOps(arr);
            d = BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.last$extension(object));
        } else {
            d = arr[i - 1] + (f - (double)i) * (arr[i] - arr[i - 1]);
        }
        return d;
    }

    public <T> Tuple3<T, T, Object> meanAndCov(IterableOnce<T> it1, IterableOnce<T> it2, Fractional<T> frac) {
        Tuple2 tuple2 = Predef$.MODULE$.tuple2ToZippedOps(Tuple2$.MODULE$.apply(it1.iterator().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Iterable())), it2.iterator().to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Iterable()))));
        Tuple4 tuple4 = (Tuple4)ZippedIterable2$.MODULE$.zippedIterable2ToIterable((ZippedIterable2)new Tuple2Zipped(Tuple2Zipped.Ops$.MODULE$.zipped$extension(tuple2, Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms()))).foldLeft((Object)Tuple4$.MODULE$.apply(frac.zero(), frac.zero(), frac.zero(), frac.zero()), (Function2 & Serializable)(acc, y) -> {
            Tuple4 tuple4 = acc;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Object oldMu1 = tuple4._1();
            Object oldMu2 = tuple4._2();
            Object oldC = tuple4._3();
            Object oldN = tuple4._4();
            Tuple4 tuple42 = Tuple4$.MODULE$.apply(oldMu1, oldMu2, oldC, oldN);
            Object oldMu12 = tuple42._1();
            Object oldMu22 = tuple42._2();
            Object oldC2 = tuple42._3();
            Object oldN2 = tuple42._4();
            Object newN = frac.mkNumericOps(oldN2).$plus(frac.fromInt(1));
            Object newMu1 = frac.mkNumericOps(oldMu12).$plus(frac.mkNumericOps(frac.mkNumericOps(y._1()).$minus(oldMu12)).$div(newN));
            Object newMu2 = frac.mkNumericOps(oldMu22).$plus(frac.mkNumericOps(frac.mkNumericOps(y._2()).$minus(oldMu22)).$div(newN));
            Object newC = frac.mkNumericOps(oldC2).$plus(frac.mkNumericOps(frac.mkNumericOps(y._1()).$minus(oldMu12)).$times(frac.mkNumericOps(y._2()).$minus(newMu2)));
            return Tuple4$.MODULE$.apply(newMu1, newMu2, newC, newN);
        });
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Object mu1 = tuple4._1();
        Object mu2 = tuple4._2();
        Object c = tuple4._3();
        Object n = tuple4._4();
        Tuple4 tuple42 = Tuple4$.MODULE$.apply(mu1, mu2, c, n);
        Object mu12 = tuple42._1();
        Object mu22 = tuple42._2();
        Object c2 = tuple42._3();
        Object n2 = tuple42._4();
        return BoxesRunTime.equals((Object)n2, (Object)BoxesRunTime.boxToInteger((int)1)) ? Tuple3$.MODULE$.apply(mu12, mu22, (Object)BoxesRunTime.boxToInteger((int)0)) : Tuple3$.MODULE$.apply(mu12, mu22, frac.mkNumericOps(c2).$div(frac.mkNumericOps(n2).$minus(frac.fromInt(1))));
    }

    public <T> Object cov(Iterable<T> it1, Iterable<T> it2, Fractional<T> n) {
        return this.meanAndCov((IterableOnce<T>)it1, (IterableOnce<T>)it2, n)._3();
    }
}

