/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.optimize.DiffFunction;
import breeze.stats.distributions.Beta$;
import breeze.stats.distributions.Density;
import breeze.stats.distributions.DiscreteDistr;
import breeze.stats.distributions.Geometric$;
import breeze.stats.distributions.Geometric$SufficientStatistic$;
import breeze.stats.distributions.Moments;
import breeze.stats.distributions.RandBasis;
import java.io.Serializable;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class Geometric
implements DiscreteDistr<Object>,
Moments<Object, Object>,
Product {
    private final double p;
    private final RandBasis rand;

    public static Beta$ conjugateFamily() {
        return Geometric$.MODULE$.conjugateFamily();
    }

    public static Geometric distribution(double d) {
        return Geometric$.MODULE$.distribution(d);
    }

    public static SufficientStatistic emptySufficientStatistic() {
        return Geometric$.MODULE$.emptySufficientStatistic();
    }

    public static DiffFunction<Object> likelihoodFunction(SufficientStatistic sufficientStatistic) {
        return Geometric$.MODULE$.likelihoodFunction(sufficientStatistic);
    }

    public static double mle(SufficientStatistic sufficientStatistic) {
        return Geometric$.MODULE$.mle(sufficientStatistic);
    }

    public static Tuple2<Object, Object> posterior(Tuple2<Object, Object> tuple2, IterableOnce<Object> iterableOnce) {
        return Geometric$.MODULE$.posterior(tuple2, iterableOnce);
    }

    public static Density<Object> predictive(Tuple2<Object, Object> tuple2, RandBasis randBasis) {
        return Geometric$.MODULE$.predictive(tuple2, randBasis);
    }

    public static SufficientStatistic sufficientStatisticFor(int n) {
        return Geometric$.MODULE$.sufficientStatisticFor(n);
    }

    public static Geometric unapply(Geometric geometric) {
        return Geometric$.MODULE$.unapply(geometric);
    }

    public static RandBasis $lessinit$greater$default$2(double d) {
        return Geometric$.MODULE$.$lessinit$greater$default$2(d);
    }

    public Geometric(double p, RandBasis rand) {
        this.p = p;
        this.rand = rand;
        Predef$.MODULE$.require(p >= 0.0);
        Predef$.MODULE$.require(p <= 1.0);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.p()));
        return Statics.finalizeHash((int)n, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Geometric)) return false;
        Geometric geometric = (Geometric)object;
        if (this.p() != geometric.p()) return false;
        if (!geometric.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Geometric;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Geometric";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)this._1());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "p";
    }

    public double p() {
        return this.p;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int draw() {
        int n;
        if (this.p() < 0.3333333333333333) {
            n = (int)package$.MODULE$.ceil(package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw())) / package$.MODULE$.log(1.0 - this.p()));
        } else {
            void var1_1;
            int i = 1;
            while (BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw()) > this.p()) {
                ++i;
            }
            n = var1_1;
        }
        return n;
    }

    @Override
    public double probabilityOf(int x) {
        return package$.MODULE$.pow(1.0 - this.p(), Int$.MODULE$.int2double(x)) * this.p();
    }

    @Override
    public double mean() {
        return 1.0 / this.p();
    }

    @Override
    public double variance() {
        return (1.0 - this.p()) / (this.p() * this.p());
    }

    @Override
    public double mode() {
        return 1.0;
    }

    @Override
    public double entropy() {
        return (-(1.0 - this.p()) * package$.MODULE$.log(1.0 - this.p()) - this.p() * package$.MODULE$.log(this.p())) / this.p();
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public Geometric copy(double p, RandBasis rand) {
        return new Geometric(p, rand);
    }

    public double copy$default$1() {
        return this.p();
    }

    public double _1() {
        return this.p();
    }

    public static class SufficientStatistic
    implements breeze.stats.distributions.SufficientStatistic<SufficientStatistic>,
    Product,
    Serializable {
        private final double sum;
        private final double n;

        public static SufficientStatistic apply(double d, double d2) {
            return Geometric$SufficientStatistic$.MODULE$.apply(d, d2);
        }

        public static SufficientStatistic fromProduct(Product product2) {
            return Geometric$SufficientStatistic$.MODULE$.fromProduct(product2);
        }

        public static SufficientStatistic unapply(SufficientStatistic sufficientStatistic) {
            return Geometric$SufficientStatistic$.MODULE$.unapply(sufficientStatistic);
        }

        public SufficientStatistic(double sum2, double n) {
            this.sum = sum2;
            this.n = n;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.sum()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.n()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SufficientStatistic)) return false;
            SufficientStatistic sufficientStatistic = (SufficientStatistic)object;
            if (this.sum() != sufficientStatistic.sum()) return false;
            if (this.n() != sufficientStatistic.n()) return false;
            if (!sufficientStatistic.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SufficientStatistic;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SufficientStatistic";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "sum";
            } else if (1 == n2) {
                string = "n";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public double sum() {
            return this.sum;
        }

        public double n() {
            return this.n;
        }

        @Override
        public SufficientStatistic $plus(SufficientStatistic t) {
            return Geometric$SufficientStatistic$.MODULE$.apply(this.sum() + t.sum(), this.n() + t.n());
        }

        @Override
        public SufficientStatistic $times(double weight) {
            return Geometric$SufficientStatistic$.MODULE$.apply(this.sum() * weight, this.n() * weight);
        }

        public SufficientStatistic copy(double sum2, double n) {
            return new SufficientStatistic(sum2, n);
        }

        public double copy$default$1() {
            return this.sum();
        }

        public double copy$default$2() {
            return this.n();
        }

        public double _1() {
            return this.sum();
        }

        public double _2() {
            return this.n();
        }
    }
}

