/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.generic.UFunc;
import breeze.numerics.package$exp$;
import breeze.numerics.package$exp$expDoubleImpl$;
import breeze.numerics.package$gammp$;
import breeze.numerics.package$gammp$gammpImplDoubleDouble$;
import breeze.numerics.package$lgamma$;
import breeze.numerics.package$lgamma$lgammaImplDouble$;
import breeze.numerics.package$log$;
import breeze.numerics.package$log$logDoubleImpl$;
import breeze.optimize.DiffFunction;
import breeze.stats.distributions.DiscreteDistr;
import breeze.stats.distributions.Moments;
import breeze.stats.distributions.Poisson$;
import breeze.stats.distributions.Poisson$SufficientStatistic$;
import breeze.stats.distributions.RandBasis;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class Poisson
implements DiscreteDistr<Object>,
Moments<Object, Object>,
Product {
    private final double mean;
    private final RandBasis rand;
    private final double ell;

    public static Poisson distribution(double d) {
        return Poisson$.MODULE$.distribution(d);
    }

    public static SufficientStatistic emptySufficientStatistic() {
        return Poisson$.MODULE$.emptySufficientStatistic();
    }

    public static DiffFunction<Object> likelihoodFunction(SufficientStatistic sufficientStatistic) {
        return Poisson$.MODULE$.likelihoodFunction(sufficientStatistic);
    }

    public static double mle(SufficientStatistic sufficientStatistic) {
        return Poisson$.MODULE$.mle(sufficientStatistic);
    }

    public static SufficientStatistic sufficientStatisticFor(int n) {
        return Poisson$.MODULE$.sufficientStatisticFor(n);
    }

    public static Poisson unapply(Poisson poisson) {
        return Poisson$.MODULE$.unapply(poisson);
    }

    public static RandBasis $lessinit$greater$default$2(double d) {
        return Poisson$.MODULE$.$lessinit$greater$default$2(d);
    }

    public Poisson(double mean2, RandBasis rand) {
        this.mean = mean2;
        this.rand = rand;
        Predef$.MODULE$.require(mean2 >= 0.0, () -> Poisson.$init$$$anonfun$1(mean2));
        Predef$.MODULE$.require(!Predef$.MODULE$.double2Double(mean2).isInfinite(), () -> Poisson.$init$$$anonfun$2(mean2));
        this.ell = package$.MODULE$.exp(-mean2);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.mean()));
        return Statics.finalizeHash((int)n, (int)1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Poisson)) return false;
        Poisson poisson = (Poisson)object;
        if (this.mean() != poisson.mean()) return false;
        if (!poisson.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Poisson;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "Poisson";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)this._1());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "mean";
    }

    @Override
    public double mean() {
        return this.mean;
    }

    public String toString() {
        return "Poisson(" + this.mean() + ")";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int draw() {
        int n;
        if (this.mean() == 0.0) {
            n = 0;
        } else if (this.mean() < 10.0) {
            void var3_2;
            double t = this.ell;
            int k = 0;
            double u = BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw());
            for (double s = t; s < u; s += (t *= this.mean() / (double)(++k))) {
            }
            n = var3_2;
        } else {
            int k_start = (int)this.mean();
            double u = BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw());
            double t1 = BoxesRunTime.unboxToDouble((Object)package$exp$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((double)k_start * BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.mean()), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$)) - this.mean() - BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((double)k_start + 1.0)), (UFunc.UImpl)package$lgamma$lgammaImplDouble$.MODULE$)))), (UFunc.UImpl)package$exp$expDoubleImpl$.MODULE$));
            if (t1 > u) {
                n = k_start;
            } else {
                int k1 = k_start;
                int k2 = k_start;
                double t2 = t1;
                double s = t1;
                while (true) {
                    ++k1;
                    if ((s += (t1 *= this.mean() / (double)k1)) > u) {
                        return k1;
                    }
                    if (k2 <= 0) continue;
                    t2 *= (double)k2 / this.mean();
                    --k2;
                    if (!((s += t2) > u)) continue;
                    return k2;
                }
                throw scala.sys.package$.MODULE$.error("wtf");
            }
        }
        return n;
    }

    @Override
    public double probabilityOf(int k) {
        return package$.MODULE$.exp(this.logProbabilityOf(k));
    }

    @Override
    public double logProbabilityOf(int k) {
        return -this.mean() + (double)k * BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.mean()), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((double)k + 1.0)), (UFunc.UImpl)package$lgamma$lgammaImplDouble$.MODULE$));
    }

    public double cdf(int k) {
        return 1.0 - BoxesRunTime.unboxToDouble((Object)package$gammp$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((double)k + 1.0)), BoxesRunTime.boxToDouble((double)this.mean()), (UFunc.UImpl2)package$gammp$gammpImplDoubleDouble$.MODULE$));
    }

    @Override
    public double variance() {
        return this.mean();
    }

    @Override
    public double mode() {
        return package$.MODULE$.ceil(this.mean()) - 1.0;
    }

    @Override
    public double entropy() {
        double entr = this.mean() * (1.0 - BoxesRunTime.unboxToDouble((Object)package$log$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.mean()), (UFunc.UImpl)package$log$logDoubleImpl$.MODULE$)));
        double extra = 0.0;
        double correction = 10000.0;
        int k = 0;
        double meanmean = 1.0 / this.mean();
        while (correction > 1.0E-6) {
            double ln_k_$bang = BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((double)k + 1.0)), (UFunc.UImpl)package$lgamma$lgammaImplDouble$.MODULE$));
            correction = (meanmean *= this.mean()) * ln_k_$bang / BoxesRunTime.unboxToDouble((Object)package$exp$.MODULE$.apply(BoxesRunTime.boxToDouble((double)ln_k_$bang), (UFunc.UImpl)package$exp$expDoubleImpl$.MODULE$));
            extra += correction;
            ++k;
        }
        return entr + BoxesRunTime.unboxToDouble((Object)package$exp$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(-this.mean())), (UFunc.UImpl)package$exp$expDoubleImpl$.MODULE$)) * extra;
    }

    public Poisson copy(double mean2, RandBasis rand) {
        return new Poisson(mean2, rand);
    }

    public double copy$default$1() {
        return this.mean();
    }

    public double _1() {
        return this.mean();
    }

    private static final String $init$$$anonfun$1(double mean$1) {
        return "Poisson mean must be non-negative, but got " + mean$1;
    }

    private static final String $init$$$anonfun$2(double mean$2) {
        return "Poisson mean must be finite, but got " + mean$2;
    }

    public static class SufficientStatistic
    implements breeze.stats.distributions.SufficientStatistic<SufficientStatistic>,
    Product,
    Serializable {
        private final double sum;
        private final double n;

        public static SufficientStatistic apply(double d, double d2) {
            return Poisson$SufficientStatistic$.MODULE$.apply(d, d2);
        }

        public static SufficientStatistic fromProduct(Product product2) {
            return Poisson$SufficientStatistic$.MODULE$.fromProduct(product2);
        }

        public static SufficientStatistic unapply(SufficientStatistic sufficientStatistic) {
            return Poisson$SufficientStatistic$.MODULE$.unapply(sufficientStatistic);
        }

        public SufficientStatistic(double sum2, double n) {
            this.sum = sum2;
            this.n = n;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.sum()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.n()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SufficientStatistic)) return false;
            SufficientStatistic sufficientStatistic = (SufficientStatistic)object;
            if (this.sum() != sufficientStatistic.sum()) return false;
            if (this.n() != sufficientStatistic.n()) return false;
            if (!sufficientStatistic.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SufficientStatistic;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SufficientStatistic";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "sum";
            } else if (1 == n2) {
                string = "n";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public double sum() {
            return this.sum;
        }

        public double n() {
            return this.n;
        }

        @Override
        public SufficientStatistic $plus(SufficientStatistic t) {
            return Poisson$SufficientStatistic$.MODULE$.apply(t.sum() + this.sum(), t.n() + this.n());
        }

        @Override
        public SufficientStatistic $times(double weight) {
            return Poisson$SufficientStatistic$.MODULE$.apply(this.sum() * weight, this.n() * weight);
        }

        public SufficientStatistic copy(double sum2, double n) {
            return new SufficientStatistic(sum2, n);
        }

        public double copy$default$1() {
            return this.sum();
        }

        public double copy$default$2() {
            return this.n();
        }

        public double _1() {
            return this.sum();
        }

        public double _2() {
            return this.n();
        }
    }
}

