/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.stats.distributions.Rand;
import breeze.stats.distributions.RandBasis$;
import java.io.Serializable;
import org.apache.commons.math3.random.RandomGenerator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class RandBasis
implements Serializable {
    private final RandomGenerator generator;
    private final Rand uniform;
    private final Rand randInt;
    private final Rand randLong;
    private final Rand gaussian;

    public static RandBasis mt0() {
        return RandBasis$.MODULE$.mt0();
    }

    public static RandBasis withSeed(int n) {
        return RandBasis$.MODULE$.withSeed(n);
    }

    public RandBasis(RandomGenerator generator) {
        this.generator = generator;
        this.uniform = new Rand<Object>(this){
            private final RandBasis $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public double draw() {
                return this.$outer.generator().nextDouble();
            }
        };
        this.randInt = new Rand<Object>(this){
            private final RandBasis $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int draw() {
                return this.$outer.generator().nextInt() & Integer.MAX_VALUE;
            }
        };
        this.randLong = new Rand<Object>(this){
            private final RandBasis $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public long draw() {
                return this.$outer.generator().nextLong() & Long.MAX_VALUE;
            }
        };
        this.gaussian = new Rand<Object>(this){
            private final RandBasis $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public double draw() {
                return this.$outer.generator().nextGaussian();
            }
        };
    }

    public RandomGenerator generator() {
        return this.generator;
    }

    public <T> Rand<T> choose(Iterable<T> c) {
        return new Rand<T>(c, this){
            private final Iterable c$1;
            private final RandBasis $outer;
            {
                this.c$1 = c$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Object draw() {
                double sz = BoxesRunTime.unboxToDouble((Object)this.$outer.uniform().draw()) * (double)this.c$1.size();
                Iterator elems = this.c$1.iterator();
                int i = 1;
                Object e = elems.next();
                while ((double)i < sz) {
                    e = elems.next();
                    ++i;
                }
                return e;
            }
        };
    }

    public <T> Rand<T> choose(Seq<T> c) {
        return this.randInt(c.size()).map((Function1 & Serializable)_$1 -> c.apply(BoxesRunTime.unboxToInt((Object)_$1)));
    }

    public <T> Rand<T> always(T t) {
        return new Rand<T>(t){
            private final Object t$1;
            {
                this.t$1 = t$5;
            }

            public Object draw() {
                return this.t$1;
            }
        };
    }

    public <T> Rand<T> fromBody(Function0<T> f) {
        return new Rand<T>(f){
            private final Function0 f$1;
            {
                this.f$1 = f$4;
            }

            public Object draw() {
                return this.f$1.apply();
            }
        };
    }

    public <U> Rand<Seq<U>> promote(Seq<Rand<U>> col) {
        return this.fromBody(() -> RandBasis.promote$$anonfun$1(col));
    }

    public <T1, T2> Rand<Tuple2<T1, T2>> promote(Tuple2<Rand<T1>, Rand<T2>> t) {
        return this.fromBody(() -> RandBasis.promote$$anonfun$2(t));
    }

    public <T1, T2, T3> Rand<Tuple3<T1, T2, T3>> promote(Tuple3<Rand<T1>, Rand<T2>, Rand<T3>> t) {
        return this.fromBody(() -> RandBasis.promote$$anonfun$3(t));
    }

    public <T1, T2, T3, T4> Rand<Tuple4<T1, T2, T3, T4>> promote(Tuple4<Rand<T1>, Rand<T2>, Rand<T3>, Rand<T4>> t) {
        return this.fromBody(() -> RandBasis.promote$$anonfun$4(t));
    }

    public Rand<Object> uniform() {
        return this.uniform;
    }

    public Rand<Object> randInt() {
        return this.randInt;
    }

    public Rand<Object> randInt(int n) {
        return new Rand<Object>(n, this){
            private final int n$1;
            private final RandBasis $outer;
            {
                this.n$1 = n$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int draw() {
                return this.$outer.generator().nextInt(this.n$1);
            }
        };
    }

    public Rand<Object> randInt(int n, int m) {
        return new Rand<Object>(n, m, this){
            private final int n$1;
            private final int m$1;
            private final RandBasis $outer;
            {
                this.n$1 = n$8;
                this.m$1 = m$4;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int draw() {
                return this.$outer.generator().nextInt(this.m$1 - this.n$1) + this.n$1;
            }
        };
    }

    public Rand<Object> randLong() {
        return this.randLong;
    }

    public Rand<Object> randLong(long n) {
        return new Rand<Object>(n, this){
            private final long n$1;
            private final RandBasis $outer;
            {
                this.n$1 = n$9;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public long draw() {
                long value = this.$outer.generator().nextLong() & Long.MAX_VALUE;
                return value % this.n$1;
            }
        };
    }

    public Rand<Object> randLong(long n, long m) {
        return new Rand<Object>(n, m, this){
            private final long n$1;
            private final long m$1;
            private final RandBasis $outer;
            {
                this.n$1 = n$10;
                this.m$1 = m$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public long draw() {
                long value = this.$outer.generator().nextLong() & Long.MAX_VALUE;
                return value % (this.m$1 - this.n$1) + this.n$1;
            }
        };
    }

    public Rand<Object> gaussian() {
        return this.gaussian;
    }

    public Rand<Object> gaussian(double m, double s) {
        return new Rand<Object>(m, s, this){
            private final double m$1;
            private final double s$1;
            private final RandBasis $outer;
            {
                this.m$1 = m$6;
                this.s$1 = s$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public double draw() {
                return this.m$1 + this.s$1 * BoxesRunTime.unboxToDouble((Object)this.$outer.gaussian().draw());
            }
        };
    }

    public Rand<IndexedSeq<Object>> permutation(int n) {
        return new Rand<IndexedSeq<Object>>(n, this){
            private final int n$1;
            private final RandBasis $outer;
            {
                this.n$1 = n$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public IndexedSeq draw() {
                ArrayBuffer arr = new ArrayBuffer();
                arr.$plus$plus$eq((IterableOnce)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.n$1));
                int i = this.n$1;
                while (i > 1) {
                    int k = this.$outer.generator().nextInt(i);
                    int tmp = arr.apply$mcII$sp(--i);
                    arr.update(i, (Object)BoxesRunTime.boxToInteger((int)arr.apply$mcII$sp(k)));
                    arr.update(k, (Object)BoxesRunTime.boxToInteger((int)tmp));
                }
                return arr.toIndexedSeq();
            }
        };
    }

    public <T> Rand<IndexedSeq<T>> subsetsOfSize(IndexedSeq<T> set, int n) {
        return new Rand<IndexedSeq<T>>(set, n, this){
            private final IndexedSeq set$1;
            private final int n$1;
            private final RandBasis $outer;
            {
                this.set$1 = set$2;
                this.n$1 = n$12;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public IndexedSeq draw() {
                int[] arr = Array$.MODULE$.range(0, this.set$1.size());
                for (int i = 0; i < RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.n$1), this.set$1.size()); ++i) {
                    int k = this.$outer.generator().nextInt(this.set$1.size() - i) + i;
                    int temp = arr[i];
                    arr[i] = arr[k];
                    arr[k] = temp;
                }
                Object object = Predef$.MODULE$.intArrayOps(arr);
                Object object2 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.take$extension(object, this.n$1));
                return (IndexedSeq)ArrayOps$.MODULE$.toIndexedSeq$extension(object2).map((Function1)this.set$1);
            }
        };
    }

    private static final Seq promote$$anonfun$1(Seq col$1) {
        return (Seq)col$1.map((Function1 & Serializable)_$2 -> _$2.draw());
    }

    private static final Tuple2 promote$$anonfun$2(Tuple2 t$2) {
        return Tuple2$.MODULE$.apply(((Rand)t$2._1()).draw(), ((Rand)t$2._2()).draw());
    }

    private static final Tuple3 promote$$anonfun$3(Tuple3 t$3) {
        return Tuple3$.MODULE$.apply(((Rand)t$3._1()).draw(), ((Rand)t$3._2()).draw(), ((Rand)t$3._3()).draw());
    }

    private static final Tuple4 promote$$anonfun$4(Tuple4 t$4) {
        return Tuple4$.MODULE$.apply(((Rand)t$4._1()).draw(), ((Rand)t$4._2()).draw(), ((Rand)t$4._3()).draw(), ((Rand)t$4._4()).draw());
    }
}

