/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.DenseVector$TupleIsomorphisms$pdoubleIsVector$;
import breeze.numerics.Bessel$i0$;
import breeze.numerics.Bessel$i0$ImplDouble$;
import breeze.numerics.Bessel$i1$;
import breeze.optimize.DiffFunction;
import breeze.optimize.OptimizationOption;
import breeze.optimize.OptimizationPackage$;
import breeze.stats.distributions.ExponentialFamily;
import breeze.stats.distributions.Rand$;
import breeze.stats.distributions.RandBasis;
import breeze.stats.distributions.VonMises;
import breeze.stats.distributions.VonMises$SufficientStatistic$;
import scala.;
import scala.$less$colon$less$;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class VonMises$
implements ExponentialFamily<VonMises, Object> {
    public static final VonMises$SufficientStatistic$ SufficientStatistic;
    public static final VonMises$ MODULE$;

    private VonMises$() {
    }

    static {
        MODULE$ = new VonMises$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(VonMises$.class);
    }

    public VonMises apply(double mu, double k, RandBasis rand) {
        return new VonMises(mu, k, rand);
    }

    public VonMises unapply(VonMises x$1) {
        return x$1;
    }

    public String toString() {
        return "VonMises";
    }

    public RandBasis $lessinit$greater$default$3(double mu, double k) {
        return Rand$.MODULE$;
    }

    @Override
    public VonMises.SufficientStatistic emptySufficientStatistic() {
        return VonMises$SufficientStatistic$.MODULE$.apply(0.0, 0.0, 0.0);
    }

    public VonMises.SufficientStatistic sufficientStatisticFor(double t) {
        return VonMises$SufficientStatistic$.MODULE$.apply(1.0, package$.MODULE$.sin(t), package$.MODULE$.cos(t));
    }

    public VonMises distribution(Tuple2 p) {
        return new VonMises(BoxesRunTime.unboxToDouble((Object)p._1()), BoxesRunTime.unboxToDouble((Object)p._2()), this.$lessinit$greater$default$3(BoxesRunTime.unboxToDouble((Object)p._1()), BoxesRunTime.unboxToDouble((Object)p._2())));
    }

    public Tuple2<Object, Object> mle(VonMises.SufficientStatistic stats) {
        DiffFunction<DenseVector<Object>> lensed = this.likelihoodFunction(stats).throughLens(DenseVector$TupleIsomorphisms$pdoubleIsVector$.MODULE$);
        double cosineSum = stats.cosines();
        double sineSum = stats.sines();
        double muPart = package$.MODULE$.signum(cosineSum) * package$.MODULE$.signum(sineSum) * package$.MODULE$.atan(package$.MODULE$.abs(sineSum / cosineSum));
        double mu = (muPart + (cosineSum < 0.0 ? Math.PI : (cosineSum > 0.0 && sineSum < 0.0 ? Math.PI * 2 : 0.0))) % (Math.PI * 2);
        double t = package$.MODULE$.sqrt(package$.MODULE$.pow(cosineSum / stats.n(), 2.0) + package$.MODULE$.pow(sineSum / stats.n(), 2.0));
        double k = (1.28 - 0.53 * package$.MODULE$.pow(t, 2.0)) * package$.MODULE$.tan(1.5707963267948966 * t);
        double kx = t < 0.53 ? t * ((double)2 + t * t * (1.0 + (double)5 * t * t / (double)6)) : (t < 0.85 ? -0.4 + 1.39 * t + 0.43 / (1.0 - t) : 1.0 / (t * ((double)3 + t * ((double)-4 + t))));
        DenseVector result = (DenseVector)breeze.optimize.package$.MODULE$.minimize(lensed, DenseVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{mu, kx}), ClassTag$.MODULE$.apply(Double.TYPE)), (Seq<OptimizationOption>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptimizationOption[0]), OptimizationPackage$.MODULE$.lbfgsMinimizationPackage(DenseVector$.MODULE$.space_Double(), (.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(result.apply(0), result.apply(1));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double a = BoxesRunTime.unboxToDouble((Object)tuple2._1());
        double b = BoxesRunTime.unboxToDouble((Object)tuple2._2());
        Tuple2 res = tuple2;
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)res, (Object)BoxesRunTime.boxToDouble((double)a), (Object)BoxesRunTime.boxToDouble((double)b));
        Tuple2 res2 = (Tuple2)tuple3._1();
        double a2 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        double b2 = BoxesRunTime.unboxToDouble((Object)tuple3._3());
        return res2;
    }

    public DiffFunction<Tuple2<Object, Object>> likelihoodFunction(VonMises.SufficientStatistic stats) {
        return new DiffFunction<Tuple2<Object, Object>>(stats){
            private final VonMises.SufficientStatistic stats$1;
            {
                this.stats$1 = stats$2;
            }

            public Tuple2 calculate(Tuple2 x) {
                Tuple2 tuple2;
                double DELTA = 1.0E-5;
                Tuple2 tuple22 = x;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                double mu = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                double k = BoxesRunTime.unboxToDouble((Object)tuple22._2());
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)mu), (Object)BoxesRunTime.boxToDouble((double)k));
                double mu2 = BoxesRunTime.unboxToDouble((Object)tuple23._1());
                double k2 = BoxesRunTime.unboxToDouble((Object)tuple23._2());
                if (mu2 < 0.0 || mu2 > Math.PI * 2 || k2 < 0.0) {
                    tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), (Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)));
                } else {
                    Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.sin(mu2)), (Object)BoxesRunTime.boxToDouble((double)package$.MODULE$.cos(mu2)));
                    double sinx = BoxesRunTime.unboxToDouble((Object)tuple24._1());
                    double cosx = BoxesRunTime.unboxToDouble((Object)tuple24._2());
                    double bessel_k = BoxesRunTime.unboxToDouble((Object)Bessel$i0$.MODULE$.apply(BoxesRunTime.boxToDouble((double)k2), (UFunc.UImpl)Bessel$i0$ImplDouble$.MODULE$));
                    double logprob = this.stats$1.n() * package$.MODULE$.log(bessel_k * (double)2 * Math.PI) - (this.stats$1.sines() * sinx + this.stats$1.cosines() * cosx) * k2;
                    double mugrad = -k2 * (this.stats$1.sines() * package$.MODULE$.cos(mu2) - this.stats$1.cosines() * package$.MODULE$.sin(mu2));
                    double kgrad = this.stats$1.n() * (Bessel$i1$.MODULE$.apply(k2) / bessel_k) - (this.stats$1.sines() * sinx + this.stats$1.cosines() * cosx);
                    tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)logprob), (Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)mugrad), (Object)BoxesRunTime.boxToDouble((double)kgrad)));
                }
                return tuple2;
            }
        };
    }
}

