/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.generic.UFunc;
import breeze.numerics.Bessel$i0$;
import breeze.numerics.Bessel$i0$ImplDouble$;
import breeze.numerics.Bessel$i1$;
import breeze.optimize.DiffFunction;
import breeze.stats.distributions.ContinuousDistr;
import breeze.stats.distributions.Moments;
import breeze.stats.distributions.Rand;
import breeze.stats.distributions.RandBasis;
import breeze.stats.distributions.VonMises$;
import breeze.stats.distributions.VonMises$SufficientStatistic$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VonMises
implements ContinuousDistr<Object>,
Moments<Object, Object>,
Product {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(VonMises.class, "0bitmap$1");
    public double normalizer$lzy1;
    public long 0bitmap$1;
    private final double mu;
    private final double k;
    private final RandBasis rand;
    public double logNormalizer$lzy1;
    private final double r;
    private final Rand<Object> myRandom;
    public String toString$lzy1;

    public static VonMises distribution(Tuple2 tuple2) {
        return VonMises$.MODULE$.distribution(tuple2);
    }

    public static SufficientStatistic emptySufficientStatistic() {
        return VonMises$.MODULE$.emptySufficientStatistic();
    }

    public static DiffFunction<Tuple2<Object, Object>> likelihoodFunction(SufficientStatistic sufficientStatistic) {
        return VonMises$.MODULE$.likelihoodFunction(sufficientStatistic);
    }

    public static Tuple2<Object, Object> mle(SufficientStatistic sufficientStatistic) {
        return VonMises$.MODULE$.mle(sufficientStatistic);
    }

    public static SufficientStatistic sufficientStatisticFor(double d) {
        return VonMises$.MODULE$.sufficientStatisticFor(d);
    }

    public static VonMises unapply(VonMises vonMises) {
        return VonMises$.MODULE$.unapply(vonMises);
    }

    public static RandBasis $lessinit$greater$default$3(double d, double d2) {
        return VonMises$.MODULE$.$lessinit$greater$default$3(d, d2);
    }

    public VonMises(double mu, double k, RandBasis rand) {
        this.mu = mu;
        this.k = k;
        this.rand = rand;
        ContinuousDistr.$init$(this);
        Predef$.MODULE$.require(k >= 0.0, VonMises::$init$$$anonfun$1);
        Predef$.MODULE$.require(mu <= Math.PI * 2 && mu >= 0.0, VonMises::$init$$$anonfun$2);
        double tau = 1.0 + package$.MODULE$.sqrt(1.0 + 4.0 * k * k);
        double rho = (tau - package$.MODULE$.sqrt(2.0 * tau)) / (2.0 * k);
        this.r = (1.0 + rho * rho) / ((double)2 * rho);
        this.myRandom = rand.uniform().flatMap((Function1 & Serializable)v -> this.$init$$$anonfun$10(mu, k, rand, BoxesRunTime.unboxToDouble((Object)v)));
    }

    @Override
    public double normalizer() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 2)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 2)) continue;
                try {
                    double d;
                    this.normalizer$lzy1 = d = ContinuousDistr.normalizer$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 2);
                    return d;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 2);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 2);
        }
        return this.normalizer$lzy1;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.mu()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.k()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof VonMises)) return false;
        VonMises vonMises = (VonMises)object;
        if (this.mu() != vonMises.mu()) return false;
        if (this.k() != vonMises.k()) return false;
        if (!vonMises.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof VonMises;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "VonMises";
    }

    public Object productElement(int n) {
        double d;
        int n2 = n;
        if (0 == n2) {
            d = this._1();
        } else if (1 == n2) {
            d = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return BoxesRunTime.boxToDouble((double)d);
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "mu";
        } else if (1 == n2) {
            string = "k";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public double mu() {
        return this.mu;
    }

    public double k() {
        return this.k;
    }

    @Override
    public double unnormalizedLogPdf(double theta) {
        return package$.MODULE$.cos(theta - this.mu()) * this.k();
    }

    @Override
    public double logNormalizer() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    double d;
                    this.logNormalizer$lzy1 = d = package$.MODULE$.log(BoxesRunTime.unboxToDouble((Object)Bessel$i0$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.k()), (UFunc.UImpl)Bessel$i0$ImplDouble$.MODULE$)) * (double)2 * Math.PI);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return d;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.logNormalizer$lzy1;
    }

    @Override
    public double draw() {
        return BoxesRunTime.unboxToDouble((Object)this.myRandom.draw());
    }

    public String toString() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 1)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 1)) continue;
                try {
                    String string;
                    this.toString$lzy1 = string = "VonMises(mu=" + this.mu() + ", k=" + this.k() + ")";
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 1);
                    return string;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 1);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 1);
        }
        return this.toString$lzy1;
    }

    @Override
    public double mean() {
        return this.mu();
    }

    @Override
    public double mode() {
        return this.mean();
    }

    @Override
    public double variance() {
        return 1.0 - Bessel$i1$.MODULE$.apply(this.k()) / BoxesRunTime.unboxToDouble((Object)Bessel$i0$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.k()), (UFunc.UImpl)Bessel$i0$ImplDouble$.MODULE$));
    }

    @Override
    public double entropy() {
        return -this.k() * Bessel$i1$.MODULE$.apply(this.k()) / BoxesRunTime.unboxToDouble((Object)Bessel$i0$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.k()), (UFunc.UImpl)Bessel$i0$ImplDouble$.MODULE$)) + package$.MODULE$.log(Math.PI * 2 * BoxesRunTime.unboxToDouble((Object)Bessel$i0$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.k()), (UFunc.UImpl)Bessel$i0$ImplDouble$.MODULE$)));
    }

    public VonMises copy(double mu, double k, RandBasis rand) {
        return new VonMises(mu, k, rand);
    }

    public double copy$default$1() {
        return this.mu();
    }

    public double copy$default$2() {
        return this.k();
    }

    public double _1() {
        return this.mu();
    }

    public double _2() {
        return this.k();
    }

    private static final String $init$$$anonfun$1() {
        return "K must be positive";
    }

    private static final String $init$$$anonfun$2() {
        return "Mu must be in the range [0,2pi]";
    }

    private final /* synthetic */ Tuple5 $init$$$anonfun$3$$anonfun$1(double k$2, double v$1, double u) {
        double z = package$.MODULE$.cos(Math.PI * u);
        double w = (1.0 + this.r * z) / (this.r + z);
        double c = k$2 * (this.r - w);
        boolean accept = v$1 < c * (2.0 - c) || v$1 <= c * package$.MODULE$.exp(1.0 - c);
        return Tuple5$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)u), (Object)BoxesRunTime.boxToDouble((double)z), (Object)BoxesRunTime.boxToDouble((double)w), (Object)BoxesRunTime.boxToDouble((double)c), (Object)BoxesRunTime.boxToBoolean((boolean)accept));
    }

    private static final /* synthetic */ Tuple2 $init$$$anonfun$6$$anonfun$3$$anonfun$1(double mu$3, double w$1, double choice) {
        double theta = choice > 0.5 ? mu$3 + package$.MODULE$.acos(w$1) : mu$3 - package$.MODULE$.acos(w$1);
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)choice), (Object)BoxesRunTime.boxToDouble((double)theta));
    }

    private final /* synthetic */ Rand $init$$$anonfun$10(double mu$1, double k$1, RandBasis rand$1, double v) {
        return rand$1.uniform().map((Function1 & Serializable)u -> this.$init$$$anonfun$3$$anonfun$1(k$1, v, BoxesRunTime.unboxToDouble((Object)u))).withFilter((Function1 & Serializable)x$1 -> {
            Tuple5 tuple5 = x$1;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            double u = BoxesRunTime.unboxToDouble((Object)tuple5._1());
            double z = BoxesRunTime.unboxToDouble((Object)tuple5._2());
            double w = BoxesRunTime.unboxToDouble((Object)tuple5._3());
            double c = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            boolean accept = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
            return accept;
        }).flatMap((Function1 & Serializable)x$12 -> {
            Tuple5 tuple5 = x$12;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            double u = BoxesRunTime.unboxToDouble((Object)tuple5._1());
            double z = BoxesRunTime.unboxToDouble((Object)tuple5._2());
            double w = BoxesRunTime.unboxToDouble((Object)tuple5._3());
            double c = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            boolean accept = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
            return rand$1.uniform().map((Function1 & Serializable)choice -> VonMises.$init$$$anonfun$6$$anonfun$3$$anonfun$1(mu$1, w, BoxesRunTime.unboxToDouble((Object)choice))).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                double choice = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                double theta = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                return theta;
            });
        });
    }

    public static class SufficientStatistic
    implements breeze.stats.distributions.SufficientStatistic<SufficientStatistic>,
    Product,
    Serializable {
        private final double n;
        private final double sines;
        private final double cosines;

        public static SufficientStatistic apply(double d, double d2, double d3) {
            return VonMises$SufficientStatistic$.MODULE$.apply(d, d2, d3);
        }

        public static SufficientStatistic fromProduct(Product product2) {
            return VonMises$SufficientStatistic$.MODULE$.fromProduct(product2);
        }

        public static SufficientStatistic unapply(SufficientStatistic sufficientStatistic) {
            return VonMises$SufficientStatistic$.MODULE$.unapply(sufficientStatistic);
        }

        public SufficientStatistic(double n, double sines, double cosines) {
            this.n = n;
            this.sines = sines;
            this.cosines = cosines;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.n()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.sines()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.cosines()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SufficientStatistic)) return false;
            SufficientStatistic sufficientStatistic = (SufficientStatistic)object;
            if (this.n() != sufficientStatistic.n()) return false;
            if (this.sines() != sufficientStatistic.sines()) return false;
            if (this.cosines() != sufficientStatistic.cosines()) return false;
            if (!sufficientStatistic.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SufficientStatistic;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "SufficientStatistic";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            switch (n2) {
                case 0: {
                    d = this._1();
                    break;
                }
                case 1: {
                    d = this._2();
                    break;
                }
                case 2: {
                    d = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "n";
                    break;
                }
                case 1: {
                    string = "sines";
                    break;
                }
                case 2: {
                    string = "cosines";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public double n() {
            return this.n;
        }

        public double sines() {
            return this.sines;
        }

        public double cosines() {
            return this.cosines;
        }

        @Override
        public SufficientStatistic $plus(SufficientStatistic t) {
            return new SufficientStatistic(this.n() + t.n(), this.sines() + t.sines(), this.cosines() + t.cosines());
        }

        @Override
        public SufficientStatistic $times(double weight) {
            return VonMises$SufficientStatistic$.MODULE$.apply(weight * this.n(), weight * this.sines(), weight * this.cosines());
        }

        public SufficientStatistic copy(double n, double sines, double cosines) {
            return new SufficientStatistic(n, sines, cosines);
        }

        public double copy$default$1() {
            return this.n();
        }

        public double copy$default$2() {
            return this.sines();
        }

        public double copy$default$3() {
            return this.cosines();
        }

        public double _1() {
            return this.n();
        }

        public double _2() {
            return this.sines();
        }

        public double _3() {
            return this.cosines();
        }
    }
}

