/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.regression;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.operators.HasOps$;
import breeze.stats.regression.LassoResult$;
import breeze.stats.regression.RegressionResult;
import java.io.Serializable;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public class LassoResult
implements RegressionResult<DenseVector<Object>, Object>,
Product,
Serializable {
    private final DenseVector coefficients;
    private final double rSquared;
    private final double lambda;

    public static LassoResult fromProduct(Product product2) {
        return LassoResult$.MODULE$.fromProduct(product2);
    }

    public static LassoResult unapply(LassoResult lassoResult) {
        return LassoResult$.MODULE$.unapply(lassoResult);
    }

    public LassoResult(DenseVector<Object> coefficients, double rSquared, double lambda) {
        this.coefficients = coefficients;
        this.rSquared = rSquared;
        this.lambda = lambda;
        Predef$.MODULE$.require(lambda >= 0.0);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.coefficients()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.rSquared()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.lambda()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LassoResult)) return false;
        LassoResult lassoResult = (LassoResult)object;
        if (this.rSquared() != lassoResult.rSquared()) return false;
        if (this.lambda() != lassoResult.lambda()) return false;
        DenseVector<Object> denseVector = this.coefficients();
        DenseVector<Object> denseVector2 = lassoResult.coefficients();
        if (denseVector == null) {
            if (denseVector2 != null) {
                return false;
            }
        } else if (!((Object)denseVector).equals(denseVector2)) return false;
        if (!lassoResult.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof LassoResult;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "LassoResult";
    }

    public Object productElement(int n) {
        Serializable serializable;
        int n2 = n;
        switch (n2) {
            case 0: {
                serializable = this._1();
                break;
            }
            case 1: {
                serializable = BoxesRunTime.boxToDouble((double)this._2());
                break;
            }
            case 2: {
                serializable = BoxesRunTime.boxToDouble((double)this._3());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return serializable;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "coefficients";
                break;
            }
            case 1: {
                string = "rSquared";
                break;
            }
            case 2: {
                string = "lambda";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public DenseVector<Object> coefficients() {
        return this.coefficients;
    }

    public double rSquared() {
        return this.rSquared;
    }

    public double lambda() {
        return this.lambda;
    }

    public double apply(DenseVector<Object> x) {
        return BoxesRunTime.unboxToDouble((Object)this.coefficients().dot(x, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
    }

    public LassoResult copy(DenseVector<Object> coefficients, double rSquared, double lambda) {
        return new LassoResult(coefficients, rSquared, lambda);
    }

    public DenseVector<Object> copy$default$1() {
        return this.coefficients();
    }

    public double copy$default$2() {
        return this.rSquared();
    }

    public double copy$default$3() {
        return this.lambda();
    }

    public DenseVector<Object> _1() {
        return this.coefficients();
    }

    public double _2() {
        return this.rSquared();
    }

    public double _3() {
        return this.lambda();
    }
}

