/*
 * Decompiled with CFR 0.152.
 */
package breeze.integrate.quasimontecarlo;

import breeze.integrate.quasimontecarlo.BaseUniformHaltonGenerator;
import breeze.integrate.quasimontecarlo.ProvidesTransformedQuasiMonteCarlo$DistributionRandomVariableSpec$;
import breeze.integrate.quasimontecarlo.ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaGeq1$;
import breeze.integrate.quasimontecarlo.ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaLeq1$;
import breeze.integrate.quasimontecarlo.ProvidesTransformedQuasiMonteCarlo$RejectionSampledGammaQuasiRandomVariable$;
import breeze.integrate.quasimontecarlo.QuasiMonteCarloGenerator;
import breeze.stats.distributions.HasInverseCdf;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public interface ProvidesTransformedQuasiMonteCarlo {
    public static void $init$(ProvidesTransformedQuasiMonteCarlo $this) {
    }

    public static double quasiMonteCarloIntegrate$(ProvidesTransformedQuasiMonteCarlo $this, Function1 f, Seq variables, long numSamples) {
        return $this.quasiMonteCarloIntegrate((Function1<double[], Object>)f, (Seq<QuasiRandomVariableSpec>)variables, numSamples);
    }

    default public double quasiMonteCarloIntegrate(Function1<double[], Object> f, Seq<QuasiRandomVariableSpec> variables, long numSamples) {
        TransformedQuasiMonteCarloGenerator generator = new TransformedQuasiMonteCarloGenerator(this, variables);
        double fSum = 0.0;
        for (long i = 0L; i < numSamples; ++i) {
            fSum += BoxesRunTime.unboxToDouble((Object)f.apply((Object)generator.getNextUnsafe()));
        }
        return fSum / (double)numSamples;
    }

    public static ProvidesTransformedQuasiMonteCarlo$DistributionRandomVariableSpec$ DistributionRandomVariableSpec$(ProvidesTransformedQuasiMonteCarlo $this) {
        return $this.DistributionRandomVariableSpec();
    }

    default public ProvidesTransformedQuasiMonteCarlo$DistributionRandomVariableSpec$ DistributionRandomVariableSpec() {
        return new ProvidesTransformedQuasiMonteCarlo$DistributionRandomVariableSpec$(this);
    }

    public static ProvidesTransformedQuasiMonteCarlo$RejectionSampledGammaQuasiRandomVariable$ RejectionSampledGammaQuasiRandomVariable$(ProvidesTransformedQuasiMonteCarlo $this) {
        return $this.RejectionSampledGammaQuasiRandomVariable();
    }

    default public ProvidesTransformedQuasiMonteCarlo$RejectionSampledGammaQuasiRandomVariable$ RejectionSampledGammaQuasiRandomVariable() {
        return new ProvidesTransformedQuasiMonteCarlo$RejectionSampledGammaQuasiRandomVariable$(this);
    }

    public static ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaLeq1$ GammaQuasiRandomVariableSpecAlphaLeq1$(ProvidesTransformedQuasiMonteCarlo $this) {
        return $this.GammaQuasiRandomVariableSpecAlphaLeq1();
    }

    default public ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaLeq1$ GammaQuasiRandomVariableSpecAlphaLeq1() {
        return new ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaLeq1$(this);
    }

    public static ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaGeq1$ GammaQuasiRandomVariableSpecAlphaGeq1$(ProvidesTransformedQuasiMonteCarlo $this) {
        return $this.GammaQuasiRandomVariableSpecAlphaGeq1();
    }

    default public ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaGeq1$ GammaQuasiRandomVariableSpecAlphaGeq1() {
        return new ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaGeq1$(this);
    }

    public static /* synthetic */ QuasiRandomVariableSpec breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$TransformedQuasiMonteCarloGenerator$$_$$lessinit$greater$$anonfun$1(QuasiRandomVariableSpec x) {
        return x.copy();
    }

    public static /* synthetic */ int breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$TransformedQuasiMonteCarloGenerator$$_$$lessinit$greater$$anonfun$2(QuasiRandomVariableSpec x) {
        return x.numInputs();
    }

    public class DistributionRandomVariableSpec
    implements TransformingQuasiRandomVariableSpec,
    Product,
    Serializable {
        private final HasInverseCdf icdfProvider;
        private final int numInputs;
        private final ProvidesTransformedQuasiMonteCarlo $outer;

        public DistributionRandomVariableSpec(ProvidesTransformedQuasiMonteCarlo $outer, HasInverseCdf icdfProvider) {
            this.icdfProvider = icdfProvider;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.numInputs = 1;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DistributionRandomVariableSpec)) return false;
            if (((DistributionRandomVariableSpec)object).breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$DistributionRandomVariableSpec$$$outer() != this.$outer) return false;
            DistributionRandomVariableSpec distributionRandomVariableSpec = (DistributionRandomVariableSpec)object;
            HasInverseCdf hasInverseCdf = this.icdfProvider();
            HasInverseCdf hasInverseCdf2 = distributionRandomVariableSpec.icdfProvider();
            if (hasInverseCdf == null) {
                if (hasInverseCdf2 != null) {
                    return false;
                }
            } else if (!hasInverseCdf.equals(hasInverseCdf2)) return false;
            if (!distributionRandomVariableSpec.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DistributionRandomVariableSpec;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DistributionRandomVariableSpec";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "icdfProvider";
        }

        public HasInverseCdf icdfProvider() {
            return this.icdfProvider;
        }

        @Override
        public int numInputs() {
            return this.numInputs;
        }

        @Override
        public double transform(double[] x, int position) {
            return this.icdfProvider().inverseCdf(x[position]);
        }

        @Override
        public QuasiRandomVariableSpec copy() {
            return this.$outer.DistributionRandomVariableSpec().apply(this.icdfProvider());
        }

        public DistributionRandomVariableSpec copy(HasInverseCdf icdfProvider) {
            return new DistributionRandomVariableSpec(this.$outer, icdfProvider);
        }

        public HasInverseCdf copy$default$1() {
            return this.icdfProvider();
        }

        public HasInverseCdf _1() {
            return this.icdfProvider();
        }

        public final ProvidesTransformedQuasiMonteCarlo breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$DistributionRandomVariableSpec$$$outer() {
            return this.$outer;
        }
    }

    public class GammaQuasiRandomVariableSpecAlphaGeq1
    implements RejectionSampledGammaQuasiRandomVariable,
    Product,
    Serializable {
        private final double alpha;
        private final double theta;
        private final int numInputs;
        private final double a;
        private final double b;
        private final double c;
        private double x;
        private final ProvidesTransformedQuasiMonteCarlo $outer;

        public GammaQuasiRandomVariableSpecAlphaGeq1(ProvidesTransformedQuasiMonteCarlo $outer, double alpha, double theta) {
            this.alpha = alpha;
            this.theta = theta;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Predef$.MODULE$.require(alpha > 1.0);
            this.numInputs = 2;
            this.a = 1.0 / package$.MODULE$.sqrt((double)2 * alpha - 1.0);
            this.b = alpha - package$.MODULE$.log(4.0);
            this.c = alpha + 1.0 / this.a;
            this.x = 0.0;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.alpha()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.theta()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GammaQuasiRandomVariableSpecAlphaGeq1)) return false;
            if (((GammaQuasiRandomVariableSpecAlphaGeq1)object).breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaGeq1$$$outer() != this.$outer) return false;
            GammaQuasiRandomVariableSpecAlphaGeq1 gammaQuasiRandomVariableSpecAlphaGeq1 = (GammaQuasiRandomVariableSpecAlphaGeq1)object;
            if (this.alpha() != gammaQuasiRandomVariableSpecAlphaGeq1.alpha()) return false;
            if (this.theta() != gammaQuasiRandomVariableSpecAlphaGeq1.theta()) return false;
            if (!gammaQuasiRandomVariableSpecAlphaGeq1.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GammaQuasiRandomVariableSpecAlphaGeq1;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "GammaQuasiRandomVariableSpecAlphaGeq1";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "alpha";
            } else if (1 == n2) {
                string = "theta";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public double alpha() {
            return this.alpha;
        }

        public double theta() {
            return this.theta;
        }

        @Override
        public int numInputs() {
            return this.numInputs;
        }

        @Override
        public boolean accept(double[] rvs, int position) {
            double u = rvs[position];
            double v = rvs[position + 1];
            double y = this.a * package$.MODULE$.log(u / (1.0 - u));
            this.x = this.alpha() * package$.MODULE$.exp(y);
            double r = this.b + this.c * y - this.x;
            double z = u * u * v;
            return r + 2.5040774 - 4.5 * z >= 0.0 || r >= package$.MODULE$.log(z);
        }

        @Override
        public double compute(double[] rvs, int position) {
            return this.theta() * this.x;
        }

        @Override
        public QuasiRandomVariableSpec copy() {
            return this.$outer.GammaQuasiRandomVariableSpecAlphaGeq1().apply(this.alpha(), this.theta());
        }

        public GammaQuasiRandomVariableSpecAlphaGeq1 copy(double alpha, double theta) {
            return new GammaQuasiRandomVariableSpecAlphaGeq1(this.$outer, alpha, theta);
        }

        public double copy$default$1() {
            return this.alpha();
        }

        public double copy$default$2() {
            return this.theta();
        }

        public double _1() {
            return this.alpha();
        }

        public double _2() {
            return this.theta();
        }

        public final ProvidesTransformedQuasiMonteCarlo breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaGeq1$$$outer() {
            return this.$outer;
        }
    }

    public class GammaQuasiRandomVariableSpecAlphaLeq1
    implements RejectionSampledGammaQuasiRandomVariable,
    Product,
    Serializable {
        private final double alpha;
        private final double theta;
        private final int numInputs;
        private final double one_over_alpha;
        private final double two_to_alpha_minus_one;
        private double x;
        private final ProvidesTransformedQuasiMonteCarlo $outer;

        public GammaQuasiRandomVariableSpecAlphaLeq1(ProvidesTransformedQuasiMonteCarlo $outer, double alpha, double theta) {
            this.alpha = alpha;
            this.theta = theta;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Predef$.MODULE$.require(alpha < 1.0);
            this.numInputs = 2;
            double b = (alpha + Math.E) / Math.E;
            this.one_over_alpha = 1.0 / alpha;
            this.two_to_alpha_minus_one = package$.MODULE$.pow(2.0, alpha - 1.0);
            this.x = 0.0;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.alpha()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.theta()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GammaQuasiRandomVariableSpecAlphaLeq1)) return false;
            if (((GammaQuasiRandomVariableSpecAlphaLeq1)object).breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaLeq1$$$outer() != this.$outer) return false;
            GammaQuasiRandomVariableSpecAlphaLeq1 gammaQuasiRandomVariableSpecAlphaLeq1 = (GammaQuasiRandomVariableSpecAlphaLeq1)object;
            if (this.alpha() != gammaQuasiRandomVariableSpecAlphaLeq1.alpha()) return false;
            if (this.theta() != gammaQuasiRandomVariableSpecAlphaLeq1.theta()) return false;
            if (!gammaQuasiRandomVariableSpecAlphaLeq1.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof GammaQuasiRandomVariableSpecAlphaLeq1;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "GammaQuasiRandomVariableSpecAlphaLeq1";
        }

        public Object productElement(int n) {
            double d;
            int n2 = n;
            if (0 == n2) {
                d = this._1();
            } else if (1 == n2) {
                d = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToDouble((double)d);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "alpha";
            } else if (1 == n2) {
                string = "theta";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public double alpha() {
            return this.alpha;
        }

        public double theta() {
            return this.theta;
        }

        @Override
        public int numInputs() {
            return this.numInputs;
        }

        @Override
        public boolean accept(double[] rvs, int position) {
            double u = rvs[position];
            double v = rvs[position + 1];
            this.x = (double)-2 * package$.MODULE$.log(1.0 - package$.MODULE$.pow(u, this.one_over_alpha));
            double exp_minus_x_over_two = package$.MODULE$.exp(-0.5 * this.x);
            return v <= package$.MODULE$.pow(this.x, this.alpha() - 1.0) * exp_minus_x_over_two / (this.two_to_alpha_minus_one * package$.MODULE$.pow(1.0 - exp_minus_x_over_two, this.alpha() - 1.0));
        }

        @Override
        public double compute(double[] rvs, int position) {
            return this.theta() * this.x;
        }

        @Override
        public QuasiRandomVariableSpec copy() {
            return this.$outer.GammaQuasiRandomVariableSpecAlphaLeq1().apply(this.alpha(), this.theta());
        }

        public GammaQuasiRandomVariableSpecAlphaLeq1 copy(double alpha, double theta) {
            return new GammaQuasiRandomVariableSpecAlphaLeq1(this.$outer, alpha, theta);
        }

        public double copy$default$1() {
            return this.alpha();
        }

        public double copy$default$2() {
            return this.theta();
        }

        public double _1() {
            return this.alpha();
        }

        public double _2() {
            return this.theta();
        }

        public final ProvidesTransformedQuasiMonteCarlo breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$GammaQuasiRandomVariableSpecAlphaLeq1$$$outer() {
            return this.$outer;
        }
    }

    public interface QuasiRandomVariableSpec {
        public int numInputs();

        public QuasiRandomVariableSpec copy();
    }

    public interface RejectionQuasiRandomVariableSpec
    extends QuasiRandomVariableSpec {
        public boolean accept(double[] var1, int var2);

        public double compute(double[] var1, int var2);
    }

    public interface RejectionSampledGammaQuasiRandomVariable
    extends RejectionQuasiRandomVariableSpec {
    }

    public class TransformedQuasiMonteCarloGenerator
    implements QuasiMonteCarloGenerator {
        private final List inVariables;
        private final QuasiRandomVariableSpec[] variables;
        private final int dimension;
        private final int inputDimension;
        private final BaseUniformHaltonGenerator baseGenerator;
        private final double[] currentValue;
        private long generatedCount;
        private long[] rejectedCount;
        private final ProvidesTransformedQuasiMonteCarlo $outer;

        public TransformedQuasiMonteCarloGenerator(ProvidesTransformedQuasiMonteCarlo $outer, List<QuasiRandomVariableSpec> inVariables) {
            this.inVariables = inVariables;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.variables = (QuasiRandomVariableSpec[])inVariables.map(ProvidesTransformedQuasiMonteCarlo::breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$TransformedQuasiMonteCarloGenerator$$_$$lessinit$greater$$anonfun$1).toArray(ClassTag$.MODULE$.apply(QuasiRandomVariableSpec.class));
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.variables());
            this.dimension = ArrayOps$.MODULE$.size$extension(object);
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.variables());
            this.inputDimension = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object2, ProvidesTransformedQuasiMonteCarlo::breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$TransformedQuasiMonteCarloGenerator$$_$$lessinit$greater$$anonfun$2, ClassTag$.MODULE$.apply(Integer.TYPE))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            this.baseGenerator = new BaseUniformHaltonGenerator(this.inputDimension());
            this.currentValue = new double[this.dimension()];
            this.generatedCount = 0L;
            this.rejectedCount = new long[this.dimension()];
        }

        public List<QuasiRandomVariableSpec> inVariables() {
            return this.inVariables;
        }

        public TransformedQuasiMonteCarloGenerator(ProvidesTransformedQuasiMonteCarlo $outer, Seq<QuasiRandomVariableSpec> inVariables) {
            this($outer, (List<QuasiRandomVariableSpec>)inVariables.toList());
        }

        public QuasiRandomVariableSpec[] variables() {
            return this.variables;
        }

        @Override
        public int dimension() {
            return this.dimension;
        }

        public int inputDimension() {
            return this.inputDimension;
        }

        @Override
        public long numGenerated() {
            return this.generatedCount;
        }

        public long numRejections() {
            return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray(this.rejectedCount).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }

        public long[] numRejectionsByVariable() {
            return (long[])this.rejectedCount.clone();
        }

        @Override
        public double[] getNextUnsafe() {
            boolean accepted = false;
            while (!accepted) {
                accepted = true;
                double[] next = this.baseGenerator.getNextUnsafe();
                int inputPosition = 0;
                for (int i = 0; i < this.dimension() && accepted; ++i) {
                    QuasiRandomVariableSpec quasiRandomVariableSpec = this.variables()[i];
                    if (quasiRandomVariableSpec instanceof TransformingQuasiRandomVariableSpec) {
                        TransformingQuasiRandomVariableSpec v = (TransformingQuasiRandomVariableSpec)quasiRandomVariableSpec;
                        this.currentValue[i] = v.transform(next, inputPosition);
                    } else if (quasiRandomVariableSpec instanceof RejectionQuasiRandomVariableSpec) {
                        RejectionQuasiRandomVariableSpec v = (RejectionQuasiRandomVariableSpec)quasiRandomVariableSpec;
                        if (v.accept(next, inputPosition)) {
                            this.currentValue[i] = v.compute(next, inputPosition);
                        } else {
                            this.rejectedCount[i] = this.rejectedCount[i] + 1L;
                            accepted = false;
                        }
                    } else {
                        throw new MatchError((Object)quasiRandomVariableSpec);
                    }
                    inputPosition += this.variables()[i].numInputs();
                }
            }
            ++this.generatedCount;
            return this.currentValue;
        }

        public final ProvidesTransformedQuasiMonteCarlo breeze$integrate$quasimontecarlo$ProvidesTransformedQuasiMonteCarlo$TransformedQuasiMonteCarloGenerator$$$outer() {
            return this.$outer;
        }
    }

    public interface TransformingQuasiRandomVariableSpec
    extends QuasiRandomVariableSpec {
        public double transform(double[] var1, int var2);
    }
}

