/*
 * Decompiled with CFR 0.152.
 */
package breeze.interpolation;

import breeze.generic.VariableUFunc;
import breeze.interpolation.package$UnivariateInterpolatorImpl$;
import breeze.linalg.Vector;
import breeze.math.Field;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.ScalaRunTime$;

public final class package {

    public static abstract class HandyUnivariateInterpolator<T>
    implements UnivariateInterpolator<T> {
        private final Object X;
        private final Object Y;
        private final Ordering<T> ord;

        public <T> HandyUnivariateInterpolator(Vector<T> x_coords, Vector<T> y_coords, ClassTag<T> evidence$1, Field<T> evidence$2, Ordering<T> evidence$3) {
            if (x_coords.size() != Predef$.MODULE$.genericWrapArray(x_coords.toArray(evidence$1)).toSet().size()) {
                throw new Exception("x coordinates must be unique");
            }
            if (x_coords.size() != y_coords.size()) {
                throw new Exception("x_coords and y_coords must be of the same size");
            }
            if (x_coords.size() == 0) {
                throw new Exception("need to provide at least one pair of coordinates");
            }
            Object object = Predef$.MODULE$.genericArrayOps(x_coords.toArray(evidence$1));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zip$extension(object, (IterableOnce)Predef$.MODULE$.genericWrapArray(y_coords.toArray(evidence$1))));
            Object[] nodes = (Tuple2[])ArrayOps$.MODULE$.sortBy$extension(object2, (Function1 & Serializable)n -> n._1(), evidence$3);
            Object object3 = Predef$.MODULE$.refArrayOps(nodes);
            this.X = ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)n -> n._1(), evidence$1);
            Object object4 = Predef$.MODULE$.refArrayOps(nodes);
            this.Y = ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)n -> n._2(), evidence$1);
            this.ord = (Ordering)Predef$.MODULE$.implicitly(evidence$3);
        }

        public Object X() {
            return this.X;
        }

        public Object Y() {
            return this.Y;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public T apply(T x) {
            T t;
            if (!this.ord.mkOrderingOps(x).$less(ScalaRunTime$.MODULE$.array_apply(this.X(), 0))) {
                Object object = Predef$.MODULE$.genericArrayOps(this.X());
                if (!this.ord.mkOrderingOps(x).$greater(ScalaRunTime$.MODULE$.array_apply(this.X(), ArrayOps$.MODULE$.size$extension(object) - 1))) {
                    t = this.interpolate(x);
                    return t;
                }
            }
            t = this.extrapolate(x);
            return t;
        }

        public abstract T interpolate(T var1);

        public T extrapolate(T x) {
            Object object = Predef$.MODULE$.genericArrayOps(this.X());
            throw new IndexOutOfBoundsException("Out of the domain [" + ScalaRunTime$.MODULE$.array_apply(this.X(), 0) + "," + ScalaRunTime$.MODULE$.array_apply(this.X(), ArrayOps$.MODULE$.size$extension(object) - 1) + "]");
        }

        public int bisearch(T x) {
            return this.bisearch(0, ScalaRunTime$.MODULE$.array_length(this.X()) - 1, x);
        }

        private int bisearch(int low, int high, T x) {
            int mid;
            HandyUnivariateInterpolator handyUnivariateInterpolator = this;
            int n = high;
            int n2 = low;
            while (true) {
                int n3;
                mid = n3 = (n2 + n) / 2;
                if (n2 == n) break;
                int mid2 = n3;
                if (handyUnivariateInterpolator.ord.mkOrderingOps(ScalaRunTime$.MODULE$.array_apply(handyUnivariateInterpolator.X(), mid2)).$less(x)) {
                    HandyUnivariateInterpolator handyUnivariateInterpolator2 = handyUnivariateInterpolator;
                    int n4 = mid2 + 1;
                    handyUnivariateInterpolator = handyUnivariateInterpolator2;
                    n2 = n4;
                    continue;
                }
                int mid3 = n3;
                HandyUnivariateInterpolator handyUnivariateInterpolator3 = handyUnivariateInterpolator;
                int n5 = mid3;
                handyUnivariateInterpolator = handyUnivariateInterpolator3;
                n = n5;
            }
            return mid;
        }
    }

    public static interface UnivariateInterpolator<T>
    extends VariableUFunc<package$UnivariateInterpolatorImpl$, UnivariateInterpolator<T>> {
        public T apply(T var1);
    }
}

