/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.linalg.BitVector$;
import breeze.linalg.DenseVector;
import breeze.linalg.Vector;
import breeze.linalg.support.CanMapKeyValuePairs;
import breeze.linalg.support.CanMapValues;
import breeze.linalg.support.CanTransformValues;
import breeze.linalg.support.CanTraverseKeyValuePairs;
import breeze.linalg.support.CanTraverseValues;
import breeze.linalg.support.ScalarOf;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.BitSet;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public class BitVector
implements Vector<Object> {
    private final BitSet data;
    private final int length;
    private final boolean enforceLength;

    public static CanTraverseValues canIterateValues() {
        return BitVector$.MODULE$.canIterateValues();
    }

    public static <V2> CanMapKeyValuePairs<BitVector, Object, Object, V2, DenseVector<V2>> canMapPairs(ClassTag<V2> classTag, Zero<V2> zero) {
        return BitVector$.MODULE$.canMapPairs(classTag, zero);
    }

    public static <V2> CanMapValues<BitVector, Object, V2, DenseVector<V2>> canMapValues(ClassTag<V2> classTag) {
        return BitVector$.MODULE$.canMapValues(classTag);
    }

    public static CanTransformValues canTransformValues() {
        return BitVector$.MODULE$.canTransformValues();
    }

    public static CanTraverseKeyValuePairs canTraverseKeyValuePairs() {
        return BitVector$.MODULE$.canTraverseKeyValuePairs();
    }

    public static BitVector ones(int n, boolean bl) {
        return BitVector$.MODULE$.ones(n, bl);
    }

    public static ScalarOf scalarOf() {
        return BitVector$.MODULE$.scalarOf();
    }

    public static BitVector zeros(int n, boolean bl) {
        return BitVector$.MODULE$.zeros(n, bl);
    }

    public static boolean apply$default$2() {
        return BitVector$.MODULE$.apply$default$2();
    }

    public static boolean ones$default$2() {
        return BitVector$.MODULE$.ones$default$2();
    }

    public static boolean zeros$default$2() {
        return BitVector$.MODULE$.zeros$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return BitVector$.MODULE$.$lessinit$greater$default$3();
    }

    public BitVector(BitSet data, int length, boolean enforceLength) {
        this.data = data;
        this.length = length;
        this.enforceLength = enforceLength;
    }

    public BitSet data() {
        return this.data;
    }

    @Override
    public int length() {
        return this.length;
    }

    public boolean enforceLength() {
        return this.enforceLength;
    }

    @Override
    public boolean apply(int i) {
        if (i < 0 || i >= this.length()) {
            throw new IndexOutOfBoundsException("" + i + " is not in the range [0, " + this.length() + ")");
        }
        return this.data().get(i);
    }

    @Override
    public void update(int i, boolean v) {
        if (i < 0 || i >= this.length()) {
            throw new IndexOutOfBoundsException("" + i + " is not in the range [0, " + this.length() + ")");
        }
        this.data().set(i, v);
    }

    @Override
    public int activeSize() {
        return this.data().cardinality();
    }

    @Override
    public Vector<Object> copy() {
        return new BitVector((BitSet)this.data().clone(), this.length(), BitVector$.MODULE$.$lessinit$greater$default$3());
    }

    @Override
    public BitVector repr() {
        return this;
    }

    @Override
    public Iterator<Object> activeKeysIterator() {
        int firstBit = this.data().nextSetBit(0);
        if (firstBit < 0) {
            return package$.MODULE$.Iterator().empty();
        }
        return new Iterator<Object>(firstBit, this){
            private boolean nextReady;
            private int _next;
            private final BitVector $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.nextReady = true;
                this._next = firstBit$1;
            }

            public boolean nextReady() {
                return this.nextReady;
            }

            public void nextReady_$eq(boolean x$1) {
                this.nextReady = x$1;
            }

            public int _next() {
                return this._next;
            }

            public void _next_$eq(int x$1) {
                this._next = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this._next() < 0) return false;
                if (this.nextReady()) return true;
                this._next_$eq(this._next() + 1);
                this._next_$eq(this.$outer.data().nextSetBit(this._next()));
                this.nextReady_$eq(this._next() >= 0);
                if (!this.nextReady()) return false;
                return true;
            }

            public int next() {
                if (!this.nextReady()) {
                    this.hasNext();
                    if (!this.nextReady()) {
                        throw new NoSuchElementException();
                    }
                }
                this.nextReady_$eq(false);
                return this._next();
            }
        };
    }

    @Override
    public Iterator<Object> activeValuesIterator() {
        return this.activeKeysIterator().map((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> true);
    }

    @Override
    public Iterator<Tuple2<Object, Object>> activeIterator() {
        return this.activeKeysIterator().map((Function1 & Serializable)_$2 -> BitVector.activeIterator$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$2)));
    }

    public boolean lengthsMatch(Vector<?> other) {
        BitVector x;
        Vector<?> vector;
        boolean bl = !this.enforceLength() ? true : ((vector = other) instanceof BitVector ? !(x = (BitVector)vector).enforceLength() || x.length() == this.length() : other.length() == this.length());
        return bl;
    }

    public String toString() {
        return this.activeKeysIterator().mkString("BitVector(", ", ", ")");
    }

    private static final /* synthetic */ Tuple2 activeIterator$$anonfun$1(int _$2) {
        Integer n = (Integer)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)_$2));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)n, (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

