/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.CSCMatrix$;
import breeze.linalg.CSCMatrix$Builder$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Matrix;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.View;
import breeze.linalg.View$Copy$;
import breeze.linalg.View$Prefer$;
import breeze.linalg.View$Require$;
import breeze.linalg.support.CanCreateZeros;
import breeze.math.Semiring;
import breeze.stats.distributions.Rand;
import breeze.storage.Zero;
import breeze.util.ArrayBuilder;
import breeze.util.ArrayBuilder$;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import breeze.util.Sorting$;
import breeze.util.Terminal$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public class CSCMatrix<V>
implements Matrix<V>,
Serializable {
    private Object _data;
    private final int rows;
    private final int cols;
    private final int[] colPtrs;
    private int used;
    private int[] _rowIndices;
    private final Zero<V> evidence$1;

    public static <T> CanCreateZeros<CSCMatrix<T>, Tuple2<Object, Object>> canCreateZeros(ClassTag<T> classTag, Zero<T> zero) {
        return CSCMatrix$.MODULE$.canCreateZeros((ClassTag)classTag, (Zero)zero);
    }

    public static UFunc.UImpl canDim() {
        return CSCMatrix$.MODULE$.canDim();
    }

    public static <V> CSCMatrix<V> create(int n, int n2, Object object, Zero<V> zero) {
        return CSCMatrix$.MODULE$.create(n, n2, object, (Zero)zero);
    }

    public static Matrix fill(int n, int n2, Function0 function0, ClassTag classTag, Zero zero) {
        return CSCMatrix$.MODULE$.fill(n, n2, function0, classTag, zero);
    }

    public static Matrix ones(int n, int n2, ClassTag classTag, Zero zero, Semiring semiring) {
        return CSCMatrix$.MODULE$.ones(n, n2, classTag, zero, semiring);
    }

    public static Matrix rand(int n, int n2, Rand rand, ClassTag classTag, Zero zero) {
        return CSCMatrix$.MODULE$.rand(n, n2, rand, classTag, zero);
    }

    public static Matrix tabulate(int n, int n2, Function2 function2, ClassTag classTag, Zero zero) {
        return CSCMatrix$.MODULE$.tabulate(n, n2, function2, classTag, zero);
    }

    public static <V> CSCMatrix<V> zeros(int n, int n2, ClassTag<V> classTag, Zero<V> zero) {
        return CSCMatrix$.MODULE$.zeros(n, n2, (ClassTag)classTag, (Zero)zero);
    }

    public static <V> CSCMatrix<V> zeros(int n, int n2, int n3, ClassTag<V> classTag, Zero<V> zero) {
        return CSCMatrix$.MODULE$.zeros(n, n2, n3, classTag, zero);
    }

    public static Rand rand$default$3() {
        return CSCMatrix$.MODULE$.rand$default$3();
    }

    public <V> CSCMatrix(Object _data, int rows, int cols, int[] colPtrs, int used, int[] _rowIndices, Zero<V> evidence$1) {
        this._data = _data;
        this.rows = rows;
        this.cols = cols;
        this.colPtrs = colPtrs;
        this.used = used;
        this._rowIndices = _rowIndices;
        this.evidence$1 = evidence$1;
        CSCMatrix$.MODULE$.breeze$linalg$CSCMatrix$$$init();
    }

    private Object _data() {
        return this._data;
    }

    private void _data_$eq(Object x$0) {
        this._data = x$0;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    public int[] colPtrs() {
        return this.colPtrs;
    }

    public int used() {
        return this.used;
    }

    public void used_$eq(int x$1) {
        this.used = x$1;
    }

    private int[] _rowIndices() {
        return this._rowIndices;
    }

    private void _rowIndices_$eq(int[] x$0) {
        this._rowIndices = x$0;
    }

    public <V> CSCMatrix(Object data, int rows, int cols, int[] colPtrs, int[] rowIndices, Zero<V> evidence$1) {
        this(data, rows, cols, colPtrs, ScalaRunTime$.MODULE$.array_length(data), rowIndices, evidence$1);
    }

    public int[] rowIndices() {
        return this._rowIndices();
    }

    public Object data() {
        return this._data();
    }

    @Override
    public V apply(int row, int col) {
        if (row >= this.rows() || col >= this.cols() || row < 0 || col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ind = this.locate(row, col);
        return (V)(ind < 0 ? this.zero() : ScalaRunTime$.MODULE$.array_apply(this.data(), ind));
    }

    @Override
    public void update(int row, int col, V v) {
        if (row >= this.rows() || col >= this.cols() || row < 0 || col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ind = this.locate(row, col);
        if (ind >= 0) {
            ScalaRunTime$.MODULE$.array_update(this.data(), ind, v);
        } else if (!BoxesRunTime.equals(v, this.zero())) {
            int insertPos = ~ind;
            this.used_$eq(this.used() + 1);
            if (this.used() > ScalaRunTime$.MODULE$.array_length(this.data())) {
                int newLength = ScalaRunTime$.MODULE$.array_length(this.data()) == 0 ? 4 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 1024 ? ScalaRunTime$.MODULE$.array_length(this.data()) * 2 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 2048 ? ScalaRunTime$.MODULE$.array_length(this.data()) + 1024 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 4096 ? ScalaRunTime$.MODULE$.array_length(this.data()) + 2048 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 8192 ? ScalaRunTime$.MODULE$.array_length(this.data()) + 4096 : (ScalaRunTime$.MODULE$.array_length(this.data()) < 16384 ? ScalaRunTime$.MODULE$.array_length(this.data()) + 8192 : ScalaRunTime$.MODULE$.array_length(this.data()) + 16384)))));
                int[] newIndex = Arrays.copyOf(this.rowIndices(), newLength);
                Object newData = ArrayUtil$.MODULE$.copyOf(this.data(), newLength);
                System.arraycopy(this._rowIndices(), insertPos, newIndex, insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data(), insertPos, newData, insertPos + 1, this.used() - insertPos - 1);
                this._rowIndices_$eq(newIndex);
                this._data_$eq(newData);
            } else if (this.used() - insertPos > 1) {
                System.arraycopy(this._rowIndices(), insertPos, this._rowIndices(), insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data(), insertPos, this.data(), insertPos + 1, this.used() - insertPos - 1);
            }
            this.rowIndices()[insertPos] = row;
            ScalaRunTime$.MODULE$.array_update(this.data(), insertPos, v);
            int i = col + 1;
            int yy = this.cols();
            while (i <= this.cols()) {
                int n = i++;
                this.colPtrs()[n] = this.colPtrs()[n] + 1;
            }
        }
    }

    public void reserve(int nnz) {
        if (nnz >= this.used() && nnz != this.rowIndices().length) {
            this._rowIndices_$eq(Arrays.copyOf(this.rowIndices(), nnz));
            this._data_$eq(ArrayUtil$.MODULE$.copyOf(this.data(), nnz));
        }
    }

    public void compact() {
        this.reserve(this.used());
    }

    @Override
    public Iterator<Tuple2<Object, Object>> activeKeysIterator() {
        return package$.MODULE$.Iterator().range(0, this.cols()).flatMap((Function1 & Serializable)c -> this.activeKeysIterator$$anonfun$3(BoxesRunTime.unboxToInt((Object)c)));
    }

    @Override
    public Iterator<Tuple2<Tuple2<Object, Object>, V>> activeIterator() {
        return package$.MODULE$.Iterator().range(0, this.cols()).flatMap((Function1 & Serializable)c -> this.activeIterator$$anonfun$3(BoxesRunTime.unboxToInt((Object)c)));
    }

    @Override
    public Iterator<V> activeValuesIterator() {
        Object object = Predef$.MODULE$.genericArrayOps(this.data());
        return ArrayOps$.MODULE$.iterator$extension(object).take(this.used());
    }

    @Override
    public int activeSize() {
        return this.used();
    }

    @Override
    public CSCMatrix<V> repr() {
        return this;
    }

    private int locate(int row, int col) {
        int start = this.colPtrs()[col];
        int end = this.colPtrs()[col + 1];
        return Arrays.binarySearch(this.rowIndices(), start, end, row);
    }

    public V zero() {
        return (V)((Zero)Predef$.MODULE$.implicitly(this.evidence$1)).zero();
    }

    @Override
    public String toString(int maxLines, int maxWidth) {
        StringBuilder buf = new StringBuilder();
        buf.$plus$plus$eq(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%d x %d CSCMatrix"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.rows()), BoxesRunTime.boxToInteger((int)this.cols())})));
        this.activeIterator().take(maxLines - 1).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                throw new MatchError((Object)tuple22);
            }
            int r = BoxesRunTime.unboxToInt((Object)tuple2._1());
            int c = BoxesRunTime.unboxToInt((Object)tuple2._2());
            Object v = tuple22._2();
            buf.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\n'));
            buf.$plus$plus$eq(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("(%d,%d) "), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)r), BoxesRunTime.boxToInteger((int)c)})));
            return buf.$plus$plus$eq(v.toString());
        });
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(Terminal$.MODULE$.terminalHeight() - 3, this.toString$default$2());
    }

    public void use(CSCMatrix<V> matrix) {
        this.use(matrix.data(), matrix.colPtrs(), matrix.rowIndices(), matrix.used());
    }

    public void use(Object data, int[] colPtrs, int[] rowIndices, int used) {
        if (colPtrs.length != this.colPtrs().length) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"colPtrs.length.==(this.colPtrs.length)"})));
        }
        if (used < 0) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"used.>=(0)"})));
        }
        if (ScalaRunTime$.MODULE$.array_length(data) < used) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"data.length.>=(used)"})));
        }
        if (rowIndices.length < used) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"rowIndices.length.>=(used)"})));
        }
        this._data_$eq(data);
        System.arraycopy(colPtrs, 0, this.colPtrs(), 0, colPtrs.length);
        this._rowIndices_$eq(rowIndices);
        this.used_$eq(used);
    }

    @Override
    public CSCMatrix<V> copy() {
        return new CSCMatrix<V>(ArrayUtil$.MODULE$.copyOf(this._data(), this.activeSize()), this.rows(), this.cols(), (int[])this.colPtrs().clone(), this.activeSize(), (int[])this._rowIndices().clone(), this.evidence$1);
    }

    @Override
    public SparseVector<V> flatten(View view) {
        SparseVector sparseVector;
        View view2 = view;
        if (View$Require$.MODULE$.equals(view2)) {
            int[] indices = new int[ScalaRunTime$.MODULE$.array_length(this.data())];
            int ind = 0;
            for (int j = 0; j < this.cols(); ++j) {
                int ip = this.colPtrs()[j];
                while (ip < this.colPtrs()[j + 1]) {
                    int i = this.rowIndices()[ip];
                    indices[ind] = i * this.rows() + j;
                    ++ip;
                    ++ind;
                }
            }
            sparseVector = new SparseVector<V>(indices, this.data(), this.activeSize(), this.rows() * this.cols(), this.evidence$1);
        } else if (View$Copy$.MODULE$.equals(view2)) {
            ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
            SparseVector sv = SparseVector$.MODULE$.zeros(this.rows() * this.cols(), man, this.evidence$1);
            for (int j = 0; j < this.cols(); ++j) {
                for (int ip = this.colPtrs()[j]; ip < this.colPtrs()[j + 1]; ++ip) {
                    int i = this.rowIndices()[ip];
                    sv.update(i * this.cols() + j, ScalaRunTime$.MODULE$.array_apply(this.data(), ip));
                }
            }
            sparseVector = sv;
        } else if (View$Prefer$.MODULE$.equals(view2)) {
            sparseVector = this.flatten(View$Require$.MODULE$);
        } else {
            throw new MatchError((Object)view2);
        }
        return sparseVector;
    }

    @Override
    public View flatten$default$1() {
        return View$Copy$.MODULE$;
    }

    @Override
    public DenseMatrix<V> toDenseMatrix(ClassTag<V> cm, Zero<V> zero) {
        return this.toDense();
    }

    /*
     * WARNING - void declaration
     */
    public DenseMatrix<V> toDense() {
        void var2_2;
        ClassTag ctg = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        Matrix res = DenseMatrix$.MODULE$.zeros(this.rows(), this.cols(), ctg, (Zero)this.evidence$1);
        for (int i = 0; i < this.cols(); ++i) {
            for (int j = this.colPtrs()[i]; j < this.colPtrs()[i + 1]; ++j) {
                ((DenseMatrix)res).update(this.rowIndices()[j], i, ScalaRunTime$.MODULE$.array_apply(this.data(), j));
            }
        }
        return var2_2;
    }

    @Override
    public boolean equals(Object p1) {
        Object object = p1;
        if (object instanceof CSCMatrix) {
            CSCMatrix y = (CSCMatrix)object;
            if (this.rows() != y.rows() || this.cols() != y.cols()) {
                return false;
            }
            Iterator<Tuple2<Tuple2<Object, Object>, V>> xIter = this.activeIterator();
            Iterator<Tuple2<Tuple2<Object, Object>, V>> yIter = y.activeIterator();
            while (xIter.hasNext() && yIter.hasNext()) {
                Tuple2 xkeyval = (Tuple2)xIter.next();
                Tuple2 ykeyval = (Tuple2)yIter.next();
                while (BoxesRunTime.equals((Object)xkeyval._2(), (Object)BoxesRunTime.boxToInteger((int)0)) && xIter.hasNext()) {
                    xkeyval = (Tuple2)xIter.next();
                }
                while (BoxesRunTime.equals((Object)ykeyval._2(), (Object)BoxesRunTime.boxToInteger((int)0)) && yIter.hasNext()) {
                    ykeyval = (Tuple2)yIter.next();
                }
                Tuple2 tuple2 = xkeyval;
                Tuple2 tuple22 = ykeyval;
                if (!(tuple2 == null ? tuple22 != null : !tuple2.equals(tuple22))) continue;
                return false;
            }
            if (xIter.hasNext() && !yIter.hasNext()) {
                while (xIter.hasNext()) {
                    if (BoxesRunTime.equals((Object)((Tuple2)xIter.next())._2(), (Object)BoxesRunTime.boxToInteger((int)0))) continue;
                    return false;
                }
            }
            if (!xIter.hasNext() && yIter.hasNext()) {
                while (yIter.hasNext()) {
                    if (BoxesRunTime.equals((Object)((Tuple2)yIter.next())._2(), (Object)BoxesRunTime.boxToInteger((int)0))) continue;
                    return false;
                }
            }
            return true;
        }
        if (object instanceof Matrix) {
            Matrix y;
            Matrix matrix = y = (Matrix)object;
            CSCMatrix cSCMatrix = this;
            return !(matrix != null ? !((Object)matrix).equals(cSCMatrix) : cSCMatrix != null);
        }
        return false;
    }

    private final /* synthetic */ Tuple2 activeKeysIterator$$anonfun$1$$anonfun$1(int c$1, int rr) {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.rowIndices()[rr]), (Object)BoxesRunTime.boxToInteger((int)c$1));
    }

    private final /* synthetic */ IterableOnce activeKeysIterator$$anonfun$3(int c) {
        return package$.MODULE$.Iterator().range(this.colPtrs()[c], this.colPtrs()[c + 1]).map((Function1 & Serializable)rr -> this.activeKeysIterator$$anonfun$1$$anonfun$1(c, BoxesRunTime.unboxToInt((Object)rr)));
    }

    private final /* synthetic */ Tuple2 activeIterator$$anonfun$1$$anonfun$1(int c$2, int rr) {
        Tuple2 tuple2 = (Tuple2)Predef$.MODULE$.ArrowAssoc((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.rowIndices()[rr]), (Object)BoxesRunTime.boxToInteger((int)c$2)));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)tuple2, ScalaRunTime$.MODULE$.array_apply(this.data(), rr));
    }

    private final /* synthetic */ IterableOnce activeIterator$$anonfun$3(int c) {
        return package$.MODULE$.Iterator().range(this.colPtrs()[c], this.colPtrs()[c + 1]).map((Function1 & Serializable)rr -> this.activeIterator$$anonfun$1$$anonfun$1(c, BoxesRunTime.unboxToInt((Object)rr)));
    }

    public static class Builder<T> {
        private final int rows;
        private final int cols;
        private final ClassTag<T> evidence$7;
        private final Semiring<T> evidence$8;
        private final Zero<T> evidence$9;
        private final ArrayBuilder.ofLong indices;
        private final ArrayBuilder<T> vs;
        private int numAdded;

        public static <T> Builder<T> fromMatrix(CSCMatrix<T> cSCMatrix, ClassTag<T> classTag, Semiring<T> semiring, Zero<T> zero) {
            return CSCMatrix$Builder$.MODULE$.fromMatrix(cSCMatrix, classTag, semiring, zero);
        }

        public static int $lessinit$greater$default$3() {
            return CSCMatrix$Builder$.MODULE$.$lessinit$greater$default$3();
        }

        public <T> Builder(int rows, int cols, int initNnz, ClassTag<T> evidence$7, Semiring<T> evidence$8, Zero<T> evidence$9) {
            this.rows = rows;
            this.cols = cols;
            this.evidence$7 = evidence$7;
            this.evidence$8 = evidence$8;
            this.evidence$9 = evidence$9;
            this.indices = new ArrayBuilder.ofLong();
            this.vs = ArrayBuilder$.MODULE$.make(evidence$7);
            this.numAdded = 0;
        }

        public int rows() {
            return this.rows;
        }

        public int cols() {
            return this.cols;
        }

        private Semiring<T> ring() {
            return (Semiring)Predef$.MODULE$.implicitly(this.evidence$8);
        }

        public void add(int r, int c, T v) {
            if (!BoxesRunTime.equals(v, this.ring().zero())) {
                ++this.numAdded;
                this.vs.$plus$eq(v);
                this.indices.$plus$eq((Object)BoxesRunTime.boxToLong((long)((long)c << 32 | (long)r & 0xFFFFFFFFL)));
            }
        }

        public int activeSize() {
            return this.numAdded;
        }

        public void sizeHint(int nnz) {
            this.indices.sizeHint(nnz);
            this.vs.sizeHint(nnz);
        }

        public CSCMatrix<T> result() {
            return this.result(false, false);
        }

        private int rowFromIndex(long idx) {
            return (int)idx;
        }

        private int colFromIndex(long idx) {
            return (int)(idx >>> 32);
        }

        public CSCMatrix<T> result(boolean keysAlreadyUnique, boolean keysAlreadySorted) {
            int n;
            int _rows;
            int n2;
            long[] indices = this.indices.result();
            Object vs = this.vs.result();
            int nnz = indices.length;
            if (this.rows() >= 0) {
                n2 = this.rows();
            } else {
                Object object = Predef$.MODULE$.longArrayOps(indices);
                Object object2 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcIJ.sp & Serializable)idx -> this.rowFromIndex(idx), ClassTag$.MODULE$.apply(Integer.TYPE)));
                n2 = _rows = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.foldLeft$extension(object2, (Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(_$2, _$3) -> RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(_$2), _$3))) + 1;
            }
            if (this.cols() >= 0) {
                n = this.cols();
            } else {
                Object object = Predef$.MODULE$.longArrayOps(indices);
                Object object3 = Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(object, (Function1)(JFunction1.mcIJ.sp & Serializable)idx -> this.colFromIndex(idx), ClassTag$.MODULE$.apply(Integer.TYPE)));
                n = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.foldLeft$extension(object3, (Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(_$4, _$5) -> RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(_$4), _$5))) + 1;
            }
            int _cols = n;
            int[] outCols = new int[_cols + 1];
            if (nnz == 0) {
                return new CSCMatrix<T>(vs, _rows, _cols, outCols, 0, new int[0], this.evidence$9);
            }
            Sorting$.MODULE$.indirectSort(indices, vs, 0, nnz);
            int[] outRows = new int[nnz];
            Object outData = Arrays$.MODULE$.newGenericArray(nnz, this.evidence$7);
            outRows[0] = this.rowFromIndex(indices[0]);
            ScalaRunTime$.MODULE$.array_update(outData, 0, ScalaRunTime$.MODULE$.array_apply(vs, 0));
            int outDataIndex = 0;
            int lastCol = this.colFromIndex(indices[0]);
            for (int i = 1; i < nnz; ++i) {
                long index = indices[i];
                int col = this.colFromIndex(index);
                if (this.cols() >= 0 && col >= this.cols()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"" + ("Column index " + col + " is out of bounds for number of columns " + this.cols() + "!") + ": " + "Builder.this.cols.<(0).||(col.<(Builder.this.cols))"})));
                }
                boolean colsEqual = col == lastCol;
                int row = this.rowFromIndex(index);
                if (this.rows() >= 0 && row >= this.rows()) {
                    throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"" + ("Row index " + row + " is out of bounds for number of rows " + this.rows() + "!") + ": " + "Builder.this.rows.<(0).||(row.<(Builder.this.rows))"})));
                }
                if (colsEqual && row == this.rowFromIndex(indices[i - 1])) {
                    if (keysAlreadyUnique) {
                        throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"keysAlreadyUnique.unary_!"})));
                    }
                    ScalaRunTime$.MODULE$.array_update(outData, outDataIndex, this.ring().$plus(ScalaRunTime$.MODULE$.array_apply(outData, outDataIndex), ScalaRunTime$.MODULE$.array_apply(vs, i)));
                } else {
                    outRows[++outDataIndex] = row;
                    ScalaRunTime$.MODULE$.array_update(outData, outDataIndex, ScalaRunTime$.MODULE$.array_apply(vs, i));
                }
                if (colsEqual) continue;
                while (lastCol < col) {
                    outCols[lastCol + 1] = outDataIndex;
                    ++lastCol;
                }
            }
            if (keysAlreadyUnique && ++outDataIndex != nnz) {
                throw new AssertionError((Object)StringOps$.MODULE$.format$extension("assertion failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"outDataIndex.==(nnz)"})));
            }
            while (lastCol < _cols) {
                outCols[lastCol + 1] = outDataIndex;
                ++lastCol;
            }
            CSCMatrix<T> out = new CSCMatrix<T>(outData, _rows, _cols, outCols, outDataIndex, outRows, this.evidence$9);
            if (!keysAlreadyUnique) {
                out.compact();
            }
            return out;
        }

        public boolean result$default$1() {
            return false;
        }

        public boolean result$default$2() {
            return false;
        }
    }
}

