/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.collection.mutable.SparseArray;
import breeze.generic.UFunc;
import breeze.linalg.CSCMatrix;
import breeze.linalg.SparseVector;
import breeze.linalg.Vector;
import breeze.linalg.VectorBuilder;
import breeze.linalg.VectorBuilder$;
import breeze.linalg.dim$;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.operators.OpDiv$;
import breeze.linalg.support.CanCreateZeros;
import breeze.linalg.support.CanCreateZerosLike;
import breeze.linalg.support.CanMapKeyValuePairs;
import breeze.linalg.support.CanMapValues;
import breeze.linalg.support.CanTransformValues;
import breeze.linalg.support.CanTraverseKeyValuePairs;
import breeze.linalg.support.ScalarOf;
import breeze.linalg.support.ScalarOf$;
import breeze.math.Field;
import breeze.math.MutableFiniteCoordinateField;
import breeze.math.MutableFiniteCoordinateField$;
import breeze.math.Ring;
import breeze.math.Semiring;
import breeze.storage.Zero;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.NotGiven$;

public final class SparseVector$
implements Serializable {
    public static final SparseVector$ MODULE$ = new SparseVector$();

    private SparseVector$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SparseVector$.class);
    }

    public <V> SparseVector<V> zeros(int size, ClassTag<V> evidence$1, Zero<V> evidence$2) {
        return new SparseVector<V>((int[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Integer.TYPE)), Array$.MODULE$.empty(evidence$1), 0, size, evidence$2);
    }

    public <V> SparseVector<V> apply(Object values, Zero<V> evidence$3) {
        return new SparseVector<V>(Array$.MODULE$.range(0, ScalaRunTime$.MODULE$.array_length(values)), values, ScalaRunTime$.MODULE$.array_length(values), ScalaRunTime$.MODULE$.array_length(values), evidence$3);
    }

    public <V> SparseVector<V> apply(Seq<V> values, ClassTag<V> evidence$4, Zero<V> evidence$5) {
        return this.apply(values.toArray(evidence$4), evidence$5);
    }

    public <V> SparseVector<V> fill(int size, Function0<V> v, ClassTag<V> evidence$6, Zero<V> evidence$7) {
        return this.apply(Array$.MODULE$.fill(size, v, evidence$6), evidence$7);
    }

    public <V> SparseVector<V> tabulate(int size, Function1<Object, V> f, ClassTag<V> evidence$8, Zero<V> evidence$9) {
        return this.apply(Array$.MODULE$.tabulate(size, f, evidence$8), evidence$9);
    }

    public <V> SparseVector<V> apply(int length, Seq<Tuple2<Object, V>> values, ClassTag<V> evidence$10, Zero<V> evidence$11, Semiring<V> evidence$12) {
        VectorBuilder b = new VectorBuilder(length, VectorBuilder$.MODULE$.$lessinit$greater$default$2(), evidence$12, evidence$10);
        values.withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Object v = tuple2._2();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
            Object v = tuple2._2();
            b.add(i, v);
        });
        return b.toSparseVector();
    }

    public <V> SparseVector<V> vertcat(Seq<SparseVector<V>> vectors, Zero<V> evidence$13, ClassTag<V> evidence$14) {
        SparseArray resultArray = (SparseArray)((IterableOnceOps)vectors.map((Function1 & Serializable)_$1 -> _$1.array())).foldLeft(new SparseArray<V>(0, evidence$14, evidence$13), (Function2 & Serializable)(_$2, _$3) -> _$2.concatenate(_$3, evidence$14));
        return new SparseVector<V>(resultArray, evidence$13);
    }

    public <V> CSCMatrix<V> horzcat(Seq<SparseVector<V>> vectors, Zero<V> evidence$15, ClassTag<V> evidence$16) {
        if (!vectors.forall((Function1 & Serializable)_$4 -> _$4.size() == ((Vector)vectors.apply(0)).size())) {
            throw new IllegalArgumentException("vector lengths must be equal, but got: " + ((IterableOnceOps)vectors.map((Function1 & Serializable)_$5 -> _$5.length())).mkString(", "));
        }
        int rows = ((SparseVector)vectors.apply(0)).length();
        int cols = vectors.length();
        Object data = Arrays$.MODULE$.newGenericArray(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)vectors.map((Function1 & Serializable)_$6 -> _$6.activeSize())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), evidence$16);
        int[] rowIndices = new int[ScalaRunTime$.MODULE$.array_length(data)];
        int[] colPtrs = new int[vectors.length() + 1];
        int used = ScalaRunTime$.MODULE$.array_length(data);
        int off = 0;
        for (int vec = 0; vec < vectors.length(); ++vec) {
            colPtrs[vec] = off;
            System.arraycopy(((SparseVector)vectors.apply(vec)).data(), 0, data, off, ((SparseVector)vectors.apply(vec)).activeSize());
            System.arraycopy(((SparseVector)vectors.apply(vec)).index(), 0, rowIndices, off, ((SparseVector)vectors.apply(vec)).activeSize());
            off += ((SparseVector)vectors.apply(vec)).activeSize();
        }
        colPtrs[vec] = off;
        return new CSCMatrix<V>(data, rows, cols, colPtrs, used, rowIndices, evidence$15);
    }

    public <V> SparseVector.CanCopySparseVector<V> canCopySparse(ClassTag<V> evidence$19, Zero<V> evidence$20) {
        return new SparseVector.CanCopySparseVector<V>(evidence$19, evidence$20);
    }

    public <V, V2> CanMapValues<SparseVector<V>, V, V2, SparseVector<V2>> canMapValues(ClassTag<V2> evidence$21, Zero<V2> evidence$22) {
        return new CanMapValues<SparseVector<V>, V, V2, SparseVector<V2>>(evidence$21, evidence$22){
            private final ClassTag evidence$21$1;
            private final Zero evidence$22$1;
            {
                this.evidence$21$1 = evidence$21$2;
                this.evidence$22$1 = evidence$22$2;
            }

            public SparseVector map(SparseVector from, Function1 fn) {
                return SparseVector$.MODULE$.tabulate(from.length(), arg_0 -> SparseVector$.breeze$linalg$SparseVector$$anon$1$$_$map$$anonfun$adapted$1(from, fn, arg_0), this.evidence$21$1, this.evidence$22$1);
            }

            public SparseVector mapActive(SparseVector from, Function1 fn) {
                Object out = Arrays$.MODULE$.newGenericArray(from.activeSize(), this.evidence$21$1);
                int i = 0;
                int yy = from.activeSize();
                while (i < from.activeSize()) {
                    int n = i++;
                    ScalaRunTime$.MODULE$.array_update(out, n, fn.apply(ScalaRunTime$.MODULE$.array_apply(from.data(), n)));
                }
                Object object = Predef$.MODULE$.intArrayOps(from.index());
                return new SparseVector<V>((int[])ArrayOps$.MODULE$.take$extension(object, from.activeSize()), out, from.activeSize(), from.length(), this.evidence$22$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$SparseVector$$anon$1$$_$map$$anonfun$adapted$1(breeze.linalg.SparseVector scala.Function1 java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <V> CanTraverseKeyValuePairs<SparseVector<V>, Object, V> canTraverseKeyValuePairs() {
        return new CanTraverseKeyValuePairs<SparseVector<V>, Object, V>(){

            public boolean isTraversableAgain(SparseVector from) {
                return true;
            }

            public void traverse(SparseVector from, CanTraverseKeyValuePairs.KeyValuePairsVisitor fn) {
                fn.visitArray(Predef$.MODULE$.wrapIntArray(from.index()), from.data(), 0, from.activeSize(), 1);
                if (from.activeSize() != from.size()) {
                    fn.zeros(from.size() - from.activeSize(), package$.MODULE$.Iterator().range(0, from.size()).filterNot((Function1)((JFunction1.mcZI.sp & Serializable)arg_0 -> SparseVector$.breeze$linalg$SparseVector$$anon$2$$_$traverse$$anonfun$1(from, arg_0))), from.default());
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$SparseVector$$anon$2$$_$traverse$$anonfun$1(breeze.linalg.SparseVector int )}, serializedLambda);
            }
        };
    }

    public <V> CanCreateZeros<SparseVector<V>, Object> canCreateZeros(ClassTag<V> evidence$23, Zero<V> evidence$24) {
        return new CanCreateZeros<SparseVector<V>, Object>(evidence$23, evidence$24){
            private final ClassTag evidence$23$1;
            private final Zero evidence$24$1;
            {
                this.evidence$23$1 = evidence$23$2;
                this.evidence$24$1 = evidence$24$2;
            }

            public SparseVector apply(int d) {
                return SparseVector$.MODULE$.zeros(d, this.evidence$23$1, this.evidence$24$1);
            }
        };
    }

    public <V> CanCreateZerosLike<SparseVector<V>, SparseVector<V>> canCreateZerosLike(ClassTag<V> evidence$25, Zero<V> evidence$26) {
        return new CanCreateZerosLike<SparseVector<V>, SparseVector<V>>(evidence$25, evidence$26){
            private final ClassTag evidence$25$1;
            private final Zero evidence$26$1;
            {
                this.evidence$25$1 = evidence$25$2;
                this.evidence$26$1 = evidence$26$2;
            }

            public SparseVector apply(SparseVector d) {
                return SparseVector$.MODULE$.zeros(d.length(), this.evidence$25$1, this.evidence$26$1);
            }
        };
    }

    public <V> CanTransformValues<SparseVector<V>, V> canTransformValues(Zero<V> evidence$27, ClassTag<V> evidence$28) {
        return new CanTransformValues<SparseVector<V>, V>(evidence$27, evidence$28){
            private final ClassTag evidence$28$1;
            private final Zero z;
            {
                this.evidence$28$1 = evidence$28$1;
                this.z = (Zero)Predef$.MODULE$.implicitly((Object)evidence$27$1);
            }

            public Zero z() {
                return this.z;
            }

            public void transform(SparseVector from, Function1 fn) {
                ArrayBuilder newData = ArrayBuilder$.MODULE$.make(this.evidence$28$1);
                ArrayBuilder newIndex = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
                int used = 0;
                for (int i = 0; i < from.length(); ++i) {
                    Object vv;
                    Object object = vv = fn.apply(from.apply(i));
                    Zero zero = this.z();
                    if (!(object == null ? zero != null : !object.equals(zero))) continue;
                    newData.$plus$eq(vv);
                    newIndex.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                    ++used;
                }
                from.array().use((int[])newIndex.result(), newData.result(), used);
            }

            public void transformActive(SparseVector from, Function1 fn) {
                for (int i = 0; i < from.activeSize(); ++i) {
                    ScalaRunTime$.MODULE$.array_update(from.data(), i, fn.apply(ScalaRunTime$.MODULE$.array_apply(from.data(), i)));
                }
            }
        };
    }

    public <V, V2> CanMapKeyValuePairs<SparseVector<V>, Object, V, V2, SparseVector<V2>> canMapPairs(ClassTag<V2> evidence$29, Zero<V2> evidence$30) {
        return new CanMapKeyValuePairs<SparseVector<V>, Object, V, V2, SparseVector<V2>>(evidence$29, evidence$30){
            private final ClassTag evidence$29$1;
            private final Zero evidence$30$1;
            {
                this.evidence$29$1 = evidence$29$2;
                this.evidence$30$1 = evidence$30$2;
            }

            public SparseVector map(SparseVector from, Function2 fn) {
                return SparseVector$.MODULE$.tabulate(from.length(), arg_0 -> SparseVector$.breeze$linalg$SparseVector$$anon$6$$_$map$$anonfun$adapted$2(from, fn, arg_0), this.evidence$29$1, this.evidence$30$1);
            }

            public SparseVector mapActive(SparseVector from, Function2 fn) {
                Object out = Arrays$.MODULE$.newGenericArray(from.used(), this.evidence$29$1);
                for (int i = 0; i < from.used(); ++i) {
                    ScalaRunTime$.MODULE$.array_update(out, i, fn.apply((Object)BoxesRunTime.boxToInteger((int)from.index()[i]), ScalaRunTime$.MODULE$.array_apply(from.data(), i)));
                }
                Object object = Predef$.MODULE$.intArrayOps(from.index());
                return new SparseVector<V>((int[])ArrayOps$.MODULE$.take$extension(object, from.used()), out, from.used(), from.length(), this.evidence$30$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{breeze$linalg$SparseVector$$anon$6$$_$map$$anonfun$adapted$2(breeze.linalg.SparseVector scala.Function2 java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <E> UFunc.UImpl<dim$, SparseVector<E>, Object> canDim() {
        return new UFunc.UImpl<dim$, SparseVector<E>, Object>(){

            public int apply(SparseVector v) {
                return v.size();
            }
        };
    }

    public <E> MutableFiniteCoordinateField<SparseVector<E>, Object, E> space(Field<E> evidence$31, ClassTag<E> evidence$32, Zero<E> evidence$33) {
        return MutableFiniteCoordinateField$.MODULE$.make(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_SV(), norm$.MODULE$.scalarNorm(evidence$31)), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.canIterateValues_SV(), norm$.MODULE$.scalarNorm(evidence$31))), evidence$31, HasOps$.MODULE$.impl_OpAdd_SV_S_eq_SV_Generic(evidence$31), HasOps$.MODULE$.impl_OpSub_SV_S_eq_SV_Generic(evidence$31), HasOps$.MODULE$.impl_Op_SV_SV_eq_SV_Generic_OpMulScalar(evidence$31), HasOps$.MODULE$.impl_Op_SV_SV_eq_SV_Generic(OpDiv$.MODULE$.opDivFromField(evidence$31), evidence$31), this.canCopySparse(evidence$32, evidence$33), HasOps$.MODULE$.castUpdateOps_V_S(this.scalarOf(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.value(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_V_S_Generic_OpMulScalar(evidence$31, (ClassTag)evidence$32)), HasOps$.MODULE$.castUpdateOps_V_S(this.scalarOf(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.value(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_V_S_Generic_OpDiv(evidence$31, (ClassTag)evidence$32)), HasOps$.MODULE$.impl_OpAdd_InPlace_T_U_Generic_from_scaleAdd_InPlace(HasOps$.MODULE$.impl_scaleAdd_SV_S_SV_InPlace_Generic(evidence$31, (ClassTag)evidence$32), evidence$31), HasOps$.MODULE$.impl_OpSub_InPlace_T_U_Generic_from_scaleAdd_InPlace(HasOps$.MODULE$.impl_scaleAdd_SV_S_SV_InPlace_Generic(evidence$31, (ClassTag)evidence$32), evidence$31), HasOps$.MODULE$.castUpdateOps_V_S(this.scalarOf(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.value(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_V_S_Generic_OpAdd(evidence$31, (ClassTag)evidence$32)), HasOps$.MODULE$.castUpdateOps_V_S(this.scalarOf(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.value(), (UFunc.InPlaceImpl2)HasOps$.MODULE$.impl_Op_InPlace_V_S_Generic_OpSub(evidence$31, (ClassTag)evidence$32)), HasOps$.MODULE$.castUpdateOps_V_V((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.value(), HasOps$.MODULE$.impl_OpMulScalar_InPlace_V_V_Generic(evidence$31)), HasOps$.MODULE$.castUpdateOps_V_V((.less.colon.less)$less$colon$less$.MODULE$.refl(), (.less.colon.less)$less$colon$less$.MODULE$.refl(), NotGiven$.MODULE$.value(), HasOps$.MODULE$.impl_OpDiv_InPlace_V_V_Generic(evidence$31)), HasOps$.MODULE$.impl_OpSet_InPlace_SV_SV_Generic(), HasOps$.MODULE$.impl_OpSet_InPlace_SV_S_Generic((Zero)evidence$33), HasOps$.MODULE$.impl_scaleAdd_SV_S_SV_InPlace_Generic(evidence$31, (ClassTag)evidence$32), this.canCreateZerosLike(evidence$32, evidence$33), this.canCreateZeros(evidence$32, evidence$33), this.canDim(), HasOps$.MODULE$.impl_OpMulScalar_SV_S_eq_SV_Generic(evidence$31, (ClassTag)evidence$32), HasOps$.MODULE$.impl_Op_SV_S_eq_SV_Generic(evidence$31, OpDiv$.MODULE$.opDivFromField(evidence$31)), HasOps$.MODULE$.implAddOp_SV_SV_eq_SV(evidence$31, (ClassTag)evidence$32), HasOps$.MODULE$.implSubOp_SV_SV_eq_SV(evidence$31, (ClassTag)evidence$32), HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(this.scalarOf(), (Ring)evidence$31, HasOps$.MODULE$.impl_OpMulScalar_SV_S_eq_SV_Generic(evidence$31, (ClassTag)evidence$32)), $less$colon$less$.MODULE$.refl(), HasOps$.MODULE$.impl_OpMulInner_SV_SV_eq_T((ClassTag)evidence$32, (Zero)evidence$33, evidence$31), HasOps$.MODULE$.zipMap((ClassTag)evidence$32, evidence$33, evidence$31), HasOps$.MODULE$.zipMapKV((ClassTag)evidence$32, evidence$33, evidence$31), HasOps$.MODULE$.canIterateValues_SV(), this.canMapValues(evidence$32, evidence$33), this.scalarOf());
    }

    public <T> ScalarOf<SparseVector<T>, T> scalarOf() {
        return ScalarOf$.MODULE$.dummy();
    }

    public void breeze$linalg$SparseVector$$$init() {
    }

    public static /* bridge */ /* synthetic */ Object breeze$linalg$SparseVector$$anon$1$$_$map$$anonfun$adapted$1(SparseVector from$4, Function1 fn$3, Object i) {
        return fn$3.apply(from$4.apply(BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ boolean breeze$linalg$SparseVector$$anon$2$$_$traverse$$anonfun$1(SparseVector from$2, int _$7) {
        Object object = Predef$.MODULE$.intArrayOps(from$2.index());
        return ArrayOps$.MODULE$.contains$extension(object, (Object)BoxesRunTime.boxToInteger((int)_$7));
    }

    public static /* bridge */ /* synthetic */ Object breeze$linalg$SparseVector$$anon$6$$_$map$$anonfun$adapted$2(SparseVector from$5, Function2 fn$4, Object i) {
        return fn$4.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), from$5.apply(BoxesRunTime.unboxToInt((Object)i)));
    }
}

