/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.collection.mutable.SparseArray;
import breeze.generic.UFunc;
import breeze.linalg.CSCMatrix;
import breeze.linalg.CSCMatrix$;
import breeze.linalg.Matrix;
import breeze.linalg.SparseVector$;
import breeze.linalg.StorageVector;
import breeze.linalg.Vector;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanCreateZeros;
import breeze.linalg.support.CanCreateZerosLike;
import breeze.linalg.support.CanMapKeyValuePairs;
import breeze.linalg.support.CanMapValues;
import breeze.linalg.support.CanTransformValues;
import breeze.linalg.support.CanTraverseKeyValuePairs;
import breeze.linalg.support.ScalarOf;
import breeze.math.Field;
import breeze.math.MutableFiniteCoordinateField;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.IntRef;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SparseVector<V>
implements StorageVector<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final SparseArray array;
    private final Zero<V> zero;

    public static <V> CanCopySparseVector<V> canCopySparse(ClassTag<V> classTag, Zero<V> zero) {
        return SparseVector$.MODULE$.canCopySparse(classTag, zero);
    }

    public static <V> CanCreateZeros<SparseVector<V>, Object> canCreateZeros(ClassTag<V> classTag, Zero<V> zero) {
        return SparseVector$.MODULE$.canCreateZeros(classTag, zero);
    }

    public static <V> CanCreateZerosLike<SparseVector<V>, SparseVector<V>> canCreateZerosLike(ClassTag<V> classTag, Zero<V> zero) {
        return SparseVector$.MODULE$.canCreateZerosLike(classTag, zero);
    }

    public static UFunc.UImpl canDim() {
        return SparseVector$.MODULE$.canDim();
    }

    public static <V, V2> CanMapKeyValuePairs<SparseVector<V>, Object, V, V2, SparseVector<V2>> canMapPairs(ClassTag<V2> classTag, Zero<V2> zero) {
        return SparseVector$.MODULE$.canMapPairs(classTag, zero);
    }

    public static <V, V2> CanMapValues<SparseVector<V>, V, V2, SparseVector<V2>> canMapValues(ClassTag<V2> classTag, Zero<V2> zero) {
        return SparseVector$.MODULE$.canMapValues(classTag, zero);
    }

    public static <V> CanTransformValues<SparseVector<V>, V> canTransformValues(Zero<V> zero, ClassTag<V> classTag) {
        return SparseVector$.MODULE$.canTransformValues(zero, classTag);
    }

    public static CanTraverseKeyValuePairs canTraverseKeyValuePairs() {
        return SparseVector$.MODULE$.canTraverseKeyValuePairs();
    }

    public static <V> SparseVector<V> fill(int n, Function0<V> function0, ClassTag<V> classTag, Zero<V> zero) {
        return SparseVector$.MODULE$.fill(n, function0, classTag, zero);
    }

    public static <V> CSCMatrix<V> horzcat(Seq<SparseVector<V>> seq, Zero<V> zero, ClassTag<V> classTag) {
        return SparseVector$.MODULE$.horzcat(seq, zero, classTag);
    }

    public static ScalarOf scalarOf() {
        return SparseVector$.MODULE$.scalarOf();
    }

    public static <E> MutableFiniteCoordinateField<SparseVector<E>, Object, E> space(Field<E> field, ClassTag<E> classTag, Zero<E> zero) {
        return SparseVector$.MODULE$.space(field, classTag, zero);
    }

    public static <V> SparseVector<V> tabulate(int n, Function1<Object, V> function1, ClassTag<V> classTag, Zero<V> zero) {
        return SparseVector$.MODULE$.tabulate(n, function1, classTag, zero);
    }

    public static <V> SparseVector<V> vertcat(Seq<SparseVector<V>> seq, Zero<V> zero, ClassTag<V> classTag) {
        return SparseVector$.MODULE$.vertcat(seq, zero, classTag);
    }

    public static <V> SparseVector<V> zeros(int n, ClassTag<V> classTag, Zero<V> zero) {
        return SparseVector$.MODULE$.zeros(n, classTag, zero);
    }

    public <V> SparseVector(SparseArray<V> array, Zero<V> zero) {
        this.array = array;
        this.zero = zero;
        SparseVector$.MODULE$.breeze$linalg$SparseVector$$$init();
    }

    public SparseArray<V> array() {
        return this.array;
    }

    public <V> SparseVector(int[] index, Object data, int activeSize, int length, Zero<V> value) {
        this(new SparseArray<V>(index, data, activeSize, length, value.zero()), value);
    }

    public <V> SparseVector(int[] index, Object data, int length, Zero<V> value) {
        this(index, data, index.length, length, value);
    }

    @Override
    public Object data() {
        return this.array().data();
    }

    public int[] index() {
        return this.array().index();
    }

    @Override
    public int activeSize() {
        return this.array().activeSize();
    }

    public int used() {
        return this.activeSize();
    }

    @Override
    public int length() {
        return this.array().length();
    }

    @Override
    public SparseVector<V> repr() {
        return this;
    }

    public boolean contains(int i) {
        return this.array().contains(i);
    }

    @Override
    public V apply(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("" + i + " not in [0," + this.size() + ")");
        }
        return this.array().apply(i);
    }

    @Override
    public void update(int i, V v) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("" + i + " not in [0," + this.size() + ")");
        }
        this.array().update(i, v);
    }

    public final V otherApply(int i) {
        return this.apply(i);
    }

    @Override
    public Iterator<Tuple2<Object, V>> activeIterator() {
        return this.activeKeysIterator().zip(this.activeValuesIterator());
    }

    @Override
    public Iterator<V> activeValuesIterator() {
        Object object = Predef$.MODULE$.genericArrayOps(this.data());
        return ArrayOps$.MODULE$.iterator$extension(object).take(this.activeSize());
    }

    @Override
    public Iterator<Object> activeKeysIterator() {
        Object object = Predef$.MODULE$.intArrayOps(this.index());
        return ArrayOps$.MODULE$.iterator$extension(object).take(this.activeSize());
    }

    public V default() {
        return this.zero.zero();
    }

    @Override
    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof SparseVector) {
            SparseVector x = (SparseVector)object;
            SparseArray<V> sparseArray = this.array();
            SparseArray<V> sparseArray2 = x.array();
            bl = !(sparseArray != null ? !((Object)sparseArray).equals(sparseArray2) : sparseArray2 != null);
        } else if (object instanceof Vector) {
            Vector x = (Vector)object;
            bl = this.length() == x.length() && this.valuesIterator().sameElements(x.valuesIterator());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.array().hashCode();
    }

    @Override
    public boolean isActive(int rawIndex) {
        return this.array().isActive(rawIndex);
    }

    public String toString() {
        return this.activeIterator().mkString("SparseVector(" + this.length() + ")(", ", ", ")");
    }

    @Override
    public SparseVector<V> copy() {
        return new SparseVector<V>((int[])ArrayUtil$.MODULE$.copyOf(this.index(), this.index().length), ArrayUtil$.MODULE$.copyOf(this.data(), this.index().length), this.activeSize(), this.size(), this.zero);
    }

    public void reserve(int nnz) {
        this.array().reserve(nnz);
    }

    public void compact() {
        this.array().compact();
    }

    public void use(int[] index, Object data, int activeSize) {
        Predef$.MODULE$.require(activeSize <= this.size(), SparseVector::use$$anonfun$1);
        Predef$.MODULE$.require(activeSize >= 0, SparseVector::use$$anonfun$2);
        Predef$.MODULE$.require(ScalaRunTime$.MODULE$.array_length(data) >= activeSize, SparseVector::use$$anonfun$3);
        this.array().use(index, data, activeSize);
    }

    @Override
    public V valueAt(int i) {
        return (V)ScalaRunTime$.MODULE$.array_apply(this.data(), i);
    }

    @Override
    public int indexAt(int i) {
        return this.index()[i];
    }

    @Override
    public boolean allVisitableIndicesActive() {
        return true;
    }

    public CSCMatrix<V> asCscRow(ClassTag<V> man) {
        Matrix matrix;
        if (this.index().length == 0) {
            matrix = CSCMatrix$.MODULE$.zeros(1, this.length(), (ClassTag)man, (Zero)this.zero);
        } else {
            IntRef ii = IntRef.create((int)0);
            int[] nIndex = (int[])Array$.MODULE$.tabulate(this.length() + 1, (Function1)(JFunction1.mcII.sp & Serializable)cp -> {
                int n;
                if (ii$1.elem < this.used() && cp == this.index()[ii$1.elem]) {
                    int n2;
                    ii$1.elem = n2 = ii$1.elem + 1;
                    n = ii$1.elem - 1;
                } else {
                    n = ii$1.elem;
                }
                return n;
            }, ClassTag$.MODULE$.apply(Integer.TYPE));
            if (ii.elem != this.used()) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            matrix = new CSCMatrix<V>(this.data(), 1, this.length(), nIndex, this.activeSize(), (int[])Array$.MODULE$.fill(ScalaRunTime$.MODULE$.array_length(this.data()), SparseVector::asCscRow$$anonfun$1, ClassTag$.MODULE$.apply(Integer.TYPE)), this.zero);
        }
        return matrix;
    }

    public CSCMatrix<V> asCscColumn(ClassTag<V> man) {
        return this.index().length == 0 ? CSCMatrix$.MODULE$.zeros(this.length(), 1, (ClassTag)man, (Zero)this.zero) : new CSCMatrix<V>(ScalaRunTime$.MODULE$.array_clone(this.data()), this.length(), 1, new int[]{0, this.used()}, this.activeSize(), this.index(), this.zero);
    }

    private static final String use$$anonfun$1() {
        return "Can't have more elements in the array than length!";
    }

    private static final String use$$anonfun$2() {
        return "activeSize must be non-negative";
    }

    private static final String use$$anonfun$3() {
        return "activeSize must be no greater than array length...";
    }

    private static final int asCscRow$$anonfun$1() {
        return 0;
    }

    public static class CanCopySparseVector<V>
    implements CanCopy<SparseVector<V>> {
        public <V> CanCopySparseVector(ClassTag<V> evidence$17, Zero<V> evidence$18) {
        }

        @Override
        public SparseVector<V> apply(SparseVector<V> v1) {
            return v1.copy();
        }
    }
}

