/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg.operators;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.operators.DenseMatrix_SlicingOps;
import breeze.linalg.operators.OpSet$;
import breeze.util.ArrayUtil$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public interface DenseMatrix_SetOps
extends DenseMatrix_SlicingOps {
    public static UFunc.InPlaceImpl2 setDMDM$(DenseMatrix_SetOps $this) {
        return $this.setDMDM();
    }

    default public <V> UFunc.InPlaceImpl2<OpSet$, DenseMatrix<V>, DenseMatrix<V>> setDMDM() {
        return new SetDMDMOp(this);
    }

    public static UFunc.InPlaceImpl2 setDMDV$(DenseMatrix_SetOps $this) {
        return $this.setDMDV();
    }

    default public <V> UFunc.InPlaceImpl2<OpSet$, DenseMatrix<V>, DenseVector<V>> setDMDV() {
        return new SetDMDVOp(this);
    }

    public static UFunc.InPlaceImpl2 setDMS$(DenseMatrix_SetOps $this) {
        return $this.setDMS();
    }

    default public <V> UFunc.InPlaceImpl2<OpSet$, DenseMatrix<V>, V> setDMS() {
        return new SetMSOp(this);
    }

    public class SetDMDMOp<V>
    implements UFunc.InPlaceImpl2<OpSet$, DenseMatrix<V>, DenseMatrix<V>> {
        private final DenseMatrix_SetOps $outer;

        public <V> SetDMDMOp(DenseMatrix_SetOps $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public void apply(DenseMatrix<V> a, DenseMatrix<V> b) {
            if (a.rows() != b.rows()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"" + "Matrixs must have same number of rows" + ": " + "a.rows.==(b.rows)"})));
            }
            if (a.cols() != b.cols()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"" + "Matrixs must have same number of columns" + ": " + "a.cols.==(b.cols)"})));
            }
            if (a.isTranspose() == b.isTranspose() && a.isContiguous() && b.isContiguous()) {
                System.arraycopy(b.data(), b.offset(), a.data(), a.offset(), a.size());
            } else if (a.isTranspose() == b.isTranspose()) {
                int i = 0;
                int yy = a.majorSize();
                while (i < a.majorSize()) {
                    int n = i++;
                    System.arraycopy(b.data(), b.offset() + n * b.majorStride(), a.data(), a.offset() + n * a.majorStride(), a.minorSize());
                }
            } else {
                this.cacheObliviousTranspose(0, a.majorSize(), 0, b.majorSize(), a.data(), a.offset(), a.majorStride(), b.data(), b.offset(), b.majorStride());
            }
        }

        public void cacheObliviousTranspose(int rBegin, int rEnd, int cBegin, int cEnd, Object dst, int dstOff, int aMajorStride, Object src, int srcOff, int bMajorStride) {
            int r = rEnd - rBegin;
            int c = cEnd - cBegin;
            if (r <= 16 && c <= 16) {
                int yy = rEnd;
                for (int i = rBegin; i < rEnd; ++i) {
                    int n = i;
                    int i2 = cBegin;
                    int yy2 = cEnd;
                    while (i2 < cEnd) {
                        int n2 = i2++;
                        ScalaRunTime$.MODULE$.array_update(dst, dstOff + n * aMajorStride + n2, ScalaRunTime$.MODULE$.array_apply(src, srcOff + n2 * bMajorStride + n));
                    }
                }
            } else if (r >= c) {
                this.cacheObliviousTranspose(rBegin, rBegin + r / 2, cBegin, cEnd, dst, dstOff, aMajorStride, src, srcOff, bMajorStride);
                this.cacheObliviousTranspose(rBegin + r / 2, rEnd, cBegin, cEnd, dst, dstOff, aMajorStride, src, srcOff, bMajorStride);
            } else {
                this.cacheObliviousTranspose(rBegin, rEnd, cBegin, cBegin + c / 2, dst, dstOff, aMajorStride, src, srcOff, bMajorStride);
                this.cacheObliviousTranspose(rBegin, rEnd, cBegin + c / 2, cEnd, dst, dstOff, aMajorStride, src, srcOff, bMajorStride);
            }
        }

        public final DenseMatrix_SetOps breeze$linalg$operators$DenseMatrix_SetOps$SetDMDMOp$$$outer() {
            return this.$outer;
        }
    }

    public class SetDMDVOp<V>
    implements UFunc.InPlaceImpl2<OpSet$, DenseMatrix<V>, DenseVector<V>> {
        private final DenseMatrix_SetOps $outer;

        public <V> SetDMDVOp(DenseMatrix_SetOps $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public void apply(DenseMatrix<V> a, DenseVector<V> b) {
            if (!(a.rows() == b.length() && a.cols() == 1 || a.cols() == b.length() && a.rows() == 1)) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"" + "DenseMatrix must have same number of rows, or same number of columns, as DenseVector, and the other dim must be 1." + ": " + "a.rows.==(b.length).&&(a.cols.==(1)).||(a.cols.==(b.length).&&(a.rows.==(1)))"})));
            }
            Object ad = a.data();
            Object bd = b.data();
            int boff = b.offset();
            int yy = a.cols();
            for (int i = 0; i < a.cols(); ++i) {
                int n = i;
                int i2 = 0;
                int yy2 = a.rows();
                while (i2 < a.rows()) {
                    int n2 = i2++;
                    ScalaRunTime$.MODULE$.array_update(ad, a.linearIndex(n2, n), ScalaRunTime$.MODULE$.array_apply(bd, boff));
                    boff += b.stride();
                }
            }
        }

        public final DenseMatrix_SetOps breeze$linalg$operators$DenseMatrix_SetOps$SetDMDVOp$$$outer() {
            return this.$outer;
        }
    }

    public class SetMSOp<V>
    implements UFunc.InPlaceImpl2<OpSet$, DenseMatrix<V>, V> {
        private final DenseMatrix_SetOps $outer;

        public <V> SetMSOp(DenseMatrix_SetOps $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public void apply(DenseMatrix<V> a, V b) {
            if (a.isContiguous()) {
                ArrayUtil$.MODULE$.fill(a.data(), a.offset(), a.size(), b);
            } else {
                this.slowPath(a, b);
            }
        }

        private void slowPath(DenseMatrix<V> a, V b) {
            Object ad = a.data();
            int aoff = a.offset();
            int yy = a.majorSize();
            for (int i = 0; i < a.majorSize(); ++i) {
                int n = i;
                int i2 = 0;
                int yy2 = a.minorSize();
                while (i2 < a.minorSize()) {
                    int n2 = i2++;
                    ScalaRunTime$.MODULE$.array_update(ad, aoff + n2, b);
                }
                aoff += a.majorStride();
            }
        }

        public final DenseMatrix_SetOps breeze$linalg$operators$DenseMatrix_SetOps$SetMSOp$$$outer() {
            return this.$outer;
        }
    }
}

