/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.operators.HasOps$;
import breeze.math.MutableFiniteCoordinateField;
import breeze.numerics.package$sqrt$;
import breeze.numerics.package$sqrt$sqrtDoubleImpl$;
import breeze.optimize.AdaDeltaGradientDescent$;
import breeze.optimize.AdaDeltaGradientDescent$History$;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.StochasticDiffFunction;
import breeze.optimize.StochasticGradientDescent;
import breeze.stats.distributions.RandBasis;
import java.io.Serializable;
import scala.Conversion;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class AdaDeltaGradientDescent<T>
extends StochasticGradientDescent<T> {
    private final double rho;
    private final double epsilon;
    public final AdaDeltaGradientDescent$History$ History$lzy1;

    public static double $lessinit$greater$default$3() {
        return AdaDeltaGradientDescent$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$4() {
        return AdaDeltaGradientDescent$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$5() {
        return AdaDeltaGradientDescent$.MODULE$.$lessinit$greater$default$5();
    }

    public <T> AdaDeltaGradientDescent(double rho, int maxIter, double tolerance, double improvementTolerance, int minImprovementWindow, MutableFiniteCoordinateField<T, ?, Object> vspace, RandBasis rand) {
        this.rho = rho;
        super(1.0, maxIter, tolerance, minImprovementWindow, vspace);
        this.History$lzy1 = new AdaDeltaGradientDescent$History$(this);
        this.epsilon = 1.0E-6;
    }

    private MutableFiniteCoordinateField<T, ?, Object> vspace$accessor() {
        return (MutableFiniteCoordinateField)super.vspace();
    }

    public double epsilon() {
        return this.epsilon;
    }

    public final AdaDeltaGradientDescent$History$ History() {
        return this.History$lzy1;
    }

    public History initialHistory(StochasticDiffFunction<T> f, T init) {
        return this.History().apply(this.vspace$accessor().zeroLike().apply(init), this.vspace$accessor().zeroLike().apply(init));
    }

    public History updateHistory(T newX, T newGrad, double newVal, StochasticDiffFunction<T> f, FirstOrderMinimizer.State<T, Object, History> oldState) {
        Object oldAvgSqGradient = oldState.history().avgSqGradient();
        Object newAvgSqGradient = ((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(oldAvgSqGradient)).$times(BoxesRunTime.boxToDouble((double)this.rho), this.vspace$accessor().mulVS_M()))).$plus(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(newGrad)).$times$colon$times(newGrad, this.vspace$accessor().mulVV()))).$times(BoxesRunTime.boxToDouble((double)(1.0 - this.rho)), this.vspace$accessor().mulVS_M()), this.vspace$accessor().addVV());
        Object oldAvgSqDelta = oldState.history().avgSqDelta();
        Object delta = ((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(newX)).$minus(oldState.x(), this.vspace$accessor().subVV());
        Object newAvgSqDelta = ((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(oldAvgSqDelta)).$times(BoxesRunTime.boxToDouble((double)this.rho), this.vspace$accessor().mulVS_M()))).$plus(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(delta)).$times$colon$times(delta, this.vspace$accessor().mulVV()))).$times(BoxesRunTime.boxToDouble((double)(1.0 - this.rho)), this.vspace$accessor().mulVS_M()), this.vspace$accessor().addVV());
        return this.History().apply(newAvgSqGradient, newAvgSqDelta);
    }

    @Override
    public T takeStep(FirstOrderMinimizer.State<T, Object, History> state, T dir, double stepSize) {
        Object newAvgSqGradient = ((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(state.history().avgSqGradient())).$times(BoxesRunTime.boxToDouble((double)this.rho), this.vspace$accessor().mulVS_M()))).$plus$colon$plus(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(state.grad())).$times$colon$times(state.grad(), this.vspace$accessor().mulVV()))).$times(BoxesRunTime.boxToDouble((double)(1.0 - this.rho)), this.vspace$accessor().mulVS_M()), this.vspace$accessor().addVV());
        Object rmsGradient = package$sqrt$.MODULE$.apply(((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(newAvgSqGradient)).$plus(BoxesRunTime.boxToDouble((double)this.epsilon()), this.vspace$accessor().addVS()), HasOps$.MODULE$.fromLowOrderCanMapActiveValues(this.vspace$accessor().scalarOf(), (UFunc.UImpl)package$sqrt$sqrtDoubleImpl$.MODULE$, this.vspace$accessor().mapValues()));
        Object rmsDelta = package$sqrt$.MODULE$.apply(((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(state.history().avgSqDelta())).$plus(BoxesRunTime.boxToDouble((double)this.epsilon()), this.vspace$accessor().addVS()), HasOps$.MODULE$.fromLowOrderCanMapActiveValues(this.vspace$accessor().scalarOf(), (UFunc.UImpl)package$sqrt$sqrtDoubleImpl$.MODULE$, this.vspace$accessor().mapValues()));
        Object delta = ((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(((ImmutableNumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(dir)).$times$colon$times(rmsDelta, this.vspace$accessor().mulVV()))).$div$colon$div(rmsGradient, this.vspace$accessor().divVV());
        return (T)((NumericOps)((Conversion)this.vspace$accessor().hasOps()).apply(state.x())).$plus(delta, this.vspace$accessor().addVV());
    }

    @Override
    public double determineStepSize(FirstOrderMinimizer.State<T, Object, History> state, StochasticDiffFunction<T> f, T dir) {
        return this.defaultStepSize();
    }

    @Override
    public Tuple2<Object, T> adjust(T newX, T newGrad, double newVal) {
        Double d = (Double)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)newVal));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)d, newGrad);
    }

    public class History
    implements Product,
    Serializable {
        private final Object avgSqGradient;
        private final Object avgSqDelta;
        private final AdaDeltaGradientDescent<T> $outer;

        public History(AdaDeltaGradientDescent $outer, T avgSqGradient, T avgSqDelta) {
            this.avgSqGradient = avgSqGradient;
            this.avgSqDelta = avgSqDelta;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof History)) return false;
            if (((History)object).breeze$optimize$AdaDeltaGradientDescent$History$$$outer() != this.$outer) return false;
            History history = (History)object;
            if (!BoxesRunTime.equals(this.avgSqGradient(), history.avgSqGradient())) return false;
            if (!BoxesRunTime.equals(this.avgSqDelta(), history.avgSqDelta())) return false;
            if (!history.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof History;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "History";
        }

        public Object productElement(int n) {
            Object t;
            int n2 = n;
            if (0 == n2) {
                t = this._1();
            } else if (1 == n2) {
                t = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return t;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "avgSqGradient";
            } else if (1 == n2) {
                string = "avgSqDelta";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public T avgSqGradient() {
            return this.avgSqGradient;
        }

        public T avgSqDelta() {
            return this.avgSqDelta;
        }

        public History copy(T avgSqGradient, T avgSqDelta) {
            return new History(this.$outer, avgSqGradient, avgSqDelta);
        }

        public Object copy$default$1() {
            return this.avgSqGradient();
        }

        public Object copy$default$2() {
            return this.avgSqDelta();
        }

        public T _1() {
            return this.avgSqGradient();
        }

        public T _2() {
            return this.avgSqDelta();
        }

        public final AdaDeltaGradientDescent<T> breeze$optimize$AdaDeltaGradientDescent$History$$$outer() {
            return this.$outer;
        }
    }
}

