/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.linalg.support.CanCopy;
import breeze.optimize.BatchDiffFunction$;
import breeze.optimize.CachedBatchDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.StochasticDiffFunction;
import breeze.stats.distributions.Rand;
import breeze.stats.distributions.Rand$;
import breeze.util.Isomorphism;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.compat.immutable.package$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public interface BatchDiffFunction<T>
extends DiffFunction<T>,
Function2<T, IndexedSeq<Object>, Object> {
    public static Object gradientAt$(BatchDiffFunction $this, Object x, IndexedSeq batch) {
        return $this.gradientAt(x, (IndexedSeq<Object>)batch);
    }

    default public T gradientAt(T x, IndexedSeq<Object> batch) {
        return (T)this.calculate(x, batch)._2();
    }

    public static double valueAt$(BatchDiffFunction $this, Object x, IndexedSeq batch) {
        return $this.valueAt(x, (IndexedSeq<Object>)batch);
    }

    default public double valueAt(T x, IndexedSeq<Object> batch) {
        return BoxesRunTime.unboxToDouble((Object)this.calculate(x, batch)._1());
    }

    public Tuple2<Object, T> calculate(T var1, IndexedSeq<Object> var2);

    public static Tuple2 calculate$(BatchDiffFunction $this, Object x) {
        return $this.calculate(x);
    }

    @Override
    default public Tuple2<Object, T> calculate(T x) {
        return this.calculate(x, this.fullRange());
    }

    public static double valueAt$(BatchDiffFunction $this, Object x) {
        return $this.valueAt(x);
    }

    @Override
    default public double valueAt(T x) {
        return this.valueAt(x, this.fullRange());
    }

    public static Object gradientAt$(BatchDiffFunction $this, Object x) {
        return $this.gradientAt(x);
    }

    @Override
    default public T gradientAt(T x) {
        return this.gradientAt(x, this.fullRange());
    }

    public static double apply$(BatchDiffFunction $this, Object x, IndexedSeq batch) {
        return $this.apply(x, (IndexedSeq<Object>)batch);
    }

    default public double apply(T x, IndexedSeq<Object> batch) {
        return this.valueAt(x, batch);
    }

    public static DiffFunction cached$(BatchDiffFunction $this, CanCopy copy) {
        return $this.cached(copy);
    }

    @Override
    default public DiffFunction<T> cached(CanCopy<T> copy) {
        return this instanceof CachedBatchDiffFunction ? this : new CachedBatchDiffFunction<T>(this, copy);
    }

    public IndexedSeq<Object> fullRange();

    public static StochasticDiffFunction withRandomBatches$(BatchDiffFunction $this, int size) {
        return $this.withRandomBatches(size);
    }

    default public StochasticDiffFunction<T> withRandomBatches(int size) {
        return new StochasticDiffFunction<T>(size, this){
            private final Rand rand;
            private final BatchDiffFunction $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.rand = Rand$.MODULE$.subsetsOfSize($outer.fullRange(), size$1);
            }

            public Rand rand() {
                return this.rand;
            }

            public Tuple2 calculate(Object x) {
                return this.$outer.calculate(x, (IndexedSeq<Object>)((IndexedSeq)this.rand().draw()));
            }
        };
    }

    public static StochasticDiffFunction withScanningBatches$(BatchDiffFunction $this, int size) {
        return $this.withScanningBatches(size);
    }

    default public StochasticDiffFunction<T> withScanningBatches(int size) {
        return new StochasticDiffFunction<T>(size, this){
            private final int size$1;
            private int lastStop;
            private final BatchDiffFunction $outer;
            {
                this.size$1 = size$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.lastStop = 0;
            }

            public int lastStop() {
                return this.lastStop;
            }

            public void lastStop_$eq(int x$1) {
                this.lastStop = x$1;
            }

            public ArraySeq nextBatch() {
                ArraySeq arraySeq;
                $anon$2 var1_1 = this;
                synchronized (var1_1) {
                    int start = this.lastStop();
                    this.lastStop_$eq(this.lastStop() + this.size$1);
                    this.lastStop_$eq(this.lastStop() % this.$outer.fullRange().size());
                    arraySeq = package$.MODULE$.ArraySeq().unsafeWrapArray(Array$.MODULE$.tabulate(this.size$1, (Function1)(JFunction1.mcII.sp & Serializable)i -> BoxesRunTime.unboxToInt((Object)this.$outer.fullRange().apply((i + start) % this.$outer.fullRange().size())), ClassTag$.MODULE$.apply(Integer.TYPE)));
                }
                return arraySeq;
            }

            public Tuple2 calculate(Object x) {
                return this.$outer.calculate(x, (IndexedSeq<Object>)this.nextBatch());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{nextBatch$$anonfun$1(int int )}, serializedLambda);
            }
        };
    }

    public static BatchDiffFunction groupItems$(BatchDiffFunction $this, int groupSize) {
        return $this.groupItems(groupSize);
    }

    default public BatchDiffFunction<T> groupItems(int groupSize) {
        return new BatchDiffFunction<T>(groupSize, this){
            private final int numGroups;
            private final IndexedSeq[] groups;
            private final BatchDiffFunction $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numGroups = ($outer.fullRange().size() + groupSize$1 - 1) / groupSize$1;
                this.groups = (IndexedSeq[])Array$.MODULE$.tabulate(this.numGroups(), (Function1 & Serializable)i -> this.$init$$$anonfun$1($outer, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(IndexedSeq.class));
            }

            public int numGroups() {
                return this.numGroups;
            }

            public IndexedSeq[] groups() {
                return this.groups;
            }

            public Tuple2 calculate(Object x, IndexedSeq batch) {
                return this.$outer.calculate(x, (IndexedSeq<Object>)((IndexedSeq)batch.flatMap((Function1)Predef$.MODULE$.wrapRefArray((Object[])this.groups()))));
            }

            public Object gradientAt(Object x, IndexedSeq batch) {
                return this.$outer.gradientAt(x, (IndexedSeq<Object>)((IndexedSeq)batch.flatMap((Function1)Predef$.MODULE$.wrapRefArray((Object[])this.groups()))));
            }

            public double valueAt(Object x, IndexedSeq batch) {
                return this.$outer.valueAt(x, (IndexedSeq<Object>)((IndexedSeq)batch.flatMap((Function1)Predef$.MODULE$.wrapRefArray((Object[])this.groups()))));
            }

            public IndexedSeq fullRange() {
                return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.groups().length);
            }

            private final /* synthetic */ IndexedSeq $init$$$anonfun$1(BatchDiffFunction $outer$1, int i) {
                return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(i), $outer$1.fullRange().length()).by(this.numGroups()).map($outer$1.fullRange());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$adapted$1(breeze.optimize.BatchDiffFunction java.lang.Object )}, serializedLambda);
            }
        };
    }

    public static BatchDiffFunction throughLens$(BatchDiffFunction $this, Isomorphism l) {
        return $this.throughLens(l);
    }

    @Override
    default public <U> BatchDiffFunction<U> throughLens(Isomorphism<T, U> l) {
        return new BatchDiffFunction<U>(l, this){
            private final Isomorphism l$1;
            private final BatchDiffFunction $outer;
            {
                this.l$1 = l$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Tuple2 calculate(Object u, IndexedSeq batch) {
                T t = this.l$1.backward(u);
                Tuple2<Object, T> tuple2 = this.$outer.calculate(t, (IndexedSeq<Object>)batch);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                double obj = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                Object gu = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)obj), gu);
                double obj2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                Object gu2 = tuple22._2();
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)obj2), this.l$1.forward(gu2));
            }

            public IndexedSeq fullRange() {
                return this.$outer.fullRange();
            }

            public Tuple2 calculate(Object u) {
                T t = this.l$1.backward(u);
                Tuple2<Object, T> tuple2 = this.$outer.calculate(t);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                double obj = BoxesRunTime.unboxToDouble((Object)tuple2._1());
                Object gu = tuple2._2();
                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)obj), gu);
                double obj2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
                Object gu2 = tuple22._2();
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)obj2), this.l$1.forward(gu2));
            }
        };
    }
}

