/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.min$;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.math.MutableInnerProductModule;
import breeze.math.Ring;
import breeze.math.Ring$;
import breeze.optimize.BacktrackingLineSearch;
import breeze.optimize.BacktrackingLineSearch$;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.CompactHessian;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.FirstOrderMinimizer$;
import breeze.optimize.LineSearch$;
import breeze.optimize.ProjectedQuasiNewton$;
import breeze.optimize.Projecting;
import breeze.optimize.SpectralProjectedGradient;
import breeze.optimize.SpectralProjectedGradient$;
import breeze.optimize.StepSizeUnderflow;
import scala.Function1;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class ProjectedQuasiNewton
extends FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>>
implements Projecting<DenseVector<Object>> {
    private final SpectralProjectedGradient innerOptimizer;
    private final int m;
    private final boolean initFeas;
    private final boolean testOpt;
    private final int maxSrchIt;
    private final double gamma;
    private final Function1 projection;
    private final MutableInnerProductModule<DenseVector<Object>, Object> space;

    public static double $lessinit$greater$default$1() {
        return ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$1();
    }

    public static int $lessinit$greater$default$2() {
        return ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$5() {
        return ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$6() {
        return ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$7() {
        return ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$7();
    }

    public static Function1 $lessinit$greater$default$8() {
        return ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$8();
    }

    public static boolean $lessinit$greater$default$9() {
        return ProjectedQuasiNewton$.MODULE$.$lessinit$greater$default$9();
    }

    public ProjectedQuasiNewton(FirstOrderMinimizer.ConvergenceCheck<DenseVector<Object>> convergenceCheck, SpectralProjectedGradient<DenseVector<Object>> innerOptimizer, int m, boolean initFeas, boolean testOpt, int maxSrchIt, double gamma, Function1<DenseVector<Object>, DenseVector<Object>> projection, MutableInnerProductModule<DenseVector<Object>, Object> space) {
        this.innerOptimizer = innerOptimizer;
        this.m = m;
        this.initFeas = initFeas;
        this.testOpt = testOpt;
        this.maxSrchIt = maxSrchIt;
        this.gamma = gamma;
        this.projection = projection;
        this.space = space;
        super(convergenceCheck, space);
    }

    public SpectralProjectedGradient<DenseVector<Object>> innerOptimizer() {
        return this.innerOptimizer;
    }

    public int m() {
        return this.m;
    }

    public boolean initFeas() {
        return this.initFeas;
    }

    public boolean testOpt() {
        return this.testOpt;
    }

    public int maxSrchIt() {
        return this.maxSrchIt;
    }

    public double gamma() {
        return this.gamma;
    }

    @Override
    public Function1<DenseVector<Object>, DenseVector<Object>> projection() {
        return this.projection;
    }

    public ProjectedQuasiNewton(double tolerance, int m, boolean initFeas, boolean testOpt, int maxIter, int maxSrchIt, double gamma, Function1<DenseVector<Object>, DenseVector<Object>> projection, boolean relativeTolerance, MutableInnerProductModule<DenseVector<Object>, Object> space) {
        this(FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck(maxIter, tolerance, relativeTolerance, FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck$default$4(), space), new SpectralProjectedGradient<DenseVector<Object>>(projection, tolerance, SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$3(), 10, SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$5(), SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$6(), 5, 50, true, SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$10(), SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$11(), SpectralProjectedGradient$.MODULE$.$lessinit$greater$default$12(), DenseVector$.MODULE$.space_Double()), m, initFeas, testOpt, maxSrchIt, gamma, projection, space);
    }

    public CompactHessian initialHistory(DiffFunction<DenseVector<Object>> f, DenseVector<Object> init) {
        return new CompactHessian(this.m());
    }

    @Override
    public Tuple2<Object, DenseVector<Object>> adjust(DenseVector<Object> newX, DenseVector<Object> newGrad, double newVal) {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)newVal), this.projectedVector(newX, newGrad.unary_$minus(HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(DenseVector$.MODULE$.DV_scalarOf(), (Ring)Ring$.MODULE$.ringD(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar())), this.space));
    }

    private DenseVector<Object> computeGradient(DenseVector<Object> x, DenseVector<Object> g) {
        return (DenseVector)this.projectedVector(x, g.unary_$minus(HasOps$.MODULE$.impl_OpNeg_T_Generic_from_OpMulScalar(DenseVector$.MODULE$.DV_scalarOf(), (Ring)Ring$.MODULE$.ringD(), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulScalar())), this.space);
    }

    @Override
    public DenseVector<Object> chooseDescentDirection(FirstOrderMinimizer.State<DenseVector<Object>, Object, CompactHessian> state, DiffFunction<DenseVector<Object>> fn) {
        DenseVector denseVector;
        if (state.iter() == 0) {
            denseVector = this.computeGradient(state.x(), state.grad());
        } else {
            QuadraticSubproblem subprob = new QuadraticSubproblem(state.adjustedValue(), state.x(), state.grad(), state.history());
            FirstOrderMinimizer.State<DenseVector<Object>, Object, Object> spgResult = this.innerOptimizer().minimizeAndReturnState(new CachedDiffFunction(subprob, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.apply(Double.TYPE))), state.x());
            this.logger().info(() -> ProjectedQuasiNewton.chooseDescentDirection$$anonfun$1(state, spgResult));
            denseVector = (DenseVector)((ImmutableNumericOps)spgResult.x()).$minus(state.x(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        }
        return denseVector;
    }

    @Override
    public double determineStepSize(FirstOrderMinimizer.State<DenseVector<Object>, Object, CompactHessian> state, DiffFunction<DenseVector<Object>> f, DenseVector<Object> dir) {
        DenseVector<Object> x = state.x();
        DenseVector<Object> grad = state.grad();
        DiffFunction<Object> ff = LineSearch$.MODULE$.functionFromSearchDirection(f, x, dir, this.space);
        BacktrackingLineSearch search = new BacktrackingLineSearch(state.value(), this.maxSrchIt(), state.iter() < 1 ? 0.1 : 0.5, BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$4(), BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$5(), BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$6(), BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$7(), BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$8(), BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$9(), BacktrackingLineSearch$.MODULE$.$lessinit$greater$default$10());
        double alpha = (double)state.iter() == 0.0 ? BoxesRunTime.unboxToDouble((Object)min$.MODULE$.apply(BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToDouble((double)(1.0 / BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(dir, norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))))), min$.MODULE$.minImpl2_Double())) : 1.0;
        if ((alpha = search.minimize((DiffFunction)ff, alpha)) * BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(grad, norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double())))) < 1.0E-10) {
            throw new StepSizeUnderflow();
        }
        return alpha;
    }

    @Override
    public DenseVector<Object> takeStep(FirstOrderMinimizer.State<DenseVector<Object>, Object, CompactHessian> state, DenseVector<Object> dir, double stepSize) {
        return (DenseVector)this.projection().apply(((NumericOps)state.x()).$plus(dir.$times(BoxesRunTime.boxToDouble((double)stepSize), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix()), HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double()));
    }

    public CompactHessian updateHistory(DenseVector<Object> newX, DenseVector<Object> newGrad, double newVal, DiffFunction<DenseVector<Object>> f, FirstOrderMinimizer.State<DenseVector<Object>, Object, CompactHessian> oldState) {
        DenseVector s = (DenseVector)newX.$minus(oldState.x(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        DenseVector y = (DenseVector)newGrad.$minus(oldState.grad(), HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
        return oldState.history().updated(y, s);
    }

    private static final String chooseDescentDirection$$anonfun$1(FirstOrderMinimizer.State state$1, FirstOrderMinimizer.State spgResult$1) {
        return StringOps$.MODULE$.format$extension("ProjectedQuasiNewton: outerIter %s innerIters %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)state$1.iter()), BoxesRunTime.boxToInteger((int)spgResult$1.iter())}));
    }

    public static class QuadraticSubproblem
    implements DiffFunction<DenseVector<Object>> {
        private final double fk;
        private final DenseVector<Object> xk;
        private final DenseVector<Object> gk;
        private final CompactHessian B;

        public QuadraticSubproblem(double fk, DenseVector<Object> xk, DenseVector<Object> gk, CompactHessian B) {
            this.fk = fk;
            this.xk = xk;
            this.gk = gk;
            this.B = B;
        }

        @Override
        public Tuple2<Object, DenseVector<Object>> calculate(DenseVector<Object> x) {
            DenseVector d = (DenseVector)x.$minus(this.xk, HasOps$.MODULE$.impl_OpSub_DV_DV_eq_DV_Double());
            DenseVector<Object> Bd = this.B.$times(d);
            double f = this.fk + BoxesRunTime.unboxToDouble((Object)d.dot(this.gk, (UFunc.UImpl2)HasOps$.MODULE$.canDotD())) + 0.5 * BoxesRunTime.unboxToDouble((Object)d.dot(Bd, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
            DenseVector g = (DenseVector)this.gk.$plus(Bd, HasOps$.MODULE$.impl_OpAdd_DV_DV_eq_DV_Double());
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)f), (Object)g);
        }
    }
}

