/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.math.NormedModule;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.StochasticDiffFunction;
import breeze.optimize.StochasticGradientDescent$;
import breeze.optimize.StochasticGradientDescent$SimpleSGD$;
import scala.Conversion;
import scala.Int$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class StochasticGradientDescent<T>
extends FirstOrderMinimizer<T, StochasticDiffFunction<T>> {
    private final double defaultStepSize;
    private final int maxIter;
    private final NormedModule vspace;

    public static <T> StochasticGradientDescent<T> apply(double d, int n, NormedModule<T, Object> normedModule) {
        return StochasticGradientDescent$.MODULE$.apply(d, n, normedModule);
    }

    public static double apply$default$1() {
        return StochasticGradientDescent$.MODULE$.apply$default$1();
    }

    public static int apply$default$2() {
        return StochasticGradientDescent$.MODULE$.apply$default$2();
    }

    public static double $lessinit$greater$default$3() {
        return StochasticGradientDescent$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return StochasticGradientDescent$.MODULE$.$lessinit$greater$default$4();
    }

    public <T> StochasticGradientDescent(double defaultStepSize, int maxIter, double tolerance, int fvalMemory, NormedModule<T, Object> vspace) {
        this.defaultStepSize = defaultStepSize;
        this.maxIter = maxIter;
        this.vspace = vspace;
        super(maxIter, tolerance, fvalMemory, true, vspace);
    }

    public double defaultStepSize() {
        return this.defaultStepSize;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public NormedModule<T, Object> vspace() {
        return this.vspace;
    }

    @Override
    public T takeStep(FirstOrderMinimizer.State<T, Object, Object> state, T dir, double stepSize) {
        return (T)((NumericOps)((Conversion)this.vspace().hasOps()).apply(state.x())).$plus(((ImmutableNumericOps)((Conversion)this.vspace().hasOps()).apply(dir)).$times(BoxesRunTime.boxToDouble((double)stepSize), this.vspace().mulVS_M()), this.vspace().addVV());
    }

    @Override
    public T chooseDescentDirection(FirstOrderMinimizer.State<T, Object, Object> state, StochasticDiffFunction<T> fn) {
        return (T)((ImmutableNumericOps)((Conversion)this.vspace().hasOps()).apply(state.grad())).$times(BoxesRunTime.boxToDouble((double)-1.0), this.vspace().mulVS_M());
    }

    @Override
    public double determineStepSize(FirstOrderMinimizer.State<T, Object, Object> state, StochasticDiffFunction<T> f, T dir) {
        return this.defaultStepSize() / package$.MODULE$.pow(Int$.MODULE$.int2double(state.iter() + 1), 0.6666666666666666);
    }

    public static class SimpleSGD<T>
    extends StochasticGradientDescent<T> {
        public static double $lessinit$greater$default$1() {
            return StochasticGradientDescent$SimpleSGD$.MODULE$.$lessinit$greater$default$1();
        }

        public static int $lessinit$greater$default$2() {
            return StochasticGradientDescent$SimpleSGD$.MODULE$.$lessinit$greater$default$2();
        }

        public <T> SimpleSGD(double initialStepSize, int maxIter, NormedModule<T, Object> vs) {
            super(initialStepSize, maxIter, StochasticGradientDescent$.MODULE$.$lessinit$greater$default$3(), StochasticGradientDescent$.MODULE$.$lessinit$greater$default$4(), vs);
        }

        public BoxedUnit initialHistory(StochasticDiffFunction<T> f, T init) {
            return BoxedUnit.UNIT;
        }

        public BoxedUnit updateHistory(T newX, T newGrad, double newValue, StochasticDiffFunction<T> f, FirstOrderMinimizer.State<T, Object, BoxedUnit> oldState) {
            return BoxedUnit.UNIT;
        }
    }
}

