/*
 * Decompiled with CFR 0.152.
 */
package breeze.signal;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.operators.HasOps$;
import breeze.numerics.package$isEven$;
import breeze.signal.OptDesignMethod;
import breeze.signal.OptDesignMethod$Firwin$;
import breeze.signal.OptFilterTaps;
import breeze.signal.OptFilterTaps$Automatic$;
import breeze.signal.OptMethod;
import breeze.signal.OptMethod$Automatic$;
import breeze.signal.OptOverhang;
import breeze.signal.OptOverhang$None$;
import breeze.signal.OptOverhang$PreserveLength$;
import breeze.signal.OptPadding;
import breeze.signal.OptPadding$Boundary$;
import breeze.signal.OptPadding$Zero$;
import breeze.signal.OptRange;
import breeze.signal.OptRange$All$;
import breeze.signal.OptWindowFunction;
import breeze.signal.OptWindowFunction$Hamming$;
import breeze.signal.fourierShift$;
import breeze.signal.fourierTr$;
import breeze.signal.iFourierTr$;
import breeze.signal.support.CanConvolve;
import breeze.signal.support.CanDesignFilterDecimation;
import breeze.signal.support.CanFilter;
import breeze.signal.support.CanFilterBPBS;
import breeze.signal.support.CanFilterLPHP;
import breeze.signal.support.CanFilterMedian;
import breeze.signal.support.CanFirwin;
import breeze.signal.support.CanHaarTr;
import breeze.signal.support.CanIHaarTr;
import breeze.signal.support.FIRKernel1D;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class package$
implements Serializable {
    private static final fourierTr$ fourierTransform;
    private static final iFourierTr$ inverseFourierTransform;
    public static final package$ MODULE$;

    private package$() {
    }

    static {
        MODULE$ = new package$();
        fourierTransform = fourierTr$.MODULE$;
        inverseFourierTransform = iFourierTr$.MODULE$;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public fourierTr$ fourierTransform() {
        return fourierTransform;
    }

    public iFourierTr$ inverseFourierTransform() {
        return inverseFourierTransform;
    }

    public DenseVector<Object> fourierFreq(int windowLength, double fs, double dt, boolean shifted) {
        if (!(fs > 0.0) && !(dt > 0.0)) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"" + "Must specify either a valid fs or a valid dt argument." + ": " + "fs.>(0).||(dt.>(0))"})));
        }
        if (fs > 0.0 && dt > 0.0 && fs != 1.0 / dt) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"" + "If fs and dt are both specified, fs == 1.0/dt must be true. Otherwise, they are incompatible" + ": " + "fs.==(1.0./(dt))"})));
        }
        double realFs = fs < 0.0 && dt > 0.0 ? 1.0 / dt : fs;
        DenseVector<Object> shiftedFreq = BoxesRunTime.unboxToBoolean((Object)package$isEven$.MODULE$.apply(BoxesRunTime.boxToInteger((int)windowLength), package$isEven$.MODULE$.isEvenImpl_Int())) ? DenseVector$.MODULE$.vertcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseVector[]{DenseVector$.MODULE$.tabulate((Range)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), windowLength / 2 - 1), (JFunction1.mcDI.sp & Serializable)i -> (double)i * realFs / (double)windowLength, ClassTag$.MODULE$.apply(Double.TYPE)), DenseVector$.MODULE$.tabulate((Range)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(-windowLength / 2), -1), (JFunction1.mcDI.sp & Serializable)i -> (double)i * realFs / (double)windowLength, ClassTag$.MODULE$.apply(Double.TYPE))}), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero()) : DenseVector$.MODULE$.vertcat(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DenseVector[]{DenseVector$.MODULE$.tabulate((Range)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), (windowLength - 1) / 2), (JFunction1.mcDI.sp & Serializable)i -> (double)i * realFs / (double)windowLength, ClassTag$.MODULE$.apply(Double.TYPE)), DenseVector$.MODULE$.tabulate((Range)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(-(windowLength - 1) / 2), -1), (JFunction1.mcDI.sp & Serializable)i -> (double)i * realFs / (double)windowLength, ClassTag$.MODULE$.apply(Double.TYPE))}), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        return shifted ? (DenseVector<Object>)fourierShift$.MODULE$.apply(shiftedFreq, fourierShift$.MODULE$.implFourierShift(Zero$.MODULE$.DoubleZero(), ClassTag$.MODULE$.apply(Double.TYPE))) : shiftedFreq;
    }

    public double fourierFreq$default$2() {
        return -1.0;
    }

    public double fourierFreq$default$3() {
        return -1.0;
    }

    public boolean fourierFreq$default$4() {
        return false;
    }

    public <Input, KernelType, Output> Output convolve(Input data, KernelType kernel, OptRange range, OptOverhang overhang, OptPadding padding, OptMethod method, CanConvolve<Input, KernelType, Output> canConvolve) {
        return canConvolve.apply(data, kernel, range, false, overhang, padding, method);
    }

    public <Input, KernelType, Output> OptRange convolve$default$3() {
        return OptRange$All$.MODULE$;
    }

    public <Input, KernelType, Output> OptOverhang convolve$default$4() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, KernelType, Output> OptPadding convolve$default$5() {
        return OptPadding$Zero$.MODULE$;
    }

    public <Input, KernelType, Output> OptMethod convolve$default$6() {
        return OptMethod$Automatic$.MODULE$;
    }

    public <Input, KernelType, Output> Output correlate(Input data, KernelType kernel, OptRange range, OptOverhang overhang, OptPadding padding, OptMethod method, CanConvolve<Input, KernelType, Output> canConvolve) {
        return canConvolve.apply(data, kernel, range, true, overhang, padding, method);
    }

    public <Input, KernelType, Output> OptRange correlate$default$3() {
        return OptRange$All$.MODULE$;
    }

    public <Input, KernelType, Output> OptOverhang correlate$default$4() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, KernelType, Output> OptPadding correlate$default$5() {
        return OptPadding$Zero$.MODULE$;
    }

    public <Input, KernelType, Output> OptMethod correlate$default$6() {
        return OptMethod$Automatic$.MODULE$;
    }

    public <Input, Kernel, Output> Output filter(Input data, Kernel kernel, OptOverhang overhang, OptPadding padding, CanFilter<Input, Kernel, Output> canFilter) {
        return canFilter.apply(data, kernel, overhang, padding);
    }

    public <Input, Kernel, Output> OptOverhang filter$default$3() {
        return OptOverhang$PreserveLength$.MODULE$;
    }

    public <Input, Kernel, Output> OptPadding filter$default$4() {
        return OptPadding$Zero$.MODULE$;
    }

    public <Input, Output> Output filterBP(Input data, Tuple2<Object, Object> omegas, double sampleRate, int taps, OptDesignMethod kernelDesign, OptOverhang overhang, OptPadding padding, CanFilterBPBS<Input, Output> canFilterBPBS) {
        return canFilterBPBS.apply(data, omegas, sampleRate, taps, false, kernelDesign, overhang, padding);
    }

    public double filterBP$default$3() {
        return 2.0;
    }

    public int filterBP$default$4() {
        return 512;
    }

    public <Input, Output> OptDesignMethod filterBP$default$5() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Input, Output> OptOverhang filterBP$default$6() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, Output> OptPadding filterBP$default$7() {
        return OptPadding$Boundary$.MODULE$;
    }

    public <Input, Output> Output filterBS(Input data, Tuple2<Object, Object> omegas, double sampleRate, int taps, OptDesignMethod kernelDesign, OptOverhang overhang, OptPadding padding, CanFilterBPBS<Input, Output> canFilterBPBS) {
        return canFilterBPBS.apply(data, omegas, sampleRate, taps, true, kernelDesign, overhang, padding);
    }

    public double filterBS$default$3() {
        return 2.0;
    }

    public int filterBS$default$4() {
        return 512;
    }

    public <Input, Output> OptDesignMethod filterBS$default$5() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Input, Output> OptOverhang filterBS$default$6() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, Output> OptPadding filterBS$default$7() {
        return OptPadding$Boundary$.MODULE$;
    }

    public <Input, Output> Output filterLP(Input data, double omega, double sampleRate, int taps, OptDesignMethod kernelDesign, OptOverhang overhang, OptPadding padding, CanFilterLPHP<Input, Output> canFilterLPHP) {
        return canFilterLPHP.apply(data, omega, sampleRate, taps, true, kernelDesign, overhang, padding);
    }

    public double filterLP$default$3() {
        return 2.0;
    }

    public int filterLP$default$4() {
        return 512;
    }

    public <Input, Output> OptDesignMethod filterLP$default$5() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Input, Output> OptOverhang filterLP$default$6() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, Output> OptPadding filterLP$default$7() {
        return OptPadding$Boundary$.MODULE$;
    }

    public <Input, Output> Output filterHP(Input data, double omega, double sampleRate, int taps, OptDesignMethod kernelDesign, OptOverhang overhang, OptPadding padding, CanFilterLPHP<Input, Output> canFilterLPHP) {
        return canFilterLPHP.apply(data, omega, sampleRate, taps, false, kernelDesign, overhang, padding);
    }

    public double filterHP$default$3() {
        return 2.0;
    }

    public int filterHP$default$4() {
        return 512;
    }

    public <Input, Output> OptDesignMethod filterHP$default$5() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Input, Output> OptOverhang filterHP$default$6() {
        return OptOverhang$None$.MODULE$;
    }

    public <Input, Output> OptPadding filterHP$default$7() {
        return OptPadding$Boundary$.MODULE$;
    }

    public <Output> FIRKernel1D<Output> designFilterFirwin(int taps, DenseVector<Object> omegas, double nyquist, boolean zeroPass, boolean scale, double multiplier, OptWindowFunction optWindow, CanFirwin<Output> canFirwin) {
        return canFirwin.apply(taps, omegas, nyquist, zeroPass, scale, multiplier, optWindow);
    }

    public double designFilterFirwin$default$3() {
        return 1.0;
    }

    public boolean designFilterFirwin$default$4() {
        return true;
    }

    public boolean designFilterFirwin$default$5() {
        return true;
    }

    public double designFilterFirwin$default$6() {
        return 1.0;
    }

    public <Output> OptWindowFunction designFilterFirwin$default$7() {
        return OptWindowFunction$Hamming$.MODULE$.apply(OptWindowFunction$Hamming$.MODULE$.$lessinit$greater$default$1(), OptWindowFunction$Hamming$.MODULE$.$lessinit$greater$default$2());
    }

    public <Output> Output designFilterDecimation(int factor, double multiplier, OptDesignMethod optDesignMethod, OptWindowFunction optWindow, OptFilterTaps optFilterOrder, CanDesignFilterDecimation<Output> canDesignFilterDecimation) {
        return canDesignFilterDecimation.apply(factor, multiplier, optDesignMethod, optWindow, optFilterOrder);
    }

    public double designFilterDecimation$default$2() {
        return 1.0;
    }

    public <Output> OptDesignMethod designFilterDecimation$default$3() {
        return OptDesignMethod$Firwin$.MODULE$;
    }

    public <Output> OptWindowFunction designFilterDecimation$default$4() {
        return OptWindowFunction$Hamming$.MODULE$.apply(OptWindowFunction$Hamming$.MODULE$.$lessinit$greater$default$1(), OptWindowFunction$Hamming$.MODULE$.$lessinit$greater$default$2());
    }

    public <Output> OptFilterTaps designFilterDecimation$default$5() {
        return OptFilterTaps$Automatic$.MODULE$;
    }

    public <Input> DenseVector<Input> filterMedian(DenseVector<Input> data, int windowLength, OptOverhang overhang, CanFilterMedian<Input> canFilterMedian) {
        return canFilterMedian.apply(data, windowLength, overhang);
    }

    public <Input> OptOverhang filterMedian$default$3() {
        return OptOverhang$PreserveLength$.MODULE$;
    }

    public <Input> DenseVector<Input> filterMedian(DenseVector<Input> data, int windowLength, CanFilterMedian<Input> canFilterMedian) {
        return canFilterMedian.apply(data, windowLength, OptOverhang$PreserveLength$.MODULE$);
    }

    public <Input, Output> Output haarTr(Input v, CanHaarTr<Input, Output> canHaarTransform) {
        return canHaarTransform.apply(v);
    }

    public <Input, Output> Output haarTransform(Input v, CanHaarTr<Input, Output> canHaarTransform) {
        return canHaarTransform.apply(v);
    }

    public <Input, Output> Output iHaarTr(Input v, CanIHaarTr<Input, Output> canInverseHaarTransform) {
        return canInverseHaarTransform.apply(v);
    }

    public <Input, Output> Output inverseHaarTransform(Input v, CanIHaarTr<Input, Output> canInverseHaarTransform) {
        return canInverseHaarTransform.apply(v);
    }
}

