/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.linalg.DenseVector;
import breeze.stats.distributions.AliasTable$;
import breeze.stats.distributions.RandBasis;
import java.io.Serializable;
import scala.Product;
import scala.collection.immutable.IndexedSeq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class AliasTable<I>
implements Product,
Serializable {
    private final DenseVector probs;
    private final DenseVector aliases;
    private final IndexedSeq outcomes;
    private final RandBasis rand;

    public static <I> AliasTable<I> apply(DenseVector<Object> denseVector, DenseVector<Object> denseVector2, IndexedSeq<I> indexedSeq, RandBasis randBasis) {
        return AliasTable$.MODULE$.apply(denseVector, denseVector2, indexedSeq, randBasis);
    }

    public static AliasTable fromProduct(Product product2) {
        return AliasTable$.MODULE$.fromProduct(product2);
    }

    public static <I> AliasTable<I> unapply(AliasTable<I> aliasTable) {
        return AliasTable$.MODULE$.unapply(aliasTable);
    }

    public <I> AliasTable(DenseVector<Object> probs, DenseVector<Object> aliases, IndexedSeq<I> outcomes, RandBasis rand) {
        this.probs = probs;
        this.aliases = aliases;
        this.outcomes = outcomes;
        this.rand = rand;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof AliasTable)) return false;
        AliasTable aliasTable = (AliasTable)object;
        DenseVector<Object> denseVector = this.probs();
        DenseVector<Object> denseVector2 = aliasTable.probs();
        if (denseVector == null) {
            if (denseVector2 != null) {
                return false;
            }
        } else if (!((Object)denseVector).equals(denseVector2)) return false;
        DenseVector<Object> denseVector3 = this.aliases();
        DenseVector<Object> denseVector4 = aliasTable.aliases();
        if (denseVector3 == null) {
            if (denseVector4 != null) {
                return false;
            }
        } else if (!((Object)denseVector3).equals(denseVector4)) return false;
        IndexedSeq<I> indexedSeq = this.outcomes();
        IndexedSeq<I> indexedSeq2 = aliasTable.outcomes();
        if (indexedSeq == null) {
            if (indexedSeq2 != null) {
                return false;
            }
        } else if (!indexedSeq.equals(indexedSeq2)) return false;
        RandBasis randBasis = this.rand();
        RandBasis randBasis2 = aliasTable.rand();
        if (randBasis == null) {
            if (randBasis2 != null) {
                return false;
            }
        } else if (!randBasis.equals(randBasis2)) return false;
        if (!aliasTable.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof AliasTable;
    }

    public int productArity() {
        return 4;
    }

    public String productPrefix() {
        return "AliasTable";
    }

    public Object productElement(int n) {
        Serializable serializable;
        int n2 = n;
        switch (n2) {
            case 0: {
                serializable = this._1();
                break;
            }
            case 1: {
                serializable = this._2();
                break;
            }
            case 2: {
                serializable = this._3();
                break;
            }
            case 3: {
                serializable = this._4();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return serializable;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "probs";
                break;
            }
            case 1: {
                string = "aliases";
                break;
            }
            case 2: {
                string = "outcomes";
                break;
            }
            case 3: {
                string = "rand";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
        }
        return string;
    }

    public DenseVector<Object> probs() {
        return this.probs;
    }

    public DenseVector<Object> aliases() {
        return this.aliases;
    }

    public IndexedSeq<I> outcomes() {
        return this.outcomes;
    }

    public RandBasis rand() {
        return this.rand;
    }

    public I draw() {
        int roll2 = BoxesRunTime.unboxToInt((Object)this.rand().randInt(this.outcomes().length()).draw());
        double toss = BoxesRunTime.unboxToDouble((Object)this.rand().uniform().draw());
        return (I)(toss < BoxesRunTime.unboxToDouble((Object)this.probs().apply(roll2)) ? this.outcomes().apply(roll2) : this.outcomes().apply(BoxesRunTime.unboxToInt((Object)this.aliases().apply(roll2))));
    }

    public <I> AliasTable<I> copy(DenseVector<Object> probs, DenseVector<Object> aliases, IndexedSeq<I> outcomes, RandBasis rand) {
        return new AliasTable<I>(probs, aliases, outcomes, rand);
    }

    public <I> DenseVector<Object> copy$default$1() {
        return this.probs();
    }

    public <I> DenseVector<Object> copy$default$2() {
        return this.aliases();
    }

    public <I> IndexedSeq<I> copy$default$3() {
        return this.outcomes();
    }

    public <I> RandBasis copy$default$4() {
        return this.rand();
    }

    public DenseVector<Object> _1() {
        return this.probs();
    }

    public DenseVector<Object> _2() {
        return this.aliases();
    }

    public IndexedSeq<I> _3() {
        return this.outcomes();
    }

    public RandBasis _4() {
        return this.rand();
    }
}

