/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.regression;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.operators.HasOps$;
import breeze.stats.regression.LeastSquaresRegressionResult$;
import breeze.stats.regression.RegressionResult;
import java.io.Serializable;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public class LeastSquaresRegressionResult
implements RegressionResult<DenseVector<Object>, Object>,
Product,
Serializable {
    private final DenseVector coefficients;
    private final double rSquared;

    public static LeastSquaresRegressionResult fromProduct(Product product2) {
        return LeastSquaresRegressionResult$.MODULE$.fromProduct(product2);
    }

    public static LeastSquaresRegressionResult unapply(LeastSquaresRegressionResult leastSquaresRegressionResult) {
        return LeastSquaresRegressionResult$.MODULE$.unapply(leastSquaresRegressionResult);
    }

    public LeastSquaresRegressionResult(DenseVector<Object> coefficients, double rSquared) {
        this.coefficients = coefficients;
        this.rSquared = rSquared;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.coefficients()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.rSquared()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof LeastSquaresRegressionResult)) return false;
        LeastSquaresRegressionResult leastSquaresRegressionResult = (LeastSquaresRegressionResult)object;
        if (this.rSquared() != leastSquaresRegressionResult.rSquared()) return false;
        DenseVector<Object> denseVector = this.coefficients();
        DenseVector<Object> denseVector2 = leastSquaresRegressionResult.coefficients();
        if (denseVector == null) {
            if (denseVector2 != null) {
                return false;
            }
        } else if (!((Object)denseVector).equals(denseVector2)) return false;
        if (!leastSquaresRegressionResult.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof LeastSquaresRegressionResult;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "LeastSquaresRegressionResult";
    }

    public Object productElement(int n) {
        Serializable serializable;
        int n2 = n;
        if (0 == n2) {
            serializable = this._1();
        } else if (1 == n2) {
            serializable = BoxesRunTime.boxToDouble((double)this._2());
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return serializable;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "coefficients";
        } else if (1 == n2) {
            string = "rSquared";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public DenseVector<Object> coefficients() {
        return this.coefficients;
    }

    public double rSquared() {
        return this.rSquared;
    }

    public double apply(DenseVector<Object> x) {
        return BoxesRunTime.unboxToDouble((Object)this.coefficients().dot(x, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
    }

    public DenseVector<Object> apply(DenseMatrix<Object> X) {
        return (DenseVector)X.$times(this.coefficients(), (UFunc.UImpl2)HasOps$.MODULE$.impl_OpMulMatrix_DMD_DVD_eq_DVD());
    }

    public LeastSquaresRegressionResult copy(DenseVector<Object> coefficients, double rSquared) {
        return new LeastSquaresRegressionResult(coefficients, rSquared);
    }

    public DenseVector<Object> copy$default$1() {
        return this.coefficients();
    }

    public double copy$default$2() {
        return this.rSquared();
    }

    public DenseVector<Object> _1() {
        return this.coefficients();
    }

    public double _2() {
        return this.rSquared();
    }
}

