/*
 * Decompiled with CFR 0.152.
 */
package breeze.util;

import breeze.util.ArrayBuilder$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public abstract class ArrayBuilder<T>
implements ReusableBuilder<T, Object>,
Serializable {
    private static final long serialVersionUID = 3L;
    private int capacity;
    private int size;

    public static <T> ArrayBuilder<T> make(ClassTag<T> classTag) {
        return ArrayBuilder$.MODULE$.make(classTag);
    }

    public <T> ArrayBuilder() {
        Growable.$init$((Growable)this);
        Builder.$init$((Builder)this);
        this.capacity = 0;
        this.size = 0;
    }

    public int capacity() {
        return this.capacity;
    }

    public void capacity_$eq(int x$1) {
        this.capacity = x$1;
    }

    public abstract Object elems();

    public int size() {
        return this.size;
    }

    public void size_$eq(int x$1) {
        this.size = x$1;
    }

    public int length() {
        return this.size();
    }

    public int knownSize() {
        return this.size();
    }

    public final void ensureSize(int size) {
        if (this.capacity() < size || this.capacity() == 0) {
            int newsize;
            int n = newsize = this.capacity() == 0 ? 16 : this.capacity() * 2;
            while (newsize < size) {
                newsize *= 2;
            }
            this.resize(newsize);
        }
    }

    public final void sizeHint(int size) {
        if (this.capacity() < size) {
            this.resize(size);
        }
    }

    public void clear() {
        this.size_$eq(0);
    }

    public abstract void resize(int var1);

    public ArrayBuilder addAll(Object xs) {
        return this.addAll(xs, 0, ScalaRunTime$.MODULE$.array_length(xs));
    }

    public ArrayBuilder addAll(Object xs, int offset, int length) {
        this.ensureSize(this.size() + length);
        Array$.MODULE$.copy(xs, offset, this.elems(), this.size(), length);
        this.size_$eq(this.size() + length);
        return this;
    }

    public ArrayBuilder addAll(IterableOnce<T> xs) {
        int k = xs.knownSize();
        if (k > 0) {
            int n;
            this.ensureSize(this.size() + k);
            IterableOnce<T> iterableOnce = xs;
            if (iterableOnce instanceof Iterable) {
                Iterable xs2 = (Iterable)iterableOnce;
                n = xs2.copyToArray(this.elems(), this.size());
            } else {
                n = xs.iterator().copyToArray(this.elems(), this.size());
            }
            this.size_$eq(this.size() + k);
        } else if (k < 0) {
            Growable.addAll$((Growable)this, xs);
        }
        return this;
    }

    public static class ofBoolean
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private boolean[] elems;

        public boolean[] elems() {
            return this.elems;
        }

        public void elems_$eq(boolean[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private boolean[] mkArray(int size) {
            void var2_2;
            boolean[] newelems = new boolean[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofBoolean addOne(boolean elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public boolean[] result() {
            boolean[] blArray;
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                boolean[] res = this.elems();
                this.elems_$eq(null);
                blArray = var1_1;
            } else {
                blArray = this.mkArray(this.size());
            }
            return blArray;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofBoolean) {
                ofBoolean x = (ofBoolean)object;
                bl = this.size() == x.size() && this.elems() == x.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofBoolean";
        }
    }

    public static final class ofByte
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private byte[] elems;

        public byte[] elems() {
            return this.elems;
        }

        public void elems_$eq(byte[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private byte[] mkArray(int size) {
            void var2_2;
            byte[] newelems = new byte[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofByte addOne(byte elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public byte[] result() {
            byte[] byArray;
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                byte[] res = this.elems();
                this.elems_$eq(null);
                byArray = var1_1;
            } else {
                byArray = this.mkArray(this.size());
            }
            return byArray;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofByte) {
                ofByte x = (ofByte)object;
                bl = this.size() == x.size() && this.elems() == x.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofByte";
        }
    }

    public static final class ofChar
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private char[] elems;

        public char[] elems() {
            return this.elems;
        }

        public void elems_$eq(char[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private char[] mkArray(int size) {
            void var2_2;
            char[] newelems = new char[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofChar addOne(char elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public char[] result() {
            char[] cArray;
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                char[] res = this.elems();
                this.elems_$eq(null);
                cArray = var1_1;
            } else {
                cArray = this.mkArray(this.size());
            }
            return cArray;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofChar) {
                ofChar x = (ofChar)object;
                bl = this.size() == x.size() && this.elems() == x.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofChar";
        }
    }

    public static final class ofDouble
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private double[] elems;

        public double[] elems() {
            return this.elems;
        }

        public void elems_$eq(double[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private double[] mkArray(int size) {
            void var2_2;
            double[] newelems = new double[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofDouble addOne(double elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public double[] result() {
            double[] dArray;
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                double[] res = this.elems();
                this.elems_$eq(null);
                dArray = var1_1;
            } else {
                dArray = this.mkArray(this.size());
            }
            return dArray;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofDouble) {
                ofDouble x = (ofDouble)object;
                bl = this.size() == x.size() && this.elems() == x.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofDouble";
        }
    }

    public static final class ofFloat
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private float[] elems;

        public float[] elems() {
            return this.elems;
        }

        public void elems_$eq(float[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private float[] mkArray(int size) {
            void var2_2;
            float[] newelems = new float[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofFloat addOne(float elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public float[] result() {
            float[] fArray;
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                float[] res = this.elems();
                this.elems_$eq(null);
                fArray = var1_1;
            } else {
                fArray = this.mkArray(this.size());
            }
            return fArray;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofFloat) {
                ofFloat x = (ofFloat)object;
                bl = this.size() == x.size() && this.elems() == x.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofFloat";
        }
    }

    public static final class ofInt
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private int[] elems;

        public int[] elems() {
            return this.elems;
        }

        public void elems_$eq(int[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private int[] mkArray(int size) {
            void var2_2;
            int[] newelems = new int[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofInt addOne(int elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public int[] result() {
            int[] nArray;
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                int[] res = this.elems();
                this.elems_$eq(null);
                nArray = var1_1;
            } else {
                nArray = this.mkArray(this.size());
            }
            return nArray;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofInt) {
                ofInt x = (ofInt)object;
                bl = this.size() == x.size() && this.elems() == x.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofInt";
        }
    }

    public static final class ofLong
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private long[] elems;

        public long[] elems() {
            return this.elems;
        }

        public void elems_$eq(long[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private long[] mkArray(int size) {
            void var2_2;
            long[] newelems = new long[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofLong addOne(long elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public long[] result() {
            long[] lArray;
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                long[] res = this.elems();
                this.elems_$eq(null);
                lArray = var1_1;
            } else {
                lArray = this.mkArray(this.size());
            }
            return lArray;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofLong) {
                ofLong x = (ofLong)object;
                bl = this.size() == x.size() && this.elems() == x.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofLong";
        }
    }

    public static final class ofRef<T>
    extends ArrayBuilder<T> {
        private static final long serialVersionUID = 3L;
        private final ClassTag<T> ct;
        private Object[] elems;

        public <T> ofRef(ClassTag<T> ct) {
            this.ct = ct;
        }

        public T[] elems() {
            return this.elems;
        }

        public void elems_$eq(T[] x$1) {
            this.elems = x$1;
        }

        private T[] mkArray(int size) {
            return this.capacity() == size && this.capacity() > 0 ? this.elems() : (this.elems() == null ? (Object[])Arrays$.MODULE$.newGenericArray(size, this.ct) : Arrays.copyOf(this.elems(), size));
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofRef addOne(T elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public T[] result() {
            T[] TArray;
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                T[] res = this.elems();
                this.elems_$eq(null);
                TArray = var1_1;
            } else {
                TArray = this.mkArray(this.size());
            }
            return TArray;
        }

        @Override
        public void clear() {
            super.clear();
            if (this.elems() != null) {
                Arrays.fill(this.elems(), null);
            }
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofRef) {
                ofRef x = (ofRef)object;
                bl = this.size() == x.size() && this.elems() == x.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofRef";
        }
    }

    public static final class ofShort
    extends ArrayBuilder<Object> {
        private static final long serialVersionUID = 3L;
        private short[] elems;

        public short[] elems() {
            return this.elems;
        }

        public void elems_$eq(short[] x$1) {
            this.elems = x$1;
        }

        /*
         * WARNING - void declaration
         */
        private short[] mkArray(int size) {
            void var2_2;
            short[] newelems = new short[size];
            if (this.size() > 0) {
                Array$.MODULE$.copy((Object)this.elems(), 0, (Object)newelems, 0, this.size());
            }
            return var2_2;
        }

        @Override
        public void resize(int size) {
            this.elems_$eq(this.mkArray(size));
            this.capacity_$eq(size);
        }

        public ofShort addOne(short elem) {
            this.ensureSize(this.size() + 1);
            this.elems()[this.size()] = elem;
            this.size_$eq(this.size() + 1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public short[] result() {
            short[] sArray;
            if (this.capacity() != 0 && this.capacity() == this.size()) {
                void var1_1;
                this.capacity_$eq(0);
                short[] res = this.elems();
                this.elems_$eq(null);
                sArray = var1_1;
            } else {
                sArray = this.mkArray(this.size());
            }
            return sArray;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofShort) {
                ofShort x = (ofShort)object;
                bl = this.size() == x.size() && this.elems() == x.elems();
            } else {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            return "ArrayBuilder.ofShort";
        }
    }

    public static final class ofUnit
    extends ArrayBuilder<BoxedUnit> {
        private static final long serialVersionUID = 3L;

        public BoxedUnit[] elems() {
            throw new UnsupportedOperationException();
        }

        public ofUnit addOne(BoxedUnit elem) {
            this.size_$eq(this.size() + 1);
            return this;
        }

        public ofUnit addAll(IterableOnce<BoxedUnit> xs) {
            this.size_$eq(this.size() + xs.iterator().size());
            return this;
        }

        public ofUnit addAll(BoxedUnit[] xs, int offset, int length) {
            this.size_$eq(this.size() + length);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public BoxedUnit[] result() {
            void var1_1;
            BoxedUnit[] ans = new BoxedUnit[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                ans[i] = BoxedUnit.UNIT;
            }
            return var1_1;
        }

        public boolean equals(Object other) {
            boolean bl;
            Object object = other;
            if (object instanceof ofUnit) {
                ofUnit x = (ofUnit)object;
                bl = this.size() == x.size();
            } else {
                bl = false;
            }
            return bl;
        }

        @Override
        public void resize(int size) {
        }

        public String toString() {
            return "ArrayBuilder.ofUnit";
        }
    }
}

