/*
 * Decompiled with CFR 0.152.
 */
package breeze.util;

import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function0;

public class LazyLogger
implements Serializable {
    private final Logger logger;

    public LazyLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger logger() {
        return this.logger;
    }

    public void info(Function0 msg) {
        if (this.logger().isInfoEnabled()) {
            this.logger().info((String)msg.apply());
        }
    }

    public void debug(Function0 msg) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((String)msg.apply());
        }
    }

    public void trace(Function0 msg) {
        if (this.logger().isTraceEnabled()) {
            this.logger().trace((String)msg.apply());
        }
    }

    public void warn(Function0 msg) {
        if (this.logger().isWarnEnabled()) {
            this.logger().warn((String)msg.apply());
        }
    }

    public void error(Function0 msg) {
        if (this.logger().isErrorEnabled()) {
            this.logger().error((String)msg.apply());
        }
    }

    public void info(Function0 msg, Throwable throwable) {
        if (this.logger().isInfoEnabled()) {
            this.logger().info((String)msg.apply(), throwable);
        }
    }

    public void debug(Function0 msg, Throwable throwable) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug((String)msg.apply(), throwable);
        }
    }

    public void trace(Function0 msg, Throwable throwable) {
        if (this.logger().isTraceEnabled()) {
            this.logger().trace((String)msg.apply(), throwable);
        }
    }

    public void warn(Function0 msg, Throwable throwable) {
        if (this.logger().isWarnEnabled()) {
            this.logger().warn((String)msg.apply(), throwable);
        }
    }

    public void error(Function0 msg, Throwable throwable) {
        if (this.logger().isErrorEnabled()) {
            this.logger().error((String)msg.apply(), throwable);
        }
    }
}

