/*
 * Decompiled with CFR 0.152.
 */
package breeze.collection.immutable;

import breeze.collection.immutable.Beam$;
import breeze.collection.immutable.BinomialHeap;
import breeze.collection.immutable.BinomialHeap$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.collection.BuildFrom;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;

public class Beam<T>
implements Iterable<T>,
StrictOptimizedIterableOps<T, Iterable, Beam<T>> {
    private final int maxSize;
    private final Ordering<T> o;
    private final BinomialHeap heap;

    public static <T> Beam<T> apply(int n, Seq<T> seq, Ordering<T> ordering) {
        return Beam$.MODULE$.apply(n, seq, ordering);
    }

    public static <T, U> BuildFrom<Beam<T>, U, Beam<U>> canBuildFrom(Ordering<U> ordering) {
        return Beam$.MODULE$.canBuildFrom(ordering);
    }

    public <T> Beam(int maxSize, Seq<T> xs, Ordering<T> o) {
        this.maxSize = maxSize;
        this.o = o;
        IterableOnce.$init$((IterableOnce)this);
        IterableOnceOps.$init$((IterableOnceOps)this);
        IterableOps.$init$((IterableOps)this);
        IterableFactoryDefaults.$init$((IterableFactoryDefaults)this);
        Iterable.$init$((Iterable)this);
        StrictOptimizedIterableOps.$init$((StrictOptimizedIterableOps)this);
        if (maxSize < 0) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.heap = this.trim(BinomialHeap$.MODULE$.apply(xs, o));
    }

    public int maxSize() {
        return this.maxSize;
    }

    public BinomialHeap<T> heap() {
        return this.heap;
    }

    public int size() {
        return this.heap().size();
    }

    public <T> Beam(int maxSize, Ordering<T> o) {
        this(maxSize, (Seq<T>)package$.MODULE$.Nil(), o);
    }

    /*
     * WARNING - void declaration
     */
    private BinomialHeap<T> trim(BinomialHeap<T> h2) {
        void var2_2;
        BinomialHeap<T> h = h2;
        while (h.size() > this.maxSize()) {
            h = h.delMin();
        }
        return var2_2;
    }

    public BinomialHeap<T> breeze$collection$immutable$Beam$$cat(BinomialHeap<T> h, T x) {
        return h.size() < this.maxSize() ? h.$plus(x) : (this.o.compare(h.min(), x) < 0 ? h.delMin().$plus(x) : h);
    }

    public Beam<T> $plus(T x) {
        return new Beam<T>(x, this){
            private final BinomialHeap heap;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                super($outer.breeze$collection$immutable$Beam$$_$$anon$superArg$1$1(), $outer.breeze$collection$immutable$Beam$$_$$anon$superArg$2$1());
                this.heap = $outer.breeze$collection$immutable$Beam$$cat($outer.heap(), x$1);
            }

            public BinomialHeap heap() {
                return this.heap;
            }
        };
    }

    public Iterator<T> iterator() {
        return this.heap().iterator();
    }

    public String toString() {
        return this.iterator().mkString("Beam(", ",", ")");
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof Beam) {
            Beam b = (Beam)object;
            bl = this.maxSize() == b.maxSize() && this.iterator().sameElements(b.iterator());
        } else {
            bl = false;
        }
        return bl;
    }

    public T min() {
        return (T)this.heap().head();
    }

    public Option<T> best() {
        return this.heap().reduceOption((Function2 & Serializable)(_$1, _$2) -> this.o.max(_$1, _$2));
    }

    public <B> Beam<B> map(Function1<T, B> f, Ordering<B> ev) {
        return (Beam)this.strictOptimizedMap(Beam$.MODULE$.canBuildFrom(ev).newBuilder((Object)this), f);
    }

    public <B> Beam<B> flatMap(Function1<T, IterableOnce<B>> f, Ordering<B> ev) {
        return (Beam)this.strictOptimizedFlatMap(Beam$.MODULE$.canBuildFrom(ev).newBuilder((Object)this), f);
    }

    public <B> Beam<B> collect(PartialFunction<T, B> pf, Ordering<B> ev) {
        return (Beam)this.strictOptimizedCollect(Beam$.MODULE$.canBuildFrom(ev).newBuilder((Object)this), pf);
    }

    public Beam<T> concat(IterableOnce<T> that) {
        return (Beam)that.iterator().foldLeft((Object)this, (Function2 & Serializable)(_$3, _$4) -> _$3.$plus(_$4));
    }

    public Beam<T> $plus$plus(IterableOnce<T> that) {
        return this.concat((IterableOnce)that);
    }

    public Builder<T, Beam<T>> newBuilder() {
        return Beam$.MODULE$.canBuildFrom(this.o).newBuilder((Object)this);
    }

    public Beam<T> fromSpecific(IterableOnce<T> coll) {
        return (Beam)((Builder)this.newBuilder().$plus$plus$eq(coll)).result();
    }

    public Builder<T, Beam<T>> newSpecificBuilder() {
        return Beam$.MODULE$.canBuildFrom(this.o).newBuilder((Object)this);
    }

    public Beam<T> empty() {
        return Beam$.MODULE$.apply(this.maxSize(), ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), this.o);
    }

    public final int breeze$collection$immutable$Beam$$_$$anon$superArg$1$1() {
        return this.maxSize();
    }

    public final Ordering breeze$collection$immutable$Beam$$_$$anon$superArg$2$1() {
        return this.o;
    }
}

