/*
 * Decompiled with CFR 0.152.
 */
package breeze.io;

import breeze.io.ByteConverter;
import breeze.io.RandomAccessFile$;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import scala.Byte$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import spire.math.ULong;

public class RandomAccessFile
implements DataInput,
DataOutput,
Closeable {
    private final ByteConverter converter;
    private final java.io.RandomAccessFile rafObj;

    public static String $lessinit$greater$default$2() {
        return RandomAccessFile$.MODULE$.$lessinit$greater$default$2();
    }

    public static ByteConverter $lessinit$greater$default$3(File file, String string) {
        return RandomAccessFile$.MODULE$.$lessinit$greater$default$3(file, string);
    }

    public RandomAccessFile(File file, String arg0, ByteConverter converter) {
        this.converter = converter;
        this.rafObj = new java.io.RandomAccessFile(file, arg0);
    }

    public RandomAccessFile(String filename, String arg0, ByteConverter converter) {
        this(new File(filename), arg0, converter);
    }

    public java.io.RandomAccessFile rafObj() {
        return this.rafObj;
    }

    public final byte readInt8() throws IOException {
        return this.rafObj().readByte();
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] readInt8(int n) throws IOException {
        void var2_2;
        byte[] tempret = new byte[n];
        this.rafObj().readFully(tempret);
        return var2_2;
    }

    public final void writeInt8(byte v) throws IOException {
        this.rafObj().write(Byte$.MODULE$.byte2int(v));
    }

    public final void writeInt8(byte[] v) throws IOException {
        this.rafObj().write(v);
    }

    @Override
    public final byte readByte() throws IOException {
        return this.readInt8();
    }

    public final byte[] readByte(int n) throws IOException {
        return this.readInt8(n);
    }

    public final void write(byte v) throws IOException {
        this.writeInt8(v);
    }

    @Override
    public final void write(byte[] v) throws IOException {
        this.writeInt8(v);
    }

    public final int readUInt8() throws IOException {
        return this.rafObj().readUnsignedByte();
    }

    /*
     * WARNING - void declaration
     */
    public final short[] readUInt8(int n) throws IOException {
        void var2_2;
        short[] tr = new short[n];
        for (int c = 0; c < n; ++c) {
            tr[c] = (short)this.readUnsignedByte();
        }
        return var2_2;
    }

    public final void writeUInt8(short value) throws IOException {
        this.rafObj().write(new byte[]{this.converter.uInt8ToByte(value)});
    }

    public final void writeUInt8(short[] values) throws IOException {
        Object object = Predef$.MODULE$.shortArrayOps(values);
        this.rafObj().write((byte[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> this.writeUInt8$$anonfun$1(BoxesRunTime.unboxToShort((Object)_$1)), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.readUInt8();
    }

    public final short[] readUnsignedByte(int n) throws IOException {
        return this.readUInt8(n);
    }

    public final void writeUnsignedByte(short value) throws IOException {
        this.writeUInt8(value);
    }

    public final void writeUnsignedByte(short[] values) throws IOException {
        this.writeUInt8(values);
    }

    public short readInt16() throws IOException {
        byte[] ba = this.readByte(2);
        return this.converter.bytesToInt16(ba[0], ba[1]);
    }

    /*
     * WARNING - void declaration
     */
    public final short[] readInt16(int n) throws IOException {
        void var3_3;
        byte[] ba = new byte[n * 2];
        this.rafObj().readFully(ba);
        short[] tr = new short[n];
        for (int c = 0; c < n; ++c) {
            tr[c] = this.converter.bytesToInt16(ba[c * 2], ba[c * 2 + 1]);
        }
        return var3_3;
    }

    public final void writeInt16(short v) throws IOException {
        this.rafObj().write(this.converter.int16ToBytes(v));
    }

    public final void writeInt16(short[] v) throws IOException {
        byte[] writeArr = new byte[v.length * 2];
        IntRef currIndex = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), v.length).foreach((Function1)(JFunction1.mcVI.sp & Serializable)cnt -> {
            int n;
            int n2;
            byte[] x = this.converter.int16ToBytes(v[cnt]);
            writeArr$1[currIndex$1.elem] = x[0];
            currIndex$1.elem = n2 = currIndex$1.elem + 1;
            writeArr$1[currIndex$1.elem] = x[1];
            currIndex$1.elem = n = currIndex$1.elem + 1;
        });
        this.rafObj().write(writeArr);
    }

    @Override
    public final short readShort() throws IOException {
        return this.readInt16();
    }

    public final short[] readShort(int n) throws IOException {
        return this.readInt16(n);
    }

    public final void writeShort(short v) throws IOException {
        this.writeInt16(v);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.writeInt16((short)v);
    }

    public final void writeShort(short[] v) throws IOException {
        this.writeInt16(v);
    }

    public char readUInt16() throws IOException {
        byte[] ba = this.readByte(2);
        return this.converter.bytesToUInt16(ba[0], ba[1]);
    }

    /*
     * WARNING - void declaration
     */
    public final char[] readUInt16(int n) throws IOException {
        void var3_3;
        byte[] ba = new byte[n * 2];
        this.rafObj().readFully(ba);
        char[] tr = new char[n];
        for (int c = 0; c < n; ++c) {
            tr[c] = this.converter.bytesToUInt16(ba[c * 2], ba[c * 2 + 1]);
        }
        return var3_3;
    }

    public final void writeUInt16(char v) throws IOException {
        this.rafObj().write(this.converter.uInt16ToBytes(v));
    }

    public final void writeUInt16(char[] v) throws IOException {
        Object object = Predef$.MODULE$.charArrayOps(v);
        this.rafObj().write((byte[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$2 -> this.writeUInt16$$anonfun$2(BoxesRunTime.unboxToChar((Object)_$2)), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.readUInt16();
    }

    public final int[] readUnsignedShort(int n) throws IOException {
        Object object = Predef$.MODULE$.charArrayOps(this.readUInt16(n));
        return (int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> BoxesRunTime.unboxToChar((Object)_$3), ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    @Override
    public final char readChar() throws IOException {
        return this.readUInt16();
    }

    public final char[] readChar(int n) throws IOException {
        return this.readUInt16(n);
    }

    public final void writeUnsignedShort(int value) throws IOException {
        this.writeUInt16((char)value);
    }

    public final void writeUnsignedShort(int[] value) throws IOException {
        Object object = Predef$.MODULE$.intArrayOps(value);
        this.writeUInt16((char[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$4 -> RandomAccessFile.writeUnsignedShort$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$4)), ClassTag$.MODULE$.apply(Character.TYPE)));
    }

    public final void writeChar(char value) throws IOException {
        this.writeUInt16(value);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.writeUInt16((char)v);
    }

    public final void WriteChar(char[] value) throws IOException {
        this.writeUInt16(value);
    }

    public final int readInt32() throws IOException {
        byte[] ba = this.readByte(4);
        return this.converter.bytesToInt32(ba[0], ba[1], ba[2], ba[3]);
    }

    /*
     * WARNING - void declaration
     */
    public final int[] readInt32(int n) throws IOException {
        void var3_3;
        byte[] ba = new byte[n * 4];
        this.rafObj().readFully(ba);
        int[] tr = new int[n];
        for (int c = 0; c < n; ++c) {
            tr[c] = this.converter.bytesToInt32(ba[c * 4], ba[c * 4 + 1], ba[c * 4 + 2], ba[c * 4 + 3]);
        }
        return var3_3;
    }

    public final void writeInt32(int v) throws IOException {
        this.rafObj().write(this.converter.int32ToBytes(v));
    }

    public final void writeInt32(int[] v) throws IOException {
        Object object = Predef$.MODULE$.intArrayOps(v);
        this.rafObj().write((byte[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$5 -> this.writeInt32$$anonfun$2(BoxesRunTime.unboxToInt((Object)_$5)), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    @Override
    public final int readInt() throws IOException {
        return this.readInt32();
    }

    public final int[] readInt(int n) throws IOException {
        return this.readInt32(n);
    }

    @Override
    public final void writeInt(int value) throws IOException {
        this.writeInt32(value);
    }

    public final void writeInt(int[] value) throws IOException {
        this.writeInt32(value);
    }

    public final long readUInt32() throws IOException {
        byte[] ba = this.readByte(4);
        return this.converter.bytesToUInt32(ba[0], ba[1], ba[2], ba[3]);
    }

    /*
     * WARNING - void declaration
     */
    public final long[] readUInt32(int n) throws IOException {
        void var3_3;
        byte[] ba = new byte[n * 4];
        this.rafObj().readFully(ba);
        long[] tr = new long[n];
        for (int c = 0; c < n; ++c) {
            tr[c] = this.converter.bytesToUInt32(ba[c * 4], ba[c * 4 + 1], ba[c * 4 + 2], ba[c * 4 + 3]);
        }
        return var3_3;
    }

    public final void writeUInt32(long v) throws IOException {
        this.rafObj().write(this.converter.uInt32ToBytes(v));
    }

    public final void writeUInt32(long[] v) throws IOException {
        Object object = Predef$.MODULE$.longArrayOps(v);
        this.rafObj().write((byte[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$6 -> this.writeUInt32$$anonfun$2(BoxesRunTime.unboxToLong((Object)_$6)), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public long readInt64() throws IOException {
        byte[] ba = this.readByte(8);
        return this.converter.bytesToInt64(ba[0], ba[1], ba[2], ba[3], ba[4], ba[5], ba[6], ba[7]);
    }

    /*
     * WARNING - void declaration
     */
    public final long[] readInt64(int n) throws IOException {
        void var3_3;
        byte[] ba = new byte[n * 8];
        this.rafObj().readFully(ba);
        long[] tr = new long[n];
        for (int c = 0; c < n; ++c) {
            int c8 = c * 8;
            tr[c] = this.converter.bytesToInt64(ba[c8], ba[c8 + 1], ba[c8 + 2], ba[c8 + 3], ba[c8 + 4], ba[c8 + 5], ba[c8 + 6], ba[c8 + 7]);
        }
        return var3_3;
    }

    public final void writeInt64(long v) throws IOException {
        this.rafObj().write(this.converter.int64ToBytes(v));
    }

    public final void writeInt64(long[] v) throws IOException {
        Object object = Predef$.MODULE$.longArrayOps(v);
        this.rafObj().write((byte[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$7 -> this.writeInt64$$anonfun$2(BoxesRunTime.unboxToLong((Object)_$7)), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    @Override
    public final long readLong() throws IOException {
        return this.readInt64();
    }

    public final long[] readLong(int n) throws IOException {
        return this.readInt64(n);
    }

    @Override
    public final void writeLong(long value) throws IOException {
        this.writeInt64(value);
    }

    public final void writeLong(long[] value) throws IOException {
        this.writeInt64(value);
    }

    public final long readUInt64() throws IOException {
        byte[] ba = this.readByte(8);
        return this.converter.bytesToUInt64(ba[0], ba[1], ba[2], ba[3], ba[4], ba[5], ba[6], ba[7]);
    }

    /*
     * WARNING - void declaration
     */
    public final long[] readUInt64(int n) throws IOException {
        void var3_3;
        byte[] ba = new byte[n * 8];
        this.rafObj().readFully(ba);
        ULong[] tr = new ULong[n];
        for (int c = 0; c < n; ++c) {
            int c8 = c * 8;
            tr[c] = new ULong(this.converter.bytesToUInt64(ba[c8], ba[c8 + 1], ba[c8 + 2], ba[c8 + 3], ba[c8 + 4], ba[c8 + 5], ba[c8 + 6], ba[c8 + 7]));
        }
        return var3_3;
    }

    public final void writeUInt64(long v) throws IOException {
        this.rafObj().write(this.converter.uInt64ToBytes(v));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public final void writeUInt64(ULong[] v) throws IOException {
        Object object = Predef$.MODULE$.genericArrayOps((Object)v);
        this.rafObj().write((byte[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$8 -> this.writeUInt64$$anonfun$2(_$8 == null ? BoxesRunTime.unboxToLong(null) : ((ULong)_$8).signed()), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public final long readUInt64Shifted() throws IOException {
        byte[] ba = this.readByte(8);
        return this.converter.bytesToUInt64Shifted(ba[0], ba[1], ba[2], ba[3], ba[4], ba[5], ba[6], ba[7]);
    }

    /*
     * WARNING - void declaration
     */
    public final long[] readUInt64Shifted(int n) throws IOException {
        void var3_3;
        byte[] ba = new byte[n * 8];
        this.rafObj().readFully(ba);
        long[] tr = new long[n];
        for (int c = 0; c < n; ++c) {
            int c8 = c * 8;
            tr[c] = this.converter.bytesToUInt64Shifted(ba[c8], ba[c8 + 1], ba[c8 + 2], ba[c8 + 3], ba[c8 + 4], ba[c8 + 5], ba[c8 + 6], ba[c8 + 7]);
        }
        return var3_3;
    }

    public final void writeUInt64Shifted(long v) throws IOException {
        this.rafObj().write(this.converter.uInt64ShiftedToBytes(v));
    }

    public final void writeUInt64Shifted(long[] v) throws IOException {
        Object object = Predef$.MODULE$.longArrayOps(v);
        this.rafObj().write((byte[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$9 -> this.writeUInt64Shifted$$anonfun$2(BoxesRunTime.unboxToLong((Object)_$9)), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    /*
     * WARNING - void declaration
     */
    public final double[] readDouble(int n) throws IOException {
        void var3_3;
        byte[] ba = new byte[n * 8];
        this.rafObj().readFully(ba);
        double[] tr = new double[n];
        for (int c = 0; c < n; ++c) {
            int c8 = c * 8;
            tr[c] = Double.longBitsToDouble(this.converter.bytesToInt64(ba[c8], ba[c8 + 1], ba[c8 + 2], ba[c8 + 3], ba[c8 + 4], ba[c8 + 5], ba[c8 + 6], ba[c8 + 7]));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final float[] readFloat(int n) throws IOException {
        void var3_3;
        byte[] ba = new byte[n * 4];
        this.rafObj().readFully(ba);
        float[] tr = new float[n];
        for (int c = 0; c < n; ++c) {
            int c4 = c * 4;
            tr[c] = Float.intBitsToFloat(this.converter.bytesToInt32(ba[c4], ba[c4 + 1], ba[c4 + 2], ba[c4 + 3]));
        }
        return var3_3;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt32(Float.floatToRawIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeInt64(Double.doubleToRawLongBits(v));
    }

    public void writeDouble(double[] v) throws IOException {
        long[] la = new long[v.length];
        for (int c = 0; c < v.length; ++c) {
            la[c] = Double.doubleToRawLongBits(v[c]);
        }
        this.writeLong(la);
    }

    public void writeFloat(float[] v) throws IOException {
        int[] ia = new int[v.length];
        for (int c = 0; c < v.length; ++c) {
            ia[c] = Float.floatToRawIntBits(v[c]);
        }
        this.writeInt(ia);
    }

    @Override
    public final boolean readBoolean() {
        return this.rafObj().readBoolean();
    }

    @Override
    public void readFully(byte[] b) {
        this.rafObj().readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) {
        this.rafObj().readFully(b, off, len);
    }

    @Override
    public String readLine() {
        return this.rafObj().readLine();
    }

    @Override
    public String readUTF() {
        return this.rafObj().readUTF();
    }

    @Override
    public final void writeChars(String value) {
        this.rafObj().writeChars(value);
    }

    @Override
    public void writeUTF(String value) {
        this.rafObj().writeUTF(value);
    }

    @Override
    public int skipBytes(int n) {
        return this.rafObj().skipBytes(n);
    }

    public void jumpBytes(int n) {
        this.rafObj().seek(this.rafObj().getFilePointer() + (long)n);
    }

    public long getFilePointer() {
        return this.rafObj().getFilePointer();
    }

    public void seek(long pos) {
        this.rafObj().seek(pos);
    }

    public long length() {
        return this.rafObj().length();
    }

    public void setLength(long newLength) {
        this.rafObj().setLength(newLength);
    }

    @Override
    public void close() {
        this.rafObj().close();
    }

    public FileChannel getChannel() {
        return this.rafObj().getChannel();
    }

    public FileDescriptor getFD() {
        return this.rafObj().getFD();
    }

    @Override
    public void write(int b) {
        this.rafObj().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.rafObj().write(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.rafObj().writeBoolean(v);
    }

    @Override
    public void writeByte(int v) {
        this.rafObj().writeByte(v);
    }

    @Override
    public void writeBytes(String s) {
        this.rafObj().writeBytes(s);
    }

    private final /* synthetic */ byte writeUInt8$$anonfun$1(short _$1) {
        return this.converter.uInt8ToByte(_$1);
    }

    private final /* synthetic */ byte[] writeUInt16$$anonfun$2(char _$2) {
        return this.converter.uInt16ToBytes(_$2);
    }

    private static final /* synthetic */ char writeUnsignedShort$$anonfun$1(int _$4) {
        return (char)_$4;
    }

    private final /* synthetic */ byte[] writeInt32$$anonfun$2(int _$5) {
        return this.converter.int32ToBytes(_$5);
    }

    private final /* synthetic */ byte[] writeUInt32$$anonfun$2(long _$6) {
        return this.converter.uInt32ToBytes(_$6);
    }

    private final /* synthetic */ byte[] writeInt64$$anonfun$2(long _$7) {
        return this.converter.int64ToBytes(_$7);
    }

    private final /* synthetic */ byte[] writeUInt64$$anonfun$2(long _$8) {
        return this.converter.uInt64ToBytes(_$8);
    }

    private final /* synthetic */ byte[] writeUInt64Shifted$$anonfun$2(long _$9) {
        return this.converter.uInt64ShiftedToBytes(_$9);
    }
}

