/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.LSMR$SafeDiv$;
import breeze.linalg.NumericOps;
import breeze.linalg.max$;
import breeze.linalg.min$;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.support.CanTranspose;
import breeze.math.MutableInnerProductVectorSpace;
import breeze.numerics.package$abs$;
import breeze.numerics.package$abs$absDoubleImpl$;
import breeze.numerics.package$sqrt$;
import breeze.numerics.package$sqrt$sqrtDoubleImpl$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import java.io.Serializable;
import scala.Conversion;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class LSMR$
implements SerializableLogging,
Serializable {
    private static volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;
    private static final LSMR$SafeDiv$ SafeDiv;
    public static final LSMR$ MODULE$;

    private LSMR$() {
    }

    static {
        MODULE$ = new LSMR$();
        SerializableLogging.$init$(MODULE$);
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LSMR$.class);
    }

    public <M, MT, V> V solve(M A, V b, double regularization, double tolerance, int maxIter, boolean quiet, UFunc.UImpl2<OpMulMatrix$, M, V, V> multMV, CanTranspose<M, MT> transA, UFunc.UImpl2<OpMulMatrix$, MT, V, V> multMTV, MutableInnerProductVectorSpace<V, Object> ispace) {
        double lambda = package$.MODULE$.sqrt(regularization);
        MT At = transA.apply(A);
        double atol = tolerance;
        double btol = tolerance;
        Object u = ispace.copy().apply(b);
        double normb = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(u, ispace.normImpl()));
        double beta = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(u, ispace.normImpl()));
        if (beta > 0.0) {
            ((NumericOps)((Conversion)ispace.hasOps()).apply(u)).$div$eq(BoxesRunTime.boxToDouble((double)beta), ispace.divIntoVS());
        }
        V v = multMTV.apply(At, u);
        Object x = ((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(v)).$times(BoxesRunTime.boxToDouble((double)0.0), ispace.mulVS_M());
        double alpha = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)v, ispace.normImpl()));
        if (alpha > 0.0) {
            ((NumericOps)((Conversion)ispace.hasOps()).apply(v)).$div$eq(BoxesRunTime.boxToDouble((double)alpha), ispace.divIntoVS());
        }
        double alphabar = alpha;
        double zetabar = alpha * beta;
        double rho = 1.0;
        double rhobar = 1.0;
        double cbar = 1.0;
        double sbar = 0.0;
        double zeta = 0.0;
        V h = v;
        Object hbar = ((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(h)).$times(BoxesRunTime.boxToDouble((double)0.0), ispace.mulVS_M());
        double betadd = beta;
        double betad = 0.0;
        double rhodold = 1.0;
        double thetatilde = 0.0;
        double tautildeold = 0.0;
        double d = 0.0;
        double normA2 = this.sqr$1(alpha);
        double maxrbar = 0.0;
        double minrbar = 1.0E100;
        boolean converged = false;
        int iter = 0;
        while (!converged && iter < maxIter) {
            ++iter;
            u = ((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(multMV.apply(A, v))).$minus(((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(u)).$times(BoxesRunTime.boxToDouble((double)alpha), ispace.mulVS_M()), ispace.subVV());
            beta = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(u, ispace.normImpl()));
            if (beta > 0.0) {
                ((NumericOps)((Conversion)ispace.hasOps()).apply(u)).$div$eq(BoxesRunTime.boxToDouble((double)beta), ispace.divIntoVS());
                v = ((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(multMTV.apply(At, u))).$minus(((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(v)).$times(BoxesRunTime.boxToDouble((double)beta), ispace.mulVS_M()), ispace.subVV());
            }
            if ((alpha = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply((Object)v, ispace.normImpl()))) > 0.0) {
                ((NumericOps)((Conversion)ispace.hasOps()).apply(v)).$div$eq(BoxesRunTime.boxToDouble((double)alpha), ispace.divIntoVS());
            }
            double alphahat = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(DenseVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{alphabar, lambda}), ClassTag$.MODULE$.apply(Double.TYPE)), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), ispace.scalarNorm()))));
            double chat = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(alphabar), alphahat);
            double shat = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(lambda), alphahat);
            double rhoold = rho;
            rho = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(DenseVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{alphahat, beta}), ClassTag$.MODULE$.apply(Double.TYPE)), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), ispace.scalarNorm()))));
            double c = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(alphahat), rho);
            double s = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(beta), rho);
            double thetanew = s * alpha;
            alphabar = c * alpha;
            double rhobarold = rhobar;
            double zetaold = zeta;
            double thetabar = sbar * rho;
            double rhotemp = cbar * rho;
            rhobar = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(DenseVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{cbar * rho, thetanew}), ClassTag$.MODULE$.apply(Double.TYPE)), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), ispace.scalarNorm()))));
            cbar = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(cbar * rho), rhobar);
            sbar = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(thetanew), rhobar);
            zeta = cbar * zetabar;
            zetabar = -sbar * zetabar;
            hbar = ((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(h)).$minus(((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(hbar)).$times(BoxesRunTime.boxToDouble((double)(thetabar * rho / (rhoold * rhobarold))), ispace.mulVS_M()), ispace.subVV());
            x = ((NumericOps)((Conversion)ispace.hasOps()).apply(x)).$plus(((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(hbar)).$times(BoxesRunTime.boxToDouble((double)LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(zeta), rho * rhobar)), ispace.mulVS_M()), ispace.addVV());
            h = ((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(v)).$minus(((ImmutableNumericOps)((Conversion)ispace.hasOps()).apply(h)).$times(BoxesRunTime.boxToDouble((double)LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(thetanew), rho)), ispace.mulVS_M()), ispace.subVV());
            double betaacute = chat * betadd;
            double betacheck = -shat * betadd;
            double betahat = c * betaacute;
            betadd = -s * betaacute;
            double thetatildeold = thetatilde;
            double rhotildeold = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(DenseVector$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{rhodold, thetabar}), ClassTag$.MODULE$.apply(Double.TYPE)), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), ispace.scalarNorm()))));
            double ctildeold = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(rhodold), rhotildeold);
            double stildeold = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(thetabar), rhotildeold);
            thetatilde = stildeold * rhobar;
            rhodold = ctildeold * rhobar;
            betad = -stildeold * betad + ctildeold * betahat;
            tautildeold = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(zetaold - thetatildeold * tautildeold), rhotildeold);
            double taud = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(zeta - thetatilde * tautildeold), rhodold);
            double normr = BoxesRunTime.unboxToDouble((Object)package$sqrt$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((d += this.sqr$1(betacheck)) + this.sqr$1(betad - taud) + this.sqr$1(betadd))), (UFunc.UImpl)package$sqrt$sqrtDoubleImpl$.MODULE$));
            double normA = BoxesRunTime.unboxToDouble((Object)package$sqrt$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(normA2 += this.sqr$1(beta))), (UFunc.UImpl)package$sqrt$sqrtDoubleImpl$.MODULE$));
            normA2 += this.sqr$1(alpha);
            maxrbar = BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(BoxesRunTime.boxToDouble((double)maxrbar), BoxesRunTime.boxToDouble((double)rhobarold), max$.MODULE$.maxImpl2_Double()));
            if (iter > 1) {
                minrbar = BoxesRunTime.unboxToDouble((Object)min$.MODULE$.apply(BoxesRunTime.boxToDouble((double)minrbar), BoxesRunTime.boxToDouble((double)rhobarold), min$.MODULE$.minImpl2_Double()));
            }
            double condA = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(BoxesRunTime.boxToDouble((double)maxrbar), BoxesRunTime.boxToDouble((double)rhotemp), max$.MODULE$.maxImpl2_Double()))), BoxesRunTime.unboxToDouble((Object)min$.MODULE$.apply(BoxesRunTime.boxToDouble((double)minrbar), BoxesRunTime.boxToDouble((double)rhotemp), min$.MODULE$.minImpl2_Double())));
            maxrbar = BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(BoxesRunTime.boxToDouble((double)maxrbar), BoxesRunTime.boxToDouble((double)rhobarold), max$.MODULE$.maxImpl2_Double()));
            if (iter > 1) {
                minrbar = BoxesRunTime.unboxToDouble((Object)min$.MODULE$.apply(BoxesRunTime.boxToDouble((double)minrbar), BoxesRunTime.boxToDouble((double)rhobarold), min$.MODULE$.minImpl2_Double()));
            }
            condA = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(BoxesRunTime.boxToDouble((double)maxrbar), BoxesRunTime.boxToDouble((double)rhotemp), max$.MODULE$.maxImpl2_Double()))), BoxesRunTime.unboxToDouble((Object)min$.MODULE$.apply(BoxesRunTime.boxToDouble((double)minrbar), BoxesRunTime.boxToDouble((double)rhotemp), min$.MODULE$.minImpl2_Double())));
            double normAr = BoxesRunTime.unboxToDouble((Object)package$abs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)zetabar), (UFunc.UImpl)package$abs$absDoubleImpl$.MODULE$));
            double normx = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(x, ispace.normImpl()));
            double test1 = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(normr), normb);
            double test2 = LSMR$SafeDiv$.MODULE$.$div$qmark$extension(this.SafeDiv(normAr), normA * normr);
            double rtol = btol + atol * normA * normx / normb;
            if (!quiet) {
                this.logger().info(() -> this.solve$$anonfun$1(atol, normr, normAr, test1, test2, rtol));
            }
            converged = normr == 0.0 || iter >= maxIter || test1 < rtol || test2 < atol;
        }
        return x;
    }

    public double solve$default$3() {
        return 0.0;
    }

    public double solve$default$4() {
        return 1.0E-9;
    }

    public int solve$default$5() {
        return 1000;
    }

    public boolean solve$default$6() {
        return false;
    }

    private final double SafeDiv(double __x) {
        return __x;
    }

    private final double sqr$1(double x) {
        return x * x;
    }

    private final String solve$$anonfun$1(double atol$1, double normr$1, double normAr$1, double test1$1, double test2$1, double rtol$1) {
        return StringOps$.MODULE$.format$extension("Residual: %.2g %.2g ", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)normr$1), BoxesRunTime.boxToDouble((double)normAr$1)})) + StringOps$.MODULE$.format$extension(":: convtest1: %.2g <? %.2g :: convtest2: %.2g <? %.2g", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)test1$1), BoxesRunTime.boxToDouble((double)rtol$1), BoxesRunTime.boxToDouble((double)test2$1), BoxesRunTime.boxToDouble((double)atol$1)}));
    }
}

