/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.Axis$_0$;
import breeze.linalg.Axis$_1$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$;
import breeze.linalg.SliceMatrix$;
import breeze.linalg.SliceVector;
import breeze.linalg.Tensor;
import breeze.linalg.Transpose;
import breeze.linalg.Vector;
import breeze.linalg.VectorBuilder;
import breeze.linalg.View;
import breeze.linalg.View$Copy$;
import breeze.linalg.View$Prefer$;
import breeze.linalg.View$Require$;
import breeze.linalg.operators.HasOps$;
import breeze.linalg.support.CanCollapseAxis;
import breeze.linalg.support.CanCreateZerosLike;
import breeze.linalg.support.CanMapKeyValuePairs;
import breeze.linalg.support.CanMapValues;
import breeze.linalg.support.CanSlice2;
import breeze.linalg.support.CanTransformValues;
import breeze.linalg.support.CanTraverseKeyValuePairs;
import breeze.linalg.support.CanTraverseValues;
import breeze.math.Semiring;
import breeze.storage.Zero;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Iterator;
import scala.collection.immutable.$colon$colon$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;

public class SliceMatrix<K1, K2, V>
implements Matrix<V> {
    private final Tensor tensor;
    private final IndexedSeq slice1;
    private final IndexedSeq slice2;
    private final Semiring<V> evidence$1;
    private final ClassTag<V> evidence$2;

    public static <K1, K2, V, R> CanCollapseAxis<SliceMatrix<K1, K2, V>, Axis$_1$, Vector<V>, R, Vector<R>> canCollapseCols_SliceMatrix(Semiring<V> semiring, ClassTag<V> classTag, ClassTag<R> classTag2, Zero<R> zero) {
        return SliceMatrix$.MODULE$.canCollapseCols_SliceMatrix((Semiring)semiring, (ClassTag)classTag, (ClassTag)classTag2, (Zero)zero);
    }

    public static <K1, K2, V, R> CanCollapseAxis<SliceMatrix<K1, K2, V>, Axis$_0$, Vector<V>, R, Transpose<Vector<R>>> canCollapseRows_SliceMatrix(Semiring<V> semiring, ClassTag<V> classTag, ClassTag<R> classTag2, Zero<R> zero) {
        return SliceMatrix$.MODULE$.canCollapseRows_SliceMatrix((Semiring)semiring, (ClassTag)classTag, (ClassTag)classTag2, (Zero)zero);
    }

    public static <K1, K2, V> CanCreateZerosLike<SliceMatrix<K1, K2, V>, DenseMatrix<V>> canCreateZerosLike(ClassTag<V> classTag, Zero<V> zero) {
        return SliceMatrix$.MODULE$.canCreateZerosLike(classTag, zero);
    }

    public static CanTraverseKeyValuePairs canIterateKeyValuePairs() {
        return SliceMatrix$.MODULE$.canIterateKeyValuePairs();
    }

    public static CanTraverseValues canIterateValues() {
        return SliceMatrix$.MODULE$.canIterateValues();
    }

    public static <K1, K2, V, V2> CanMapKeyValuePairs<SliceMatrix<K1, K2, V>, Tuple2<Object, Object>, V, V2, DenseMatrix<V2>> canMapKeyValuePairs(ClassTag<V2> classTag, Zero<V2> zero) {
        return SliceMatrix$.MODULE$.canMapKeyValuePairs(classTag, zero);
    }

    public static <K1, K2, V, V2> CanMapValues<SliceMatrix<K1, K2, V>, V, V2, DenseMatrix<V2>> canMapValues(ClassTag<V2> classTag, Zero<V2> zero) {
        return SliceMatrix$.MODULE$.canMapValues(classTag, zero);
    }

    public static <K1, K2, V> CanSlice2<SliceMatrix<K1, K2, V>, $colon$colon$, Object, SliceVector<Tuple2<K1, K2>, V>> canSliceCol(Semiring<V> semiring, ClassTag<V> classTag) {
        return SliceMatrix$.MODULE$.canSliceCol(semiring, classTag);
    }

    public static <K1, K2, V> CanSlice2<SliceMatrix<K1, K2, V>, Object, $colon$colon$, Transpose<SliceVector<Tuple2<K1, K2>, V>>> canSliceRow(Semiring<V> semiring, ClassTag<V> classTag) {
        return SliceMatrix$.MODULE$.canSliceRow(semiring, classTag);
    }

    public static <K1, K2, V> CanSlice2<SliceMatrix<K1, K2, V>, $colon$colon$, Seq<Object>, SliceMatrix<K1, K2, V>> canSliceWeirdCols_SM(Semiring<V> semiring, ClassTag<V> classTag) {
        return SliceMatrix$.MODULE$.canSliceWeirdCols_SM((Semiring)semiring, (ClassTag)classTag);
    }

    public static <K1, K2, V> CanSlice2<SliceMatrix<K1, K2, V>, Seq<Object>, $colon$colon$, SliceMatrix<K1, K2, V>> canSliceWeirdRows_SM(Semiring<V> semiring, ClassTag<V> classTag) {
        return SliceMatrix$.MODULE$.canSliceWeirdRows_SM((Semiring)semiring, (ClassTag)classTag);
    }

    public static CanTransformValues canTransformValues() {
        return SliceMatrix$.MODULE$.canTransformValues();
    }

    public static CanCollapseAxis.HandHold handholdCanMapCols_SM() {
        return SliceMatrix$.MODULE$.handholdCanMapCols_SM();
    }

    public static CanCollapseAxis.HandHold handholdCanMapRows_SM() {
        return SliceMatrix$.MODULE$.handholdCanMapRows_SM();
    }

    public static UFunc.InPlaceImpl2 opSetInPlace() {
        return SliceMatrix$.MODULE$.opSetInPlace();
    }

    public <K1, K2, V> SliceMatrix(Tensor<Tuple2<K1, K2>, V> tensor, IndexedSeq<K1> slice1, IndexedSeq<K2> slice2, Semiring<V> evidence$1, ClassTag<V> evidence$2) {
        this.tensor = tensor;
        this.slice1 = slice1;
        this.slice2 = slice2;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }

    public Tensor<Tuple2<K1, K2>, V> tensor() {
        return this.tensor;
    }

    public IndexedSeq<K1> slice1() {
        return this.slice1;
    }

    public IndexedSeq<K2> slice2() {
        return this.slice2;
    }

    @Override
    public V apply(int i, int j) {
        Object object = Predef$.MODULE$.ArrowAssoc(this.slice1().apply(i));
        return this.tensor().apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, this.slice2().apply(j)));
    }

    @Override
    public void update(int i, int j, V e) {
        Object object = Predef$.MODULE$.ArrowAssoc(this.slice1().apply(i));
        this.tensor().update(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, this.slice2().apply(j)), e);
    }

    @Override
    public int rows() {
        return this.slice1().length();
    }

    @Override
    public int cols() {
        return this.slice2().length();
    }

    @Override
    public Iterator<V> activeValuesIterator() {
        return this.valuesIterator();
    }

    @Override
    public Iterator<Tuple2<Tuple2<Object, Object>, V>> activeIterator() {
        return this.iterator();
    }

    @Override
    public Iterator<Tuple2<Object, Object>> activeKeysIterator() {
        return this.keysIterator();
    }

    @Override
    public int activeSize() {
        return this.size();
    }

    @Override
    public SliceMatrix<K1, K2, V> repr() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Matrix<V> copy() {
        Matrix<V> matrix;
        if (this.rows() == 0) {
            matrix = Matrix$.MODULE$.zeroRows(this.cols(), this.evidence$2);
        } else if (this.cols() == 0) {
            matrix = Matrix$.MODULE$.zeroCols(this.rows(), this.evidence$2);
        } else {
            void var1_1;
            DenseMatrix result = new DenseMatrix(this.rows(), this.cols(), Arrays$.MODULE$.newGenericArray(this.size(), this.evidence$2));
            result.$colon$eq(this, HasOps$.MODULE$.impl_OpSet_InPlace_DM_M());
            matrix = var1_1;
        }
        return matrix;
    }

    @Override
    public Vector<V> flatten(View view) {
        Vector<V> vector;
        View view2 = view;
        if (View$Require$.MODULE$.equals(view2)) {
            throw new UnsupportedOperationException("Cannot make Vector as view of SliceMatrix.");
        }
        if (View$Copy$.MODULE$.equals(view2)) {
            VectorBuilder<V> vb = new VectorBuilder<V>(this.rows() * this.cols(), this.activeSize(), this.evidence$1, this.evidence$2);
            Iterator<Tuple2<Tuple2<Object, Object>, V>> ai = this.activeIterator();
            while (ai.hasNext()) {
                Tuple2 tuple2;
                Tuple2 tuple22 = (Tuple2)ai.next();
                if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                    throw new MatchError((Object)tuple22);
                }
                int r = BoxesRunTime.unboxToInt((Object)tuple2._1());
                int c = BoxesRunTime.unboxToInt((Object)tuple2._2());
                Object v = tuple22._2();
                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)r), (Object)BoxesRunTime.boxToInteger((int)c), v);
                int r2 = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int c2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                Object v2 = tuple3._3();
                vb.add(c2 * this.rows() + r2, v2);
            }
            vector = vb.toVector();
        } else if (View$Prefer$.MODULE$.equals(view2)) {
            vector = this.flatten(View$Copy$.MODULE$);
        } else {
            throw new MatchError((Object)view2);
        }
        return vector;
    }

    @Override
    public View flatten$default$1() {
        return View$Copy$.MODULE$;
    }
}

