/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.HashVector;
import breeze.linalg.HashVector$;
import breeze.linalg.NumericOps;
import breeze.linalg.SparseVector;
import breeze.linalg.Vector;
import breeze.linalg.VectorBuilder$;
import breeze.linalg.operators.OpAdd$;
import breeze.linalg.operators.OpDiv$;
import breeze.linalg.operators.OpMulInner$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.linalg.operators.OpMulScalar$;
import breeze.linalg.operators.OpSub$;
import breeze.linalg.scaleAdd$;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanCreateZeros;
import breeze.linalg.support.CanCreateZerosLike;
import breeze.math.Field;
import breeze.math.MutableModule;
import breeze.math.Ring;
import breeze.math.Semiring;
import breeze.storage.Zero;
import breeze.storage.Zero$;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import breeze.util.Sorting$;
import java.io.Serializable;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class VectorBuilder<E>
implements NumericOps<VectorBuilder<E>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private int[] _index;
    private Object _data;
    private int used;
    private int length;
    private final Semiring<E> ring;

    public static <V, Vec> UFunc.InPlaceImpl2<OpAdd$, VectorBuilder<V>, Vec> canAddInto_VV_V(.less.colon.less<Vec, Vector<V>> less2) {
        return VectorBuilder$.MODULE$.canAddInto_VV_V((.less.colon.less)less2);
    }

    public static <V, Vec> UFunc.InPlaceImpl2<OpAdd$, Vec, VectorBuilder<V>> canAddInto_V_VB(.less.colon.less<Vec, Vector<V>> less2, Semiring<V> semiring) {
        return VectorBuilder$.MODULE$.canAddInto_V_VB((.less.colon.less)less2, (Semiring)semiring);
    }

    public static <T> UFunc.InPlaceImpl3<scaleAdd$, VectorBuilder<T>, T, VectorBuilder<T>> canAxpy(Semiring<T> semiring, ClassTag<T> classTag) {
        return VectorBuilder$.MODULE$.canAxpy((Semiring)semiring, (ClassTag)classTag);
    }

    public static UFunc.InPlaceImpl3 canAxpy_Double() {
        return VectorBuilder$.MODULE$.canAxpy_Double();
    }

    public static UFunc.InPlaceImpl3 canAxpy_Float() {
        return VectorBuilder$.MODULE$.canAxpy_Float();
    }

    public static UFunc.InPlaceImpl3 canAxpy_Int() {
        return VectorBuilder$.MODULE$.canAxpy_Int();
    }

    public static UFunc.InPlaceImpl3 canAxpy_Long() {
        return VectorBuilder$.MODULE$.canAxpy_Long();
    }

    public static <V, Vec> UFunc.InPlaceImpl3<scaleAdd$, Vec, V, VectorBuilder<V>> canAxpy_V_VB_Semi(.less.colon.less<Vec, Vector<V>> less2, Semiring<V> semiring) {
        return VectorBuilder$.MODULE$.canAxpy_V_VB_Semi((.less.colon.less)less2, (Semiring)semiring);
    }

    public static <V> CanCopyBuilder<V> canCopyBuilder(ClassTag<V> classTag, Semiring<V> semiring, Zero<V> zero) {
        return VectorBuilder$.MODULE$.canCopyBuilder(classTag, semiring, zero);
    }

    public static <T> UFunc.InPlaceImpl2<OpDiv$, VectorBuilder<T>, T> canDivInto_V_S(Field<T> field, ClassTag<T> classTag) {
        return VectorBuilder$.MODULE$.canDivInto_V_S((Field)field, (ClassTag)classTag);
    }

    public static <Vec, V> UFunc.UImpl2<OpMulInner$, VectorBuilder<V>, Vec, V> canDot_VB_V(.less.colon.less<Vec, Vector<V>> less2, Semiring<V> semiring) {
        return VectorBuilder$.MODULE$.canDot_VB_V((.less.colon.less)less2, (Semiring)semiring);
    }

    public static <Vec, V> UFunc.UImpl2<OpMulInner$, Vec, VectorBuilder<V>, V> canDot_V_VB(.less.colon.less<Vec, Vector<V>> less2, Semiring<V> semiring) {
        return VectorBuilder$.MODULE$.canDot_V_VB((.less.colon.less)less2, (Semiring)semiring);
    }

    public static UFunc.UImpl2 canMulDMVB_Double() {
        return VectorBuilder$.MODULE$.canMulDMVB_Double();
    }

    public static UFunc.UImpl2 canMulDMVB_Float() {
        return VectorBuilder$.MODULE$.canMulDMVB_Float();
    }

    public static UFunc.UImpl2 canMulDMVB_Int() {
        return VectorBuilder$.MODULE$.canMulDMVB_Int();
    }

    public static UFunc.UImpl2 canMulDMVB_Long() {
        return VectorBuilder$.MODULE$.canMulDMVB_Long();
    }

    public static <T> UFunc.UImpl2<OpMulMatrix$, DenseMatrix<T>, VectorBuilder<T>, DenseVector<T>> canMulDMVB_Semi(ClassTag<T> classTag, Semiring<T> semiring) {
        return VectorBuilder$.MODULE$.canMulDMVB_Semi((ClassTag)classTag, (Semiring)semiring);
    }

    public static <T> UFunc.InPlaceImpl2<OpMulScalar$, VectorBuilder<T>, T> canMulInto_V_S(Semiring<T> semiring, ClassTag<T> classTag) {
        return VectorBuilder$.MODULE$.canMulInto_V_S((Semiring)semiring, (ClassTag)classTag);
    }

    public static <T> UFunc.InPlaceImpl2<OpAdd$, VectorBuilder<T>, T> canOpInto_V_S_OpAdd(Ring<T> ring, ClassTag<T> classTag) {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpAdd((Ring)ring, (ClassTag)classTag);
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_S_OpDiv_Double() {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpDiv_Double();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_S_OpDiv_Float() {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpDiv_Float();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_S_OpDiv_Int() {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpDiv_Int();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_S_OpDiv_Long() {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpDiv_Long();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_S_OpMulScalar_Double() {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpMulScalar_Double();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_S_OpMulScalar_Float() {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpMulScalar_Float();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_S_OpMulScalar_Int() {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpMulScalar_Int();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_S_OpMulScalar_Long() {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpMulScalar_Long();
    }

    public static <T> UFunc.InPlaceImpl2<OpSub$, VectorBuilder<T>, T> canOpInto_V_S_OpSub(Ring<T> ring, ClassTag<T> classTag) {
        return VectorBuilder$.MODULE$.canOpInto_V_S_OpSub((Ring)ring, (ClassTag)classTag);
    }

    public static <T> UFunc.InPlaceImpl2<OpAdd$, VectorBuilder<T>, VectorBuilder<T>> canOpInto_V_V_OpAdd(Ring<T> ring, ClassTag<T> classTag) {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpAdd((Ring)ring, (ClassTag)classTag);
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_V_OpAdd_Double() {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpAdd_Double();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_V_OpAdd_Float() {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpAdd_Float();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_V_OpAdd_Int() {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpAdd_Int();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_V_OpAdd_Long() {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpAdd_Long();
    }

    public static <T> UFunc.InPlaceImpl2<OpSub$, VectorBuilder<T>, VectorBuilder<T>> canOpInto_V_V_OpSub(Ring<T> ring, ClassTag<T> classTag) {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpSub((Ring)ring, (ClassTag)classTag);
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_V_OpSub_Double() {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpSub_Double();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_V_OpSub_Float() {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpSub_Float();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_V_OpSub_Int() {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpSub_Int();
    }

    public static UFunc.InPlaceImpl2 canOpInto_V_V_OpSub_Long() {
        return VectorBuilder$.MODULE$.canOpInto_V_V_OpSub_Long();
    }

    public static UFunc.InPlaceImpl2 canSet() {
        return VectorBuilder$.MODULE$.canSet();
    }

    public static UFunc.InPlaceImpl2 canSet_Double() {
        return VectorBuilder$.MODULE$.canSet_Double();
    }

    public static UFunc.InPlaceImpl2 canSet_Float() {
        return VectorBuilder$.MODULE$.canSet_Float();
    }

    public static UFunc.InPlaceImpl2 canSet_Int() {
        return VectorBuilder$.MODULE$.canSet_Int();
    }

    public static UFunc.InPlaceImpl2 canSet_Long() {
        return VectorBuilder$.MODULE$.canSet_Long();
    }

    public static <V, Vec> UFunc.InPlaceImpl2<OpSub$, VectorBuilder<V>, Vec> canSubInto_VV_V(.less.colon.less<Vec, Vector<V>> less2, Ring<V> ring) {
        return VectorBuilder$.MODULE$.canSubInto_VV_V((.less.colon.less)less2, (Ring)ring);
    }

    public static <V, Vec> UFunc.InPlaceImpl2<OpSub$, Vec, VectorBuilder<V>> canSubInto_V_VB(.less.colon.less<Vec, Vector<V>> less2, Ring<V> ring) {
        return VectorBuilder$.MODULE$.canSubInto_V_VB((.less.colon.less)less2, (Ring)ring);
    }

    public static <V> CanCreateZeros<VectorBuilder<V>, Object> canZeroBuilder(Semiring<V> semiring, Zero<V> zero, ClassTag<V> classTag) {
        return VectorBuilder$.MODULE$.canZeroBuilder(semiring, zero, classTag);
    }

    public static <V> CanZerosBuilder<V> canZerosBuilder(ClassTag<V> classTag, Semiring<V> semiring, Zero<V> zero) {
        return VectorBuilder$.MODULE$.canZerosBuilder(classTag, semiring, zero);
    }

    public static <V> VectorBuilder<V> fill(int n, Function0<V> function0, ClassTag<V> classTag, Semiring<V> semiring, Zero<V> zero) {
        return VectorBuilder$.MODULE$.fill(n, function0, classTag, semiring, zero);
    }

    public static <T> MutableModule<VectorBuilder<T>, T> space(Field<T> field, ClassTag<T> classTag) {
        return VectorBuilder$.MODULE$.space((Field)field, (ClassTag)classTag);
    }

    public static <V> VectorBuilder<V> tabulate(int n, Function1<Object, V> function1, ClassTag<V> classTag, Semiring<V> semiring, Zero<V> zero) {
        return VectorBuilder$.MODULE$.tabulate(n, function1, classTag, semiring, zero);
    }

    public static <V> VectorBuilder<V> zeros(int n, int n2, ClassTag<V> classTag, Semiring<V> semiring, Zero<V> zero) {
        return VectorBuilder$.MODULE$.zeros(n, n2, classTag, semiring, zero);
    }

    public static int $lessinit$greater$default$2() {
        return VectorBuilder$.MODULE$.$lessinit$greater$default$2();
    }

    public static int zeros$default$2() {
        return VectorBuilder$.MODULE$.zeros$default$2();
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canAxpy_Double_$eq(UFunc.InPlaceImpl3 inPlaceImpl3) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canAxpy_Double_$eq(inPlaceImpl3);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canAxpy_Float_$eq(UFunc.InPlaceImpl3 inPlaceImpl3) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canAxpy_Float_$eq(inPlaceImpl3);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canAxpy_Int_$eq(UFunc.InPlaceImpl3 inPlaceImpl3) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canAxpy_Int_$eq(inPlaceImpl3);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canAxpy_Long_$eq(UFunc.InPlaceImpl3 inPlaceImpl3) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canAxpy_Long_$eq(inPlaceImpl3);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canMulDMVB_Double_$eq(UFunc.UImpl2 uImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canMulDMVB_Double_$eq(uImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canMulDMVB_Float_$eq(UFunc.UImpl2 uImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canMulDMVB_Float_$eq(uImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canMulDMVB_Int_$eq(UFunc.UImpl2 uImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canMulDMVB_Int_$eq(uImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canMulDMVB_Long_$eq(UFunc.UImpl2 uImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canMulDMVB_Long_$eq(uImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpDiv_Double_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpDiv_Double_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpDiv_Float_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpDiv_Float_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpDiv_Int_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpDiv_Int_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpDiv_Long_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpDiv_Long_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpMulScalar_Double_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpMulScalar_Double_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpMulScalar_Float_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpMulScalar_Float_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpMulScalar_Int_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpMulScalar_Int_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpMulScalar_Long_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_S_OpMulScalar_Long_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpAdd_Double_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpAdd_Double_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpAdd_Float_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpAdd_Float_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpAdd_Int_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpAdd_Int_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpAdd_Long_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpAdd_Long_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpSub_Double_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpSub_Double_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpSub_Float_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpSub_Float_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpSub_Int_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpSub_Int_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpSub_Long_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canOpInto_V_V_OpSub_Long_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canSet_Double_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canSet_Double_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canSet_Float_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canSet_Float_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canSet_Int_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canSet_Int_$eq(inPlaceImpl2);
    }

    public static void breeze$linalg$operators$VectorBuilderOps$_setter_$canSet_Long_$eq(UFunc.InPlaceImpl2 inPlaceImpl2) {
        VectorBuilder$.MODULE$.breeze$linalg$operators$VectorBuilderOps$_setter_$canSet_Long_$eq(inPlaceImpl2);
    }

    public <E> VectorBuilder(int[] _index, Object _data, int used, int length, Semiring<E> ring) {
        this._index = _index;
        this._data = _data;
        this.used = used;
        this.length = length;
        this.ring = ring;
    }

    private int[] _index() {
        return this._index;
    }

    private void _index_$eq(int[] x$0) {
        this._index = x$0;
    }

    private Object _data() {
        return this._data;
    }

    private void _data_$eq(Object x$0) {
        this._data = x$0;
    }

    private int used() {
        return this.used;
    }

    private void used_$eq(int x$0) {
        this.used = x$0;
    }

    public int length() {
        return this.length;
    }

    public void length_$eq(int x$1) {
        this.length = x$1;
    }

    public <E> VectorBuilder(int length, int initialNonZero, Semiring<E> ring, ClassTag<E> man) {
        this(new int[initialNonZero], Arrays$.MODULE$.newGenericArray(initialNonZero, man), 0, length, ring);
    }

    public <E> VectorBuilder(Semiring<E> ring, ClassTag<E> man, Zero<E> zero) {
        this(-1, VectorBuilder$.MODULE$.$lessinit$greater$default$2(), ring, man);
    }

    public int size() {
        return this.length();
    }

    public Object data() {
        return this._data();
    }

    public int[] index() {
        return this._index();
    }

    public int activeSize() {
        return this.used();
    }

    @Override
    public VectorBuilder<E> repr() {
        return this;
    }

    public boolean contains(int i) {
        Object object = Predef$.MODULE$.intArrayOps(this._index());
        return ArrayOps$.MODULE$.contains$extension(object, (Object)BoxesRunTime.boxToInteger((int)i));
    }

    /*
     * WARNING - void declaration
     */
    public E apply(int i) {
        void var3_3;
        this.boundsCheck(i);
        Object acc = this.ring.zero();
        for (int off = 0; off < this.used(); ++off) {
            if (this._index()[off] != i) continue;
            acc = this.ring.$plus(acc, ScalaRunTime$.MODULE$.array_apply(this._data(), off));
        }
        return var3_3;
    }

    private void boundsCheck(int i) {
        if (this.length() >= 0 && (i < 0 || i >= this.size())) {
            throw new IndexOutOfBoundsException("" + i + " not in [0," + this.size() + ")");
        }
    }

    public void update(int i, E v) {
        this.boundsCheck(i);
        boolean marked = false;
        for (int off = 0; off < this.used(); ++off) {
            if (this._index()[off] != i) continue;
            if (!marked) {
                ScalaRunTime$.MODULE$.array_update(this._data(), off, v);
            } else {
                ScalaRunTime$.MODULE$.array_update(this._data(), off, this.ring.zero());
            }
            marked = true;
        }
    }

    public void add(int i, E v) {
        this.boundsCheck(i);
        if (ScalaRunTime$.MODULE$.array_length(this._data()) <= this.used()) {
            this.reallocate(package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(this._data()) * 2, 1));
        }
        ScalaRunTime$.MODULE$.array_update(this._data(), this.used(), v);
        this._index()[this.used()] = i;
        this.used_$eq(this.used() + 1);
    }

    public Iterator<Tuple2<Object, E>> activeIterator() {
        return this.toHashVector().activeIterator();
    }

    public Iterator<E> activeValuesIterator() {
        return this.toHashVector().activeValuesIterator();
    }

    public Iterator<Object> activeKeysIterator() {
        return this.toHashVector().activeKeysIterator();
    }

    public E default() {
        return this.ring.zero();
    }

    public boolean isActive(int rawIndex) {
        return rawIndex < this.used() && rawIndex > 0;
    }

    public String toString() {
        Object object = Predef$.MODULE$.intArrayOps(this.index());
        Object object2 = Predef$.MODULE$.genericArrayOps(this.data());
        return ArrayOps$.MODULE$.iterator$extension(object).zip((IterableOnce)ArrayOps$.MODULE$.iterator$extension(object2)).take(this.used()).mkString("VectorBuilder(" + this.length() + ")(", ", ", ")");
    }

    public VectorBuilder<E> copy() {
        return new VectorBuilder<E>((int[])ArrayUtil$.MODULE$.copyOf(this.index(), this.index().length), ArrayUtil$.MODULE$.copyOf(this.data(), this.index().length), this.activeSize(), this.size(), this.ring);
    }

    public VectorBuilder<E> zerosLike() {
        return new VectorBuilder<E>(new int[0], ArrayUtil$.MODULE$.newArrayLike(this.data(), 0), 0, this.size(), this.ring);
    }

    public void reserve(int nnz) {
        if (nnz < ScalaRunTime$.MODULE$.array_length(this._data())) {
            this.reallocate(nnz);
        }
    }

    private void reallocate(int nnz) {
        this._index_$eq((int[])ArrayUtil$.MODULE$.copyOf(this._index(), nnz));
        this._data_$eq(ArrayUtil$.MODULE$.copyOf(this.data(), nnz));
    }

    /*
     * WARNING - void declaration
     */
    public HashVector<E> toHashVector() {
        void var2_2;
        this.requirePositiveLength();
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        HashVector hv = HashVector$.MODULE$.zeros(this.length(), man, Zero$.MODULE$.zeroFromSemiring(this.ring));
        for (int i = 0; i < this.used(); ++i) {
            hv.update(this.index()[i], this.ring.$plus(hv.apply(this.index()[i]), ScalaRunTime$.MODULE$.array_apply(this.data(), i)));
        }
        return var2_2;
    }

    private void requirePositiveLength() {
        if (this.size() < 0) {
            throw new UnsupportedOperationException("Can't make a vector with a negative length!");
        }
    }

    /*
     * WARNING - void declaration
     */
    public DenseVector<E> toDenseVector() {
        void var2_2;
        this.requirePositiveLength();
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        Vector hv = DenseVector$.MODULE$.zeros(this.length(), man, Zero$.MODULE$.zeroFromSemiring(this.ring));
        for (int i = 0; i < this.used(); ++i) {
            ((DenseVector)hv).update(this.index()[i], this.ring.$plus(((DenseVector)hv).apply(this.index()[i]), ScalaRunTime$.MODULE$.array_apply(this.data(), i)));
        }
        return var2_2;
    }

    public SparseVector<E> toSparseVector() {
        return this.toSparseVector(this.toSparseVector$default$1(), this.toSparseVector$default$2());
    }

    public SparseVector<E> toSparseVector(boolean alreadySorted, boolean keysAlreadyUnique) {
        this.requirePositiveLength();
        int[] index = this.index();
        Object values = this.data();
        if (alreadySorted && keysAlreadyUnique) {
            return new SparseVector<E>(index, values, this.used(), this.length(), Zero$.MODULE$.zeroFromSemiring(this.ring));
        }
        int[] outIndex = (int[])ArrayUtil$.MODULE$.copyOf(index, this.used());
        Object outValues = ArrayUtil$.MODULE$.copyOf(values, this.used());
        if (!alreadySorted) {
            Sorting$.MODULE$.indirectSort(outIndex, outValues, 0, this.used());
        }
        if (outIndex.length > 0) {
            if (outIndex[this.used() - 1] >= this.length()) {
                throw new IndexOutOfBoundsException("Index " + index[this.used() - 1] + " exceeds dimension " + this.length());
            }
            if (outIndex[0] < 0) {
                throw new IndexOutOfBoundsException("Index " + outIndex[0] + " is less than 0");
            }
        }
        int out = 0;
        if (!keysAlreadyUnique) {
            for (int i = 1; i < this.used(); ++i) {
                if (outIndex[out] == outIndex[i]) {
                    ScalaRunTime$.MODULE$.array_update(outValues, out, this.ring.$plus(ScalaRunTime$.MODULE$.array_apply(outValues, out), ScalaRunTime$.MODULE$.array_apply(outValues, i)));
                    continue;
                }
                outIndex[++out] = outIndex[i];
                ScalaRunTime$.MODULE$.array_update(outValues, out, ScalaRunTime$.MODULE$.array_apply(outValues, i));
            }
            if (outIndex.length > 0) {
                ++out;
            }
        } else {
            out = this.used();
        }
        return new SparseVector<E>(outIndex, outValues, out, this.length(), Zero$.MODULE$.zeroFromSemiring(this.ring));
    }

    public boolean toSparseVector$default$1() {
        return false;
    }

    public boolean toSparseVector$default$2() {
        return false;
    }

    public void compact() {
        SparseVector<E> ah = this.toSparseVector();
        this.clear();
        this.reallocate(ah.activeSize());
        for (int i = 0; i < ah.iterableSize(); ++i) {
            if (!ah.isActive(i)) continue;
            this.add(ah.index()[i], ScalaRunTime$.MODULE$.array_apply(ah.data(), i));
        }
    }

    public void clear() {
        this.used_$eq(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object p1) {
        if (this == p1) return true;
        Object object = p1;
        if (!(object instanceof VectorBuilder)) return false;
        VectorBuilder vb = (VectorBuilder)object;
        if (this.length() != vb.length()) return false;
        HashVector<E> hashVector = vb.toHashVector();
        HashVector<E> hashVector2 = this.toHashVector();
        if (hashVector != null) {
            if (!((Object)hashVector).equals(hashVector2)) return false;
            return true;
        }
        if (hashVector2 == null) return true;
        return false;
    }

    public void use(int[] index, Object data, int activeSize) {
        Predef$.MODULE$.require(activeSize >= 0, VectorBuilder::use$$anonfun$1);
        Predef$.MODULE$.require(ScalaRunTime$.MODULE$.array_length(data) >= activeSize, VectorBuilder::use$$anonfun$2);
        this._data_$eq(data);
        this._index_$eq(index);
        this.used_$eq(activeSize);
    }

    public E valueAt(int i) {
        return (E)ScalaRunTime$.MODULE$.array_apply(this.data(), i);
    }

    public int indexAt(int i) {
        return this.index()[i];
    }

    public boolean allVisitableIndicesActive() {
        return true;
    }

    public Vector<E> toVector() {
        this.requirePositiveLength();
        return (Vector)((Object)(this.size() < 40 || this.activeSize() > this.size() / 4 ? this.toDenseVector() : this.toSparseVector()));
    }

    private static final String use$$anonfun$1() {
        return "activeSize must be non-negative";
    }

    private static final String use$$anonfun$2() {
        return "activeSize must be no greater than array length...";
    }

    public static class CanCopyBuilder<V>
    implements CanCopy<VectorBuilder<V>> {
        public <V> CanCopyBuilder(ClassTag<V> evidence$18, Semiring<V> evidence$19, Zero<V> evidence$20) {
        }

        @Override
        public VectorBuilder<V> apply(VectorBuilder<V> v1) {
            return v1.copy();
        }
    }

    public static class CanZerosBuilder<V>
    implements CanCreateZerosLike<VectorBuilder<V>, VectorBuilder<V>> {
        public <V> CanZerosBuilder(ClassTag<V> evidence$21, Semiring<V> evidence$22, Zero<V> evidence$23) {
        }

        @Override
        public VectorBuilder<V> apply(VectorBuilder<V> v1) {
            return v1.zerosLike();
        }
    }
}

